/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.LongLongStringPK;

public class LongLongStringPKTest
extends AbstractClusterJTest {
    protected int PK_MODULUS = 2;
    protected int NUMBER_OF_INSTANCES = this.PK_MODULUS * this.PK_MODULUS * this.PK_MODULUS;
    protected long PRETTY_BIG_NUMBER = 1000000000000000L;
    protected List<LongLongStringPK> instances = new ArrayList<LongLongStringPK>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        try {
            this.tx.begin();
            this.session.deletePersistentAll(LongLongStringPK.class);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.createInstances();
        this.addTearDownClasses(LongLongStringPK.class);
    }

    public void test() {
        this.insert();
        this.find();
        this.update();
        this.delete();
        this.failOnError();
    }

    protected void insert() {
        this.session.makePersistentAll(this.instances);
    }

    protected void find() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            Object[] objectArray = new Object[]{this.getPK1(i), this.getPK2(i), this.getPK3(i)};
            LongLongStringPK longLongStringPK = (LongLongStringPK)this.session.find(LongLongStringPK.class, (Object)objectArray);
            this.verify(longLongStringPK, i, false);
        }
    }

    protected void update() {
        Object[] objectArray;
        int n;
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 4) continue;
            objectArray = this.createInstance(n);
            objectArray.setStringvalue(this.getValue(this.NUMBER_OF_INSTANCES - n));
            this.session.updatePersistent((Object)objectArray);
            this.verify((LongLongStringPK)objectArray, n, true);
        }
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 4) continue;
            objectArray = new Object[]{this.getPK1(n), this.getPK2(n), this.getPK3(n)};
            LongLongStringPK longLongStringPK = (LongLongStringPK)this.session.find(LongLongStringPK.class, (Object)objectArray);
            this.verify(longLongStringPK, n, true);
        }
    }

    protected void delete() {
        Object[] objectArray;
        int n;
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 5) continue;
            objectArray = this.createInstance(n);
            this.session.deletePersistent((Object)objectArray);
        }
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 5) continue;
            objectArray = new Object[]{this.getPK1(n), this.getPK2(n), this.getPK3(n)};
            LongLongStringPK longLongStringPK = (LongLongStringPK)this.session.find(LongLongStringPK.class, (Object)objectArray);
            this.errorIfNotEqual("Failed to delete instance: " + n, null, longLongStringPK);
        }
    }

    protected void createInstances() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            LongLongStringPK longLongStringPK = this.createInstance(i);
            this.instances.add(longLongStringPK);
        }
    }

    protected LongLongStringPK createInstance(int n) {
        LongLongStringPK longLongStringPK = (LongLongStringPK)this.session.newInstance(LongLongStringPK.class);
        longLongStringPK.setLongpk1(this.getPK1(n));
        longLongStringPK.setLongpk2(this.getPK2(n));
        longLongStringPK.setStringpk(this.getPK3(n));
        longLongStringPK.setStringvalue(this.getValue(n));
        return longLongStringPK;
    }

    protected String toString(LongLongStringPK longLongStringPK) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LongLongStringPK[");
        stringBuffer.append(longLongStringPK.getLongpk1());
        stringBuffer.append(",");
        stringBuffer.append(longLongStringPK.getLongpk2());
        stringBuffer.append(",\"");
        stringBuffer.append(longLongStringPK.getStringpk());
        stringBuffer.append("\"]: ");
        stringBuffer.append(longLongStringPK.getStringvalue());
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    protected long getPK1(int n) {
        return this.PRETTY_BIG_NUMBER * (long)(n / this.PK_MODULUS / this.PK_MODULUS % this.PK_MODULUS);
    }

    protected long getPK2(int n) {
        return this.PRETTY_BIG_NUMBER * (long)(n / this.PK_MODULUS % this.PK_MODULUS);
    }

    protected String getPK3(int n) {
        return "" + n % this.PK_MODULUS;
    }

    protected String getValue(int n) {
        return "Value " + n;
    }

    protected void verify(LongLongStringPK longLongStringPK, int n, boolean bl) {
        this.errorIfNotEqual("PK1 failed", this.getPK1(n), longLongStringPK.getLongpk1());
        this.errorIfNotEqual("PK2 failed", this.getPK2(n), longLongStringPK.getLongpk2());
        this.errorIfNotEqual("PK3 failed", this.getPK3(n), longLongStringPK.getStringpk());
        if (bl) {
            this.errorIfNotEqual("Value failed", this.getValue(this.NUMBER_OF_INSTANCES - n), longLongStringPK.getStringvalue());
        } else {
            this.errorIfNotEqual("Value failed", this.getValue(n), longLongStringPK.getStringvalue());
        }
    }
}

