/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJUserException;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.NullValues;

public class NullValuesTest
extends AbstractClusterJModelTest {
    protected static final String tablename = "nullvalues";
    protected static final int numberOfPropertyTypes = 7;
    protected static final int numberOfFieldsPerProperty = 12;
    protected static final int DATABASE_NOT_NULL = 0;
    protected static final int DATABASE_NULL = 1;
    protected static final String[] databaseNull = new String[]{"DATABASE_NOT_NULL", "DATABASE_NULL"};
    protected static final int DATABASE_NO_DEFAULT = 0;
    protected static final int DATABASE_DEFAULT = 2;
    protected static final String[] databaseDefault = new String[]{"DATABASE_NO_DEFAULT", "DATABASE_DEFAULT"};
    protected static final int NULLVALUE_NONE = 0;
    protected static final int NULLVALUE_EXCEPTION = 4;
    protected static final int NULLVALUE_DEFAULT = 8;
    protected static final String[] nullValue = new String[]{"NULL_VALUE_NONE", "NULL_VALUE_EXCEPTION", "NULL_VALUE_DEFAULT"};
    protected static final String[] propertyTypes = new String[]{"Integer", "Long", "Short", "Byte", "String", "Float", "Double"};

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.session.deletePersistentAll(NullValues.class);
        this.addTearDownClasses(NullValues.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        NullValues nullValues = this.createValidInstance();
        int n = 0;
        nullValues.setId(n);
        this.session.makePersistent((Object)nullValues);
        this.tx.commit();
        this.tx.begin();
        nullValues = (NullValues)this.session.find(NullValues.class, (Object)n);
        this.session.deletePersistent((Object)nullValues);
        this.tx.commit();
        for (int i = 0; i < 7; ++i) {
            for (n = 0; n < 12; ++n) {
                NullValues nullValues2 = this.createValidInstance();
                int n2 = i * 12 + n;
                nullValues2.setId(n2);
                try {
                    this.tx.begin();
                    this.setValue(nullValues2, i, n, true);
                    this.session.makePersistent((Object)nullValues2);
                    this.tx.commit();
                    if (this.expectedException(n2, null)) {
                        this.error("Expected exception not thrown for case " + this.decodeType(i) + ": " + this.decodeValues(n2));
                    }
                }
                catch (Exception exception) {
                    if (this.expectedException(n2, exception)) continue;
                    this.error("Unexpected exception from commit for case " + this.decodeType(i) + ": " + this.decodeValues(n2) + " " + exception.toString());
                    exception.printStackTrace();
                    continue;
                }
                finally {
                    if (this.tx.isActive()) {
                        this.tx.rollback();
                    }
                }
                try {
                    this.tx.begin();
                    nullValues2 = (NullValues)this.session.find(NullValues.class, (Object)n2);
                    this.verifyNullValues(i, n, n2, nullValues2);
                    this.tx.commit();
                    continue;
                }
                catch (Exception exception) {
                    this.error("Unexpected exception from find for case" + this.decodeType(i) + ": " + this.decodeValues(n2) + " " + exception.toString());
                    exception.printStackTrace();
                }
            }
        }
        this.failOnError();
    }

    protected NullValues createValidInstance() {
        NullValues nullValues = (NullValues)this.session.newInstance(NullValues.class);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 12; ++j) {
                this.setValue(nullValues, i, j, false);
            }
        }
        return nullValues;
    }

    protected int whatDatabaseDefault(int n) {
        return (n % 12 & 2) >> 1;
    }

    protected int whatDatabaseNull(int n) {
        return n % 12 & 1;
    }

    protected int whatNullValue(int n) {
        return (n % 12 & 0xC) >> 2;
    }

    private String decodeValues(int n) {
        String string = databaseNull[this.whatDatabaseNull(n)];
        String string2 = databaseDefault[this.whatDatabaseDefault(n)];
        String string3 = nullValue[this.whatNullValue(n)];
        return string + " " + string2 + " " + string3;
    }

    private String decodeType(int n) {
        return propertyTypes[n];
    }

    private boolean expectedException(int n, Exception exception) {
        Throwable throwable;
        Throwable throwable2 = throwable = exception == null ? null : exception.getCause();
        if (this.whatDatabaseNull(n) == 0 && this.whatNullValue(n) == 0) {
            if (exception != null && exception instanceof ClusterJDatastoreException) {
                return true;
            }
            if (throwable instanceof Exception) {
                return this.expectedException(n, (Exception)throwable);
            }
            return false;
        }
        if (this.whatNullValue(n) == 1) {
            return exception != null && exception instanceof ClusterJUserException;
        }
        return false;
    }

    private void verifyNullValues(int n, int n2, int n3, NullValues nullValues) {
        Object object = this.getValue(nullValues, n, n2);
        if (this.whatDatabaseNull(n3) == 1 && this.whatDatabaseDefault(n3) == 0 && this.whatNullValue(n3) == 0) {
            this.errorIfNotEqual("For id " + n3 + " propertyType " + n + " fieldIndex " + n2 + " instance was " + (nullValues == null ? "null" : nullValues.toString() + " value was " + (object == null ? "null " : object + " of type " + object.getClass().getName() + " ") + this.decodeValues(n3)), null, object);
        }
    }

    private void setValue(NullValues nullValues, int n, int n2, boolean bl) {
        block0 : switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        nullValues.setIntNotNullNoDefaultNullValueNone(bl ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 1: {
                        nullValues.setIntNullNoDefaultNullValueNone(bl ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 2: {
                        nullValues.setIntNotNullDefaultNullValueNone(bl ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 3: {
                        nullValues.setIntNullDefaultNullValueNone(bl ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 4: {
                        nullValues.setIntNotNullNoDefaultNullValueException(bl ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 5: {
                        nullValues.setIntNullNoDefaultNullValueException(bl ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 6: {
                        nullValues.setIntNotNullDefaultNullValueException(bl ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 7: {
                        nullValues.setIntNullDefaultNullValueException(bl ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 8: {
                        nullValues.setIntNotNullNoDefaultNullValueDefault(bl ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 9: {
                        nullValues.setIntNullNoDefaultNullValueDefault(bl ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 10: {
                        nullValues.setIntNotNullDefaultNullValueDefault(bl ? null : Integer.valueOf(0));
                        break block0;
                    }
                    case 11: {
                        nullValues.setIntNullDefaultNullValueDefault(bl ? null : Integer.valueOf(0));
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + n2);
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        nullValues.setLongNotNullNoDefaultNullValueNone(bl ? null : Long.valueOf(0L));
                        break;
                    }
                    case 1: {
                        nullValues.setLongNullNoDefaultNullValueNone(bl ? null : Long.valueOf(0L));
                        break;
                    }
                    case 2: {
                        nullValues.setLongNotNullDefaultNullValueNone(bl ? null : Long.valueOf(0L));
                        break;
                    }
                    case 3: {
                        nullValues.setLongNullDefaultNullValueNone(bl ? null : Long.valueOf(0L));
                        break;
                    }
                    case 4: {
                        nullValues.setLongNotNullNoDefaultNullValueException(bl ? null : Long.valueOf(0L));
                        break;
                    }
                    case 5: {
                        nullValues.setLongNullNoDefaultNullValueException(bl ? null : Long.valueOf(0L));
                        break;
                    }
                    case 6: {
                        nullValues.setLongNotNullDefaultNullValueException(bl ? null : Long.valueOf(0L));
                        break;
                    }
                    case 7: {
                        nullValues.setLongNullDefaultNullValueException(bl ? null : Long.valueOf(0L));
                        break;
                    }
                    case 8: {
                        nullValues.setLongNotNullNoDefaultNullValueDefault(bl ? null : Long.valueOf(0L));
                        break;
                    }
                    case 9: {
                        nullValues.setLongNullNoDefaultNullValueDefault(bl ? null : Long.valueOf(0L));
                        break;
                    }
                    case 10: {
                        nullValues.setLongNotNullDefaultNullValueDefault(bl ? null : Long.valueOf(0L));
                        break;
                    }
                    case 11: {
                        nullValues.setLongNullDefaultNullValueDefault(bl ? null : Long.valueOf(0L));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal field index " + n2);
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        nullValues.setShortNotNullNoDefaultNullValueNone(bl ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 1: {
                        nullValues.setShortNullNoDefaultNullValueNone(bl ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 2: {
                        nullValues.setShortNotNullDefaultNullValueNone(bl ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 3: {
                        nullValues.setShortNullDefaultNullValueNone(bl ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 4: {
                        nullValues.setShortNotNullNoDefaultNullValueException(bl ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 5: {
                        nullValues.setShortNullNoDefaultNullValueException(bl ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 6: {
                        nullValues.setShortNotNullDefaultNullValueException(bl ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 7: {
                        nullValues.setShortNullDefaultNullValueException(bl ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 8: {
                        nullValues.setShortNotNullNoDefaultNullValueDefault(bl ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 9: {
                        nullValues.setShortNullNoDefaultNullValueDefault(bl ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 10: {
                        nullValues.setShortNotNullDefaultNullValueDefault(bl ? null : Short.valueOf((short)0));
                        break;
                    }
                    case 11: {
                        nullValues.setShortNullDefaultNullValueDefault(bl ? null : Short.valueOf((short)0));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal field index " + n2);
                    }
                }
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        nullValues.setByteNotNullNoDefaultNullValueNone(bl ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 1: {
                        nullValues.setByteNullNoDefaultNullValueNone(bl ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 2: {
                        nullValues.setByteNotNullDefaultNullValueNone(bl ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 3: {
                        nullValues.setByteNullDefaultNullValueNone(bl ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 4: {
                        nullValues.setByteNotNullNoDefaultNullValueException(bl ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 5: {
                        nullValues.setByteNullNoDefaultNullValueException(bl ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 6: {
                        nullValues.setByteNotNullDefaultNullValueException(bl ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 7: {
                        nullValues.setByteNullDefaultNullValueException(bl ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 8: {
                        nullValues.setByteNotNullNoDefaultNullValueDefault(bl ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 9: {
                        nullValues.setByteNullNoDefaultNullValueDefault(bl ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 10: {
                        nullValues.setByteNotNullDefaultNullValueDefault(bl ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    case 11: {
                        nullValues.setByteNullDefaultNullValueDefault(bl ? null : Byte.valueOf((byte)0));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal field index " + n2);
                    }
                }
            }
            case 4: {
                switch (n2) {
                    case 0: {
                        nullValues.setStringNotNullNoDefaultNullValueNone(bl ? null : "0");
                        break block0;
                    }
                    case 1: {
                        nullValues.setStringNullNoDefaultNullValueNone(bl ? null : "0");
                        break block0;
                    }
                    case 2: {
                        nullValues.setStringNotNullDefaultNullValueNone(bl ? null : "0");
                        break block0;
                    }
                    case 3: {
                        nullValues.setStringNullDefaultNullValueNone(bl ? null : "0");
                        break block0;
                    }
                    case 4: {
                        nullValues.setStringNotNullNoDefaultNullValueException(bl ? null : "0");
                        break block0;
                    }
                    case 5: {
                        nullValues.setStringNullNoDefaultNullValueException(bl ? null : "0");
                        break block0;
                    }
                    case 6: {
                        nullValues.setStringNotNullDefaultNullValueException(bl ? null : "0");
                        break block0;
                    }
                    case 7: {
                        nullValues.setStringNullDefaultNullValueException(bl ? null : "0");
                        break block0;
                    }
                    case 8: {
                        nullValues.setStringNotNullNoDefaultNullValueDefault(bl ? null : "0");
                        break block0;
                    }
                    case 9: {
                        nullValues.setStringNullNoDefaultNullValueDefault(bl ? null : "0");
                        break block0;
                    }
                    case 10: {
                        nullValues.setStringNotNullDefaultNullValueDefault(bl ? null : "0");
                        break block0;
                    }
                    case 11: {
                        nullValues.setStringNullDefaultNullValueDefault(bl ? null : "0");
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + n2);
            }
            case 5: {
                switch (n2) {
                    case 0: {
                        nullValues.setFloatNotNullNoDefaultNullValueNone(bl ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 1: {
                        nullValues.setFloatNullNoDefaultNullValueNone(bl ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 2: {
                        nullValues.setFloatNotNullDefaultNullValueNone(bl ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 3: {
                        nullValues.setFloatNullDefaultNullValueNone(bl ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 4: {
                        nullValues.setFloatNotNullNoDefaultNullValueException(bl ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 5: {
                        nullValues.setFloatNullNoDefaultNullValueException(bl ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 6: {
                        nullValues.setFloatNotNullDefaultNullValueException(bl ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 7: {
                        nullValues.setFloatNullDefaultNullValueException(bl ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 8: {
                        nullValues.setFloatNotNullNoDefaultNullValueDefault(bl ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 9: {
                        nullValues.setFloatNullNoDefaultNullValueDefault(bl ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 10: {
                        nullValues.setFloatNotNullDefaultNullValueDefault(bl ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                    case 11: {
                        nullValues.setFloatNullDefaultNullValueDefault(bl ? null : Float.valueOf(0.0f));
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + n2);
            }
            case 6: {
                switch (n2) {
                    case 0: {
                        nullValues.setDoubleNotNullNoDefaultNullValueNone(bl ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 1: {
                        nullValues.setDoubleNullNoDefaultNullValueNone(bl ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 2: {
                        nullValues.setDoubleNotNullDefaultNullValueNone(bl ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 3: {
                        nullValues.setDoubleNullDefaultNullValueNone(bl ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 4: {
                        nullValues.setDoubleNotNullNoDefaultNullValueException(bl ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 5: {
                        nullValues.setDoubleNullNoDefaultNullValueException(bl ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 6: {
                        nullValues.setDoubleNotNullDefaultNullValueException(bl ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 7: {
                        nullValues.setDoubleNullDefaultNullValueException(bl ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 8: {
                        nullValues.setDoubleNotNullNoDefaultNullValueDefault(bl ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 9: {
                        nullValues.setDoubleNullNoDefaultNullValueDefault(bl ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 10: {
                        nullValues.setDoubleNotNullDefaultNullValueDefault(bl ? null : Double.valueOf(0.0));
                        break block0;
                    }
                    case 11: {
                        nullValues.setDoubleNullDefaultNullValueDefault(bl ? null : Double.valueOf(0.0));
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + n2);
            }
            default: {
                throw new IllegalArgumentException("Illegal property type " + n);
            }
        }
    }

    private Object getValue(NullValues nullValues, int n, int n2) {
        if (nullValues == null) {
            return null;
        }
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return nullValues.getIntNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return nullValues.getIntNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return nullValues.getIntNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return nullValues.getIntNullDefaultNullValueNone();
                    }
                    case 4: {
                        return nullValues.getIntNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return nullValues.getIntNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return nullValues.getIntNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return nullValues.getIntNullDefaultNullValueException();
                    }
                    case 8: {
                        return nullValues.getIntNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return nullValues.getIntNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return nullValues.getIntNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return nullValues.getIntNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + n2);
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return nullValues.getLongNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return nullValues.getLongNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return nullValues.getLongNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return nullValues.getLongNullDefaultNullValueNone();
                    }
                    case 4: {
                        return nullValues.getLongNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return nullValues.getLongNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return nullValues.getLongNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return nullValues.getLongNullDefaultNullValueException();
                    }
                    case 8: {
                        return nullValues.getLongNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return nullValues.getLongNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return nullValues.getLongNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return nullValues.getLongNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + n2);
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return nullValues.getShortNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return nullValues.getShortNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return nullValues.getShortNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return nullValues.getShortNullDefaultNullValueNone();
                    }
                    case 4: {
                        return nullValues.getShortNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return nullValues.getShortNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return nullValues.getShortNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return nullValues.getShortNullDefaultNullValueException();
                    }
                    case 8: {
                        return nullValues.getShortNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return nullValues.getShortNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return nullValues.getShortNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return nullValues.getShortNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + n2);
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        return nullValues.getByteNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return nullValues.getByteNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return nullValues.getByteNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return nullValues.getByteNullDefaultNullValueNone();
                    }
                    case 4: {
                        return nullValues.getByteNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return nullValues.getByteNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return nullValues.getByteNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return nullValues.getByteNullDefaultNullValueException();
                    }
                    case 8: {
                        return nullValues.getByteNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return nullValues.getByteNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return nullValues.getByteNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return nullValues.getByteNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + n2);
            }
            case 4: {
                switch (n2) {
                    case 0: {
                        return nullValues.getStringNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return nullValues.getStringNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return nullValues.getStringNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return nullValues.getStringNullDefaultNullValueNone();
                    }
                    case 4: {
                        return nullValues.getStringNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return nullValues.getStringNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return nullValues.getStringNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return nullValues.getStringNullDefaultNullValueException();
                    }
                    case 8: {
                        return nullValues.getStringNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return nullValues.getStringNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return nullValues.getStringNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return nullValues.getStringNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + n2);
            }
            case 5: {
                switch (n2) {
                    case 0: {
                        return nullValues.getFloatNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return nullValues.getFloatNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return nullValues.getFloatNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return nullValues.getFloatNullDefaultNullValueNone();
                    }
                    case 4: {
                        return nullValues.getFloatNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return nullValues.getFloatNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return nullValues.getFloatNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return nullValues.getFloatNullDefaultNullValueException();
                    }
                    case 8: {
                        return nullValues.getFloatNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return nullValues.getFloatNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return nullValues.getFloatNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return nullValues.getFloatNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + n2);
            }
            case 6: {
                switch (n2) {
                    case 0: {
                        return nullValues.getDoubleNotNullNoDefaultNullValueNone();
                    }
                    case 1: {
                        return nullValues.getDoubleNullNoDefaultNullValueNone();
                    }
                    case 2: {
                        return nullValues.getDoubleNotNullDefaultNullValueNone();
                    }
                    case 3: {
                        return nullValues.getDoubleNullDefaultNullValueNone();
                    }
                    case 4: {
                        return nullValues.getDoubleNotNullNoDefaultNullValueException();
                    }
                    case 5: {
                        return nullValues.getDoubleNullNoDefaultNullValueException();
                    }
                    case 6: {
                        return nullValues.getDoubleNotNullDefaultNullValueException();
                    }
                    case 7: {
                        return nullValues.getDoubleNullDefaultNullValueException();
                    }
                    case 8: {
                        return nullValues.getDoubleNotNullNoDefaultNullValueDefault();
                    }
                    case 9: {
                        return nullValues.getDoubleNullNoDefaultNullValueDefault();
                    }
                    case 10: {
                        return nullValues.getDoubleNotNullDefaultNullValueDefault();
                    }
                    case 11: {
                        return nullValues.getDoubleNullDefaultNullValueDefault();
                    }
                }
                throw new IllegalArgumentException("Illegal field index " + n2);
            }
        }
        throw new IllegalArgumentException("Illegal property type " + n);
    }
}

