/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnType;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.Lob;
import com.mysql.clusterj.annotation.NotPersistent;
import com.mysql.clusterj.annotation.NullValue;
import com.mysql.clusterj.annotation.Persistent;
import com.mysql.clusterj.core.metadata.AbstractDomainFieldHandlerImpl;
import com.mysql.clusterj.core.metadata.DomainTypeHandlerImpl;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.Table;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class DomainFieldHandlerImpl
extends AbstractDomainFieldHandlerImpl {
    NullValue nullValue = NullValue.NONE;
    Method getMethod;
    protected Method setMethod;
    protected NullObjectOperationHandler nullValueDelegate;
    protected Index indexAnnotation = null;
    protected Persistent persistentAnnotation = null;
    protected com.mysql.clusterj.annotation.Column columnAnnotation = null;
    protected String columnAllowsNull;
    protected Lob lobAnnotation;
    protected boolean lob = false;
    protected NotPersistent notPersistentAnnotation;
    static NullObjectOperationHandler nullValueDEFAULT = new NullObjectOperationHandler(){

        @Override
        public boolean operationSetValue(DomainFieldHandlerImpl domainFieldHandlerImpl, Operation operation) {
            domainFieldHandlerImpl.operationSetValue(domainFieldHandlerImpl, domainFieldHandlerImpl.defaultValue, operation);
            return true;
        }
    };
    static NullObjectOperationHandler nullValueEXCEPTION = new NullObjectOperationHandler(){

        @Override
        public boolean operationSetValue(DomainFieldHandlerImpl domainFieldHandlerImpl, Operation operation) {
            throw new ClusterJUserException(AbstractDomainFieldHandlerImpl.local.message("ERR_Null_Value_Exception", (Object)domainFieldHandlerImpl.domainTypeHandler.getName(), (Object)domainFieldHandlerImpl.name));
        }
    };
    static NullObjectOperationHandler nullValueNONE = new NullObjectOperationHandler(){

        @Override
        public boolean operationSetValue(DomainFieldHandlerImpl domainFieldHandlerImpl, Operation operation) {
            return false;
        }
    };

    public int compareTo(Object object) {
        return this.compareTo((DomainFieldHandlerImpl)object);
    }

    public DomainFieldHandlerImpl(DomainTypeHandlerImpl<?> domainTypeHandlerImpl, Table table, int n, String string, Class<?> clazz, Method method, Method method2) {
        if (logger.isDebugEnabled()) {
            logger.debug("new DomainFieldHandlerImpl: fieldNumber: " + n + "; name:" + string + "; getMethod: " + method + "; setMethod: " + method2);
        }
        this.domainTypeHandler = domainTypeHandlerImpl;
        this.fieldNumber = n;
        this.name = string;
        this.type = clazz;
        this.setMethod = method2;
        this.getMethod = method;
        Annotation[] annotationArray = method2.getAnnotations();
        if (annotationArray != null && annotationArray.length != 0) {
            for (Annotation annotation : annotationArray) {
                this.error(local.message("ERR_Annotate_Set_Method", (Object)string, (Object)annotation.annotationType().getName()));
            }
        }
        this.notPersistentAnnotation = method.getAnnotation(NotPersistent.class);
        if (this.isPersistent()) {
            this.columnName = string.toLowerCase();
            this.columnNames = new String[]{string};
            this.columnAnnotation = method.getAnnotation(com.mysql.clusterj.annotation.Column.class);
            if (this.columnAnnotation != null) {
                if (this.columnAnnotation.name() != null) {
                    this.columnName = this.columnAnnotation.name();
                    this.columnNames = new String[]{this.columnName};
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Column name annotation for " + string + " is " + this.columnName);
                }
                this.columnAllowsNull = this.columnAnnotation.allowsNull();
                if (logger.isDebugEnabled()) {
                    logger.debug("Column allowsNull annotation for " + string + " is " + this.columnAllowsNull);
                }
                this.columnDefaultValue = this.columnAnnotation.defaultValue();
                if (this.columnDefaultValue.equals("")) {
                    this.columnDefaultValue = null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Column defaultValue annotation for " + string + " is " + this.columnDefaultValue);
                }
            }
            this.storeColumn = table.getColumn(this.columnName);
            if (this.storeColumn == null) {
                throw new ClusterJUserException(local.message("ERR_No_Column", string, table.getName(), this.columnName));
            }
            this.initializeColumnMetadata(this.storeColumn);
            if (logger.isDebugEnabled()) {
                logger.debug("Column type for " + string + " is " + this.storeColumnType.toString() + "; charset name is " + this.charsetName);
            }
            domainTypeHandlerImpl.registerPrimaryKeyColumn(this, this.columnName);
            this.lobAnnotation = method.getAnnotation(Lob.class);
        }
        if (this.primaryKey) {
            if (clazz.equals(Integer.TYPE)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerKeyInt;
            } else if (clazz.equals(Long.TYPE)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerKeyLong;
            } else if (clazz.equals(String.class)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerKeyString;
            } else if (clazz.equals(byte[].class)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerKeyBytes;
            } else if (clazz.equals(Short.TYPE)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerKeyShort;
            } else if (clazz.equals(Byte.TYPE)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerKeyByte;
            } else {
                this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
                this.error(local.message("ERR_Primary_Field_Type", domainTypeHandlerImpl.getName(), string, this.printableName(clazz)));
            }
        } else if (this.lobAnnotation != null) {
            this.lob = true;
            if (clazz.equals(byte[].class)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerBytesLob;
            } else if (clazz.equals(String.class)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerStringLob;
            } else {
                this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
                this.error(local.message("ERR_Unsupported_Field_Type", (Object)this.printableName(clazz), (Object)string));
            }
        } else if (!this.isPersistent()) {
            this.objectOperationHandlerDelegate = clazz.equals(Byte.TYPE) ? objectOperationHandlerNotPersistentByte : (clazz.equals(Double.TYPE) ? objectOperationHandlerNotPersistentDouble : (clazz.equals(Float.TYPE) ? objectOperationHandlerNotPersistentFloat : (clazz.equals(Integer.TYPE) ? objectOperationHandlerNotPersistentInt : (clazz.equals(Long.TYPE) ? objectOperationHandlerNotPersistentLong : (clazz.equals(Short.TYPE) ? objectOperationHandlerNotPersistentShort : objectOperationHandlerNotPersistentObject)))));
        } else if (clazz.equals(byte[].class)) {
            if (ColumnType.Blob == this.storeColumnType) {
                this.lob = true;
                this.objectOperationHandlerDelegate = objectOperationHandlerBytesLob;
            } else {
                this.objectOperationHandlerDelegate = objectOperationHandlerBytes;
            }
        } else if (clazz.equals(java.util.Date.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerJavaUtilDate;
        } else if (clazz.equals(BigDecimal.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerDecimal;
        } else if (clazz.equals(BigInteger.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerBigInteger;
        } else if (clazz.equals(Double.TYPE)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerDouble;
        } else if (clazz.equals(Float.TYPE)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerFloat;
        } else if (clazz.equals(Integer.TYPE)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerInt;
        } else if (clazz.equals(Integer.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerObjectInteger;
        } else if (clazz.equals(Long.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerObjectLong;
        } else if (clazz.equals(Short.class)) {
            this.objectOperationHandlerDelegate = ColumnType.Year.equals((Object)this.storeColumnType) ? objectOperationHandlerObjectShortYear : objectOperationHandlerObjectShort;
        } else if (clazz.equals(Float.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerObjectFloat;
        } else if (clazz.equals(Double.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerObjectDouble;
        } else if (clazz.equals(Long.TYPE)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerLong;
        } else if (clazz.equals(Short.TYPE)) {
            this.objectOperationHandlerDelegate = ColumnType.Year.equals((Object)this.storeColumnType) ? objectOperationHandlerShortYear : objectOperationHandlerShort;
        } else if (clazz.equals(String.class)) {
            if (ColumnType.Text == this.storeColumnType) {
                this.lob = true;
                this.objectOperationHandlerDelegate = objectOperationHandlerStringLob;
            } else {
                this.objectOperationHandlerDelegate = objectOperationHandlerString;
            }
        } else if (clazz.equals(Byte.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerObjectByte;
        } else if (clazz.equals(Byte.TYPE)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerByte;
        } else if (clazz.equals(Boolean.TYPE)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerBoolean;
        } else if (clazz.equals(Boolean.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerObjectBoolean;
        } else if (clazz.equals(Date.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlDate;
        } else if (clazz.equals(Time.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlTime;
        } else if (clazz.equals(Timestamp.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlTimestamp;
        } else {
            this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
            this.error(local.message("ERR_Unsupported_Field_Type", (Object)clazz.getName(), (Object)string));
        }
        this.indexAnnotation = method.getAnnotation(Index.class);
        Object var9_10 = null;
        if (this.indexAnnotation != null) {
            String string2 = this.indexAnnotation.name();
            if (this.indexAnnotation.columns().length != 0) {
                throw new ClusterJUserException(local.message("ERR_Index_Annotation_Columns", (Object)domainTypeHandlerImpl.getName(), (Object)string));
            }
        }
        this.registerIndices(domainTypeHandlerImpl);
        this.persistentAnnotation = method.getAnnotation(Persistent.class);
        if (this.persistentAnnotation != null) {
            this.nullValue = this.persistentAnnotation.nullValue();
            if (logger.isDebugEnabled()) {
                logger.debug("Persistent nullValue annotation for " + string + " is " + (Object)((Object)this.nullValue));
            }
        }
        this.defaultValue = this.objectOperationHandlerDelegate.getDefaultValueFor(this, this.columnDefaultValue);
        if (logger.isDebugEnabled()) {
            logger.debug("Default null value for " + string + " is " + this.defaultValue);
        }
        switch (this.nullValue) {
            case DEFAULT: {
                this.nullValueDelegate = nullValueDEFAULT;
                break;
            }
            case EXCEPTION: {
                this.nullValueDelegate = nullValueEXCEPTION;
                break;
            }
            case NONE: {
                this.nullValueDelegate = nullValueNONE;
            }
        }
        this.reportErrors();
    }

    public DomainFieldHandlerImpl(DomainTypeHandlerImpl<?> domainTypeHandlerImpl, Table table, int n, Column column) {
        this.domainTypeHandler = domainTypeHandlerImpl;
        this.fieldNumber = n;
        this.storeColumn = column;
        this.initializeColumnMetadata(column);
        this.name = this.columnName;
        this.columnNames = new String[]{this.columnName};
        if (this.primaryKey) {
            domainTypeHandlerImpl.registerPrimaryKeyColumn(this, this.columnName);
            switch (this.storeColumnType) {
                case Int: 
                case Unsigned: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerKeyInt;
                    this.type = Integer.TYPE;
                    break;
                }
                case Char: 
                case Varchar: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerKeyString;
                    this.type = String.class;
                    break;
                }
                case Bigint: 
                case Bigunsigned: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerKeyLong;
                    this.type = Long.TYPE;
                    break;
                }
                case Binary: 
                case Varbinary: 
                case Longvarbinary: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerKeyBytes;
                    this.type = byte[].class;
                    break;
                }
                case Smallint: 
                case Smallunsigned: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerKeyShort;
                    this.type = Short.TYPE;
                    break;
                }
                case Tinyint: 
                case Tinyunsigned: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerKeyByte;
                    this.type = Byte.TYPE;
                    break;
                }
                default: {
                    this.error(local.message("ERR_Primary_Column_Type", new Object[]{domainTypeHandlerImpl.getName(), this.name, this.storeColumnType}));
                    break;
                }
            }
        } else {
            switch (this.storeColumnType) {
                case Bigint: 
                case Bigunsigned: {
                    if (column.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectLong;
                        this.type = Long.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerLong;
                    this.type = Long.TYPE;
                    break;
                }
                case Binary: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerBytes;
                    this.type = byte[].class;
                    break;
                }
                case Bit: {
                    if (column.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectLong;
                        this.type = Long.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerLong;
                    this.type = Long.TYPE;
                    break;
                }
                case Blob: {
                    this.lob = true;
                    this.objectOperationHandlerDelegate = objectOperationHandlerBytesLob;
                    this.type = byte[].class;
                    break;
                }
                case Char: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerString;
                    this.type = String.class;
                    break;
                }
                case Date: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlDate;
                    this.type = Date.class;
                    break;
                }
                case Datetime: 
                case Datetime2: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlTimestamp;
                    this.type = Timestamp.class;
                    break;
                }
                case Decimal: 
                case Decimalunsigned: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerDecimal;
                    this.type = BigDecimal.class;
                    break;
                }
                case Double: {
                    if (column.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectDouble;
                        this.type = Double.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerDouble;
                    this.type = Double.TYPE;
                    break;
                }
                case Float: {
                    if (column.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectFloat;
                        this.type = Float.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerFloat;
                    this.type = Float.TYPE;
                    break;
                }
                case Int: {
                    if (column.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectInteger;
                        this.type = Integer.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerInt;
                    this.type = Integer.TYPE;
                    break;
                }
                case Longvarbinary: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerBytes;
                    this.type = byte[].class;
                    break;
                }
                case Longvarchar: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerString;
                    this.type = String.class;
                    break;
                }
                case Mediumint: 
                case Mediumunsigned: {
                    if (column.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectInteger;
                        this.type = Integer.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerInt;
                    this.type = Integer.TYPE;
                    break;
                }
                case Olddecimal: {
                    this.error(local.message("ERR_Unsupported_Field_Type", (Object)"Olddecimal", (Object)this.name));
                    this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
                    break;
                }
                case Olddecimalunsigned: {
                    this.error(local.message("ERR_Unsupported_Field_Type", (Object)"Olddecimalunsigned", (Object)this.name));
                    this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
                    break;
                }
                case Smallint: 
                case Smallunsigned: {
                    if (column.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectShort;
                        this.type = Short.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerShort;
                    this.type = Short.TYPE;
                    break;
                }
                case Text: {
                    this.lob = true;
                    this.objectOperationHandlerDelegate = objectOperationHandlerStringLob;
                    this.type = String.class;
                    break;
                }
                case Time: 
                case Time2: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlTime;
                    this.type = Time.class;
                    break;
                }
                case Timestamp: 
                case Timestamp2: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlTimestamp;
                    this.type = Timestamp.class;
                    break;
                }
                case Tinyint: 
                case Tinyunsigned: {
                    if (column.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectByte;
                        this.type = Byte.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerByte;
                    this.type = Byte.TYPE;
                    break;
                }
                case Undefined: {
                    this.error(local.message("ERR_Unsupported_Field_Type", (Object)"Undefined", (Object)this.name));
                    this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
                    break;
                }
                case Unsigned: {
                    if (column.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectInteger;
                        this.type = Integer.class;
                    } else {
                        this.objectOperationHandlerDelegate = objectOperationHandlerInt;
                        this.type = Integer.TYPE;
                    }
                }
                case Varbinary: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerBytes;
                    this.type = byte[].class;
                    break;
                }
                case Varchar: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerString;
                    this.type = String.class;
                    break;
                }
                case Year: {
                    if (column.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectShort;
                        this.type = Short.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerShort;
                    this.type = Short.TYPE;
                    break;
                }
                default: {
                    this.error(local.message("ERR_Unsupported_Field_Type", (Object)this.storeColumnType, (Object)this.name));
                    this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("new dynamic DomainFieldHandlerImpl: fieldNumber: " + this.fieldNumber + "; name: " + this.name + "; type: " + this.type);
        }
        this.nullValueDelegate = nullValueNONE;
        this.registerIndices(domainTypeHandlerImpl);
        this.reportErrors();
    }

    @Override
    public boolean isPersistent() {
        return this.notPersistentAnnotation == null;
    }

    protected void registerIndices(DomainTypeHandlerImpl<?> domainTypeHandlerImpl) {
        this.indices = domainTypeHandlerImpl.registerIndices(this, this.columnName);
        this.indexNames = domainTypeHandlerImpl.getIndexNames(this.indices);
        if (logger.isDebugEnabled()) {
            logger.debug("Index names for " + this.name + " are " + this.indexNames);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Indices for " + this.name + " are " + this.printIndices());
        }
    }

    @Override
    public void operationSetValue(ValueHandler valueHandler, Operation operation) {
        boolean bl = valueHandler.isNull(this.fieldNumber);
        if (logger.isDetailEnabled()) {
            logger.detail("Column: " + this.columnName + " field: " + this.name + " isNull: " + bl + " type: " + this.type + " delegate " + this.objectOperationHandlerDelegate.handler());
        }
        try {
            if (bl && this.nullValueDelegate.operationSetValue(this, operation)) {
                return;
            }
            this.objectOperationHandlerDelegate.operationSetValue((AbstractDomainFieldHandlerImpl)this, valueHandler, operation);
        }
        catch (ClusterJDatastoreException clusterJDatastoreException) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "setValue"), clusterJDatastoreException);
        }
    }

    @Override
    public boolean isLob() {
        return this.lob;
    }

    @Override
    public Object getDefaultValue() {
        Object object = this.objectOperationHandlerDelegate.getDefaultValueFor(this, null);
        return object;
    }

    protected static interface NullObjectOperationHandler {
        public boolean operationSetValue(DomainFieldHandlerImpl var1, Operation var2);
    }
}

