/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.junit.Ignore;

public class TestSuite
implements Test {
    public final String name;
    public final List<String> testClasses = new ArrayList<String>();
    public final List<TestCase> tests = new ArrayList<TestCase>();
    public Ignore ignoreTypeAnnotation = null;
    public String ignoreTypeReason = null;

    public TestSuite(String string) {
        this.name = string;
    }

    public TestSuite(Class<?> clazz) {
        this.name = clazz.getName();
        if (!TestCase.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("TestSuite<init>: " + clazz.getName());
        }
        this.addTestSuite(clazz);
    }

    public void addTestSuite(Class<? extends TestCase> clazz) {
        this.ignoreTypeAnnotation = clazz.getAnnotation(Ignore.class);
        this.ignoreTypeReason = this.ignoreTypeAnnotation == null ? null : this.ignoreTypeAnnotation.value();
        this.testClasses.add(clazz.getName());
        Method[] methodArray = clazz.getMethods();
        Ignore ignore = null;
        String string = null;
        for (Method method : methodArray) {
            ignore = method.getAnnotation(Ignore.class);
            String string2 = string = ignore == null ? null : ignore.value();
            if (!method.getName().startsWith("test") || method.getParameterTypes().length != 0 || !method.getReturnType().equals(Void.TYPE) || !Modifier.isPublic(method.getModifiers())) continue;
            try {
                if (this.ignoreTypeAnnotation != null || ignore != null) {
                    System.out.println(method.getName() + " @Ignore: " + this.ignoreTypeReason + ":" + string);
                    continue;
                }
                TestCase testCase = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                testCase.name = clazz.getSimpleName() + "." + method.getName();
                testCase.method = method;
                this.tests.add(testCase);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public int testCount() {
        return this.tests.size();
    }

    public int countTestCases() {
        return this.tests.size();
    }

    @Override
    public void run(TestResult testResult) {
        for (TestCase testCase : this.tests) {
            testCase.run(testResult);
        }
    }
}

