/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnType;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionServiceImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.FixedByteBufferPoolImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.NdbRecord;
import com.mysql.ndbjtie.ndbapi.NdbRecordConst;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

public class NdbRecordImpl {
    static final I18NHelper local = I18NHelper.getInstance(NdbRecordImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbRecordImpl.class);
    protected static final int SIZEOF_RECORD_SPECIFICATION = ClusterConnectionServiceImpl.SIZEOF_RECORD_SPECIFICATION;
    private NdbRecord ndbRecord = null;
    protected Column[] storeColumns = null;
    private NdbDictionary.RecordSpecificationArray recordSpecificationArray;
    NdbDictionary.TableConst tableConst = null;
    NdbDictionary.IndexConst indexConst = null;
    String name;
    protected int bufferSize;
    protected int maximumColumnId;
    protected int[] offsets;
    protected int[] lengths;
    protected static final byte[] BIT_IN_BYTE_MASK = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    protected static final byte[] RESET_BIT_IN_BYTE_MASK = new byte[]{-2, -3, -5, -9, -17, -33, -65, 127};
    protected static int[] BIT_INT_MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    protected static long[] BIT_LONG_MASK = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, -1L, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};
    protected int[] nullbitBitInByte = null;
    protected int[] nullbitByteOffset = null;
    protected int nullIndicatorSize;
    protected int maximumColumnLength;
    private NdbDictionary.Dictionary ndbDictionary;
    private int numberOfTableColumns;
    private FixedByteBufferPoolImpl bufferPool = null;
    int offset = 0;
    int nullablePosition = 0;
    byte[] defaultValues;
    private int[] recordSpecificationIndexes = null;
    private Column autoIncrementColumn;
    private AutoIncrementValueSetter autoIncrementValueSetter;
    private Set<String> projectedColumnSet;
    protected AutoIncrementValueSetter autoIncrementValueSetterError = new AutoIncrementValueSetter(){

        @Override
        public void set(ByteBuffer byteBuffer, long l) {
            throw new ClusterJFatalInternalException(local.message("ERR_No_AutoIncrement_Column", (Object)NdbRecordImpl.this.tableConst.getName()));
        }
    };
    protected AutoIncrementValueSetter autoIncrementValueSetterInt = new AutoIncrementValueSetter(){

        @Override
        public void set(ByteBuffer byteBuffer, long l) {
            if (logger.isDetailEnabled()) {
                logger.detail("autoincrement set value: " + l);
            }
            if (l < 0L || l > Integer.MAX_VALUE) {
                throw new ClusterJDatastoreException(local.message("ERR_AutoIncrement_Value_Out_Of_Range", l, NdbRecordImpl.this.autoIncrementColumn.getName(), NdbRecordImpl.this.tableConst.getName()));
            }
            NdbRecordImpl.this.setInt(byteBuffer, NdbRecordImpl.this.autoIncrementColumn, (int)l);
        }
    };
    protected AutoIncrementValueSetter autoIncrementValueSetterLong = new AutoIncrementValueSetter(){

        @Override
        public void set(ByteBuffer byteBuffer, long l) {
            if (logger.isDetailEnabled()) {
                logger.detail("autoincrement set value: " + l);
            }
            if (l < 0L) {
                throw new ClusterJDatastoreException(local.message("ERR_AutoIncrement_Value_Out_Of_Range", l, NdbRecordImpl.this.autoIncrementColumn.getName(), NdbRecordImpl.this.tableConst.getName()));
            }
            NdbRecordImpl.this.setLong(byteBuffer, NdbRecordImpl.this.autoIncrementColumn, l);
        }
    };
    protected AutoIncrementValueSetter autoIncrementValueSetterMediumInt = new AutoIncrementValueSetter(){

        @Override
        public void set(ByteBuffer byteBuffer, long l) {
            if (logger.isDetailEnabled()) {
                logger.detail("autoincrement set value: " + l);
            }
            if (l < (long)Utility.MIN_MEDIUMINT_VALUE || l > (long)Utility.MAX_MEDIUMINT_VALUE) {
                throw new ClusterJDatastoreException(local.message("ERR_AutoIncrement_Value_Out_Of_Range", l, NdbRecordImpl.this.autoIncrementColumn.getName(), NdbRecordImpl.this.tableConst.getName()));
            }
            NdbRecordImpl.this.setInt(byteBuffer, NdbRecordImpl.this.autoIncrementColumn, (int)l);
        }
    };
    protected AutoIncrementValueSetter autoIncrementValueSetterMediumUnsigned = new AutoIncrementValueSetter(){

        @Override
        public void set(ByteBuffer byteBuffer, long l) {
            if (logger.isDetailEnabled()) {
                logger.detail("autoincrement set value: " + l);
            }
            if (l < 0L || l > (long)Utility.MAX_MEDIUMUNSIGNED_VALUE) {
                throw new ClusterJDatastoreException(local.message("ERR_AutoIncrement_Value_Out_Of_Range", l, NdbRecordImpl.this.autoIncrementColumn.getName(), NdbRecordImpl.this.tableConst.getName()));
            }
            NdbRecordImpl.this.setInt(byteBuffer, NdbRecordImpl.this.autoIncrementColumn, (int)l);
        }
    };
    protected AutoIncrementValueSetter autoIncrementValueSetterShort = new AutoIncrementValueSetter(){

        @Override
        public void set(ByteBuffer byteBuffer, long l) {
            if (logger.isDetailEnabled()) {
                logger.detail("autoincrement set value: " + l);
            }
            if (l < 0L || l > 32767L) {
                throw new ClusterJDatastoreException(local.message("ERR_AutoIncrement_Value_Out_Of_Range", l, NdbRecordImpl.this.autoIncrementColumn.getName(), NdbRecordImpl.this.tableConst.getName()));
            }
            NdbRecordImpl.this.setShort(byteBuffer, NdbRecordImpl.this.autoIncrementColumn, (short)l);
        }
    };
    protected AutoIncrementValueSetter autoIncrementValueSetterByte = new AutoIncrementValueSetter(){

        @Override
        public void set(ByteBuffer byteBuffer, long l) {
            if (logger.isDetailEnabled()) {
                logger.detail("autoincrement set value: " + l);
            }
            if (l < 0L || l > 127L) {
                throw new ClusterJDatastoreException(local.message("ERR_AutoIncrement_Value_Out_Of_Range", l, NdbRecordImpl.this.autoIncrementColumn.getName(), NdbRecordImpl.this.tableConst.getName()));
            }
            NdbRecordImpl.this.setByte(byteBuffer, NdbRecordImpl.this.autoIncrementColumn, (byte)l);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NdbRecordImpl(Table table, NdbDictionary.Dictionary dictionary) {
        this.ndbDictionary = dictionary;
        this.tableConst = this.getNdbTable(table.getName());
        this.name = table.getKey();
        this.numberOfTableColumns = this.tableConst.getNoOfColumns();
        this.recordSpecificationIndexes = new int[this.numberOfTableColumns];
        this.offsets = new int[this.numberOfTableColumns];
        this.lengths = new int[this.numberOfTableColumns];
        this.nullbitBitInByte = new int[this.numberOfTableColumns];
        this.nullbitByteOffset = new int[this.numberOfTableColumns];
        this.storeColumns = new Column[this.numberOfTableColumns];
        this.projectedColumnSet = new TreeSet<String>();
        for (String string : table.getProjectedColumnNames()) {
            this.projectedColumnSet.add(string);
        }
        try {
            this.autoIncrementColumn = table.getAutoIncrementColumn();
            if (this.autoIncrementColumn != null) {
                this.chooseAutoIncrementValueSetter();
            }
            this.ndbRecord = this.createNdbRecord(table, dictionary);
            if (logger.isDetailEnabled()) {
                logger.detail(table.getName() + " " + this.dumpDefinition());
            }
            this.initializeDefaultBuffer();
        }
        finally {
            NdbDictionary.RecordSpecificationArray.delete(this.recordSpecificationArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NdbRecordImpl(Index index, Table table, NdbDictionary.Dictionary dictionary) {
        this.ndbDictionary = dictionary;
        this.tableConst = this.getNdbTable(table.getName());
        this.indexConst = this.getNdbIndex(index.getInternalName(), this.tableConst.getName());
        this.name = table.getName() + ":" + index.getInternalName();
        this.numberOfTableColumns = this.tableConst.getNoOfColumns();
        int n = this.indexConst.getNoOfColumns();
        this.recordSpecificationIndexes = new int[this.numberOfTableColumns];
        this.offsets = new int[this.numberOfTableColumns];
        this.lengths = new int[this.numberOfTableColumns];
        this.nullbitBitInByte = new int[this.numberOfTableColumns];
        this.nullbitByteOffset = new int[this.numberOfTableColumns];
        this.storeColumns = new Column[this.numberOfTableColumns];
        this.projectedColumnSet = new TreeSet<String>();
        for (String string : table.getProjectedColumnNames()) {
            this.projectedColumnSet.add(string);
        }
        this.recordSpecificationArray = NdbDictionary.RecordSpecificationArray.create(n);
        try {
            this.ndbRecord = this.createNdbRecord(index, table, dictionary);
            if (logger.isDetailEnabled()) {
                logger.detail(index.getInternalName() + " " + this.dumpDefinition());
            }
            this.initializeDefaultBuffer();
        }
        finally {
            NdbDictionary.RecordSpecificationArray.delete(this.recordSpecificationArray);
        }
    }

    private void initializeDefaultBuffer() {
        this.defaultValues = new byte[this.bufferSize];
        ByteBuffer byteBuffer = this.bufferPool.borrowBuffer();
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.put(this.defaultValues);
        for (Column column : this.storeColumns) {
            if (column == null || !column.getNullable()) continue;
            this.setNull(byteBuffer, column);
        }
        byteBuffer.position(0);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.get(this.defaultValues);
        this.bufferPool.returnBuffer(byteBuffer);
    }

    protected ByteBuffer newBuffer(boolean bl) {
        ByteBuffer byteBuffer = this.bufferPool.borrowBuffer();
        this.initializeBuffer(byteBuffer, bl);
        return byteBuffer;
    }

    protected ByteBuffer newBuffer() {
        return this.newBuffer(true);
    }

    protected void returnBuffer(ByteBuffer byteBuffer) {
        this.bufferPool.returnBuffer(byteBuffer);
    }

    protected void checkGuard(ByteBuffer byteBuffer, String string) {
        this.bufferPool.checkGuard(byteBuffer, string);
    }

    protected void initializeBuffer(ByteBuffer byteBuffer, boolean bl) {
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.clear();
        if (bl) {
            byteBuffer.put(this.defaultValues);
            byteBuffer.clear();
        }
    }

    protected void initializeBuffer(ByteBuffer byteBuffer) {
        this.initializeBuffer(byteBuffer, true);
    }

    public int setNull(ByteBuffer byteBuffer, Column column) {
        int n = column.getColumnId();
        if (!column.getNullable()) {
            return n;
        }
        int n2 = this.nullbitByteOffset[n];
        byte by = BIT_IN_BYTE_MASK[this.nullbitBitInByte[n]];
        byte by2 = byteBuffer.get(n2);
        byteBuffer.put(n2, (byte)(by2 | by));
        return n;
    }

    public int resetNull(ByteBuffer byteBuffer, Column column) {
        int n = column.getColumnId();
        if (!column.getNullable()) {
            return n;
        }
        int n2 = this.nullbitByteOffset[n];
        byte by = RESET_BIT_IN_BYTE_MASK[this.nullbitBitInByte[n]];
        byte by2 = byteBuffer.get(n2);
        byteBuffer.put(n2, (byte)(by2 & by));
        return n;
    }

    public int setBigInteger(ByteBuffer byteBuffer, Column column, BigInteger bigInteger) {
        this.resetNull(byteBuffer, column);
        int n = column.getColumnId();
        int n2 = this.offsets[n];
        byteBuffer.position(n2);
        Utility.convertValue(byteBuffer, column, bigInteger);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return n;
    }

    public int setByte(ByteBuffer byteBuffer, Column column, byte by) {
        this.resetNull(byteBuffer, column);
        int n = column.getColumnId();
        if (column.getType() == ColumnType.Bit) {
            byteBuffer.putInt(this.offsets[n], by & 0xFF);
        } else {
            byteBuffer.put(this.offsets[n], by);
        }
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return n;
    }

    public int setBytes(ByteBuffer byteBuffer, Column column, byte[] byArray) {
        this.resetNull(byteBuffer, column);
        int n = column.getColumnId();
        int n2 = this.offsets[n];
        int n3 = column.getLength();
        int n4 = column.getPrefixLength();
        if (n3 < byArray.length) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", column.getName(), n3, byArray.length));
        }
        byteBuffer.limit(n2 + n4 + n3);
        byteBuffer.position(n2);
        Utility.convertValue(byteBuffer, column, byArray);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return n;
    }

    public int setDecimal(ByteBuffer byteBuffer, Column column, BigDecimal bigDecimal) {
        this.resetNull(byteBuffer, column);
        int n = column.getColumnId();
        int n2 = this.offsets[n];
        byteBuffer.position(n2);
        Utility.convertValue(byteBuffer, column, bigDecimal);
        return n;
    }

    public int setDouble(ByteBuffer byteBuffer, Column column, double d) {
        this.resetNull(byteBuffer, column);
        int n = column.getColumnId();
        byteBuffer.putDouble(this.offsets[n], d);
        return n;
    }

    public int setFloat(ByteBuffer byteBuffer, Column column, float f) {
        this.resetNull(byteBuffer, column);
        int n = column.getColumnId();
        byteBuffer.putFloat(this.offsets[n], f);
        return n;
    }

    public int setInt(ByteBuffer byteBuffer, Column column, int n) {
        this.resetNull(byteBuffer, column);
        int n2 = column.getColumnId();
        int n3 = Utility.convertIntValueForStorage(column, n);
        byteBuffer.putInt(this.offsets[n2], n3);
        return n2;
    }

    public int setLong(ByteBuffer byteBuffer, Column column, long l) {
        this.resetNull(byteBuffer, column);
        int n = column.getColumnId();
        long l2 = Utility.convertLongValueForStorage(column, l);
        byteBuffer.putLong(this.offsets[n], l2);
        return n;
    }

    public int setShort(ByteBuffer byteBuffer, Column column, short s) {
        this.resetNull(byteBuffer, column);
        int n = column.getColumnId();
        if (column.getLength() == 4) {
            byteBuffer.putInt(this.offsets[n], s & 0xFFFF);
        } else {
            byteBuffer.putShort(this.offsets[n], s);
        }
        return n;
    }

    public int setString(ByteBuffer byteBuffer, DbImpl.BufferManager bufferManager, Column column, String string) {
        this.resetNull(byteBuffer, column);
        int n = column.getColumnId();
        int n2 = this.offsets[n];
        int n3 = column.getPrefixLength();
        int n4 = column.getLength() + n3;
        byteBuffer.limit(n2 + n4);
        byteBuffer.position(n2);
        ByteBuffer byteBuffer2 = Utility.encode(string, column, bufferManager);
        if (n4 < byteBuffer2.remaining()) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", column.getName(), n4 - n3, byteBuffer2.remaining() - n3));
        }
        byteBuffer.put(byteBuffer2);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return n;
    }

    public boolean getBoolean(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.getInt(this.offsets[n]);
        return Utility.getBoolean(this.storeColumns[n], n2);
    }

    public byte getByte(ByteBuffer byteBuffer, int n) {
        Column column = this.storeColumns[n];
        if (column.getType() == ColumnType.Bit) {
            int n2 = BIT_INT_MASK[column.getLength()];
            return (byte)(n2 & byteBuffer.getInt(this.offsets[n]));
        }
        return byteBuffer.get(this.offsets[n]);
    }

    public byte[] getBytes(ByteBuffer byteBuffer, int n) {
        return this.getBytes(byteBuffer, this.storeColumns[n]);
    }

    public byte[] getBytes(ByteBuffer byteBuffer, Column column) {
        int n = column.getColumnId();
        if (this.isNull(byteBuffer, n)) {
            return null;
        }
        int n2 = column.getPrefixLength();
        int n3 = this.lengths[n];
        int n4 = this.offsets[n];
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                n3 = (byteBuffer.get(n4) + 256) % 256;
                ++n4;
                break;
            }
            case 2: {
                n3 = (byteBuffer.get(n4) + 256) % 256;
                int n5 = (byteBuffer.get(n4 + 1) + 256) % 256;
                n3 += 256 * n5;
                n4 += 2;
                break;
            }
            default: {
                throw new ClusterJFatalInternalException(local.message("ERR_Invalid_Prefix_Length", n2));
            }
        }
        byteBuffer.position(n4);
        byte[] byArray = new byte[n3];
        byteBuffer.get(byArray);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return byArray;
    }

    public double getDouble(ByteBuffer byteBuffer, int n) {
        double d = byteBuffer.getDouble(this.offsets[n]);
        return d;
    }

    public float getFloat(ByteBuffer byteBuffer, int n) {
        float f = byteBuffer.getFloat(this.offsets[n]);
        return f;
    }

    public int getInt(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.getInt(this.offsets[n]);
        Column column = this.storeColumns[n];
        if (column.getType() == ColumnType.Bit) {
            int n3 = BIT_INT_MASK[column.getLength()];
            return n3 & Utility.getInt(this.storeColumns[n], n2);
        }
        return Utility.getInt(this.storeColumns[n], n2);
    }

    public long getLong(ByteBuffer byteBuffer, int n) {
        long l = byteBuffer.getLong(this.offsets[n]);
        Column column = this.storeColumns[n];
        if (column.getType() == ColumnType.Bit) {
            long l2 = BIT_LONG_MASK[column.getLength()];
            return l2 & Utility.getLong(this.storeColumns[n], l);
        }
        return Utility.getLong(this.storeColumns[n], l);
    }

    public short getShort(ByteBuffer byteBuffer, int n) {
        Column column = this.storeColumns[n];
        if (column.getType() == ColumnType.Bit) {
            int n2 = BIT_INT_MASK[column.getLength()];
            return (short)(n2 & byteBuffer.getInt(this.offsets[n]));
        }
        return byteBuffer.getShort(this.offsets[n]);
    }

    public String getString(ByteBuffer byteBuffer, int n, DbImpl.BufferManager bufferManager) {
        int n2;
        if (this.isNull(byteBuffer, n)) {
            return null;
        }
        Column column = this.storeColumns[n];
        int n3 = column.getPrefixLength();
        int n4 = this.offsets[n];
        byteBuffer.limit(byteBuffer.capacity());
        switch (n3) {
            case 0: {
                n2 = this.lengths[n];
                break;
            }
            case 1: {
                n2 = (byteBuffer.get(n4) + 256) % 256;
                ++n4;
                break;
            }
            case 2: {
                n2 = (byteBuffer.get(n4) + 256) % 256;
                int n5 = (byteBuffer.get(n4 + 1) + 256) % 256;
                n2 += 256 * n5;
                n4 += 2;
                break;
            }
            default: {
                throw new ClusterJFatalInternalException(local.message("ERR_Invalid_Prefix_Length", n3));
            }
        }
        byteBuffer.position(n4);
        byteBuffer.limit(n4 + n2);
        String string = Utility.decode(byteBuffer, column.getCharsetNumber(), bufferManager);
        if (n3 == 0) {
            string = string.trim();
        }
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return string;
    }

    public BigInteger getBigInteger(ByteBuffer byteBuffer, int n) {
        Column column = this.storeColumns[n];
        int n2 = column.getColumnId();
        int n3 = this.offsets[n2];
        int n4 = column.getPrecision();
        int n5 = column.getScale();
        int n6 = Utility.getDecimalColumnSpace(n4, n5);
        byteBuffer.position(n3);
        BigInteger bigInteger = Utility.getBigInteger(byteBuffer, n6, n4, n5);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return bigInteger;
    }

    public BigInteger getBigInteger(ByteBuffer byteBuffer, Column column) {
        int n = column.getColumnId();
        int n2 = this.offsets[n];
        int n3 = column.getPrecision();
        int n4 = column.getScale();
        int n5 = Utility.getDecimalColumnSpace(n3, n4);
        byteBuffer.position(n2);
        BigInteger bigInteger = Utility.getBigInteger(byteBuffer, n5, n3, n4);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return bigInteger;
    }

    public BigDecimal getDecimal(ByteBuffer byteBuffer, int n) {
        Column column = this.storeColumns[n];
        int n2 = column.getColumnId();
        int n3 = this.offsets[n2];
        int n4 = column.getPrecision();
        int n5 = column.getScale();
        int n6 = Utility.getDecimalColumnSpace(n4, n5);
        byteBuffer.position(n3);
        BigDecimal bigDecimal = Utility.getDecimal(byteBuffer, n6, n4, n5);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return bigDecimal;
    }

    public BigDecimal getDecimal(ByteBuffer byteBuffer, Column column) {
        int n = column.getColumnId();
        int n2 = this.offsets[n];
        int n3 = column.getPrecision();
        int n4 = column.getScale();
        int n5 = Utility.getDecimalColumnSpace(n3, n4);
        byteBuffer.position(n2);
        BigDecimal bigDecimal = Utility.getDecimal(byteBuffer, n5, n3, n4);
        byteBuffer.limit(this.bufferSize);
        byteBuffer.position(0);
        return bigDecimal;
    }

    public Boolean getObjectBoolean(ByteBuffer byteBuffer, int n) {
        if (this.isNull(byteBuffer, n)) {
            return null;
        }
        return this.getBoolean(byteBuffer, n);
    }

    public Boolean getObjectBoolean(ByteBuffer byteBuffer, Column column) {
        return this.getObjectBoolean(byteBuffer, column.getColumnId());
    }

    public Byte getObjectByte(ByteBuffer byteBuffer, int n) {
        if (this.isNull(byteBuffer, n)) {
            return null;
        }
        return this.getByte(byteBuffer, n);
    }

    public Byte getObjectByte(ByteBuffer byteBuffer, Column column) {
        return this.getObjectByte(byteBuffer, column.getColumnId());
    }

    public Float getObjectFloat(ByteBuffer byteBuffer, int n) {
        if (this.isNull(byteBuffer, n)) {
            return null;
        }
        return Float.valueOf(this.getFloat(byteBuffer, n));
    }

    public Float getObjectFloat(ByteBuffer byteBuffer, Column column) {
        return this.getObjectFloat(byteBuffer, column.getColumnId());
    }

    public Double getObjectDouble(ByteBuffer byteBuffer, int n) {
        if (this.isNull(byteBuffer, n)) {
            return null;
        }
        return this.getDouble(byteBuffer, n);
    }

    public Double getObjectDouble(ByteBuffer byteBuffer, Column column) {
        return this.getObjectDouble(byteBuffer, column.getColumnId());
    }

    public Integer getObjectInteger(ByteBuffer byteBuffer, int n) {
        if (this.isNull(byteBuffer, n)) {
            return null;
        }
        return this.getInt(byteBuffer, n);
    }

    public Integer getObjectInteger(ByteBuffer byteBuffer, Column column) {
        return this.getObjectInteger(byteBuffer, column.getColumnId());
    }

    public Long getObjectLong(ByteBuffer byteBuffer, int n) {
        if (this.isNull(byteBuffer, n)) {
            return null;
        }
        return this.getLong(byteBuffer, n);
    }

    public Long getObjectLong(ByteBuffer byteBuffer, Column column) {
        return this.getObjectLong(byteBuffer, column.getColumnId());
    }

    public Short getObjectShort(ByteBuffer byteBuffer, int n) {
        if (this.isNull(byteBuffer, n)) {
            return null;
        }
        return this.getShort(byteBuffer, n);
    }

    public Short getObjectShort(ByteBuffer byteBuffer, Column column) {
        return this.getObjectShort(byteBuffer, column.getColumnId());
    }

    public boolean isNull(ByteBuffer byteBuffer, int n) {
        if (!this.storeColumns[n].getNullable()) {
            return false;
        }
        byte by = byteBuffer.get(this.nullbitByteOffset[n]);
        boolean bl = this.isSet(by, this.nullbitBitInByte[n]);
        return bl;
    }

    public boolean isPresent(byte[] byArray, int n) {
        byte by = byArray[n / 8];
        return this.isSet(by, n % 8);
    }

    public void markPresent(byte[] byArray, int n) {
        int n2 = n / 8;
        byte by = BIT_IN_BYTE_MASK[n % 8];
        int n3 = n2;
        byArray[n3] = (byte)(byArray[n3] | (byte)by);
    }

    protected boolean isSet(byte by, int n) {
        byte by2 = BIT_IN_BYTE_MASK[n];
        boolean bl = (by & by2) != 0;
        return bl;
    }

    protected static void handleError(Object object, NdbDictionary.Dictionary dictionary) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, dictionary.getNdbError());
    }

    protected NdbRecord createNdbRecord(Index index, Table table, NdbDictionary.Dictionary dictionary) {
        String[] stringArray = index.getColumnNames();
        this.recordSpecificationArray = NdbDictionary.RecordSpecificationArray.create(stringArray.length);
        this.analyzeColumns(table, stringArray);
        NdbRecord ndbRecord = dictionary.createRecord(this.indexConst, this.tableConst, this.recordSpecificationArray, stringArray.length, SIZEOF_RECORD_SPECIFICATION, 0);
        NdbRecordImpl.handleError(ndbRecord, dictionary);
        int n = NdbDictionary.getRecordRowLength(ndbRecord);
        if (this.bufferSize < n) {
            logger.warn("NdbRecordImpl.createNdbRecord rowLength for " + this.name + " is " + n + " but we only allocate length of " + this.bufferSize);
            this.bufferSize = n;
        }
        this.bufferPool = new FixedByteBufferPoolImpl(this.bufferSize, this.name);
        return ndbRecord;
    }

    protected NdbRecord createNdbRecord(Table table, NdbDictionary.Dictionary dictionary) {
        String[] stringArray = table.getColumnNames();
        String[] stringArray2 = table.getProjectedColumnNames();
        this.recordSpecificationArray = NdbDictionary.RecordSpecificationArray.create(stringArray2.length);
        this.analyzeColumns(table, stringArray);
        NdbRecord ndbRecord = dictionary.createRecord(this.tableConst, (NdbDictionary.RecordSpecificationConstArray)this.recordSpecificationArray, stringArray2.length, SIZEOF_RECORD_SPECIFICATION, 0);
        NdbRecordImpl.handleError(ndbRecord, dictionary);
        int n = NdbDictionary.getRecordRowLength(ndbRecord);
        if (this.bufferSize < n) {
            logger.warn("NdbRecordImpl.createNdbRecord rowLength for " + this.name + " is " + n + " but we only allocate length of " + this.bufferSize);
            this.bufferSize = n;
        }
        this.bufferPool = new FixedByteBufferPoolImpl(this.bufferSize, this.name);
        return ndbRecord;
    }

    private void analyzeColumns(Table table, String[] stringArray) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        ArrayList<Column> arrayList2 = new ArrayList<Column>();
        ArrayList<Column> arrayList3 = new ArrayList<Column>();
        ArrayList<Column> arrayList4 = new ArrayList<Column>();
        ArrayList<Column> arrayList5 = new ArrayList<Column>();
        int n = 0;
        int n2 = 0;
        for (String string : stringArray) {
            Column column = table.getColumn(string);
            int n3 = column.getColumnId();
            this.recordSpecificationIndexes[n3] = n2++;
            this.lengths[n] = column.getLength();
            this.storeColumns[n] = column;
            ++n;
            if (!this.projectedColumnSet.contains(string)) continue;
            switch (column.getType()) {
                case Bigint: 
                case Bigunsigned: 
                case Bit: 
                case Blob: 
                case Date: 
                case Datetime: 
                case Datetime2: 
                case Double: 
                case Text: 
                case Time: 
                case Time2: 
                case Timestamp: 
                case Timestamp2: {
                    arrayList.add(column);
                    break;
                }
                case Binary: 
                case Char: 
                case Decimal: 
                case Decimalunsigned: 
                case Longvarbinary: 
                case Longvarchar: 
                case Olddecimal: 
                case Olddecimalunsigned: 
                case Tinyint: 
                case Tinyunsigned: 
                case Varbinary: 
                case Varchar: {
                    arrayList4.add(column);
                    break;
                }
                case Float: 
                case Int: 
                case Mediumint: 
                case Mediumunsigned: 
                case Unsigned: {
                    arrayList2.add(column);
                    break;
                }
                case Smallint: 
                case Smallunsigned: 
                case Year: {
                    arrayList3.add(column);
                    break;
                }
                case Undefined: {
                    throw new ClusterJFatalUserException(local.message("ERR_Unknown_Column_Type", new Object[]{table.getName(), string, column.getType()}));
                }
                default: {
                    throw new ClusterJFatalInternalException(local.message("ERR_Unknown_Column_Type", new Object[]{table.getName(), string, column.getType()}));
                }
            }
            if (!column.getNullable()) continue;
            arrayList5.add(column);
        }
        this.offset = arrayList5.size() + 0;
        this.nullIndicatorSize = this.offset = (7 + this.offset) / 8 * 8;
        for (Column column : arrayList) {
            this.analyzeColumn(8, column);
        }
        for (Column column : arrayList2) {
            this.analyzeColumn(4, column);
        }
        for (Column column : arrayList3) {
            this.analyzeColumn(2, column);
        }
        for (Column column : arrayList4) {
            this.analyzeColumn(1, column);
        }
        this.bufferSize = this.offset;
        if (logger.isDebugEnabled()) {
            logger.debug(this.dumpDefinition());
        }
    }

    private void analyzeColumn(int n, Column column) {
        int n2 = column.getColumnId();
        int n3 = this.recordSpecificationIndexes[n2];
        NdbDictionary.RecordSpecification recordSpecification = this.recordSpecificationArray.at(n3);
        NdbDictionary.ColumnConst columnConst = this.tableConst.getColumn(n2);
        recordSpecification.column(columnConst);
        recordSpecification.offset(this.offset);
        this.offsets[n2] = this.offset;
        int n4 = column.getColumnSpace();
        this.offset += n4 == 0 ? n : n4;
        if (column.getNullable()) {
            int n5;
            int n6 = this.nullablePosition / 8;
            this.nullbitBitInByte[n2] = n5 = this.nullablePosition - this.nullablePosition / 8 * 8;
            this.nullbitByteOffset[n2] = n6;
            recordSpecification.nullbit_byte_offset(n6);
            recordSpecification.nullbit_bit_in_byte(n5);
            ++this.nullablePosition;
        } else {
            recordSpecification.nullbit_byte_offset(0);
            recordSpecification.nullbit_bit_in_byte(0);
        }
    }

    private String dumpDefinition() {
        StringBuilder stringBuilder = new StringBuilder(this.name);
        stringBuilder.append(" numberOfColumns: ");
        stringBuilder.append(this.projectedColumnSet.size());
        stringBuilder.append('\n');
        for (int i = 0; i < this.numberOfTableColumns; ++i) {
            Column column = this.storeColumns[i];
            if (column == null || !this.projectedColumnSet.contains(column.getName())) continue;
            stringBuilder.append(" column: ");
            stringBuilder.append(column.getName());
            stringBuilder.append(" offset: ");
            stringBuilder.append(this.offsets[i]);
            stringBuilder.append(" length: ");
            stringBuilder.append(this.lengths[i]);
            stringBuilder.append(" nullbitBitInByte: ");
            stringBuilder.append(this.nullbitBitInByte[i]);
            stringBuilder.append(" nullbitByteOffset: ");
            stringBuilder.append(this.nullbitByteOffset[i]);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public String dumpValues(ByteBuffer byteBuffer, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("table name: ");
        stringBuilder.append(this.name);
        stringBuilder.append(" numberOfColumns: ");
        stringBuilder.append(this.numberOfTableColumns);
        stringBuilder.append('\n');
        for (int i = 0; i < this.numberOfTableColumns; ++i) {
            Column column = this.storeColumns[i];
            if (column == null || !this.projectedColumnSet.contains(column.getName())) continue;
            stringBuilder.append(" column: ");
            stringBuilder.append(column.getName());
            stringBuilder.append(" offset: ");
            stringBuilder.append(this.offsets[i]);
            stringBuilder.append(" length: ");
            stringBuilder.append(this.lengths[i]);
            stringBuilder.append(" nullbitBitInByte: ");
            int n = this.nullbitBitInByte[i];
            stringBuilder.append(n);
            stringBuilder.append(" nullbitByteOffset: ");
            int n2 = this.nullbitByteOffset[i];
            stringBuilder.append(n2);
            stringBuilder.append(" data: ");
            int n3 = column.getColumnSpace() != 0 ? column.getColumnSpace() : column.getSize();
            int n4 = this.offsets[i];
            byteBuffer.limit(this.bufferSize);
            byteBuffer.position(0);
            for (int j = n4; j < n4 + n3; ++j) {
                stringBuilder.append(String.format("%2x ", byteBuffer.get(j)));
            }
            stringBuilder.append(" null: ");
            stringBuilder.append(this.isNull(byteBuffer, i));
            if (byArray != null) {
                stringBuilder.append(" present: ");
                stringBuilder.append(this.isPresent(byArray, i));
            }
            stringBuilder.append('\n');
        }
        byteBuffer.position(0);
        return stringBuilder.toString();
    }

    NdbDictionary.TableConst getNdbTable(String string) {
        NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(string);
        if (tableConst == null) {
            tableConst = this.ndbDictionary.getTable(string.toLowerCase());
        }
        if (tableConst == null) {
            Utility.throwError(tableConst, this.ndbDictionary.getNdbError(), string);
        }
        return tableConst;
    }

    NdbDictionary.TableConst getNdbTable() {
        this.assertValid();
        return this.tableConst;
    }

    NdbDictionary.IndexConst getNdbIndex(String string, String string2) {
        NdbDictionary.IndexConst indexConst = this.ndbDictionary.getIndex(string, string2);
        if (indexConst == null) {
            Utility.throwError(indexConst, this.ndbDictionary.getNdbError(), string2 + "+" + string);
        }
        return indexConst;
    }

    NdbDictionary.IndexConst getNdbIndex() {
        this.assertValid();
        return this.indexConst;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public NdbRecordConst getNdbRecord() {
        this.assertValid();
        return this.ndbRecord;
    }

    public int getNumberOfColumns() {
        return this.numberOfTableColumns;
    }

    protected void releaseNdbRecord() {
        if (this.ndbRecord != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Releasing NdbRecord for " + this.tableConst.getName());
            }
            this.ndbDictionary.releaseRecord(this.ndbRecord);
            this.ndbRecord = null;
            this.bufferPool = null;
        }
    }

    protected void assertValid() {
        if (this.ndbRecord == null) {
            throw new ClusterJUserException(local.message("ERR_NdbRecord_was_released"));
        }
    }

    public int getNullIndicatorSize() {
        return this.nullIndicatorSize;
    }

    public boolean isLob(int n) {
        return this.storeColumns[n].isLob();
    }

    public void setAutoIncrementValue(ByteBuffer byteBuffer, long l) {
        this.autoIncrementValueSetter.set(byteBuffer, l);
    }

    private void chooseAutoIncrementValueSetter() {
        switch (this.autoIncrementColumn.getType()) {
            case Int: 
            case Unsigned: {
                if (logger.isDebugEnabled()) {
                    logger.debug("chooseAutoIncrementValueSetter autoIncrementValueSetterInt.");
                }
                this.autoIncrementValueSetter = this.autoIncrementValueSetterInt;
                break;
            }
            case Bigint: 
            case Bigunsigned: {
                if (logger.isDebugEnabled()) {
                    logger.debug("chooseAutoIncrementValueSetter autoIncrementValueSetterBigint.");
                }
                this.autoIncrementValueSetter = this.autoIncrementValueSetterLong;
                break;
            }
            case Mediumint: {
                if (logger.isDebugEnabled()) {
                    logger.debug("chooseAutoIncrementValueSetter autoIncrementValueSetterMediumint.");
                }
                this.autoIncrementValueSetter = this.autoIncrementValueSetterMediumInt;
                break;
            }
            case Mediumunsigned: {
                if (logger.isDebugEnabled()) {
                    logger.debug("chooseAutoIncrementValueSetter autoIncrementValueSetterMediumunsigned.");
                }
                this.autoIncrementValueSetter = this.autoIncrementValueSetterMediumUnsigned;
                break;
            }
            case Smallint: 
            case Smallunsigned: {
                if (logger.isDebugEnabled()) {
                    logger.debug("chooseAutoIncrementValueSetter autoIncrementValueSetterSmallint.");
                }
                this.autoIncrementValueSetter = this.autoIncrementValueSetterShort;
                break;
            }
            case Tinyint: 
            case Tinyunsigned: {
                if (logger.isDebugEnabled()) {
                    logger.debug("chooseAutoIncrementValueSetter autoIncrementValueSetterTinyint.");
                }
                this.autoIncrementValueSetter = this.autoIncrementValueSetterByte;
                break;
            }
            default: {
                logger.error("chooseAutoIncrementValueSetter undefined.");
                this.autoIncrementValueSetter = this.autoIncrementValueSetterError;
                throw new ClusterJFatalInternalException(local.message("ERR_Unsupported_AutoIncrement_Column_Type", new Object[]{this.autoIncrementColumn.getType(), this.autoIncrementColumn.getName(), this.tableConst.getName()}));
            }
        }
    }

    protected static interface AutoIncrementValueSetter {
        public void set(ByteBuffer var1, long var2);
    }
}

