DROP SCHEMA IF EXISTS sakila_x;
CREATE SCHEMA sakila_x;
USE sakila_x;

GRANT ALL ON sakila_x.* to 'test'@'localhost' IDENTIFIED BY 'test';
GRANT ALL ON sakila_x.* to 'test'@'%' IDENTIFIED BY 'test';
FLUSH PRIVILEGES;

CREATE TABLE `movies` (
  `doc` json DEFAULT NULL,
  `_id` varchar(32) GENERATED ALWAYS AS (json_unquote(json_extract(doc, '$._id'))) STORED
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `users` (
  `doc` json DEFAULT NULL,
  `_id` varchar(32) GENERATED ALWAYS AS (json_unquote(json_extract(doc, '$._id'))) STORED
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `character` (
  `character_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `age` smallint(4) unsigned NOT NULL,
  `gender` enum('male', 'female') NOT NULL,
  `from` varchar(30) DEFAULT '' NOT NULL,
  `universe` varchar(30) NOT NULL,
  `base` bool DEFAULT false NOT NULL,
  PRIMARY KEY (`character_id`),
  UNIQUE KEY `idx_name` (`name`),
  KEY `idx_base` (`base`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `movies` (`doc`) VALUES('{ "_id" : "3fcb3707946943b6a68354effbf34a89", "title" : "ACADEMY DINOSAUR", "description" : "A Epic Drama of a Feminist And a Mad Scientist who must Battle a Teacher in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "86 min", "rating" : "PG", "actors" : ["PENELOPE GUINESS", "CHRISTIAN GABLE", "LUCILLE TRACY", "SANDRA PECK", "JOHNNY CAGE", "MENA TEMPLE", "WARREN NOLTE", "OPRAH KILMER", "ROCK DUKAKIS", "MARY KEITEL"]}'),
('{ "_id" : "ddbeecd5760d443b9da594801d06fd08", "title" : "ACE GOLDFINGER", "description" : "A Astounding Epistle of a Database Administrator And a Explorer who must Find a Car in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "48 min", "rating" : "G", "actors" : ["BOB FAWCETT", "MINNIE ZELLWEGER", "SEAN GUINESS", "CHRIS DEPP"]}'),
('{ "_id" : "c30c983f24cb4ce1ac59e9262a8a42b6", "title" : "ADAPTATION HOLES", "description" : "A Astounding Reflection of a Lumberjack And a Car who must Sink a Lumberjack in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "50 min", "rating" : "NC-17", "actors" : ["NICK WAHLBERG", "BOB FAWCETT", "CAMERON STREEP", "RAY JOHANSSON", "JULIANNE DENCH"]}'),
('{ "_id" : "f6c74fcca4844206b7fd6608d9419ed5", "title" : "AFFAIR PREJUDICE", "description" : "A Fanciful Documentary of a Frisbee And a Lumberjack who must Chase a Monkey in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "117 min", "rating" : "G", "actors" : ["JODIE DEGENERES", "SCARLETT DAMON", "KENNETH PESCI", "FAY WINSLET", "OPRAH KILMER"]}'),
('{ "_id" : "a6f4b93e1a264a108393524f29546a8c", "title" : "AFRICAN EGG", "description" : "A Fast-Paced Documentary of a Pastry Chef And a Dentist who must Pursue a Forensic Psychologist in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "130 min", "rating" : "G", "actors" : ["GARY PHOENIX", "DUSTIN TAUTOU", "MATTHEW LEIGH", "MATTHEW CARREY", "THORA TEMPLE"]}'),
('{ "_id" : "2a91177d47ac4987b285ca07f731b305", "title" : "AGENT TRUMAN", "description" : "A Intrepid Panorama of a Robot And a Boy who must Escape a Sumo Wrestler in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "169 min", "rating" : "PG", "actors" : ["KIRSTEN PALTROW", "SANDRA KILMER", "JAYNE NEESON", "WARREN NOLTE", "MORGAN WILLIAMS", "KENNETH HOFFMAN", "REESE WEST"]}'),
('{ "_id" : "7dcd8f71b9df48399a9838945b2eb021", "title" : "AIRPLANE SIERRA", "description" : "A Touching Saga of a Hunter And a Butler who must Discover a Butler in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "62 min", "rating" : "PG-13", "actors" : ["JIM MOSTEL", "RICHARD PENN", "OPRAH KILMER", "MENA HOPPER", "MICHAEL BOLGER"]}'),
('{ "_id" : "eb239e1093334f779646124d3c5bd133", "title" : "AIRPORT POLLOCK", "description" : "A Epic Tale of a Moose And a Girl who must Confront a Monkey in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "54 min", "rating" : "R", "actors" : ["FAY KILMER", "GENE WILLIS", "SUSAN DAVIS", "LUCILLE DEE"]}'),
('{ "_id" : "789bc64b87844f689914aa99665899e0", "title" : "ALABAMA DEVIL", "description" : "A Thoughtful Panorama of a Database Administrator And a Mad Scientist who must Outgun a Mad Scientist in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "114 min", "rating" : "PG-13", "actors" : ["CHRISTIAN GABLE", "ELVIS MARX", "RIP CRAWFORD", "MENA TEMPLE", "RIP WINSLET", "WARREN NOLTE", "GRETA KEITEL", "WILLIAM HACKMAN", "MERYL ALLEN"]}'),
('{ "_id" : "a96409d9ac7f437c8864bf023a23bc22", "title" : "ALADDIN CALENDAR", "description" : "A Action-Packed Tale of a Man And a Lumberjack who must Reach a Feminist in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "63 min", "rating" : "NC-17", "actors" : ["ALEC WAYNE", "JUDY DEAN", "VAL BOLGER", "RAY JOHANSSON", "RENEE TRACY", "JADA RYDER", "GRETA MALDEN", "ROCK DUKAKIS"]}'),
('{ "_id" : "6287a6c91e6342319c94b76ae9c4ea4a", "title" : "ALAMO VIDEOTAPE", "description" : "A Boring Epistle of a Butler And a Cat who must Fight a Pastry Chef in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "126 min", "rating" : "G", "actors" : ["JOHNNY CAGE", "SCARLETT DAMON", "SEAN GUINESS", "MICHAEL BENING"]}'),
('{ "_id" : "06d9dea30e424b9cb56566ffb6ffbe6a", "title" : "ALASKA PHANTOM", "description" : "A Fanciful Saga of a Hunter And a Pastry Chef who must Vanquish a Boy in Australia", "release_year" : "2006", "language" : "English", "duration" : "136 min", "rating" : "PG", "actors" : ["VAL BOLGER", "BURT POSEY", "SIDNEY CROWE", "SYLVESTER DERN", "ALBERT JOHANSSON", "GENE MCKELLEN", "JEFF SILVERSTONE"]}'),
('{ "_id" : "dd70fc9a579e4b9080969d36d593dc63", "title" : "ALI FOREVER", "description" : "A Action-Packed Drama of a Dentist And a Crocodile who must Battle a Feminist in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "150 min", "rating" : "PG", "actors" : ["CARY MCCONAUGHEY", "CHRISTOPHER BERRY", "KENNETH TORN", "MORGAN MCDORMAND", "JON CHASE"]}'),
('{ "_id" : "36c17a4d14e8412f88ca6cbcc413f98b", "title" : "ALICE FANTASIA", "description" : "A Emotional Drama of a A Shark And a Database Administrator who must Vanquish a Pioneer in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "94 min", "rating" : "NC-17", "actors" : ["WOODY HOFFMAN", "MINNIE ZELLWEGER", "MORGAN WILLIAMS", "ROCK DUKAKIS"]}'),
('{ "_id" : "ea8eba5501f14af790b5270bead67647", "title" : "ALIEN CENTER", "description" : "A Brilliant Drama of a Cat And a Mad Scientist who must Battle a Feminist in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "46 min", "rating" : "NC-17", "actors" : ["BURT DUKAKIS", "KENNETH PALTROW", "SIDNEY CROWE", "RENEE TRACY", "HUMPHREY WILLIS", "MENA HOPPER"]}'),
('{ "_id" : "e34dcefdc2d04f7b8e9abeac83fdc2a0", "title" : "ALLEY EVOLUTION", "description" : "A Fast-Paced Drama of a Robot And a Composer who must Battle a Astronaut in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "180 min", "rating" : "NC-17", "actors" : ["KARL BERRY", "JUDE CRUISE", "ALBERT JOHANSSON", "GREGORY GOODING", "JOHN SUVARI"]}'),
('{ "_id" : "1116d49d08594c44aef7e596d6e0eba0", "title" : "ALONE TRIP", "description" : "A Fast-Paced Character Study of a Composer And a Dog who must Outgun a Boat in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "82 min", "rating" : "R", "actors" : ["ED CHASE", "KARL BERRY", "UMA WOOD", "WOODY JOLIE", "SPENCER DEPP", "CHRIS DEPP", "LAURENCE BULLOCK", "RENEE BALL"]}'),
('{ "_id" : "c4ebcac76f2d4096b03dcfb8564e5422", "title" : "ALTER VICTORY", "description" : "A Thoughtful Drama of a Composer And a Feminist who must Meet a Secret Agent in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "57 min", "rating" : "PG-13", "actors" : ["REESE KILMER", "JADA RYDER", "ANGELA WITHERSPOON", "OPRAH KILMER"]}'),
('{ "_id" : "1c8b37f7d0654bd0958d10758d5ed6c0", "title" : "AMADEUS HOLY", "description" : "A Emotional Display of a Pioneer And a Technical Writer who must Battle a Man in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "113 min", "rating" : "PG", "actors" : ["JOHNNY LOLLOBRIGIDA", "JULIA MCQUEEN", "VAL BOLGER", "KIRK JOVOVICH", "JAMES PITT", "PENELOPE CRONYN"]}'),
('{ "_id" : "10e74a06307a41feac6ccfa880fee878", "title" : "AMELIE HELLFIGHTERS", "description" : "A Boring Drama of a Woman And a Squirrel who must Conquer a Student in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "79 min", "rating" : "R", "actors" : ["CARMEN HUNT", "WALTER TORN", "ED MANSFIELD", "EWAN GOODING", "IAN TANDY", "LAURA BRODY"]}'),
('{ "_id" : "e53fdadefaf64b659a9e87695996eae0", "title" : "AMERICAN CIRCUS", "description" : "A Insightful Drama of a Girl And a Astronaut who must Face a Database Administrator in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "129 min", "rating" : "R", "actors" : ["KEVIN BLOOM", "RIP CRAWFORD", "SIDNEY CROWE", "WARREN JACKMAN", "FRANCES TOMEI"]}'),
('{ "_id" : "e4ce4b518db94708ae914b2fa426e033", "title" : "AMISTAD MIDSUMMER", "description" : "A Emotional Character Study of a Dentist And a Crocodile who must Meet a Sumo Wrestler in California", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "G", "actors" : ["CARY MCCONAUGHEY", "DARYL WAHLBERG", "SALMA NOLTE", "SCARLETT BENING"]}'),
('{ "_id" : "0f3dca31c7724516873ebc226b0be05d", "title" : "ANACONDA CONFESSIONS", "description" : "A Lacklusture Display of a Dentist And a Dentist who must Fight a Girl in Australia", "release_year" : "2006", "language" : "English", "duration" : "92 min", "rating" : "R", "actors" : ["PENELOPE GUINESS", "JENNIFER DAVIS", "ELVIS MARX", "JAYNE NOLTE", "HUMPHREY WILLIS"]}'),
('{ "_id" : "65a65f2c6f214f0db0bfa14e6318d775", "title" : "ANALYZE HOOSIERS", "description" : "A Thoughtful Display of a Explorer And a Pastry Chef who must Overcome a Feminist in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "181 min", "rating" : "R", "actors" : ["TOM MCKELLEN", "TOM MIRANDA", "JESSICA BAILEY", "GRETA MALDEN", "ED GUINESS"]}'),
('{ "_id" : "4932bb8cb1504286b5b29b85ac3dc178", "title" : "ANGELS LIFE", "description" : "A Thoughtful Display of a Woman And a Astronaut who must Battle a Robot in Berlin", "release_year" : "2006", "language" : "English", "duration" : "74 min", "rating" : "G", "actors" : ["PENELOPE GUINESS", "JENNIFER DAVIS", "GRACE MOSTEL", "JULIA BARRYMORE", "CHRISTOPHER BERRY", "ED MANSFIELD", "NICK DEGENERES", "LAURENCE BULLOCK", "RENEE BALL"]}'),
('{ "_id" : "d2574f0d263e47ffbcd7a3cf00816a98", "title" : "ANNIE IDENTITY", "description" : "A Amazing Panorama of a Pastry Chef And a Boat who must Escape a Woman in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "86 min", "rating" : "G", "actors" : ["ADAM GRANT", "CATE MCQUEEN", "GRETA KEITEL"]}'),
('{ "_id" : "5fedecced9ef4466917c2c517673a2e8", "title" : "ANONYMOUS HUMAN", "description" : "A Amazing Reflection of a Database Administrator And a Astronaut who must Outrace a Database Administrator in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "179 min", "rating" : "NC-17", "actors" : ["GRACE MOSTEL", "FAY KILMER", "JIM MOSTEL", "SUSAN DAVIS", "WHOOPI HURT", "EMILY DEE", "MERYL GIBSON", "MENA HOPPER", "ED GUINESS"]}'),
('{ "_id" : "62c7b197fc69424580e403a295032a50", "title" : "ANTHEM LUKE", "description" : "A Touching Panorama of a Waitress And a Woman who must Outrace a Dog in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "91 min", "rating" : "PG-13", "actors" : ["MILLA KEITEL", "OPRAH KILMER"]}'),
('{ "_id" : "393597503ca147e5b144399ba6ff5ed7", "title" : "ANTITRUST TOMATOES", "description" : "A Fateful Yarn of a Womanizer And a Feminist who must Succumb a Database Administrator in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "168 min", "rating" : "NC-17", "actors" : ["BETTE NICHOLSON", "UMA WOOD", "SIDNEY CROWE", "SALMA NOLTE", "WILLIAM HACKMAN", "RENEE BALL", "REESE WEST"]}'),
('{ "_id" : "d05a911050d04e29ad7eaf997bd4ba7f", "title" : "ANYTHING SAVANNAH", "description" : "A Epic Story of a Pastry Chef And a Woman who must Chase a Feminist in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "82 min", "rating" : "R", "actors" : ["JOE SWANK", "CHRISTOPHER WEST", "LISA MONROE"]}'),
('{ "_id" : "7678ef58eb4d4901b456ab5459103db7", "title" : "APACHE DIVINE", "description" : "A Awe-Inspiring Reflection of a Pastry Chef And a Teacher who must Overcome a Sumo Wrestler in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "92 min", "rating" : "NC-17", "actors" : ["NICK WAHLBERG", "CUBA OLIVIER", "ANNE CRONYN", "HENRY BERRY"]}'),
('{ "_id" : "8fcff3a58bda4015bf08ffe923489f10", "title" : "APOCALYPSE FLAMINGOS", "description" : "A Astounding Story of a Dog And a Squirrel who must Defeat a Woman in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "119 min", "rating" : "R", "actors" : ["MAE HOFFMAN", "VIVIEN BASINGER", "OPRAH KILMER", "WILL WILSON", "RUSSELL CLOSE"]}'),
('{ "_id" : "4e8cabc09b9348a49f7fac4f722611ea", "title" : "APOLLO TEEN", "description" : "A Action-Packed Reflection of a Crocodile And a Explorer who must Find a Sumo Wrestler in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "153 min", "rating" : "PG-13", "actors" : ["MAE HOFFMAN", "WOODY JOLIE", "ED MANSFIELD", "ALBERT JOHANSSON", "OPRAH KILMER", "MENA HOPPER", "JEFF SILVERSTONE", "DEBBIE AKROYD"]}'),
('{ "_id" : "64e4aa5d1fe84fdf88afd72dbc8c00fe", "title" : "ARABIA DOGMA", "description" : "A Touching Epistle of a Madman And a Mad Cow who must Defeat a Student in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "62 min", "rating" : "NC-17", "actors" : ["KARL BERRY", "RIP CRAWFORD", "JULIA MCQUEEN", "JOHNNY CAGE", "JUDE CRUISE", "SEAN WILLIAMS", "BURT POSEY", "WALTER TORN", "RUSSELL BACALL", "FRANCES TOMEI", "GRETA MALDEN", "LISA MONROE"]}'),
('{ "_id" : "1a2a557f514b4600807e1bb1139fedcb", "title" : "ARACHNOPHOBIA ROLLERCOASTER", "description" : "A Action-Packed Reflection of a Pastry Chef And a Composer who must Discover a Mad Scientist in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "147 min", "rating" : "PG-13", "actors" : ["GRACE MOSTEL", "JUDY DEAN", "DARYL WAHLBERG", "MORGAN HOPKINS", "CUBA ALLEN", "RITA REYNOLDS", "EWAN GOODING", "HUMPHREY GARLAND"]}'),
('{ "_id" : "635442b596d84ee0a9b40bf4e8f30fab", "title" : "ARGONAUTS TOWN", "description" : "A Emotional Epistle of a Forensic Psychologist And a Butler who must Challenge a Waitress in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "127 min", "rating" : "PG-13", "actors" : ["JULIA BARRYMORE", "GARY PENN", "GENE WILLIS", "DAN STREEP", "KEVIN GARLAND"]}'),
('{ "_id" : "00091b1649da4193b2d54ed10a7a8780", "title" : "ARIZONA BANG", "description" : "A Brilliant Panorama of a Mad Scientist And a Mad Cow who must Meet a Pioneer in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "121 min", "rating" : "PG", "actors" : ["KARL BERRY", "RAY JOHANSSON", "RUSSELL BACALL", "GRETA KEITEL"]}'),
('{ "_id" : "c0ffac199dc948158a51cb48471d4e00", "title" : "ARK RIDGEMONT", "description" : "A Beautiful Yarn of a Pioneer And a Monkey who must Pursue a Explorer in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "68 min", "rating" : "NC-17", "actors" : ["PARKER GOLDBERG", "NICK DEGENERES", "AUDREY BAILEY"]}'),
('{ "_id" : "0fa1b701e1cd46e7a53ac959e33461cf", "title" : "ARMAGEDDON LOST", "description" : "A Fast-Paced Tale of a Boat And a Teacher who must Succumb a Composer in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "99 min", "rating" : "G", "actors" : ["ANGELA HUDSON", "JAMES PITT", "PENELOPE CRONYN", "CUBA ALLEN", "KIM ALLEN", "GENE MCKELLEN", "GREGORY GOODING"]}'),
('{ "_id" : "295cb4668cbd4800b28e5fd210c138bb", "title" : "ARMY FLINTSTONES", "description" : "A Boring Saga of a Database Administrator And a Womanizer who must Battle a Waitress in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "148 min", "rating" : "R", "actors" : ["ED CHASE", "CARY MCCONAUGHEY", "MAE HOFFMAN", "GENE WILLIS", "PENELOPE CRONYN", "MATTHEW CARREY", "RUSSELL CLOSE"]}'),
('{ "_id" : "7059fda762be459394aaf9d68550f92f", "title" : "ARSENIC INDEPENDENCE", "description" : "A Fanciful Documentary of a Mad Cow And a Womanizer who must Find a Dentist in Berlin", "release_year" : "2006", "language" : "English", "duration" : "137 min", "rating" : "PG", "actors" : ["CUBA ALLEN", "RITA REYNOLDS", "OPRAH KILMER"]}'),
('{ "_id" : "64fb373635d34dc2a9c8a27a506924ec", "title" : "ARTIST COLDBLOODED", "description" : "A Stunning Reflection of a Robot And a Moose who must Challenge a Woman in California", "release_year" : "2006", "language" : "English", "duration" : "170 min", "rating" : "NC-17", "actors" : ["ED CHASE", "SANDRA KILMER", "KIRK JOVOVICH", "JAYNE NEESON", "SIDNEY CROWE", "RENEE TRACY", "MERYL ALLEN"]}'),
('{ "_id" : "d193680c10774e2bbd8e01bbe741e0e5", "title" : "ATLANTIS CAUSE", "description" : "A Thrilling Yarn of a Feminist And a Hunter who must Fight a Technical Writer in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "170 min", "rating" : "G", "actors" : ["WOODY HOFFMAN", "AUDREY OLIVIER", "JULIANNE DENCH", "FRANCES TOMEI", "GRETA KEITEL", "CATE HARRIS", "CHRIS DEPP", "HARVEY HOPE", "CUBA BIRCH"]}'),
('{ "_id" : "5d038f9995744659b32ca17b476883e4", "title" : "ATTACKS HATE", "description" : "A Fast-Paced Panorama of a Technical Writer And a Mad Scientist who must Find a Feminist in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "113 min", "rating" : "PG-13", "actors" : ["DAN TORN", "MILLA KEITEL", "GROUCHO DUNST", "BURT TEMPLE"]}'),
('{ "_id" : "a2263cedec814ade9a221303cf6c989e", "title" : "ATTRACTION NEWTON", "description" : "A Astounding Panorama of a Composer And a Frisbee who must Reach a Husband in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "83 min", "rating" : "PG-13", "actors" : ["UMA WOOD", "RIP WINSLET", "GARY PENN", "CHRISTOPHER WEST"]}'),
('{ "_id" : "91694221443f4350b7af2b68c2d47104", "title" : "AUTUMN CROW", "description" : "A Beautiful Tale of a Dentist And a Mad Cow who must Battle a Moose in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "108 min", "rating" : "G", "actors" : ["DUSTIN TAUTOU", "ANGELA HUDSON", "JAMES PITT"]}'),
('{ "_id" : "ced32eb5436b40f8926da96818b78ae5", "title" : "BABY HALL", "description" : "A Boring Character Study of a A Shark And a Girl who must Outrace a Feminist in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "153 min", "rating" : "NC-17", "actors" : ["NICK WAHLBERG", "MATTHEW JOHANSSON", "CHARLIZE DENCH", "DARYL WAHLBERG", "KEVIN GARLAND", "RIVER DEAN", "MINNIE KILMER", "VIVIEN BASINGER"]}'),
('{ "_id" : "d4b27a25b2924396bfeedd509ffaf787", "title" : "BACKLASH UNDEFEATED", "description" : "A Stunning Character Study of a Mad Scientist And a Mad Cow who must Kill a Car in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "118 min", "rating" : "PG-13", "actors" : ["CHRISTIAN AKROYD", "SPENCER PECK", "CHRISTOPHER BERRY", "SYLVESTER DERN", "DAN STREEP", "KEVIN GARLAND", "JANE JACKMAN"]}'),
('{ "_id" : "64339557db2145dc87db90b8ee0e0b93", "title" : "BADMAN DAWN", "description" : "A Emotional Panorama of a Pioneer And a Composer who must Escape a Mad Scientist in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "162 min", "rating" : "R", "actors" : ["BEN WILLIS", "HARRISON BALE", "CUBA ALLEN", "WARREN JACKMAN", "GRETA KEITEL", "OLYMPIA PFEIFFER", "ALAN DREYFUSS", "THORA TEMPLE"]}'),
('{ "_id" : "ee5bf28f01b14c06b137771c57647e91", "title" : "BAKED CLEOPATRA", "description" : "A Stunning Drama of a Forensic Psychologist And a Husband who must Overcome a Waitress in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "182 min", "rating" : "G", "actors" : ["MICHELLE MCCONAUGHEY"]}'),
('{ "_id" : "10b91762599c4073b8e8bfed183dfce6", "title" : "BALLOON HOMEWARD", "description" : "A Insightful Panorama of a Forensic Psychologist And a Mad Cow who must Build a Mad Scientist in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "75 min", "rating" : "NC-17", "actors" : ["PARKER GOLDBERG", "MENA TEMPLE", "GARY PENN", "RICHARD PENN", "RENEE BALL", "ROCK DUKAKIS"]}'),
('{ "_id" : "3f0442e75317489aaeb58bdf541c6d73", "title" : "BALLROOM MOCKINGBIRD", "description" : "A Thrilling Documentary of a Composer And a Monkey who must Find a Feminist in California", "release_year" : "2006", "language" : "English", "duration" : "173 min", "rating" : "G", "actors" : ["JUDY DEAN", "ADAM GRANT", "BEN WILLIS", "DARYL WAHLBERG", "HARRISON BALE", "LUCILLE DEE", "GENE MCKELLEN"]}'),
('{ "_id" : "b6b28ab005a54da3a0249ed440e32ed3", "title" : "BANG KWAI", "description" : "A Epic Drama of a Madman And a Cat who must Face a A Shark in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "87 min", "rating" : "NC-17", "actors" : ["BETTE NICHOLSON", "SANDRA PECK", "JULIA BARRYMORE", "MICHELLE MCCONAUGHEY", "WALTER TORN", "RUSSELL TEMPLE", "FAY WOOD"]}'),
('{ "_id" : "dd8ca8e3757b4da992b8837a99309a38", "title" : "BANGER PINOCCHIO", "description" : "A Awe-Inspiring Drama of a Car And a Pastry Chef who must Chase a Crocodile in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "113 min", "rating" : "R", "actors" : ["JOHNNY LOLLOBRIGIDA", "LUCILLE TRACY", "DUSTIN TAUTOU", "JAYNE NEESON", "GENE WILLIS", "AUDREY BAILEY"]}'),
('{ "_id" : "8c889ecbdf134b729aa9e07bfa76b30c", "title" : "BARBARELLA STREETCAR", "description" : "A Awe-Inspiring Story of a Feminist And a Cat who must Conquer a Dog in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "65 min", "rating" : "G", "actors" : ["MARY TANDY", "CUBA ALLEN", "NICK DEGENERES", "ALAN DREYFUSS", "GENE MCKELLEN"]}'),
('{ "_id" : "9b217baa82c043c4bd001119f8ecec37", "title" : "BAREFOOT MANCHURIAN", "description" : "A Intrepid Story of a Cat And a Student who must Vanquish a Girl in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "129 min", "rating" : "G", "actors" : ["JENNIFER DAVIS", "ELVIS MARX", "MILLA PECK", "KIRK JOVOVICH", "DARYL CRAWFORD", "ED MANSFIELD", "MORGAN WILLIAMS", "WILL WILSON"]}'),
('{ "_id" : "456790ab932d44eb857c76b678c7f934", "title" : "BASIC EASY", "description" : "A Stunning Epistle of a Man And a Husband who must Reach a Mad Scientist in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "90 min", "rating" : "PG-13", "actors" : ["JESSICA BAILEY", "PENELOPE MONROE", "GRETA KEITEL", "EWAN GOODING", "EMILY DEE", "GROUCHO WILLIAMS"]}'),
('{ "_id" : "563f2a1d56634e5b9d8cdd9db0eaab4c", "title" : "BEACH HEARTBREAKERS", "description" : "A Fateful Display of a Womanizer And a Mad Scientist who must Outgun a A Shark in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "122 min", "rating" : "G", "actors" : ["WOODY HOFFMAN", "NICK STALLONE", "MENA TEMPLE", "BEN WILLIS", "GENE WILLIS", "FRANCES TOMEI", "HARVEY HOPE"]}'),
('{ "_id" : "1eaae078cf704ed4a7d090283b8465e4", "title" : "BEAR GRACELAND", "description" : "A Astounding Saga of a Dog And a Boy who must Kill a Teacher in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "160 min", "rating" : "R", "actors" : ["SCARLETT DAMON", "PENELOPE CRONYN", "BEN HARRIS"]}'),
('{ "_id" : "011a5d2e88ab4910b4fa49c6ba32fd08", "title" : "BEAST HUNCHBACK", "description" : "A Awe-Inspiring Epistle of a Student And a Squirrel who must Defeat a Boy in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "89 min", "rating" : "R", "actors" : ["BETTE NICHOLSON", "JODIE DEGENERES", "ANGELINA ASTAIRE", "KENNETH TORN", "SUSAN DAVIS"]}'),
('{ "_id" : "e20b0a18f50b499f973d4e896ab32739", "title" : "BEAUTY GREASE", "description" : "A Fast-Paced Display of a Composer And a Moose who must Sink a Robot in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "175 min", "rating" : "G", "actors" : ["CAMERON ZELLWEGER", "ED MANSFIELD", "LUCILLE DEE", "NICK DEGENERES", "MICHAEL BENING"]}'),
('{ "_id" : "356ceca816c64a6ea0275d5be55e76a3", "title" : "BED HIGHBALL", "description" : "A Astounding Panorama of a Lumberjack And a Dog who must Redeem a Woman in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "106 min", "rating" : "NC-17", "actors" : ["JENNIFER DAVIS", "GINA DEGENERES", "SUSAN DAVIS", "ALBERT NOLTE", "AUDREY BAILEY"]}'),
('{ "_id" : "e515e0145b864ed29dcc97192c4523a5", "title" : "BEDAZZLED MARRIED", "description" : "A Astounding Character Study of a Madman And a Robot who must Meet a Mad Scientist in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "73 min", "rating" : "PG", "actors" : ["LUCILLE TRACY", "GARY PHOENIX", "DAN HARRIS", "PENELOPE MONROE", "JAYNE NOLTE", "LAURENCE BULLOCK", "REESE WEST"]}'),
('{ "_id" : "9332037d6ca541b2818aa0ea00c522e3", "title" : "BEETHOVEN EXORCIST", "description" : "A Epic Display of a Pioneer And a Student who must Challenge a Butler in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "151 min", "rating" : "PG-13", "actors" : ["SANDRA PECK", "WARREN JACKMAN", "SCARLETT BENING", "MINNIE KILMER", "VIVIEN BASINGER", "BELA WALKEN"]}'),
('{ "_id" : "b93d324a84494d3aa261ef57407affcf", "title" : "BEHAVIOR RUNAWAY", "description" : "A Unbelieveable Drama of a Student And a Husband who must Outrace a Sumo Wrestler in Berlin", "release_year" : "2006", "language" : "English", "duration" : "100 min", "rating" : "PG", "actors" : ["TIM HACKMAN", "REESE KILMER", "DARYL WAHLBERG", "RITA REYNOLDS", "ED GUINESS"]}'),
('{ "_id" : "c848d83a071e4840a6cfca5523b4f59b", "title" : "BENEATH RUSH", "description" : "A Astounding Panorama of a Man And a Monkey who must Discover a Man in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "53 min", "rating" : "NC-17", "actors" : ["REESE KILMER", "ANGELINA ASTAIRE", "GENE WILLIS", "CHRIS BRIDGES", "SUSAN DAVIS", "JANE JACKMAN", "VIVIEN BASINGER"]}'),
('{ "_id" : "d1ad4ca77e784b3a9511bd1cb618a592", "title" : "BERETS AGENT", "description" : "A Taut Saga of a Crocodile And a Boy who must Overcome a Technical Writer in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "77 min", "rating" : "PG-13", "actors" : ["GRACE MOSTEL", "JULIA BARRYMORE", "JESSICA BAILEY", "JULIANNE DENCH", "CATE HARRIS", "ANGELA WITHERSPOON", "IAN TANDY", "WILLIAM HACKMAN", "MERYL ALLEN", "JULIA FAWCETT"]}'),
('{ "_id" : "cbf82358c4bd4abc9066da9221188ed2", "title" : "BETRAYED REAR", "description" : "A Emotional Character Study of a Boat And a Pioneer who must Find a Explorer in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "122 min", "rating" : "NC-17", "actors" : ["CHRISTIAN AKROYD", "ANGELINA ASTAIRE", "MORGAN MCDORMAND", "NICK DEGENERES"]}'),
('{ "_id" : "0e10f4a28cca452ebdc025074ab544cf", "title" : "BEVERLY OUTLAW", "description" : "A Fanciful Documentary of a Womanizer And a Boat who must Defeat a Madman in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "R", "actors" : ["SANDRA PECK", "JODIE DEGENERES", "RALPH CRUZ", "JOHN SUVARI"]}'),
('{ "_id" : "5b5004154d514d0389e072b35874b152", "title" : "BIKINI BORROWERS", "description" : "A Astounding Drama of a Astronaut And a Cat who must Discover a Woman in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "142 min", "rating" : "NC-17", "actors" : ["BETTE NICHOLSON", "PENELOPE CRONYN"]}'),
('{ "_id" : "3833a1f0c76e435fa1ce19d6deec19c3", "title" : "BILKO ANONYMOUS", "description" : "A Emotional Reflection of a Teacher And a Man who must Meet a Cat in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "100 min", "rating" : "PG-13", "actors" : ["GOLDIE BRODY", "ELLEN PRESLEY", "RUSSELL CLOSE"]}'),
('{ "_id" : "0581613aa76548a2b96051c9b2c26d08", "title" : "BILL OTHERS", "description" : "A Stunning Saga of a Mad Scientist And a Forensic Psychologist who must Challenge a Squirrel in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "93 min", "rating" : "PG", "actors" : ["DUSTIN TAUTOU", "MINNIE ZELLWEGER", "CHRIS BRIDGES", "RUSSELL TEMPLE", "AL GARLAND", "LAURENCE BULLOCK"]}'),
('{ "_id" : "1022bdfdf5c64c9284f92d63ef7cd261", "title" : "BINGO TALENTED", "description" : "A Touching Tale of a Girl And a Crocodile who must Discover a Waitress in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "150 min", "rating" : "PG-13", "actors" : ["GOLDIE BRODY", "CAMERON WRAY", "CARY MCCONAUGHEY", "JON CHASE", "RENEE BALL"]}'),
('{ "_id" : "879a7d213a4a492da14ec35ba8737cad", "title" : "BIRCH ANTITRUST", "description" : "A Fanciful Panorama of a Husband And a Pioneer who must Outgun a Dog in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "162 min", "rating" : "PG", "actors" : ["JOE SWANK", "WOODY HOFFMAN", "DARYL WAHLBERG", "EWAN GOODING", "ALAN DREYFUSS", "MATTHEW CARREY"]}'),
('{ "_id" : "a2393e2f80ca4ab2a94db30924ea0bca", "title" : "BIRD INDEPENDENCE", "description" : "A Thrilling Documentary of a Car And a Student who must Sink a Hunter in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "163 min", "rating" : "G", "actors" : ["FAY KILMER", "JAYNE NOLTE"]}'),
('{ "_id" : "40c3a2a47afc49c1819d09dcd2cebfed", "title" : "BIRDCAGE CASPER", "description" : "A Fast-Paced Saga of a Frisbee And a Astronaut who must Overcome a Feminist in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "103 min", "rating" : "NC-17", "actors" : ["KENNETH PESCI", "KENNETH TORN", "SALMA NOLTE", "RENEE BALL"]}'),
('{ "_id" : "a534eed947444a1c8bc522c9d6d0d6df", "title" : "BIRDS PERDITION", "description" : "A Boring Story of a Womanizer And a Pioneer who must Face a Dog in California", "release_year" : "2006", "language" : "English", "duration" : "61 min", "rating" : "G", "actors" : ["SANDRA PECK", "GARY PENN", "SYLVESTER DERN", "WHOOPI HURT"]}'),
('{ "_id" : "87cee516088448229906f5894bf05fd4", "title" : "BLACKOUT PRIVATE", "description" : "A Intrepid Yarn of a Pastry Chef And a Mad Scientist who must Challenge a Secret Agent in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "PG", "actors" : ["SANDRA KILMER", "CARY MCCONAUGHEY", "CAMERON ZELLWEGER", "KENNETH HOFFMAN", "MATTHEW CARREY"]}'),
('{ "_id" : "9e7be8959d6247f989bdad7ff7826535", "title" : "BLADE POLISH", "description" : "A Thoughtful Character Study of a Frisbee And a Pastry Chef who must Fight a Dentist in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "114 min", "rating" : "PG-13", "actors" : ["JENNIFER DAVIS", "ALEC WAYNE", "KEVIN GARLAND", "RIVER DEAN", "ANGELA WITHERSPOON"]}'),
('{ "_id" : "3bdc33e90cc44557ae05465585645d30", "title" : "BLANKET BEVERLY", "description" : "A Emotional Documentary of a Student And a Girl who must Build a Boat in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "148 min", "rating" : "G", "actors" : ["FRED COSTNER", "ALAN DREYFUSS", "BURT TEMPLE", "THORA TEMPLE"]}'),
('{ "_id" : "6e825aebb6684c9f814343856282880d", "title" : "BLINDNESS GUN", "description" : "A Touching Drama of a Robot And a Dentist who must Meet a Hunter in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "103 min", "rating" : "PG-13", "actors" : ["BURT DUKAKIS", "CHRIS BRIDGES", "ADAM HOPPER"]}'),
('{ "_id" : "6b6745223e3847d5baa2a8e32a46679d", "title" : "BLOOD ARGONAUTS", "description" : "A Boring Drama of a Explorer And a Man who must Kill a Lumberjack in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "71 min", "rating" : "G", "actors" : ["CATE MCQUEEN", "ADAM HOPPER", "LAURA BRODY", "CUBA BIRCH"]}'),
('{ "_id" : "2d59cdfdb48347cd926976bf1a66fb0d", "title" : "BLUES INSTINCT", "description" : "A Insightful Documentary of a Boat And a Composer who must Meet a Forensic Psychologist in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "50 min", "rating" : "G", "actors" : ["CAMERON STREEP", "GROUCHO DUNST", "SALMA NOLTE", "MATTHEW CARREY"]}'),
('{ "_id" : "a58492db6f7744d29a80d88126bf1775", "title" : "BOILED DARES", "description" : "A Awe-Inspiring Story of a Waitress And a Dog who must Discover a Dentist in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "102 min", "rating" : "PG", "actors" : ["DAN TORN", "TIM HACKMAN", "NICK STALLONE", "PENELOPE PINKETT", "JIM MOSTEL", "MORGAN HOPKINS", "GREGORY GOODING", "JULIA FAWCETT"]}'),
('{ "_id" : "a5fb5c54c55641a686e12fc676435ee9", "title" : "BONNIE HOLOCAUST", "description" : "A Fast-Paced Story of a Crocodile And a Robot who must Find a Moose in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "63 min", "rating" : "G", "actors" : ["JOHNNY LOLLOBRIGIDA", "JULIA MCQUEEN", "HENRY BERRY", "MINNIE ZELLWEGER", "SUSAN DAVIS", "FRANCES TOMEI", "FAY WINSLET", "OPRAH KILMER", "ED GUINESS"]}'),
('{ "_id" : "03a831d319624c4d8e695c5ac2276168", "title" : "BOOGIE AMELIE", "description" : "A Lacklusture Character Study of a Husband And a Sumo Wrestler who must Succumb a Technical Writer in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "121 min", "rating" : "R", "actors" : ["KEVIN BLOOM", "JODIE DEGENERES", "GROUCHO SINATRA", "NICK DEGENERES", "GENE MCKELLEN", "MERYL ALLEN"]}'),
('{ "_id" : "d55b95e66f894f73bfa66b1d902d42ba", "title" : "BOONDOCK BALLROOM", "description" : "A Fateful Panorama of a Crocodile And a Boy who must Defeat a Monkey in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "76 min", "rating" : "NC-17", "actors" : ["ED CHASE", "JENNIFER DAVIS", "UMA WOOD", "FRED COSTNER", "KIRSTEN PALTROW", "SANDRA PECK", "DAN HARRIS", "RAY JOHANSSON", "KENNETH PESCI", "CHRIS BRIDGES", "WARREN JACKMAN", "HUMPHREY GARLAND", "AUDREY BAILEY"]}'),
('{ "_id" : "f314ba6d3f59401a83b9259e18d187bb", "title" : "BORN SPINAL", "description" : "A Touching Epistle of a Frisbee And a Husband who must Pursue a Student in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "179 min", "rating" : "PG", "actors" : ["KIRSTEN PALTROW", "SISSY SOBIESKI", "NICK STALLONE", "DUSTIN TAUTOU", "RAY JOHANSSON", "KENNETH PALTROW", "DAN STREEP", "RITA REYNOLDS", "MERYL ALLEN"]}'),
('{ "_id" : "6fc9e3664d014de28d57c43cc214da5e", "title" : "BORROWERS BEDAZZLED", "description" : "A Brilliant Epistle of a Teacher And a Sumo Wrestler who must Defeat a Man in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "63 min", "rating" : "G", "actors" : ["CUBA OLIVIER", "ELVIS MARX", "KIRK JOVOVICH", "SCARLETT DAMON", "DARYL CRAWFORD", "HARVEY HOPE", "JON CHASE"]}'),
('{ "_id" : "1de499bdd2f14dcdad2bcee3f3c308c2", "title" : "BOULEVARD MOB", "description" : "A Fateful Epistle of a Moose And a Monkey who must Confront a Lumberjack in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "63 min", "rating" : "R", "actors" : ["RIP CRAWFORD", "AUDREY OLIVIER", "KIRSTEN AKROYD", "MORGAN MCDORMAND", "DAN STREEP", "EWAN GOODING", "ANGELA WITHERSPOON", "HARVEY HOPE"]}'),
('{ "_id" : "0583d59e6def475b91eec5fd418d0d7e", "title" : "BOUND CHEAPER", "description" : "A Thrilling Panorama of a Database Administrator And a Astronaut who must Challenge a Lumberjack in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "98 min", "rating" : "PG", "actors" : ["KARL BERRY", "CUBA OLIVIER"]}'),
('{ "_id" : "10309ff4b2fe42b69575eaf5f6b46035", "title" : "BOWFINGER GABLES", "description" : "A Fast-Paced Yarn of a Waitress And a Composer who must Outgun a Dentist in California", "release_year" : "2006", "language" : "English", "duration" : "72 min", "rating" : "NC-17", "actors" : ["KARL BERRY", "CARMEN HUNT", "MICHELLE MCCONAUGHEY", "MINNIE ZELLWEGER", "WILL WILSON"]}'),
('{ "_id" : "b97ae7448ce64322b2ed0949c421a88b", "title" : "BRANNIGAN SUNRISE", "description" : "A Amazing Epistle of a Moose And a Crocodile who must Outrace a Dog in Berlin", "release_year" : "2006", "language" : "English", "duration" : "121 min", "rating" : "PG", "actors" : ["RIP CRAWFORD", "KENNETH HOFFMAN"]}'),
('{ "_id" : "7058f11ee94a4d90b1a2217936df69d2", "title" : "BRAVEHEART HUMAN", "description" : "A Insightful Story of a Dog And a Pastry Chef who must Battle a Girl in Berlin", "release_year" : "2006", "language" : "English", "duration" : "176 min", "rating" : "PG-13", "actors" : ["NICK STALLONE", "KIRSTEN AKROYD", "JANE JACKMAN", "JAYNE NOLTE"]}'),
('{ "_id" : "997732bc96c84a53ab04198e76cdd8c4", "title" : "BREAKFAST GOLDFINGER", "description" : "A Beautiful Reflection of a Student And a Student who must Fight a Moose in Berlin", "release_year" : "2006", "language" : "English", "duration" : "123 min", "rating" : "G", "actors" : ["ANGELINA ASTAIRE", "RUSSELL TEMPLE", "AL GARLAND", "MICHAEL BOLGER", "JULIA ZELLWEGER"]}'),
('{ "_id" : "000c43b8423446ebaeb657a52a497ba5", "title" : "BREAKING HOME", "description" : "A Beautiful Display of a Secret Agent And a Monkey who must Battle a Sumo Wrestler in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "169 min", "rating" : "PG-13", "actors" : ["GRACE MOSTEL", "HELEN VOIGHT", "WOODY HOFFMAN", "CARMEN HUNT", "FRANCES TOMEI", "MORGAN WILLIAMS"]}'),
('{ "_id" : "30bd9934e314446ebb02348644a498f9", "title" : "BRIDE INTRIGUE", "description" : "A Epic Tale of a Robot And a Monkey who must Vanquish a Man in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "56 min", "rating" : "G", "actors" : ["ANGELA HUDSON"]}'),
('{ "_id" : "8664607659e24b6bb31d1c418f907fbf", "title" : "BRIGHT ENCOUNTERS", "description" : "A Fateful Yarn of a Lumberjack And a Feminist who must Conquer a Student in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "73 min", "rating" : "PG-13", "actors" : ["CAMERON ZELLWEGER", "ALBERT NOLTE", "RENEE BALL", "MERYL ALLEN"]}'),
('{ "_id" : "fec6271b331e4c7aa991b7b70bd60417", "title" : "BRINGING HYSTERICAL", "description" : "A Fateful Saga of a A Shark And a Technical Writer who must Find a Woman in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "136 min", "rating" : "PG", "actors" : ["FRANCES DAY-LEWIS", "ANGELA WITHERSPOON"]}'),
('{ "_id" : "e69523b53a334aaa877f3319a82ac8e9", "title" : "BROOKLYN DESERT", "description" : "A Beautiful Drama of a Dentist And a Composer who must Battle a Sumo Wrestler in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "161 min", "rating" : "R", "actors" : ["JODIE DEGENERES", "JAYNE NEESON", "SEAN GUINESS", "ALBERT NOLTE", "GROUCHO WILLIAMS"]}'),
('{ "_id" : "04d029e638134a2582aa87861e62ee51", "title" : "BROTHERHOOD BLANKET", "description" : "A Fateful Character Study of a Butler And a Technical Writer who must Sink a Astronaut in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "73 min", "rating" : "R", "actors" : ["FRED COSTNER", "FRANCES DAY-LEWIS", "JUDE CRUISE", "JAYNE NEESON", "DARYL CRAWFORD"]}'),
('{ "_id" : "bf7a3a176a5f48669a29ded446afcd0d", "title" : "BUBBLE GROSSE", "description" : "A Awe-Inspiring Panorama of a Crocodile And a Moose who must Confront a Girl in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "60 min", "rating" : "R", "actors" : ["VIVIEN BASINGER", "MENA HOPPER", "ROCK DUKAKIS"]}'),
('{ "_id" : "65c8764cf1a545ad80b639aa0ae39a3c", "title" : "BUCKET BROTHERHOOD", "description" : "A Amazing Display of a Girl And a Womanizer who must Succumb a Lumberjack in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "133 min", "rating" : "PG", "actors" : ["RIP CRAWFORD", "TIM HACKMAN", "GARY PHOENIX", "CHARLIZE DENCH", "KIRSTEN AKROYD", "BURT TEMPLE"]}'),
('{ "_id" : "1ebf16e4b29348069894aa69932ed0ab", "title" : "BUGSY SONG", "description" : "A Awe-Inspiring Character Study of a Secret Agent And a Boat who must Find a Squirrel in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "119 min", "rating" : "G", "actors" : ["WOODY JOLIE", "KIRSTEN AKROYD"]}'),
('{ "_id" : "9470f50c2842418a9b8d4dfde3be6308", "title" : "BULL SHAWSHANK", "description" : "A Fanciful Drama of a Moose And a Squirrel who must Conquer a Pioneer in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "125 min", "rating" : "NC-17", "actors" : ["NICK WAHLBERG", "SANDRA KILMER", "ALEC WAYNE", "KIRK JOVOVICH", "DAN STREEP", "JULIANNE DENCH", "ANGELA WITHERSPOON", "JAYNE NOLTE"]}'),
('{ "_id" : "cd4f0fb06d784284a8d82f2249e657c3", "title" : "BULWORTH COMMANDMENTS", "description" : "A Amazing Display of a Mad Cow And a Pioneer who must Redeem a Sumo Wrestler in The Outback", "release_year" : "2006", "language" : "English", "duration" : "61 min", "rating" : "G", "actors" : ["PENELOPE GUINESS", "ANGELA HUDSON", "SCARLETT BENING", "ALAN DREYFUSS"]}'),
('{ "_id" : "63b66ece01b64b85b195acd4a3bb8021", "title" : "BUNCH MINDS", "description" : "A Emotional Story of a Feminist And a Feminist who must Escape a Pastry Chef in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "63 min", "rating" : "G", "actors" : ["KARL BERRY", "WOODY HOFFMAN", "JOHNNY CAGE", "CHRIS BRIDGES", "GRETA KEITEL", "EWAN GOODING", "JADA RYDER", "LAURENCE BULLOCK"]}'),
('{ "_id" : "a5a186c51e064249bd54b7a29844c817", "title" : "BUTCH PANTHER", "description" : "A Lacklusture Yarn of a Feminist And a Database Administrator who must Face a Hunter in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "67 min", "rating" : "PG-13", "actors" : ["CUBA OLIVIER", "CARMEN HUNT", "GROUCHO DUNST"]}'),
('{ "_id" : "1448f9a863cd4f5ba7d38e0f2d612c3e", "title" : "BUTTERFLY CHOCOLAT", "description" : "A Fateful Story of a Girl And a Composer who must Conquer a Husband in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "89 min", "rating" : "G", "actors" : ["NICK STALLONE", "MENA TEMPLE", "KIM ALLEN", "LISA MONROE", "ED GUINESS", "BURT TEMPLE", "MARY KEITEL"]}'),
('{ "_id" : "08dec2fc026d4cfbbc58216621c56038", "title" : "CABIN FLASH", "description" : "A Stunning Epistle of a Boat And a Man who must Challenge a A Shark in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "53 min", "rating" : "NC-17", "actors" : ["UMA WOOD", "ALEC WAYNE", "BEN WILLIS", "RENEE BALL"]}'),
('{ "_id" : "66b987bb6469427098a1acb536ca51e3", "title" : "CADDYSHACK JEDI", "description" : "A Awe-Inspiring Epistle of a Woman And a Madman who must Fight a Robot in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "52 min", "rating" : "NC-17", "actors" : ["ED CHASE", "ELVIS MARX", "TOM MCKELLEN", "NATALIE HOPKINS", "KENNETH PALTROW", "MERYL GIBSON", "ROCK DUKAKIS"]}'),
('{ "_id" : "8f7fe4c0f3514b1dbb67012ed672905d", "title" : "CALENDAR GUNFIGHT", "description" : "A Thrilling Drama of a Frisbee And a Lumberjack who must Sink a Man in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "120 min", "rating" : "NC-17", "actors" : ["BETTE NICHOLSON", "CAMERON STREEP", "TIM HACKMAN", "MILLA PECK", "GARY PHOENIX", "GINA DEGENERES", "GRETA KEITEL", "WHOOPI HURT"]}'),
('{ "_id" : "286e01b7a3e04192a6877e3560d5c6a4", "title" : "CALIFORNIA BIRDS", "description" : "A Thrilling Yarn of a Database Administrator And a Robot who must Battle a Database Administrator in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "75 min", "rating" : "NC-17", "actors" : ["SCARLETT BENING", "RUSSELL CLOSE"]}'),
('{ "_id" : "d0fa23cbbe0d4e3f8595b441c817a4d0", "title" : "CAMELOT VACATION", "description" : "A Touching Character Study of a Woman And a Waitress who must Battle a Pastry Chef in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "61 min", "rating" : "NC-17", "actors" : ["JUDE CRUISE", "ALBERT NOLTE"]}'),
('{ "_id" : "ff4843d50644478bb2cea30ee0fae7bd", "title" : "CAMPUS REMEMBER", "description" : "A Astounding Drama of a Crocodile And a Mad Cow who must Build a Robot in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "167 min", "rating" : "R", "actors" : ["MATTHEW JOHANSSON", "REESE KILMER", "WILL WILSON"]}'),
('{ "_id" : "7fbc80bf8ae6403b9bb02627aebc85ce", "title" : "CANDIDATE PERDITION", "description" : "A Brilliant Epistle of a Composer And a Database Administrator who must Vanquish a Mad Scientist in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "70 min", "rating" : "R", "actors" : ["SANDRA KILMER", "SIDNEY CROWE", "MORGAN HOPKINS", "THORA TEMPLE"]}'),
('{ "_id" : "0dd454fa080149f0926d61a22890d7db", "title" : "CANDLES GRAPES", "description" : "A Fanciful Character Study of a Monkey And a Explorer who must Build a Astronaut in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "135 min", "rating" : "NC-17", "actors" : ["SANDRA KILMER", "REESE KILMER", "ANGELA HUDSON", "MILLA KEITEL", "CHARLIZE DENCH", "ALBERT JOHANSSON", "JOHN SUVARI"]}'),
('{ "_id" : "16ea584a74bf40cabd7c679b700bcd7d", "title" : "CANYON STOCK", "description" : "A Thoughtful Reflection of a Waitress And a Feminist who must Escape a Squirrel in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "R", "actors" : ["ZERO CAGE", "VAL BOLGER", "RALPH CRUZ", "SPENCER DEPP", "MATTHEW LEIGH", "RUSSELL TEMPLE"]}'),
('{ "_id" : "915f914c0c7f4a7d8eb9881e89728c1a", "title" : "CAPER MOTIONS", "description" : "A Fateful Saga of a Moose And a Car who must Pursue a Woman in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "176 min", "rating" : "G", "actors" : ["HELEN VOIGHT", "AUDREY OLIVIER", "VAL BOLGER", "CHRISTIAN AKROYD", "KEVIN GARLAND", "CATE MCQUEEN", "BURT TEMPLE"]}'),
('{ "_id" : "87795a7635784e5482b77d02b9606b57", "title" : "CARIBBEAN LIBERTY", "description" : "A Fanciful Tale of a Pioneer And a Technical Writer who must Outgun a Pioneer in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "92 min", "rating" : "NC-17", "actors" : ["BEN WILLIS", "ELLEN PRESLEY", "CHRIS BRIDGES", "SUSAN DAVIS", "JANE JACKMAN", "KIM ALLEN", "HARVEY HOPE", "LAURENCE BULLOCK"]}'),
('{ "_id" : "a0a941d387474714ba3f4d9a68890fab", "title" : "CAROL TEXAS", "description" : "A Astounding Character Study of a Composer And a Student who must Overcome a Composer in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "151 min", "rating" : "PG", "actors" : ["FRED COSTNER", "GARY PHOENIX", "DUSTIN TAUTOU", "BEN WILLIS", "VIVIEN BASINGER", "OPRAH KILMER", "THORA TEMPLE"]}'),
('{ "_id" : "ae327bddb1b1432386a7ffa8a37da6df", "title" : "CARRIE BUNCH", "description" : "A Amazing Epistle of a Student And a Astronaut who must Discover a Frisbee in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "114 min", "rating" : "PG", "actors" : ["VAL BOLGER", "MENA TEMPLE", "JUDE CRUISE", "ANGELINA ASTAIRE", "KENNETH TORN", "GRETA MALDEN", "BELA WALKEN"]}'),
('{ "_id" : "4dc4a261fbde41a8ad4eb1f407c5f2b1", "title" : "CASABLANCA SUPER", "description" : "A Amazing Panorama of a Crocodile And a Forensic Psychologist who must Pursue a Secret Agent in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "G", "actors" : ["KIRSTEN AKROYD", "WALTER TORN", "ANGELA WITHERSPOON", "REESE WEST"]}'),
('{ "_id" : "9b59c7db871c4756b81638b743818ca9", "title" : "CASPER DRAGONFLY", "description" : "A Intrepid Documentary of a Boat And a Crocodile who must Chase a Robot in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "163 min", "rating" : "PG-13", "actors" : ["HELEN VOIGHT", "RAY JOHANSSON", "RALPH CRUZ", "ELLEN PRESLEY", "WALTER TORN"]}'),
('{ "_id" : "b0843ab267f645fb81a790e3e37bcc9b", "title" : "CASSIDY WYOMING", "description" : "A Intrepid Drama of a Frisbee And a Hunter who must Kill a Secret Agent in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "61 min", "rating" : "NC-17", "actors" : ["CUBA OLIVIER", "SANDRA KILMER", "AUDREY OLIVIER", "ANGELA HUDSON", "LUCILLE DEE", "ANGELA WITHERSPOON", "MARY KEITEL"]}'),
('{ "_id" : "05039b6d643f44e3aa55ca6e975315ed", "title" : "CASUALTIES ENCINO", "description" : "A Insightful Yarn of a A Shark And a Pastry Chef who must Face a Boy in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "179 min", "rating" : "G", "actors" : ["CAMERON STREEP", "MENA TEMPLE", "DARYL WAHLBERG", "GROUCHO DUNST", "SUSAN DAVIS"]}'),
('{ "_id" : "e301389fddd64824848a6f81d6fd3791", "title" : "CAT CONEHEADS", "description" : "A Fast-Paced Panorama of a Girl And a A Shark who must Confront a Boy in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "112 min", "rating" : "G", "actors" : ["HELEN VOIGHT", "ANGELA WITHERSPOON", "LAURA BRODY", "RENEE BALL"]}'),
('{ "_id" : "c3634b809dbd4e46b25558e612b3052a", "title" : "CATCH AMISTAD", "description" : "A Boring Reflection of a Lumberjack And a Feminist who must Discover a Woman in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "183 min", "rating" : "G", "actors" : ["JOHNNY CAGE", "CHRISTIAN AKROYD", "KENNETH PESCI", "DAN STREEP", "IAN TANDY"]}'),
('{ "_id" : "029c6b5f6f07428eb4912b4026e3d7be", "title" : "CAUSE DATE", "description" : "A Taut Tale of a Explorer And a Pastry Chef who must Conquer a Hunter in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "179 min", "rating" : "R", "actors" : ["PENELOPE PINKETT", "DUSTIN TAUTOU", "JAYNE NEESON", "WILLIAM HACKMAN", "JAYNE SILVERSTONE", "REESE WEST"]}'),
('{ "_id" : "d58c13f3a98c469085f990cdfaf7d351", "title" : "CELEBRITY HORN", "description" : "A Amazing Documentary of a Secret Agent And a Astronaut who must Vanquish a Hunter in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "110 min", "rating" : "PG-13", "actors" : ["DUSTIN TAUTOU", "MATTHEW LEIGH", "ANGELA WITHERSPOON", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "c6661426d1d34e02bbb340e9b44a2a17", "title" : "CENTER DINOSAUR", "description" : "A Beautiful Character Study of a Sumo Wrestler And a Dentist who must Find a Dog in California", "release_year" : "2006", "language" : "English", "duration" : "152 min", "rating" : "PG", "actors" : ["ALEC WAYNE", "FAY WINSLET", "GEOFFREY HESTON", "ED GUINESS"]}'),
('{ "_id" : "6472665396a4446880f9d94dfc15d466", "title" : "CHAINSAW UPTOWN", "description" : "A Beautiful Documentary of a Boy And a Robot who must Discover a Squirrel in Australia", "release_year" : "2006", "language" : "English", "duration" : "114 min", "rating" : "PG", "actors" : ["NICK WAHLBERG", "GENE HOPKINS"]}'),
('{ "_id" : "e41b973364da43898620f88d2a77f61c", "title" : "CHAMBER ITALIAN", "description" : "A Fateful Reflection of a Moose And a Husband who must Overcome a Monkey in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "117 min", "rating" : "NC-17", "actors" : ["ALEC WAYNE", "HENRY BERRY", "RIP WINSLET", "GINA DEGENERES", "ADAM HOPPER", "RICHARD PENN", "EMILY DEE"]}'),
('{ "_id" : "2acd4e14e7d84f6dbde92994ce4f1b83", "title" : "CHAMPION FLATLINERS", "description" : "A Amazing Story of a Mad Cow And a Dog who must Kill a Husband in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "51 min", "rating" : "PG", "actors" : ["FRANCES DAY-LEWIS", "JUDE CRUISE", "CAMERON WRAY", "GENE WILLIS"]}'),
('{ "_id" : "2ae9c1031dcc4e1b8218c8eb4c070c84", "title" : "CHANCE RESURRECTION", "description" : "A Astounding Story of a Forensic Psychologist And a Forensic Psychologist who must Overcome a Moose in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "70 min", "rating" : "R", "actors" : ["MILLA PECK", "CHRISTIAN AKROYD", "BEN WILLIS", "WHOOPI HURT", "ANGELA WITHERSPOON", "MERYL ALLEN"]}'),
('{ "_id" : "d12eea1445f64367aba46b5ab69ff5f8", "title" : "CHAPLIN LICENSE", "description" : "A Boring Drama of a Dog And a Forensic Psychologist who must Outrace a Explorer in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "146 min", "rating" : "NC-17", "actors" : ["TIM HACKMAN", "PENELOPE CRONYN", "GROUCHO DUNST", "GINA DEGENERES", "CUBA ALLEN", "MINNIE KILMER"]}'),
('{ "_id" : "7de1c9c1024345e58db95d104c71d6a2", "title" : "CHARADE DUFFEL", "description" : "A Action-Packed Display of a Man And a Waitress who must Build a Dog in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "66 min", "rating" : "PG", "actors" : ["GREG CHAPLIN", "KIRSTEN AKROYD", "WARREN NOLTE"]}'),
('{ "_id" : "d4faa852725f42a9975392febd373461", "title" : "CHARIOTS CONSPIRACY", "description" : "A Unbelieveable Epistle of a Robot And a Husband who must Chase a Robot in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "71 min", "rating" : "R", "actors" : ["GINA DEGENERES", "MICHAEL BOLGER"]}'),
('{ "_id" : "9df4002951e04b60a2b4de4cc62781f0", "title" : "CHASING FIGHT", "description" : "A Astounding Saga of a Technical Writer And a Butler who must Battle a Butler in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "114 min", "rating" : "PG", "actors" : ["TOM MIRANDA", "JADA RYDER", "FAY WINSLET", "RUSSELL TEMPLE", "MENA HOPPER"]}'),
('{ "_id" : "c1d2c2c730ce4b6a88700eff476506b9", "title" : "CHEAPER CLYDE", "description" : "A Emotional Character Study of a Pioneer And a Girl who must Discover a Dog in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "87 min", "rating" : "G", "actors" : ["PENELOPE GUINESS", "LUCILLE TRACY"]}'),
('{ "_id" : "7f9c79084c2e4e339899899eb95d5134", "title" : "CHICAGO NORTH", "description" : "A Fateful Yarn of a Mad Cow And a Waitress who must Battle a Student in California", "release_year" : "2006", "language" : "English", "duration" : "185 min", "rating" : "PG-13", "actors" : ["MAE HOFFMAN", "CUBA ALLEN", "LIZA BERGMAN", "KEVIN GARLAND", "RIVER DEAN", "MERYL GIBSON", "BURT TEMPLE", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "01073782e4b34eccac252ec4fa2e6b8a", "title" : "CHICKEN HELLFIGHTERS", "description" : "A Emotional Drama of a Dog And a Explorer who must Outrace a Technical Writer in Australia", "release_year" : "2006", "language" : "English", "duration" : "122 min", "rating" : "PG", "actors" : ["KIRSTEN PALTROW", "HENRY BERRY"]}'),
('{ "_id" : "e4835a30e8934f2a902bd47563a0b234", "title" : "CHILL LUCK", "description" : "A Lacklusture Epistle of a Boat And a Technical Writer who must Fight a A Shark in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "142 min", "rating" : "PG", "actors" : ["MARY TANDY", "BURT POSEY", "WOODY JOLIE", "MEG HAWKE", "WARREN JACKMAN"]}'),
('{ "_id" : "272277ae13e24e80bd72555fbabcbcb9", "title" : "CHINATOWN GLADIATOR", "description" : "A Brilliant Panorama of a Technical Writer And a Lumberjack who must Escape a Butler in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "61 min", "rating" : "PG", "actors" : ["UMA WOOD", "DAN TORN", "BOB FAWCETT", "JUDE CRUISE", "JESSICA BAILEY", "SEAN WILLIAMS", "PENELOPE MONROE", "GEOFFREY HESTON", "JEFF SILVERSTONE", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "c8db1a4aa29b42bab0ed3cac7aa7d306", "title" : "CHISUM BEHAVIOR", "description" : "A Epic Documentary of a Sumo Wrestler And a Butler who must Kill a Car in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "124 min", "rating" : "G", "actors" : ["NICK WAHLBERG", "GENE HOPKINS", "FAY WINSLET", "JULIA FAWCETT"]}'),
('{ "_id" : "b6c31596141649aaa31da7ae37a50edc", "title" : "CHITTY LOCK", "description" : "A Boring Epistle of a Boat And a Database Administrator who must Kill a Sumo Wrestler in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "107 min", "rating" : "G", "actors" : ["JOHNNY LOLLOBRIGIDA", "LUCILLE TRACY", "ELVIS MARX", "SISSY SOBIESKI", "VAL BOLGER", "SUSAN DAVIS", "RUSSELL TEMPLE", "AL GARLAND", "NICK DEGENERES", "OLYMPIA PFEIFFER", "LISA MONROE", "HUMPHREY GARLAND", "ROCK DUKAKIS"]}'),
('{ "_id" : "7b4a6764065b4bd380b8fae7f1be40a2", "title" : "CHOCOLAT HARRY", "description" : "A Action-Packed Epistle of a Dentist And a Moose who must Meet a Mad Cow in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "101 min", "rating" : "NC-17", "actors" : ["JOE SWANK", "RIP CRAWFORD", "KIRK JOVOVICH", "JANE JACKMAN", "REESE WEST"]}'),
('{ "_id" : "1173f4b3e04e438cad477268ce3a19cf", "title" : "CHOCOLATE DUCK", "description" : "A Unbelieveable Story of a Mad Scientist And a Technical Writer who must Discover a Composer in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "132 min", "rating" : "R", "actors" : ["JOE SWANK", "CAMERON STREEP", "GARY PENN", "MINNIE ZELLWEGER", "JULIANNE DENCH", "HUMPHREY WILLIS", "GROUCHO WILLIAMS"]}'),
('{ "_id" : "280aba9cff1c4b1d83cd93fed6c625f3", "title" : "CHRISTMAS MOONSHINE", "description" : "A Action-Packed Epistle of a Feminist And a Astronaut who must Conquer a Boat in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "150 min", "rating" : "NC-17", "actors" : ["PENELOPE MONROE", "EMILY DEE", "THORA TEMPLE"]}'),
('{ "_id" : "2d353b8fda9941ad805a40a2d95cb541", "title" : "CIDER DESIRE", "description" : "A Stunning Character Study of a Composer And a Mad Cow who must Succumb a Cat in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "101 min", "rating" : "PG", "actors" : ["JULIA MCQUEEN", "JODIE DEGENERES", "FRANCES DAY-LEWIS", "PENELOPE PINKETT", "JON CHASE"]}'),
('{ "_id" : "c4b7bad6fb554df9a654d211767dcc18", "title" : "CINCINATTI WHISPERER", "description" : "A Brilliant Saga of a Pastry Chef And a Hunter who must Confront a Butler in Berlin", "release_year" : "2006", "language" : "English", "duration" : "143 min", "rating" : "NC-17", "actors" : ["ANNE CRONYN", "RUSSELL BACALL", "CUBA ALLEN", "JULIANNE DENCH"]}'),
('{ "_id" : "18fc19a943cb4ab0ae8292e770222ce0", "title" : "CIRCUS YOUTH", "description" : "A Thoughtful Drama of a Pastry Chef And a Dentist who must Pursue a Girl in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "90 min", "rating" : "PG-13", "actors" : ["BOB FAWCETT", "MATTHEW CARREY"]}'),
('{ "_id" : "b114b11badea43b5a6db6db609e487d3", "title" : "CITIZEN SHREK", "description" : "A Fanciful Character Study of a Technical Writer And a Husband who must Redeem a Robot in The Outback", "release_year" : "2006", "language" : "English", "duration" : "165 min", "rating" : "G", "actors" : ["KEVIN BLOOM", "GARY PHOENIX", "JUDE CRUISE", "CARY MCCONAUGHEY", "KENNETH TORN", "RUSSELL TEMPLE", "BEN HARRIS", "IAN TANDY"]}'),
('{ "_id" : "f8321acb8b3f46c2a15ee13cf385c959", "title" : "CLASH FREDDY", "description" : "A Amazing Yarn of a Composer And a Squirrel who must Escape a Astronaut in Australia", "release_year" : "2006", "language" : "English", "duration" : "81 min", "rating" : "G", "actors" : ["UMA WOOD", "VIVIEN BERGEN", "HELEN VOIGHT", "MILLA PECK", "LIZA BERGMAN", "KIM ALLEN", "ALAN DREYFUSS"]}'),
('{ "_id" : "aa244e8a3a254d78a5223bed5ff402cc", "title" : "CLEOPATRA DEVIL", "description" : "A Fanciful Documentary of a Crocodile And a Technical Writer who must Fight a A Shark in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "150 min", "rating" : "PG-13", "actors" : ["KARL BERRY", "FRED COSTNER", "EWAN GOODING", "KIM ALLEN", "FAY WOOD", "WILLIAM HACKMAN", "JOHN SUVARI"]}'),
('{ "_id" : "25174970942b4fba968a05d81939a036", "title" : "CLERKS ANGELS", "description" : "A Thrilling Display of a Sumo Wrestler And a Girl who must Confront a Man in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "164 min", "rating" : "G", "actors" : ["PENELOPE CRONYN", "SUSAN DAVIS", "ADAM HOPPER", "BELA WALKEN"]}'),
('{ "_id" : "f7782e2827d74a8f9ef9dc9129b1befb", "title" : "CLOCKWORK PARADISE", "description" : "A Insightful Documentary of a Technical Writer And a Feminist who must Challenge a Cat in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "143 min", "rating" : "PG-13", "actors" : ["SPENCER PECK", "SYLVESTER DERN", "SALMA NOLTE", "KEVIN GARLAND", "LUCILLE DEE"]}'),
('{ "_id" : "deb7d38e58af4a208605f69d0c03fe12", "title" : "CLONES PINOCCHIO", "description" : "A Amazing Drama of a Car And a Robot who must Pursue a Dentist in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "124 min", "rating" : "R", "actors" : ["MATTHEW JOHANSSON", "ANGELA HUDSON", "SIDNEY CROWE", "SALMA NOLTE", "MERYL GIBSON"]}'),
('{ "_id" : "d3393493922d439e8ee2e91c3934919a", "title" : "CLOSER BANG", "description" : "A Unbelieveable Panorama of a Frisbee And a Hunter who must Vanquish a Monkey in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "58 min", "rating" : "R", "actors" : ["KIRSTEN PALTROW", "JODIE DEGENERES", "RUSSELL TEMPLE", "GRETA MALDEN", "ED GUINESS", "JULIA FAWCETT"]}'),
('{ "_id" : "c58c00ec7b1f44638ce2e8b5da7e5864", "title" : "CLUB GRAFFITI", "description" : "A Epic Tale of a Pioneer And a Hunter who must Escape a Girl in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "65 min", "rating" : "PG-13", "actors" : ["TOM MCKELLEN", "MORGAN WILLIAMS", "LISA MONROE", "DEBBIE AKROYD"]}'),
('{ "_id" : "172e6277663643f494ffc8423bc1cf70", "title" : "CLUE GRAIL", "description" : "A Taut Tale of a Butler And a Mad Scientist who must Build a Crocodile in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "70 min", "rating" : "NC-17", "actors" : ["KIRK JOVOVICH", "RIP WINSLET", "SPENCER PECK", "LIZA BERGMAN", "GENE HOPKINS", "MERYL ALLEN"]}'),
('{ "_id" : "ff06212ecad6418798a54a4eecf7af48", "title" : "CLUELESS BUCKET", "description" : "A Taut Tale of a Car And a Pioneer who must Conquer a Sumo Wrestler in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "95 min", "rating" : "R", "actors" : ["UMA WOOD", "CHARLIZE DENCH", "GINA DEGENERES", "CAMERON ZELLWEGER", "MORGAN MCDORMAND", "ADAM HOPPER", "ALAN DREYFUSS", "JON CHASE"]}'),
('{ "_id" : "c4b007a1a0b74f07be0f6e0a847d0552", "title" : "CLYDE THEORY", "description" : "A Beautiful Yarn of a Astronaut And a Frisbee who must Overcome a Explorer in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "139 min", "rating" : "PG-13", "actors" : ["SISSY SOBIESKI", "JOHNNY CAGE", "GREG CHAPLIN", "MERYL ALLEN"]}'),
('{ "_id" : "e1fafd95024c4bbf9ae5b69e73982aaa", "title" : "COAST RAINBOW", "description" : "A Astounding Documentary of a Mad Cow And a Pioneer who must Challenge a Butler in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "55 min", "rating" : "PG", "actors" : ["BETTE NICHOLSON", "CAMERON STREEP", "SISSY SOBIESKI", "REESE KILMER", "FRANCES DAY-LEWIS", "ANGELA WITHERSPOON", "OPRAH KILMER", "LISA MONROE", "BURT TEMPLE", "REESE WEST"]}'),
('{ "_id" : "59395805bf8a4384afadfad27954a659", "title" : "COLDBLOODED DARLING", "description" : "A Brilliant Panorama of a Dentist And a Moose who must Find a Student in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "70 min", "rating" : "G", "actors" : ["BETTE NICHOLSON", "LUCILLE TRACY", "BEN WILLIS", "GINA DEGENERES"]}'),
('{ "_id" : "386aead422d64d7e925944a4b725cf20", "title" : "COLOR PHILADELPHIA", "description" : "A Thoughtful Panorama of a Car And a Crocodile who must Sink a Monkey in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "149 min", "rating" : "G", "actors" : ["PENELOPE GUINESS", "GROUCHO DUNST", "SALMA NOLTE", "DARYL CRAWFORD", "CHRISTOPHER WEST", "OLYMPIA PFEIFFER", "JOHN SUVARI"]}'),
('{ "_id" : "691fc59f26c94fe69a5f2630183a6d46", "title" : "COMA HEAD", "description" : "A Awe-Inspiring Drama of a Boy And a Frisbee who must Escape a Pastry Chef in California", "release_year" : "2006", "language" : "English", "duration" : "109 min", "rating" : "NC-17", "actors" : ["CAMERON WRAY", "RENEE TRACY", "GEOFFREY HESTON"]}'),
('{ "_id" : "bf073395f7b649e1a353da808c2c9a88", "title" : "COMANCHEROS ENEMY", "description" : "A Boring Saga of a Lumberjack And a Monkey who must Find a Monkey in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "67 min", "rating" : "R", "actors" : ["GOLDIE BRODY", "CATE MCQUEEN", "JAYNE NOLTE", "MICHAEL BENING", "RENEE BALL"]}'),
('{ "_id" : "79f7486a840d4cbb979cf5b9dae702e9", "title" : "COMFORTS RUSH", "description" : "A Unbelieveable Panorama of a Pioneer And a Husband who must Meet a Mad Cow in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "76 min", "rating" : "NC-17", "actors" : ["RUSSELL TEMPLE", "MERYL GIBSON", "HUMPHREY WILLIS", "HUMPHREY GARLAND", "BELA WALKEN"]}'),
('{ "_id" : "9dec4209b3e0495684a4b48c1fe836ef", "title" : "COMMAND DARLING", "description" : "A Awe-Inspiring Tale of a Forensic Psychologist And a Woman who must Challenge a Database Administrator in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "120 min", "rating" : "PG-13", "actors" : ["GRACE MOSTEL", "BURT POSEY", "KENNETH PESCI", "LIZA BERGMAN", "RITA REYNOLDS", "EWAN GOODING", "GEOFFREY HESTON", "MERYL GIBSON"]}'),
('{ "_id" : "349691f209e7437c8506e235dae770ff", "title" : "COMMANDMENTS EXPRESS", "description" : "A Fanciful Saga of a Student And a Mad Scientist who must Battle a Hunter in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "59 min", "rating" : "R", "actors" : ["JOHNNY LOLLOBRIGIDA", "BURT DUKAKIS", "WARREN JACKMAN", "CUBA BIRCH"]}'),
('{ "_id" : "8074a7efba8544ba8156471ce5deabaa", "title" : "CONEHEADS SMOOCHY", "description" : "A Touching Story of a Womanizer And a Composer who must Pursue a Husband in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "112 min", "rating" : "NC-17", "actors" : ["JOHNNY LOLLOBRIGIDA", "DAN TORN", "JULIA MCQUEEN", "ALEC WAYNE", "AUDREY OLIVIER", "JULIA BARRYMORE", "GINA DEGENERES", "WARREN JACKMAN", "RICHARD PENN"]}'),
('{ "_id" : "1c4a9e3e00b54a08b20097b34f46596a", "title" : "CONFESSIONS MAGUIRE", "description" : "A Insightful Story of a Car And a Boy who must Battle a Technical Writer in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "65 min", "rating" : "PG-13", "actors" : ["GRACE MOSTEL", "RUSSELL BACALL", "WARREN JACKMAN", "AUDREY BAILEY"]}'),
('{ "_id" : "d2ffb40a283e425797b5a34665bc9c0d", "title" : "CONFIDENTIAL INTERVIEW", "description" : "A Stunning Reflection of a Cat And a Woman who must Find a Astronaut in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "180 min", "rating" : "NC-17", "actors" : ["PARKER GOLDBERG", "SYLVESTER DERN"]}'),
('{ "_id" : "853ab4ac1b08429f9163b878bc498842", "title" : "CONFUSED CANDLES", "description" : "A Stunning Epistle of a Cat And a Forensic Psychologist who must Confront a Pioneer in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "122 min", "rating" : "PG-13", "actors" : ["CHRISTIAN AKROYD", "RALPH CRUZ", "JAMES PITT", "ALBERT NOLTE", "RIVER DEAN", "GENE MCKELLEN"]}'),
('{ "_id" : "d1faf365f398460da8abe1d9c916fb7d", "title" : "CONGENIALITY QUEST", "description" : "A Touching Documentary of a Cat And a Pastry Chef who must Find a Lumberjack in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "87 min", "rating" : "PG-13", "actors" : ["TOM MCKELLEN", "NICK STALLONE", "CHRISTOPHER BERRY"]}'),
('{ "_id" : "208bbdada75e41809d2737a5a33ebdf1", "title" : "CONNECTICUT TRAMP", "description" : "A Unbelieveable Drama of a Crocodile And a Mad Cow who must Reach a Dentist in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "172 min", "rating" : "R", "actors" : ["KARL BERRY", "FRED COSTNER", "JOHNNY CAGE", "HENRY BERRY", "MEG HAWKE", "ALBERT JOHANSSON", "VIVIEN BASINGER"]}'),
('{ "_id" : "97bcaa922594456caff49774769da8e3", "title" : "CONNECTION MICROCOSMOS", "description" : "A Fateful Documentary of a Crocodile And a Husband who must Face a Husband in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "115 min", "rating" : "G", "actors" : ["CAMERON STREEP", "NATALIE HOPKINS", "SCARLETT DAMON", "RENEE TRACY", "FAY WINSLET", "RUSSELL TEMPLE", "VIVIEN BASINGER"]}'),
('{ "_id" : "549cd5d16a2544ef9ed268c54378e882", "title" : "CONQUERER NUTS", "description" : "A Taut Drama of a Mad Scientist And a Man who must Escape a Pioneer in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "173 min", "rating" : "G", "actors" : ["MATTHEW JOHANSSON", "KIRSTEN PALTROW", "KEVIN BLOOM", "HENRY BERRY", "CAMERON ZELLWEGER", "JOHN SUVARI"]}'),
('{ "_id" : "c2b46690302c4d5aa60a2734b01d846c", "title" : "CONSPIRACY SPIRIT", "description" : "A Awe-Inspiring Story of a Student And a Frisbee who must Conquer a Crocodile in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "184 min", "rating" : "PG-13", "actors" : ["KIRK JOVOVICH", "MINNIE KILMER", "CHRISTOPHER WEST", "MENA HOPPER"]}'),
('{ "_id" : "be2bb86e04ff4ba98b728d9d3c33cf38", "title" : "CONTACT ANONYMOUS", "description" : "A Insightful Display of a A Shark And a Monkey who must Face a Database Administrator in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "166 min", "rating" : "PG-13", "actors" : ["MENA TEMPLE", "CHRISTOPHER BERRY", "MORGAN HOPKINS", "EWAN GOODING", "OLYMPIA PFEIFFER"]}'),
('{ "_id" : "3a513c4fd9d9428394d63bfdc38c7bab", "title" : "CONTROL ANTHEM", "description" : "A Fateful Documentary of a Robot And a Student who must Battle a Cat in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "185 min", "rating" : "G", "actors" : ["BOB FAWCETT", "AUDREY OLIVIER", "CHARLIZE DENCH"]}'),
('{ "_id" : "f4a695a306674372aadac924405e3901", "title" : "CONVERSATION DOWNHILL", "description" : "A Taut Character Study of a Husband And a Waitress who must Sink a Squirrel in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "112 min", "rating" : "R", "actors" : ["DUSTIN TAUTOU", "CHRIS BRIDGES", "GRETA MALDEN"]}'),
('{ "_id" : "6b1d21e01f6143e89d7ca78cd0ac0697", "title" : "CORE SUIT", "description" : "A Unbelieveable Tale of a Car And a Explorer who must Confront a Boat in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "92 min", "rating" : "PG-13", "actors" : ["PENELOPE PINKETT", "PENELOPE CRONYN", "ANGELA WITHERSPOON", "MENA HOPPER"]}'),
('{ "_id" : "ef1c7889aedd48c8aaf5160fbd364808", "title" : "COWBOY DOOM", "description" : "A Astounding Drama of a Boy And a Lumberjack who must Fight a Butler in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "146 min", "rating" : "PG", "actors" : ["ED CHASE", "MILLA KEITEL", "JULIANNE DENCH", "WHOOPI HURT", "GREGORY GOODING"]}'),
('{ "_id" : "fcbe550fda8547fcafdefd8e0cdc0274", "title" : "CRAFT OUTFIELD", "description" : "A Lacklusture Display of a Explorer And a Hunter who must Succumb a Database Administrator in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "64 min", "rating" : "NC-17", "actors" : ["RIP CRAWFORD", "HENRY BERRY", "SCARLETT DAMON", "LIZA BERGMAN", "JADA RYDER", "MARY KEITEL"]}'),
('{ "_id" : "34ce5e19375f41b9ace5de815bc60df3", "title" : "CRANES RESERVOIR", "description" : "A Fanciful Documentary of a Teacher And a Dog who must Outgun a Forensic Psychologist in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "57 min", "rating" : "NC-17", "actors" : ["VIVIEN BERGEN", "REESE KILMER", "ANGELINA ASTAIRE", "CHARLIZE DENCH", "LAURA BRODY", "JULIA ZELLWEGER"]}'),
('{ "_id" : "1e0c9fd10be14bf18a4eab7a7f29e95e", "title" : "CRAZY HOME", "description" : "A Fanciful Panorama of a Boy And a Woman who must Vanquish a Database Administrator in The Outback", "release_year" : "2006", "language" : "English", "duration" : "136 min", "rating" : "PG", "actors" : ["SISSY SOBIESKI", "WOODY JOLIE", "MEG HAWKE", "RUSSELL BACALL", "MORGAN MCDORMAND", "ALBERT NOLTE", "CATE HARRIS", "RUSSELL TEMPLE", "VIVIEN BASINGER", "HARVEY HOPE", "WILL WILSON", "ALAN DREYFUSS", "GENE MCKELLEN"]}'),
('{ "_id" : "ee19439121ca4392bf0b190f7728a569", "title" : "CREATURES SHAKESPEARE", "description" : "A Emotional Drama of a Womanizer And a Squirrel who must Vanquish a Crocodile in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "139 min", "rating" : "NC-17", "actors" : ["SUSAN DAVIS", "GROUCHO DUNST", "REESE WEST"]}'),
('{ "_id" : "bc2b82b159ba46f4ab0bbe8e8561ff2e", "title" : "CREEPERS KANE", "description" : "A Awe-Inspiring Reflection of a Squirrel And a Boat who must Outrace a Car in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "172 min", "rating" : "NC-17", "actors" : ["CHRISTOPHER BERRY", "SYLVESTER DERN", "RENEE TRACY", "SCARLETT BENING", "JAYNE NOLTE", "WILLIAM HACKMAN"]}'),
('{ "_id" : "b6ac7f41960b4107aeda54a7920a9a26", "title" : "CROOKED FROGMEN", "description" : "A Unbelieveable Drama of a Hunter And a Database Administrator who must Battle a Crocodile in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "143 min", "rating" : "PG-13", "actors" : ["JOE SWANK", "CHRISTIAN GABLE", "CATE HARRIS", "ALBERT JOHANSSON", "LAURENCE BULLOCK", "WILLIAM HACKMAN"]}'),
('{ "_id" : "697d2a1ce4c0488b91464254ac09615f", "title" : "CROSSING DIVORCE", "description" : "A Beautiful Documentary of a Dog And a Robot who must Redeem a Womanizer in Berlin", "release_year" : "2006", "language" : "English", "duration" : "50 min", "rating" : "R", "actors" : ["JUDE CRUISE", "MILLA KEITEL"]}'),
('{ "_id" : "d4588b572f664f728ee76c15b283919a", "title" : "CROSSROADS CASUALTIES", "description" : "A Intrepid Documentary of a Sumo Wrestler And a Astronaut who must Battle a Composer in The Outback", "release_year" : "2006", "language" : "English", "duration" : "153 min", "rating" : "G", "actors" : ["BETTE NICHOLSON", "KENNETH PESCI", "KENNETH TORN", "FRANCES TOMEI", "ED MANSFIELD", "RUSSELL TEMPLE", "MERYL GIBSON", "ED GUINESS"]}'),
('{ "_id" : "24f299fce47443d39b22b6ffe8ee3add", "title" : "CROW GREASE", "description" : "A Awe-Inspiring Documentary of a Woman And a Husband who must Sink a Database Administrator in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "104 min", "rating" : "PG", "actors" : ["CAMERON STREEP", "JODIE DEGENERES", "SCARLETT DAMON", "CHRIS BRIDGES", "WALTER TORN", "GROUCHO DUNST", "CAMERON ZELLWEGER", "MORGAN MCDORMAND", "FRANCES TOMEI", "LISA MONROE"]}'),
('{ "_id" : "ccef705082e34b79bbbda2922b8c6a40", "title" : "CROWDS TELEMARK", "description" : "A Intrepid Documentary of a Astronaut And a Forensic Psychologist who must Find a Frisbee in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "112 min", "rating" : "R", "actors" : ["MATTHEW JOHANSSON", "ANNE CRONYN", "JEFF SILVERSTONE", "MATTHEW CARREY"]}'),
('{ "_id" : "a30f68f8095945dea3e8038829809fd2", "title" : "CRUELTY UNFORGIVEN", "description" : "A Brilliant Tale of a Car And a Moose who must Battle a Dentist in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "69 min", "rating" : "G", "actors" : ["GREG CHAPLIN", "WILL WILSON"]}'),
('{ "_id" : "f4e7a63a6518422c9d5ab39933361e71", "title" : "CRUSADE HONEY", "description" : "A Fast-Paced Reflection of a Explorer And a Butler who must Battle a Madman in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "112 min", "rating" : "R", "actors" : ["TIM HACKMAN", "FAY KILMER", "RAY JOHANSSON", "SEAN GUINESS", "MEG HAWKE", "MATTHEW LEIGH", "RENEE TRACY", "ALBERT JOHANSSON", "LISA MONROE"]}'),
('{ "_id" : "4194717f926347c3bd1f6476c1802ccb", "title" : "CRYSTAL BREAKING", "description" : "A Fast-Paced Character Study of a Feminist And a Explorer who must Face a Pastry Chef in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "184 min", "rating" : "NC-17", "actors" : ["REESE KILMER", "JAYNE NEESON", "PENELOPE CRONYN", "LIZA BERGMAN", "FAY WOOD"]}'),
('{ "_id" : "100aea00849641349ebb9ba88be24d4d", "title" : "CUPBOARD SINNERS", "description" : "A Emotional Reflection of a Frisbee And a Boat who must Reach a Pastry Chef in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "56 min", "rating" : "R", "actors" : ["HELEN VOIGHT", "CAMERON STREEP", "TIM HACKMAN", "CHRISTIAN AKROYD", "SPENCER PECK", "MATTHEW LEIGH", "FRANCES TOMEI", "JADA RYDER"]}'),
('{ "_id" : "b9406d9877e04ce180e1613976709508", "title" : "CURTAIN VIDEOTAPE", "description" : "A Boring Reflection of a Dentist And a Mad Cow who must Chase a Secret Agent in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "133 min", "rating" : "PG-13", "actors" : ["JOE SWANK", "WALTER TORN", "EWAN GOODING"]}'),
('{ "_id" : "998aff546fa74c69bd570a397139500b", "title" : "CYCLONE FAMILY", "description" : "A Lacklusture Drama of a Student And a Monkey who must Sink a Womanizer in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "176 min", "rating" : "PG", "actors" : ["HELEN VOIGHT", "RIP CRAWFORD", "JUDY DEAN"]}'),
('{ "_id" : "ccdf2173a4974c27ba63f57411b823a6", "title" : "DADDY PITTSBURGH", "description" : "A Epic Story of a A Shark And a Student who must Confront a Explorer in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "161 min", "rating" : "G", "actors" : ["JOHNNY LOLLOBRIGIDA", "KENNETH PALTROW", "MICHELLE MCCONAUGHEY", "KEVIN GARLAND", "DARYL CRAWFORD"]}'),
('{ "_id" : "57be6314997e4ee88a1bb5a07cae326f", "title" : "DAISY MENAGERIE", "description" : "A Fast-Paced Saga of a Pastry Chef And a Monkey who must Sink a Composer in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "84 min", "rating" : "G", "actors" : ["JOHNNY LOLLOBRIGIDA", "UMA WOOD", "GOLDIE BRODY", "JODIE DEGENERES", "CARMEN HUNT", "MILLA KEITEL", "MINNIE KILMER"]}'),
('{ "_id" : "fde743eff9e74cb49299cca6e9dd6433", "title" : "DALMATIONS SWEDEN", "description" : "A Emotional Epistle of a Moose And a Hunter who must Overcome a Robot in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "106 min", "rating" : "PG", "actors" : ["JOE SWANK", "KEVIN BLOOM", "VAL BOLGER", "GROUCHO DUNST", "ALBERT NOLTE", "AL GARLAND"]}'),
('{ "_id" : "e2636a0d124047e6b97f528a385d704d", "title" : "DANCES NONE", "description" : "A Insightful Reflection of a A Shark And a Dog who must Kill a Butler in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "58 min", "rating" : "NC-17", "actors" : ["MATTHEW JOHANSSON", "ZERO CAGE", "RIP WINSLET", "MAE HOFFMAN", "WALTER TORN"]}'),
('{ "_id" : "6534579695c94e9ebb4ca7c9afe34d54", "title" : "DANCING FEVER", "description" : "A Stunning Story of a Explorer And a Forensic Psychologist who must Face a Crocodile in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "144 min", "rating" : "G", "actors" : ["KENNETH TORN", "MATTHEW LEIGH", "JANE JACKMAN", "JAYNE NOLTE", "LAURA BRODY", "ROCK DUKAKIS"]}'),
('{ "_id" : "9475732492de4357b07fc758d54d7424", "title" : "DANGEROUS UPTOWN", "description" : "A Unbelieveable Story of a Mad Scientist And a Woman who must Overcome a Dog in California", "release_year" : "2006", "language" : "English", "duration" : "121 min", "rating" : "PG", "actors" : ["ANNE CRONYN", "MARY TANDY", "RALPH CRUZ", "SPENCER PECK", "KIRSTEN AKROYD", "DARYL WAHLBERG", "CATE HARRIS", "ALBERT JOHANSSON"]}'),
('{ "_id" : "4cb1db8bf71949e994c8fd4bb0c2c016", "title" : "DARES PLUTO", "description" : "A Fateful Story of a Robot And a Dentist who must Defeat a Astronaut in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "89 min", "rating" : "PG-13", "actors" : ["KARL BERRY", "BOB FAWCETT", "CAMERON WRAY", "WARREN NOLTE", "PENELOPE MONROE", "GRETA KEITEL", "MERYL GIBSON", "LAURA BRODY", "WILL WILSON", "JULIA ZELLWEGER"]}'),
('{ "_id" : "27ac45e5ea1c42208193e1003a12c117", "title" : "DARKNESS WAR", "description" : "A Touching Documentary of a Husband And a Hunter who must Escape a Boy in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "99 min", "rating" : "NC-17", "actors" : ["GENE WILLIS", "GINA DEGENERES"]}'),
('{ "_id" : "6fd8e8e3af9544cca95388fef23a5161", "title" : "DARKO DORADO", "description" : "A Stunning Reflection of a Frisbee And a Husband who must Redeem a Dog in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "130 min", "rating" : "NC-17", "actors" : ["DUSTIN TAUTOU", "MORGAN MCDORMAND", "RICHARD PENN", "GRETA MALDEN"]}'),
('{ "_id" : "3053fe5d47d94352adde9915320174a9", "title" : "DARLING BREAKING", "description" : "A Brilliant Documentary of a Astronaut And a Squirrel who must Succumb a Student in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "165 min", "rating" : "PG-13", "actors" : ["FRANCES DAY-LEWIS", "JAYNE NEESON"]}'),
('{ "_id" : "901079925e9143aca48793a252c2e27e", "title" : "DARN FORRESTER", "description" : "A Fateful Story of a A Shark And a Explorer who must Succumb a Technical Writer in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "185 min", "rating" : "G", "actors" : ["BOB FAWCETT", "SANDRA KILMER", "JODIE DEGENERES", "RALPH CRUZ", "CHARLIZE DENCH", "SEAN GUINESS", "CHRIS BRIDGES", "CATE MCQUEEN", "MENA HOPPER"]}'),
('{ "_id" : "75fe285195fa4e6bba4af0c7f6cdbc36", "title" : "DATE SPEED", "description" : "A Touching Saga of a Composer And a Moose who must Discover a Dentist in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "104 min", "rating" : "R", "actors" : ["KARL BERRY", "KEVIN BLOOM", "JUDE CRUISE", "RIP WINSLET"]}'),
('{ "_id" : "a233e8e0c78c48dc8cb91d79b30541a4", "title" : "DAUGHTER MADIGAN", "description" : "A Beautiful Tale of a Hunter And a Mad Scientist who must Confront a Squirrel in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "59 min", "rating" : "PG-13", "actors" : ["MILLA PECK", "ED MANSFIELD", "LUCILLE DEE", "JOHN SUVARI"]}'),
('{ "_id" : "2cfee80f66bf45d8b6f8a9d5004dae78", "title" : "DAWN POND", "description" : "A Thoughtful Documentary of a Dentist And a Forensic Psychologist who must Defeat a Waitress in Berlin", "release_year" : "2006", "language" : "English", "duration" : "57 min", "rating" : "PG", "actors" : ["RIP WINSLET", "SCARLETT DAMON", "MATTHEW LEIGH", "VIVIEN BASINGER", "GROUCHO WILLIAMS", "MERYL ALLEN"]}'),
('{ "_id" : "a0fb619ae8fd42728313a7208e956276", "title" : "DAY UNFAITHFUL", "description" : "A Stunning Documentary of a Composer And a Mad Scientist who must Find a Technical Writer in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "113 min", "rating" : "G", "actors" : ["KARL BERRY", "MINNIE ZELLWEGER", "GREG CHAPLIN", "ANGELA WITHERSPOON", "JULIA FAWCETT"]}'),
('{ "_id" : "95ac39588c8b49779f8de57bcebfb451", "title" : "DAZED PUNK", "description" : "A Action-Packed Story of a Pioneer And a Technical Writer who must Discover a Forensic Psychologist in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "120 min", "rating" : "G", "actors" : ["GRACE MOSTEL", "BOB FAWCETT", "BEN WILLIS", "GEOFFREY HESTON", "BEN HARRIS", "GRETA MALDEN"]}'),
('{ "_id" : "7ca8d2d5f2ff40278c9fa6d15ac00f78", "title" : "DECEIVER BETRAYED", "description" : "A Taut Story of a Moose And a Squirrel who must Build a Husband in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "122 min", "rating" : "NC-17", "actors" : ["GRACE MOSTEL", "FRED COSTNER", "MORGAN HOPKINS", "ALBERT JOHANSSON"]}'),
('{ "_id" : "4b7839ec51794e6ebbdaccb182349e42", "title" : "DEEP CRUSADE", "description" : "A Amazing Tale of a Crocodile And a Squirrel who must Discover a Composer in Australia", "release_year" : "2006", "language" : "English", "duration" : "51 min", "rating" : "PG-13", "actors" : ["TIM HACKMAN", "REESE KILMER", "SCARLETT DAMON", "WARREN NOLTE", "GENE HOPKINS", "OLYMPIA PFEIFFER", "GREGORY GOODING"]}'),
('{ "_id" : "4b76c7a7e5f84315a9bcffb1c33c1029", "title" : "DEER VIRGINIAN", "description" : "A Thoughtful Story of a Mad Cow And a Womanizer who must Overcome a Mad Scientist in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "106 min", "rating" : "NC-17", "actors" : ["GINA DEGENERES", "LIZA BERGMAN", "IAN TANDY"]}'),
('{ "_id" : "be90a4ff40fb4fdbb0febb371837e5d8", "title" : "DELIVERANCE MULHOLLAND", "description" : "A Astounding Saga of a Monkey And a Moose who must Conquer a Butler in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "100 min", "rating" : "R", "actors" : ["FRED COSTNER", "MATTHEW LEIGH", "HUMPHREY GARLAND"]}'),
('{ "_id" : "156f6c19a8974318be68451dda595bcf", "title" : "DESERT POSEIDON", "description" : "A Brilliant Documentary of a Butler And a Frisbee who must Build a Astronaut in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "64 min", "rating" : "R", "actors" : ["GOLDIE BRODY", "HENRY BERRY", "BURT POSEY", "LIZA BERGMAN", "RENEE BALL"]}'),
('{ "_id" : "7d152b364d0d4b99864eb80e4d39cd65", "title" : "DESIRE ALIEN", "description" : "A Fast-Paced Tale of a Dog And a Forensic Psychologist who must Meet a Astronaut in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "76 min", "rating" : "NC-17", "actors" : ["TOM MCKELLEN", "JOHNNY CAGE", "ANGELINA ASTAIRE", "JULIANNE DENCH", "CATE HARRIS", "LAURA BRODY", "ROCK DUKAKIS"]}'),
('{ "_id" : "62806cc5ff8c43c7b6c60a6b18e3ea59", "title" : "DESPERATE TRAINSPOTTING", "description" : "A Epic Yarn of a Forensic Psychologist And a Teacher who must Face a Lumberjack in California", "release_year" : "2006", "language" : "English", "duration" : "81 min", "rating" : "G", "actors" : ["CARY MCCONAUGHEY", "RENEE TRACY", "MORGAN WILLIAMS", "RENEE BALL"]}'),
('{ "_id" : "b35db525c6ea4a5d81a0a1e0ea28399b", "title" : "DESTINATION JERK", "description" : "A Beautiful Yarn of a Teacher And a Cat who must Build a Car in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "76 min", "rating" : "PG-13", "actors" : ["GRACE MOSTEL", "RIP CRAWFORD", "CAMERON WRAY"]}'),
('{ "_id" : "b4d735c6f58d4173a48881cbda63b769", "title" : "DESTINY SATURDAY", "description" : "A Touching Drama of a Crocodile And a Crocodile who must Conquer a Explorer in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "56 min", "rating" : "G", "actors" : ["NICK WAHLBERG", "SANDRA KILMER", "KEVIN BLOOM", "ALEC WAYNE", "DAN HARRIS", "MARY TANDY", "EMILY DEE"]}'),
('{ "_id" : "132fe7bb198c4e25a451ac92fd90277c", "title" : "DETAILS PACKER", "description" : "A Epic Saga of a Waitress And a Composer who must Face a Boat in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "88 min", "rating" : "R", "actors" : ["MICHELLE MCCONAUGHEY", "SALMA NOLTE"]}'),
('{ "_id" : "51985a1ad0a04f238419885a14b6a906", "title" : "DETECTIVE VISION", "description" : "A Fanciful Documentary of a Pioneer And a Woman who must Redeem a Hunter in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "143 min", "rating" : "PG-13", "actors" : ["KENNETH TORN", "ANGELA WITHERSPOON", "JULIA ZELLWEGER"]}'),
('{ "_id" : "1b7ef747536848ae88cb50ace9e599d4", "title" : "DEVIL DESIRE", "description" : "A Beautiful Reflection of a Monkey And a Dentist who must Face a Database Administrator in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "87 min", "rating" : "R", "actors" : ["MARY TANDY", "KIRSTEN AKROYD", "GROUCHO DUNST", "ED MANSFIELD", "EWAN GOODING"]}'),
('{ "_id" : "57e8147518a44e608c1ad63eac29a13b", "title" : "DIARY PANIC", "description" : "A Thoughtful Character Study of a Frisbee And a Mad Cow who must Outgun a Man in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "107 min", "rating" : "G", "actors" : ["JODIE DEGENERES", "MARY TANDY", "MAE HOFFMAN", "DARYL CRAWFORD"]}'),
('{ "_id" : "d78dc73f82654389bbbb76eecd535607", "title" : "DINOSAUR SECRETARY", "description" : "A Action-Packed Drama of a Feminist And a Girl who must Reach a Robot in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "63 min", "rating" : "R", "actors" : ["LUCILLE TRACY", "BURT DUKAKIS", "JAYNE NEESON", "RUSSELL BACALL", "PENELOPE MONROE", "MINNIE KILMER"]}'),
('{ "_id" : "7768519845a94808bf0ac3ead6759017", "title" : "DIRTY ACE", "description" : "A Action-Packed Character Study of a Forensic Psychologist And a Girl who must Build a Dentist in The Outback", "release_year" : "2006", "language" : "English", "duration" : "147 min", "rating" : "NC-17", "actors" : ["VIVIEN BERGEN", "SCARLETT DAMON", "RIVER DEAN", "GEOFFREY HESTON", "MERYL ALLEN"]}'),
('{ "_id" : "e28cc795685e414ebe1b6f21f07a295f", "title" : "DISCIPLE MOTHER", "description" : "A Touching Reflection of a Mad Scientist And a Boat who must Face a Moose in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "141 min", "rating" : "PG", "actors" : ["JOHNNY CAGE", "JULIA BARRYMORE", "ADAM GRANT", "PENELOPE CRONYN", "EWAN GOODING", "JAYNE NOLTE", "MATTHEW CARREY"]}'),
('{ "_id" : "e18d0f7e496c4a4b9003a323cbad3e1b", "title" : "DISTURBING SCARFACE", "description" : "A Lacklusture Display of a Crocodile And a Butler who must Overcome a Monkey in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "94 min", "rating" : "R", "actors" : ["ANGELINA ASTAIRE", "KENNETH PESCI", "JULIANNE DENCH", "AUDREY BAILEY"]}'),
('{ "_id" : "da8652fb76064895b9785e1283f55d25", "title" : "DIVIDE MONSTER", "description" : "A Intrepid Saga of a Man And a Forensic Psychologist who must Reach a Squirrel in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "68 min", "rating" : "PG-13", "actors" : ["SANDRA KILMER", "CHRISTIAN AKROYD", "HENRY BERRY", "CHRISTIAN NEESON", "ALAN DREYFUSS", "GENE MCKELLEN"]}'),
('{ "_id" : "156b80f4c2de4a1ca37c8d5124ec3240", "title" : "DIVINE RESURRECTION", "description" : "A Boring Character Study of a Man And a Womanizer who must Succumb a Teacher in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "100 min", "rating" : "R", "actors" : ["CHRISTIAN GABLE", "CUBA OLIVIER", "HELEN VOIGHT", "DAN HARRIS", "KENNETH PALTROW"]}'),
('{ "_id" : "d9bdb8ecc25c44af8de5f609499bcb49", "title" : "DIVORCE SHINING", "description" : "A Unbelieveable Saga of a Crocodile And a Student who must Discover a Cat in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "47 min", "rating" : "G", "actors" : ["CHRISTIAN NEESON", "SEAN WILLIAMS", "MORGAN MCDORMAND", "WILL WILSON", "GENE MCKELLEN", "JULIA ZELLWEGER"]}'),
('{ "_id" : "2c75deca4d5c40bfa2352fcc49c7b679", "title" : "DOCTOR GRAIL", "description" : "A Insightful Drama of a Womanizer And a Waitress who must Reach a Forensic Psychologist in The Outback", "release_year" : "2006", "language" : "English", "duration" : "57 min", "rating" : "G", "actors" : ["JAMES PITT", "PENELOPE MONROE", "SALMA NOLTE", "ALBERT NOLTE", "CATE MCQUEEN", "JON CHASE"]}'),
('{ "_id" : "26f41f812d2440588c1dcddad0f25c5f", "title" : "DOGMA FAMILY", "description" : "A Brilliant Character Study of a Database Administrator And a Monkey who must Succumb a Astronaut in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "122 min", "rating" : "G", "actors" : ["KIRK JOVOVICH", "HENRY BERRY", "GROUCHO SINATRA", "SIDNEY CROWE", "GINA DEGENERES", "RIVER DEAN", "CHRISTOPHER WEST"]}'),
('{ "_id" : "498b59a5275140eea82f3511bec56fcf", "title" : "DOLLS RAGE", "description" : "A Thrilling Display of a Pioneer And a Frisbee who must Escape a Teacher in The Outback", "release_year" : "2006", "language" : "English", "duration" : "120 min", "rating" : "PG-13", "actors" : ["CARY MCCONAUGHEY"]}'),
('{ "_id" : "d95edab116bd4e6088eefb19102a2079", "title" : "DONNIE ALLEY", "description" : "A Awe-Inspiring Tale of a Butler And a Frisbee who must Vanquish a Teacher in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "125 min", "rating" : "NC-17", "actors" : ["VIVIEN BERGEN", "RIP CRAWFORD", "TOM MCKELLEN", "DUSTIN TAUTOU", "GROUCHO DUNST", "VIVIEN BASINGER", "WILL WILSON"]}'),
('{ "_id" : "aef24be43761445fa886312d03330c7c", "title" : "DOOM DANCING", "description" : "A Astounding Panorama of a Car And a Mad Scientist who must Battle a Lumberjack in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "68 min", "rating" : "R", "actors" : ["CAMERON STREEP", "NICK STALLONE", "CHRISTIAN AKROYD", "JESSICA BAILEY", "MAE HOFFMAN", "WOODY JOLIE", "WARREN NOLTE", "CHRIS DEPP"]}'),
('{ "_id" : "60ef8f9eeb944fa4b8ac9722a6b9be05", "title" : "DOORS PRESIDENT", "description" : "A Awe-Inspiring Display of a Squirrel And a Woman who must Overcome a Boy in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "49 min", "rating" : "NC-17", "actors" : ["KARL BERRY", "LUCILLE TRACY", "NATALIE HOPKINS", "CHRISTIAN AKROYD", "SYLVESTER DERN", "GENE HOPKINS", "ED MANSFIELD", "KIM ALLEN", "REESE WEST"]}'),
('{ "_id" : "d9dd8c2ccabe4454a906e92857e118bd", "title" : "DORADO NOTTING", "description" : "A Action-Packed Tale of a Sumo Wrestler And a A Shark who must Meet a Frisbee in California", "release_year" : "2006", "language" : "English", "duration" : "139 min", "rating" : "NC-17", "actors" : ["AUDREY OLIVIER", "JESSICA BAILEY", "GENE WILLIS", "FAY WOOD"]}'),
('{ "_id" : "a3fa8b87d2654f33897c563e7cc78313", "title" : "DOUBLE WRATH", "description" : "A Thoughtful Yarn of a Womanizer And a Dog who must Challenge a Madman in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "177 min", "rating" : "R", "actors" : ["KEVIN BLOOM", "BURT DUKAKIS", "FRANCES DAY-LEWIS", "GARY PENN", "CARY MCCONAUGHEY", "DARYL WAHLBERG", "HARRISON BALE", "JULIANNE DENCH"]}'),
('{ "_id" : "db6d51ca2ed84bd48fa4db144888ed65", "title" : "DOUBTFIRE LABYRINTH", "description" : "A Intrepid Panorama of a Butler And a Composer who must Meet a Mad Cow in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "154 min", "rating" : "R", "actors" : ["HARRISON BALE", "RENEE TRACY", "JULIANNE DENCH", "SCARLETT BENING", "KENNETH HOFFMAN"]}'),
('{ "_id" : "3077c1327a5f409dbea742a6110b6c05", "title" : "DOWNHILL ENOUGH", "description" : "A Emotional Tale of a Pastry Chef And a Forensic Psychologist who must Succumb a Monkey in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "47 min", "rating" : "G", "actors" : ["WOODY JOLIE", "BEN WILLIS", "DARYL CRAWFORD", "HARVEY HOPE"]}'),
('{ "_id" : "45ec18d84bca429eb0199acf47c25fe0", "title" : "DOZEN LION", "description" : "A Taut Drama of a Cat And a Girl who must Defeat a Frisbee in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "177 min", "rating" : "NC-17", "actors" : ["NATALIE HOPKINS", "CAMERON WRAY", "JADA RYDER", "BEN HARRIS", "LAURA BRODY", "KENNETH HOFFMAN"]}'),
('{ "_id" : "a9470f5283274a9aaa1d3f0eaa6b8382", "title" : "DRACULA CRYSTAL", "description" : "A Thrilling Reflection of a Feminist And a Cat who must Find a Frisbee in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "176 min", "rating" : "G", "actors" : ["NICK WAHLBERG", "JODIE DEGENERES", "CARMEN HUNT", "CAMERON WRAY", "MICHELLE MCCONAUGHEY", "SEAN WILLIAMS", "BEN WILLIS", "GREG CHAPLIN", "MORGAN HOPKINS", "DARYL CRAWFORD", "MORGAN WILLIAMS", "IAN TANDY", "REESE WEST"]}'),
('{ "_id" : "d6a11723f9474f57af301dd9c66fbea2", "title" : "DRAGON SQUAD", "description" : "A Taut Reflection of a Boy And a Waitress who must Outgun a Teacher in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "170 min", "rating" : "NC-17", "actors" : ["ANNE CRONYN", "SPENCER PECK", "JIM MOSTEL", "SPENCER DEPP", "SUSAN DAVIS", "ALBERT NOLTE", "GENE HOPKINS", "ED GUINESS"]}'),
('{ "_id" : "e0601cd318a04defb2b367d901f14c16", "title" : "DRAGONFLY STRANGERS", "description" : "A Boring Documentary of a Pioneer And a Man who must Vanquish a Man in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "133 min", "rating" : "NC-17", "actors" : ["CHRISTIAN GABLE", "ANGELINA ASTAIRE", "FAY WINSLET"]}'),
('{ "_id" : "7421a69d6f9e4af09749b262367ddadf", "title" : "DREAM PICKUP", "description" : "A Epic Display of a Car And a Composer who must Overcome a Forensic Psychologist in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "135 min", "rating" : "PG", "actors" : ["MILLA PECK", "JODIE DEGENERES", "HUMPHREY WILLIS", "JON CHASE"]}'),
('{ "_id" : "af7bc03494434c0188f08abec34676ec", "title" : "DRIFTER COMMANDMENTS", "description" : "A Epic Reflection of a Womanizer And a Squirrel who must Discover a Husband in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "61 min", "rating" : "PG-13", "actors" : ["VIVIEN BERGEN", "KIRSTEN PALTROW", "VAL BOLGER", "HENRY BERRY", "SPENCER PECK", "AL GARLAND", "AUDREY BAILEY"]}'),
('{ "_id" : "a8f2ecbbb8d44b8681458a002b60478c", "title" : "DRIVER ANNIE", "description" : "A Lacklusture Character Study of a Butler And a Car who must Redeem a Boat in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "159 min", "rating" : "PG-13", "actors" : ["UMA WOOD", "SANDRA KILMER", "PARKER GOLDBERG", "CHRISTIAN AKROYD", "CHARLIZE DENCH", "MORGAN MCDORMAND", "MORGAN WILLIAMS", "FAY WINSLET"]}'),
('{ "_id" : "b42468d5fea14c27aa044f1e81472f24", "title" : "DRIVING POLISH", "description" : "A Action-Packed Yarn of a Feminist And a Technical Writer who must Sink a Boat in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "175 min", "rating" : "NC-17", "actors" : ["MATTHEW JOHANSSON", "VIVIEN BERGEN", "RIP WINSLET", "SUSAN DAVIS", "PENELOPE MONROE", "NICK DEGENERES", "WILL WILSON"]}'),
('{ "_id" : "d0825131cbaa44319a0145fcbd055801", "title" : "DROP WATERFRONT", "description" : "A Fanciful Documentary of a Husband And a Explorer who must Reach a Madman in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "178 min", "rating" : "R", "actors" : ["BETTE NICHOLSON", "CAMERON STREEP", "JUDY DEAN", "MENA TEMPLE", "JESSICA BAILEY", "MEG HAWKE", "FRANCES TOMEI", "ED MANSFIELD"]}'),
('{ "_id" : "9fc545321bfb450494ee9151bc8cd755", "title" : "DRUMLINE CYCLONE", "description" : "A Insightful Panorama of a Monkey And a Sumo Wrestler who must Outrace a Mad Scientist in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "110 min", "rating" : "G", "actors" : ["GROUCHO SINATRA", "CAMERON STREEP", "JUDY DEAN", "MENA TEMPLE", "FAY WOOD", "WILL WILSON", "REESE WEST", "ED MANSFIELD"]}'),
('{ "_id" : "b0a315459c1c462ca5bf06c383c90adb", "title" : "DRUMS DYNAMITE", "description" : "A Epic Display of a Crocodile And a Crocodile who must Confront a Dog in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "96 min", "rating" : "PG", "actors" : ["VIVIEN BERGEN", "JUDE CRUISE", "MORGAN HOPKINS", "LUCILLE DEE", "WHOOPI HURT", "JEFF SILVERSTONE", "REESE WEST"]}'),
('{ "_id" : "b0703e7bcdba4d73a7ecd305351d1cbf", "title" : "DUCK RACER", "description" : "A Lacklusture Yarn of a Teacher And a Squirrel who must Overcome a Dog in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "116 min", "rating" : "NC-17", "actors" : ["WOODY HOFFMAN", "PENELOPE CRONYN"]}'),
('{ "_id" : "a9752d31b8a7480088d287f57681a775", "title" : "DUDE BLINDNESS", "description" : "A Stunning Reflection of a Husband And a Lumberjack who must Face a Frisbee in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "132 min", "rating" : "G", "actors" : ["SANDRA PECK", "VAL BOLGER", "GROUCHO SINATRA", "RALPH CRUZ", "SCARLETT DAMON", "SCARLETT BENING", "ANGELA WITHERSPOON"]}'),
('{ "_id" : "3b40a202593849aea7698f12e6e36eb5", "title" : "DUFFEL APOCALYPSE", "description" : "A Emotional Display of a Boat And a Explorer who must Challenge a Madman in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "171 min", "rating" : "G", "actors" : ["CARY MCCONAUGHEY", "GROUCHO SINATRA", "EWAN GOODING"]}'),
('{ "_id" : "de1c2c6049af45af8d271e0b5ddf9c43", "title" : "DUMBO LUST", "description" : "A Touching Display of a Feminist And a Dentist who must Conquer a Husband in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "119 min", "rating" : "NC-17", "actors" : ["SANDRA PECK", "HENRY BERRY", "MAE HOFFMAN", "RALPH CRUZ", "SEAN GUINESS", "ED MANSFIELD", "EWAN GOODING", "FAY WOOD", "MARY KEITEL"]}'),
('{ "_id" : "0b3d267b191645f297f5cc9ff3da78a1", "title" : "DURHAM PANKY", "description" : "A Brilliant Panorama of a Girl And a Boy who must Face a Mad Scientist in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "154 min", "rating" : "R", "actors" : ["MATTHEW JOHANSSON", "WOODY HOFFMAN", "MILLA KEITEL", "BEN WILLIS", "SUSAN DAVIS", "SCARLETT BENING", "FRANCES TOMEI", "MORGAN WILLIAMS", "FAY WOOD"]}'),
('{ "_id" : "08f3979f3a9c420fbad37a2b926e0046", "title" : "DWARFS ALTER", "description" : "A Emotional Yarn of a Girl And a Dog who must Challenge a Composer in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "101 min", "rating" : "G", "actors" : ["MARY KEITEL"]}'),
('{ "_id" : "bb462d2917f54f5e860b021b8f6bf41f", "title" : "DYING MAKER", "description" : "A Intrepid Tale of a Boat And a Monkey who must Kill a Cat in California", "release_year" : "2006", "language" : "English", "duration" : "168 min", "rating" : "PG", "actors" : ["GROUCHO SINATRA", "MICHAEL BOLGER"]}'),
('{ "_id" : "7e5826895f794095bc306817bd699121", "title" : "DYNAMITE TARZAN", "description" : "A Intrepid Documentary of a Forensic Psychologist And a Mad Scientist who must Face a Explorer in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "141 min", "rating" : "PG-13", "actors" : ["BOB FAWCETT", "CHARLIZE DENCH", "JULIANNE DENCH", "EWAN GOODING", "CUBA BIRCH"]}'),
('{ "_id" : "f495d8a7e0aa46b494ca7b8bc0e510d0", "title" : "EAGLES PANKY", "description" : "A Thoughtful Story of a Car And a Boy who must Find a A Shark in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "140 min", "rating" : "NC-17", "actors" : ["FRED COSTNER", "FRANCES DAY-LEWIS", "JUDE CRUISE", "MAE HOFFMAN", "SCARLETT DAMON", "CHRIS DEPP"]}'),
('{ "_id" : "759c4655f06c42b8b1161698616a8a06", "title" : "EARLY HOME", "description" : "A Amazing Panorama of a Mad Scientist And a Husband who must Meet a Woman in The Outback", "release_year" : "2006", "language" : "English", "duration" : "96 min", "rating" : "NC-17", "actors" : ["DAN TORN", "MENA TEMPLE", "SCARLETT DAMON", "BEN WILLIS", "WALTER TORN", "MORGAN WILLIAMS"]}'),
('{ "_id" : "26f2155aef4c4ed7adb904fe420c1b04", "title" : "EARRING INSTINCT", "description" : "A Stunning Character Study of a Dentist And a Mad Cow who must Find a Teacher in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "98 min", "rating" : "R", "actors" : ["FRED COSTNER", "LUCILLE TRACY", "MAE HOFFMAN", "RITA REYNOLDS", "HARVEY HOPE"]}'),
('{ "_id" : "0ad0265b751b468489cf3c1500c8280a", "title" : "EARTH VISION", "description" : "A Stunning Drama of a Butler And a Madman who must Outrace a Womanizer in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "NC-17", "actors" : ["KENNETH TORN", "RICHARD PENN", "JAYNE NOLTE"]}'),
('{ "_id" : "af66b1a3d64e4e9a8cd0533ccf22b64a", "title" : "EASY GLADIATOR", "description" : "A Fateful Story of a Monkey And a Girl who must Overcome a Pastry Chef in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "148 min", "rating" : "G", "actors" : ["FRED COSTNER", "MATTHEW LEIGH", "ED MANSFIELD"]}'),
('{ "_id" : "84c3a82789db4d4fb8da9416a3ec8ca2", "title" : "EDGE KISSING", "description" : "A Beautiful Yarn of a Composer And a Mad Cow who must Redeem a Mad Scientist in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "153 min", "rating" : "NC-17", "actors" : ["JAYNE NEESON", "ANGELA WITHERSPOON", "CUBA BIRCH"]}'),
('{ "_id" : "d9723afd8b464155b68aa716734a227a", "title" : "EFFECT GLADIATOR", "description" : "A Beautiful Display of a Pastry Chef And a Pastry Chef who must Outgun a Forensic Psychologist in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "107 min", "rating" : "PG", "actors" : ["JULIA MCQUEEN", "ALEC WAYNE", "NICK STALLONE", "JULIA BARRYMORE", "RENEE TRACY", "OLYMPIA PFEIFFER", "LISA MONROE"]}'),
('{ "_id" : "c76f05fdf34f4fffb224e8a707dd27ab", "title" : "EGG IGBY", "description" : "A Beautiful Documentary of a Boat And a Sumo Wrestler who must Succumb a Database Administrator in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "67 min", "rating" : "PG", "actors" : ["LUCILLE TRACY", "TOM MCKELLEN", "NATALIE HOPKINS", "MERYL GIBSON", "OPRAH KILMER"]}'),
('{ "_id" : "2347bdb395d04edb96e567a624f19f09", "title" : "EGYPT TENENBAUMS", "description" : "A Intrepid Story of a Madman And a Secret Agent who must Outrace a Astronaut in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "PG", "actors" : ["CUBA OLIVIER", "GARY PENN", "KENNETH TORN", "SUSAN DAVIS", "CHRIS DEPP"]}'),
('{ "_id" : "97210f99dc7a46d5bd892faeecc740fd", "title" : "ELEMENT FREDDY", "description" : "A Awe-Inspiring Reflection of a Waitress And a Squirrel who must Kill a Mad Cow in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "115 min", "rating" : "NC-17", "actors" : ["KIRK JOVOVICH", "ANGELA HUDSON", "MERYL GIBSON", "BELA WALKEN"]}'),
('{ "_id" : "f9d44934343e4663ad8ce890598bddeb", "title" : "ELEPHANT TROJAN", "description" : "A Beautiful Panorama of a Lumberjack And a Forensic Psychologist who must Overcome a Frisbee in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "126 min", "rating" : "PG-13", "actors" : ["PENELOPE GUINESS", "CAMERON STREEP", "VAL BOLGER", "GINA DEGENERES", "HARRISON BALE"]}'),
('{ "_id" : "131bf40b3790410d873468616b1f7d78", "title" : "ELF MURDER", "description" : "A Action-Packed Story of a Frisbee And a Woman who must Reach a Girl in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "155 min", "rating" : "NC-17", "actors" : ["CAMERON WRAY", "WARREN NOLTE", "GENE HOPKINS", "ALBERT JOHANSSON", "AUDREY BAILEY"]}'),
('{ "_id" : "001eb143019d4c49822596a72d52c5be", "title" : "ELIZABETH SHANE", "description" : "A Lacklusture Display of a Womanizer And a Dog who must Face a Sumo Wrestler in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "152 min", "rating" : "NC-17", "actors" : ["DAN TORN", "BEN WILLIS", "OPRAH KILMER"]}'),
('{ "_id" : "ea0f765d72454752a76216beaaf48680", "title" : "EMPIRE MALKOVICH", "description" : "A Amazing Story of a Feminist And a Cat who must Face a Car in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "177 min", "rating" : "G", "actors" : ["CUBA OLIVIER", "FRED COSTNER", "HELEN VOIGHT", "DAN TORN", "RAY JOHANSSON", "RALPH CRUZ", "ELLEN PRESLEY", "SIDNEY CROWE", "RICHARD PENN"]}'),
('{ "_id" : "fdcf2524825d47668ca7a974f0358eb4", "title" : "ENCINO ELF", "description" : "A Astounding Drama of a Feminist And a Teacher who must Confront a Husband in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "143 min", "rating" : "G", "actors" : ["ZERO CAGE", "KIRSTEN PALTROW", "BEN WILLIS", "JAMES PITT", "SYLVESTER DERN", "HARVEY HOPE"]}'),
('{ "_id" : "5d94f81edcb04ca79d54dcb5a7b59dc5", "title" : "ENCOUNTERS CURTAIN", "description" : "A Insightful Epistle of a Pastry Chef And a Womanizer who must Build a Boat in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "92 min", "rating" : "NC-17", "actors" : ["ALEC WAYNE", "ANNE CRONYN", "EWAN GOODING", "MERYL GIBSON"]}'),
('{ "_id" : "11821204f5694f418223b1391129b775", "title" : "ENDING CROWDS", "description" : "A Unbelieveable Display of a Dentist And a Madman who must Vanquish a Squirrel in Berlin", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "NC-17", "actors" : ["ZERO CAGE", "BURT DUKAKIS", "MARY TANDY", "SIDNEY CROWE", "CHRISTOPHER WEST"]}'),
('{ "_id" : "955d266a57c348ff84dc4e14ebbcad97", "title" : "ENEMY ODDS", "description" : "A Fanciful Panorama of a Mad Scientist And a Woman who must Pursue a Astronaut in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "77 min", "rating" : "NC-17", "actors" : ["VIVIEN BERGEN", "LIZA BERGMAN", "EWAN GOODING", "BELA WALKEN"]}'),
('{ "_id" : "d1887207dbe94fca9928e0266d9661a8", "title" : "ENGLISH BULWORTH", "description" : "A Intrepid Epistle of a Pastry Chef And a Pastry Chef who must Pursue a Crocodile in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "51 min", "rating" : "PG-13", "actors" : ["MENA TEMPLE", "PENELOPE PINKETT", "MATTHEW LEIGH", "JAYNE NOLTE", "FAY WOOD"]}'),
('{ "_id" : "9794f87baa524944a00b16e20f7c4138", "title" : "ENOUGH RAGING", "description" : "A Astounding Character Study of a Boat And a Secret Agent who must Find a Mad Cow in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "158 min", "rating" : "NC-17", "actors" : ["JOHNNY LOLLOBRIGIDA", "SANDRA PECK", "SEAN WILLIAMS", "JULIANNE DENCH", "KEVIN GARLAND", "RICHARD PENN", "AL GARLAND", "MATTHEW CARREY", "MICHAEL BOLGER"]}'),
('{ "_id" : "ed7025d3af6a4acc991255461a3d1562", "title" : "ENTRAPMENT SATISFACTION", "description" : "A Thoughtful Panorama of a Hunter And a Teacher who must Reach a Mad Cow in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "176 min", "rating" : "R", "actors" : ["FRED COSTNER", "WOODY HOFFMAN", "FRANCES DAY-LEWIS", "PENELOPE CRONYN"]}'),
('{ "_id" : "39e4e5659b1b422bb905dc61b32d9d7a", "title" : "ESCAPE METROPOLIS", "description" : "A Taut Yarn of a Astronaut And a Technical Writer who must Outgun a Boat in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "167 min", "rating" : "R", "actors" : ["JOHNNY LOLLOBRIGIDA", "NATALIE HOPKINS", "FRANCES TOMEI", "ED MANSFIELD"]}'),
('{ "_id" : "47f9c81e9512496caed54b5c686a474e", "title" : "EVE RESURRECTION", "description" : "A Awe-Inspiring Yarn of a Pastry Chef And a Database Administrator who must Challenge a Teacher in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "66 min", "rating" : "G", "actors" : ["ED CHASE", "SUSAN DAVIS", "SCARLETT BENING", "KENNETH HOFFMAN", "GENE MCKELLEN", "ROCK DUKAKIS"]}'),
('{ "_id" : "97fca6a6a47947afb4988d8cd8e06f27", "title" : "EVERYONE CRAFT", "description" : "A Fateful Display of a Waitress And a Dentist who must Reach a Butler in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "163 min", "rating" : "PG", "actors" : ["GOLDIE BRODY", "MICHELLE MCCONAUGHEY", "WOODY JOLIE", "JAMES PITT", "MINNIE ZELLWEGER"]}'),
('{ "_id" : "66c98da58302404096564d6a58b03d72", "title" : "EVOLUTION ALTER", "description" : "A Fanciful Character Study of a Feminist And a Madman who must Find a Explorer in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "174 min", "rating" : "PG-13", "actors" : ["ELVIS MARX", "RAY JOHANSSON", "ANGELA WITHERSPOON", "GRETA MALDEN", "ED GUINESS", "BURT TEMPLE"]}'),
('{ "_id" : "74edd9de2006498da199b6ee91459646", "title" : "EXCITEMENT EVE", "description" : "A Brilliant Documentary of a Monkey And a Car who must Conquer a Crocodile in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "51 min", "rating" : "G", "actors" : ["GRACE MOSTEL", "VIVIEN BERGEN", "SANDRA PECK", "PENELOPE PINKETT", "KENNETH PALTROW", "GINA DEGENERES", "SUSAN DAVIS", "MORGAN HOPKINS"]}'),
('{ "_id" : "b724ebcc4f9d4052803970cd39c71a43", "title" : "EXORCIST STING", "description" : "A Touching Drama of a Dog And a Sumo Wrestler who must Conquer a Mad Scientist in Berlin", "release_year" : "2006", "language" : "English", "duration" : "167 min", "rating" : "G", "actors" : ["GOLDIE BRODY", "ANGELA WITHERSPOON", "KIM ALLEN", "VIVIEN BASINGER", "GREGORY GOODING"]}'),
('{ "_id" : "10f7246bac6946f0b04b8a09c8977ebc", "title" : "EXPECATIONS NATURAL", "description" : "A Amazing Drama of a Butler And a Husband who must Reach a A Shark in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "138 min", "rating" : "PG-13", "actors" : ["ELVIS MARX", "DARYL WAHLBERG", "LAURENCE BULLOCK"]}'),
('{ "_id" : "dfe28fb71bd245c4810c00322bf41936", "title" : "EXPENDABLE STALLION", "description" : "A Amazing Character Study of a Mad Cow And a Squirrel who must Discover a Hunter in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "97 min", "rating" : "PG", "actors" : ["FRANCES DAY-LEWIS", "DUSTIN TAUTOU", "JAYNE NEESON", "FAY WINSLET"]}'),
('{ "_id" : "8ab10c07e3c94c3c8fe0d613e15bea20", "title" : "EXPRESS LONELY", "description" : "A Boring Drama of a Astronaut And a Boat who must Face a Boat in California", "release_year" : "2006", "language" : "English", "duration" : "178 min", "rating" : "R", "actors" : ["ALEC WAYNE", "PARKER GOLDBERG", "RIP WINSLET", "SEAN WILLIAMS", "MINNIE ZELLWEGER", "ALBERT JOHANSSON", "OLYMPIA PFEIFFER", "GREGORY GOODING"]}'),
('{ "_id" : "fca0b0b15aba4c5eaae3812ba3196577", "title" : "EXTRAORDINARY CONQUERER", "description" : "A Stunning Story of a Dog And a Feminist who must Face a Forensic Psychologist in Berlin", "release_year" : "2006", "language" : "English", "duration" : "122 min", "rating" : "G", "actors" : ["HENRY BERRY", "MINNIE ZELLWEGER", "CHRIS BRIDGES", "LIZA BERGMAN", "FAY WOOD", "NICK DEGENERES", "RENEE BALL"]}'),
('{ "_id" : "c0a4440b50834abd85ebc757c9d5784d", "title" : "EYES DRIVING", "description" : "A Thrilling Story of a Cat And a Waitress who must Fight a Explorer in The Outback", "release_year" : "2006", "language" : "English", "duration" : "172 min", "rating" : "PG-13", "actors" : ["DAN HARRIS", "RENEE TRACY", "FAY WINSLET", "MICHAEL BENING", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "864bba72bff8477d9edefaf33e741ab5", "title" : "FACTORY DRAGON", "description" : "A Action-Packed Saga of a Teacher And a Frisbee who must Escape a Lumberjack in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "144 min", "rating" : "PG-13", "actors" : ["SISSY SOBIESKI", "HENRY BERRY", "MAE HOFFMAN", "CATE MCQUEEN", "MERYL GIBSON", "MENA HOPPER"]}'),
('{ "_id" : "cd91c7589f6645cca5ee8083477d3c08", "title" : "FALCON VOLUME", "description" : "A Fateful Saga of a Sumo Wrestler And a Hunter who must Redeem a A Shark in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "102 min", "rating" : "PG-13", "actors" : ["MARY TANDY", "KENNETH PALTROW", "SALMA NOLTE", "ED MANSFIELD"]}'),
('{ "_id" : "dac7662e9e694f38a8cc6e0814602fbe", "title" : "FAMILY SWEET", "description" : "A Epic Documentary of a Teacher And a Boy who must Escape a Woman in Berlin", "release_year" : "2006", "language" : "English", "duration" : "155 min", "rating" : "R", "actors" : ["SANDRA PECK", "PENELOPE PINKETT", "BURT POSEY", "GROUCHO SINATRA", "DARYL WAHLBERG", "FAY WOOD", "KENNETH HOFFMAN", "MATTHEW CARREY", "DEBBIE AKROYD"]}'),
('{ "_id" : "ce2753a59e0548fc9a6d71aabf154e43", "title" : "FANTASIA PARK", "description" : "A Thoughtful Documentary of a Mad Scientist And a A Shark who must Outrace a Feminist in Australia", "release_year" : "2006", "language" : "English", "duration" : "131 min", "rating" : "G", "actors" : ["WARREN NOLTE", "HARRISON BALE", "GROUCHO WILLIAMS"]}'),
('{ "_id" : "66eced64d0594e4f9daf06dd5ab03ab4", "title" : "FANTASY TROOPERS", "description" : "A Touching Saga of a Teacher And a Monkey who must Overcome a Secret Agent in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "58 min", "rating" : "PG-13", "actors" : ["NATALIE HOPKINS", "GREG CHAPLIN", "SEAN GUINESS", "IAN TANDY", "GRETA MALDEN", "CHRISTOPHER WEST", "JON CHASE", "BELA WALKEN", "MARY KEITEL"]}'),
('{ "_id" : "edbcc0b69446410680c8ae433b2c952a", "title" : "FARGO GANDHI", "description" : "A Thrilling Reflection of a Pastry Chef And a Crocodile who must Reach a Teacher in The Outback", "release_year" : "2006", "language" : "English", "duration" : "130 min", "rating" : "G", "actors" : ["MICHELLE MCCONAUGHEY", "SCARLETT DAMON", "KENNETH PESCI", "MORGAN WILLIAMS", "CHRISTOPHER WEST"]}'),
('{ "_id" : "1da238a40f414689a480bfce359a44b8", "title" : "FATAL HAUNTED", "description" : "A Beautiful Drama of a Student And a Secret Agent who must Confront a Dentist in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "91 min", "rating" : "PG", "actors" : ["MILLA PECK", "JODIE DEGENERES", "ANGELA HUDSON", "MORGAN MCDORMAND", "FAY WINSLET", "WILL WILSON"]}'),
('{ "_id" : "26e28d27993d4a47ab6c77868e7f03ea", "title" : "FEATHERS METAL", "description" : "A Thoughtful Yarn of a Monkey And a Teacher who must Find a Dog in Australia", "release_year" : "2006", "language" : "English", "duration" : "104 min", "rating" : "PG-13", "actors" : ["MILLA PECK", "NATALIE HOPKINS", "CHRISTIAN AKROYD", "KENNETH PALTROW", "WOODY JOLIE", "CHARLIZE DENCH", "SCARLETT BENING", "JAYNE NOLTE", "NICK DEGENERES"]}'),
('{ "_id" : "9b85617df7a743a3adff260215666975", "title" : "FELLOWSHIP AUTUMN", "description" : "A Lacklusture Reflection of a Dentist And a Hunter who must Meet a Teacher in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "77 min", "rating" : "NC-17", "actors" : ["MENA TEMPLE", "FAY KILMER", "DAN HARRIS", "CHRISTIAN NEESON", "RAY JOHANSSON", "SALMA NOLTE", "CHRISTOPHER WEST"]}'),
('{ "_id" : "8607ccd8d9db477e843cf9211930a197", "title" : "FERRIS MOTHER", "description" : "A Touching Display of a Frisbee And a Frisbee who must Kill a Girl in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "142 min", "rating" : "PG", "actors" : ["SISSY SOBIESKI"]}'),
('{ "_id" : "0f346449a1fb4d0988fb95760eaaac88", "title" : "FEUD FROGMEN", "description" : "A Brilliant Reflection of a Database Administrator And a Mad Cow who must Chase a Woman in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "98 min", "rating" : "R", "actors" : ["TIM HACKMAN", "TOM MIRANDA", "PENELOPE CRONYN", "MARY KEITEL"]}'),
('{ "_id" : "bdd9ff219dae42148e1f3775c4cd33e2", "title" : "FEVER EMPIRE", "description" : "A Insightful Panorama of a Cat And a Boat who must Defeat a Boat in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "158 min", "rating" : "R", "actors" : ["HELEN VOIGHT", "FAY WINSLET", "AUDREY BAILEY"]}'),
('{ "_id" : "98ba5f9b5e8f4ccc800c21b91b12d4cf", "title" : "FICTION CHRISTMAS", "description" : "A Emotional Yarn of a A Shark And a Student who must Battle a Robot in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "72 min", "rating" : "PG", "actors" : ["KEVIN BLOOM", "ALEC WAYNE", "CUBA ALLEN", "ADAM HOPPER", "LISA MONROE", "MATTHEW CARREY", "ROCK DUKAKIS", "MARY KEITEL"]}'),
('{ "_id" : "acada69a31074d9cba35d08f3a19af17", "title" : "FIDDLER LOST", "description" : "A Boring Tale of a Squirrel And a Dog who must Challenge a Madman in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "75 min", "rating" : "R", "actors" : ["TIM HACKMAN", "FRANCES DAY-LEWIS", "JAMES PITT", "SPENCER PECK", "DARYL WAHLBERG", "MEG HAWKE", "RUSSELL BACALL", "SCARLETT BENING", "CATE MCQUEEN", "ANGELA WITHERSPOON", "IAN TANDY"]}'),
('{ "_id" : "13e0d45687e74aa1bf0538151e339a96", "title" : "FIDELITY DEVIL", "description" : "A Awe-Inspiring Drama of a Technical Writer And a Composer who must Reach a Pastry Chef in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "118 min", "rating" : "G", "actors" : ["HELEN VOIGHT", "PENELOPE CRONYN", "ALAN DREYFUSS", "RUSSELL CLOSE"]}'),
('{ "_id" : "011f4f138856446aa0116ba2e2f766a4", "title" : "FIGHT JAWBREAKER", "description" : "A Intrepid Panorama of a Womanizer And a Girl who must Escape a Girl in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "91 min", "rating" : "R", "actors" : ["NICK WAHLBERG", "ALBERT JOHANSSON", "MERYL GIBSON"]}'),
('{ "_id" : "628e8d9920da415aa0c50a4f1a47450f", "title" : "FINDING ANACONDA", "description" : "A Fateful Tale of a Database Administrator And a Girl who must Battle a Squirrel in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "156 min", "rating" : "R", "actors" : ["FRANCES DAY-LEWIS", "RIP WINSLET", "MATTHEW LEIGH", "SIDNEY CROWE", "CUBA BIRCH"]}'),
('{ "_id" : "e6fcc002f47743afa34401a162ba1e9d", "title" : "FIRE WOLVES", "description" : "A Intrepid Documentary of a Frisbee And a Dog who must Outrace a Lumberjack in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "173 min", "rating" : "R", "actors" : ["JOHNNY LOLLOBRIGIDA", "CHRISTIAN AKROYD", "WOODY JOLIE", "RENEE TRACY", "RIVER DEAN"]}'),
('{ "_id" : "24d135b0d38c42f58782e28d0b5aed07", "title" : "FIREBALL PHILADELPHIA", "description" : "A Amazing Yarn of a Dentist And a A Shark who must Vanquish a Madman in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "148 min", "rating" : "PG", "actors" : ["VAL BOLGER", "JUDE CRUISE", "ADAM GRANT", "JAMES PITT", "FRANCES TOMEI"]}'),
('{ "_id" : "6a812b123c954f16b50bb9e0b544cf6a", "title" : "FIREHOUSE VIETNAM", "description" : "A Awe-Inspiring Character Study of a Boat And a Boy who must Kill a Pastry Chef in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "103 min", "rating" : "G", "actors" : ["SANDRA PECK", "MATTHEW LEIGH", "FAY WINSLET", "BEN HARRIS", "OLYMPIA PFEIFFER"]}'),
('{ "_id" : "5f4b501643984c4898a8fc4af0713f5b", "title" : "FISH OPUS", "description" : "A Touching Display of a Feminist And a Girl who must Confront a Astronaut in Australia", "release_year" : "2006", "language" : "English", "duration" : "125 min", "rating" : "R", "actors" : ["PARKER GOLDBERG", "LAURENCE BULLOCK"]}'),
('{ "_id" : "bc299c9cadbf45ddaa534745452494e3", "title" : "FLAMINGOS CONNECTICUT", "description" : "A Fast-Paced Reflection of a Composer And a Composer who must Meet a Cat in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "80 min", "rating" : "PG-13", "actors" : ["GOLDIE BRODY", "TOM MIRANDA", "FAY KILMER", "KENNETH TORN", "GENE WILLIS", "JANE JACKMAN", "RITA REYNOLDS", "ALBERT JOHANSSON", "JON CHASE"]}'),
('{ "_id" : "a4fad36602ed413e8e052bd47da0f71a", "title" : "FLASH WARS", "description" : "A Astounding Saga of a Moose And a Pastry Chef who must Chase a Student in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "123 min", "rating" : "NC-17", "actors" : ["NICK WAHLBERG", "MATTHEW JOHANSSON", "DAN TORN", "KIRSTEN PALTROW", "SANDRA PECK", "MILLA KEITEL", "GRETA MALDEN"]}'),
('{ "_id" : "9c9040b43a2d4cdfafa0e7c34b3b2836", "title" : "FLATLINERS KILLER", "description" : "A Taut Display of a Secret Agent And a Waitress who must Sink a Robot in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "100 min", "rating" : "G", "actors" : ["NICK STALLONE", "GARY PENN", "KENNETH TORN", "JIM MOSTEL", "RUSSELL BACALL", "MORGAN HOPKINS", "SCARLETT BENING", "MENA HOPPER", "ROCK DUKAKIS"]}'),
('{ "_id" : "117428b046284557b113d6fa7023434d", "title" : "FLIGHT LIES", "description" : "A Stunning Character Study of a Crocodile And a Pioneer who must Pursue a Teacher in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "179 min", "rating" : "R", "actors" : ["ELLEN PRESLEY", "GARY PENN", "KENNETH TORN", "JIM MOSTEL", "RUSSELL BACALL", "MORGAN HOPKINS", "GRETA MALDEN", "JADA RYDER", "CAMERON ZELLWEGER"]}'),
('{ "_id" : "66931abc91a149709c0948948f08ab29", "title" : "FLINTSTONES HAPPINESS", "description" : "A Fateful Story of a Husband And a Moose who must Vanquish a Boy in California", "release_year" : "2006", "language" : "English", "duration" : "148 min", "rating" : "PG-13", "actors" : ["ALBERT NOLTE", "HUMPHREY WILLIS", "DEBBIE AKROYD", "BELA WALKEN"]}'),
('{ "_id" : "7c98519bf1944c81bb0c8fa0bfe4e516", "title" : "FLOATS GARDEN", "description" : "A Action-Packed Epistle of a Robot And a Car who must Chase a Boat in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "145 min", "rating" : "PG-13", "actors" : ["RIP WINSLET", "SEAN WILLIAMS", "ELLEN PRESLEY", "JIM MOSTEL", "CAMERON ZELLWEGER"]}'),
('{ "_id" : "433b341584eb43f4a8abeee4b27df221", "title" : "FLYING HOOK", "description" : "A Thrilling Display of a Mad Cow And a Dog who must Challenge a Frisbee in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "69 min", "rating" : "NC-17", "actors" : ["CUBA OLIVIER", "JOHNNY CAGE", "WALTER TORN", "CATE MCQUEEN", "GRETA KEITEL", "GRETA MALDEN", "NICK DEGENERES", "KENNETH HOFFMAN"]}'),
('{ "_id" : "38489aa77e27419692629c156d012da4", "title" : "FOOL MOCKINGBIRD", "description" : "A Lacklusture Tale of a Crocodile And a Composer who must Defeat a Madman in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "158 min", "rating" : "PG", "actors" : ["RIP CRAWFORD", "NATALIE HOPKINS"]}'),
('{ "_id" : "b6b79b7aaeae437bb178099d1603306b", "title" : "FOREVER CANDIDATE", "description" : "A Unbelieveable Panorama of a Technical Writer And a Man who must Pursue a Frisbee in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "131 min", "rating" : "NC-17", "actors" : ["JADA RYDER"]}'),
('{ "_id" : "d41cd056e5904592b0ff35419f88ad06", "title" : "FORREST SONS", "description" : "A Thrilling Documentary of a Forensic Psychologist And a Butler who must Defeat a Explorer in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "63 min", "rating" : "R", "actors" : ["ED CHASE", "RIP CRAWFORD", "DARYL WAHLBERG", "WALTER TORN", "MARY KEITEL"]}'),
('{ "_id" : "7bab056a7a2f4e8db15d275cf03b8e40", "title" : "FORRESTER COMANCHEROS", "description" : "A Fateful Tale of a Squirrel And a Forensic Psychologist who must Redeem a Man in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "112 min", "rating" : "NC-17", "actors" : ["KIRK JOVOVICH", "REESE KILMER", "SEAN GUINESS"]}'),
('{ "_id" : "9222bafc1b104b3eb144b4f965c2dc26", "title" : "FORWARD TEMPLE", "description" : "A Astounding Display of a Forensic Psychologist And a Mad Scientist who must Challenge a Girl in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "90 min", "rating" : "NC-17", "actors" : ["RIP WINSLET", "SEAN WILLIAMS", "GREG CHAPLIN"]}'),
('{ "_id" : "a66d9a5a133d4d3bb8cac66a446e0e6e", "title" : "FRANKENSTEIN STRANGER", "description" : "A Insightful Character Study of a Feminist And a Pioneer who must Pursue a Pastry Chef in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "159 min", "rating" : "NC-17", "actors" : ["SCARLETT DAMON", "BEN HARRIS"]}'),
('{ "_id" : "ca391d09a98349cfae22c75702be6e0a", "title" : "FREAKY POCUS", "description" : "A Fast-Paced Documentary of a Pastry Chef And a Crocodile who must Chase a Squirrel in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "126 min", "rating" : "R", "actors" : ["TOM MIRANDA", "MATTHEW LEIGH", "SIDNEY CROWE", "KEVIN GARLAND", "FAY WINSLET"]}'),
('{ "_id" : "04eb09a6fe7e4d2b986a07ff33a5ebf9", "title" : "FREDDY STORM", "description" : "A Intrepid Saga of a Man And a Lumberjack who must Vanquish a Husband in The Outback", "release_year" : "2006", "language" : "English", "duration" : "65 min", "rating" : "NC-17", "actors" : ["JULIA MCQUEEN", "HENRY BERRY", "WALTER TORN"]}'),
('{ "_id" : "3c8ffdab087b4fedbd821c9b280656f5", "title" : "FREEDOM CLEOPATRA", "description" : "A Emotional Reflection of a Dentist And a Mad Cow who must Face a Squirrel in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "133 min", "rating" : "PG-13", "actors" : ["CAMERON STREEP", "ALEC WAYNE", "TOM MCKELLEN", "RAY JOHANSSON", "CHRISTOPHER BERRY"]}'),
('{ "_id" : "f2722de12a174dbb8c0fea14c7413e94", "title" : "FRENCH HOLIDAY", "description" : "A Thrilling Epistle of a Dog And a Feminist who must Kill a Madman in Berlin", "release_year" : "2006", "language" : "English", "duration" : "99 min", "rating" : "PG", "actors" : ["ED CHASE", "AUDREY OLIVIER", "JODIE DEGENERES", "DAN STREEP", "CATE MCQUEEN", "WILL WILSON", "HUMPHREY GARLAND"]}'),
('{ "_id" : "e8a35f7f560c4022843bfa7eae94f17e", "title" : "FRIDA SLIPPER", "description" : "A Fateful Story of a Lumberjack And a Car who must Escape a Boat in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "73 min", "rating" : "R", "actors" : ["UMA WOOD", "JAYNE NEESON", "MINNIE ZELLWEGER", "KENNETH TORN", "RENEE TRACY"]}'),
('{ "_id" : "44d3e961710f4c02a9c6e44fe0225b21", "title" : "FRISCO FORREST", "description" : "A Beautiful Documentary of a Woman And a Pioneer who must Pursue a Mad Scientist in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "51 min", "rating" : "PG", "actors" : ["TOM MCKELLEN", "ANGELA HUDSON", "KIRSTEN AKROYD", "GINA DEGENERES", "DAN STREEP", "LIZA BERGMAN", "ALBERT NOLTE", "RICHARD PENN", "ROCK DUKAKIS"]}'),
('{ "_id" : "e4f1075aadbd421e91d7a787d8dca2c6", "title" : "FROGMEN BREAKING", "description" : "A Unbelieveable Yarn of a Mad Scientist And a Cat who must Chase a Lumberjack in Australia", "release_year" : "2006", "language" : "English", "duration" : "111 min", "rating" : "R", "actors" : ["BEN WILLIS", "ELLEN PRESLEY", "MORGAN MCDORMAND", "RIVER DEAN", "RUSSELL TEMPLE", "LAURENCE BULLOCK"]}'),
('{ "_id" : "93b8827d9fba48dcbc3f315e8e88670d", "title" : "FRONTIER CABIN", "description" : "A Emotional Story of a Madman And a Waitress who must Battle a Teacher in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "183 min", "rating" : "PG-13", "actors" : ["JOHNNY LOLLOBRIGIDA", "RIP CRAWFORD", "FAY KILMER", "JUDE CRUISE", "BEN WILLIS", "HARVEY HOPE"]}'),
('{ "_id" : "702ad85b7948435684cd5c6a80a12c84", "title" : "FROST HEAD", "description" : "A Amazing Reflection of a Lumberjack And a Cat who must Discover a Husband in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "82 min", "rating" : "PG", "actors" : ["ED CHASE", "CARMEN HUNT", "RALPH CRUZ", "GENE HOPKINS", "CATE HARRIS", "FAY WINSLET", "LAURENCE BULLOCK"]}'),
('{ "_id" : "668d8b26cc2a4400bf56c873fd0712a5", "title" : "FUGITIVE MAGUIRE", "description" : "A Taut Epistle of a Feminist And a Sumo Wrestler who must Battle a Crocodile in Australia", "release_year" : "2006", "language" : "English", "duration" : "83 min", "rating" : "R", "actors" : ["CUBA OLIVIER", "ALEC WAYNE", "MARY TANDY", "RALPH CRUZ", "CHARLIZE DENCH", "MEG HAWKE", "RICHARD PENN", "EMILY DEE", "GEOFFREY HESTON", "LAURA BRODY", "OLYMPIA PFEIFFER"]}'),
('{ "_id" : "ec8b69c26ef04e0899d41aea04780950", "title" : "FULL FLATLINERS", "description" : "A Beautiful Documentary of a Astronaut And a Moose who must Pursue a Monkey in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "94 min", "rating" : "PG", "actors" : ["MICHELLE MCCONAUGHEY", "CARY MCCONAUGHEY", "RALPH CRUZ", "SUSAN DAVIS", "SCARLETT BENING", "LAURA BRODY"]}'),
('{ "_id" : "bbd965fdb96348648aaa29e959334fd4", "title" : "FURY MURDER", "description" : "A Lacklusture Reflection of a Boat And a Forensic Psychologist who must Fight a Waitress in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "178 min", "rating" : "PG-13", "actors" : ["KARL BERRY", "KIRK JOVOVICH", "WOODY JOLIE", "LAURA BRODY"]}'),
('{ "_id" : "1953251740794209b6dcc9cd569e7a9c", "title" : "GABLES METROPOLIS", "description" : "A Fateful Display of a Cat And a Pioneer who must Challenge a Pastry Chef in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "161 min", "rating" : "PG", "actors" : ["FRED COSTNER", "RIP CRAWFORD", "FRANCES DAY-LEWIS", "RAY JOHANSSON", "GROUCHO DUNST", "CATE MCQUEEN", "ADAM HOPPER", "GROUCHO WILLIAMS"]}'),
('{ "_id" : "17b7061bb6474187923729e4a64c1cd1", "title" : "GALAXY SWEETHEARTS", "description" : "A Emotional Reflection of a Womanizer And a Pioneer who must Face a Squirrel in Berlin", "release_year" : "2006", "language" : "English", "duration" : "128 min", "rating" : "R", "actors" : ["UMA WOOD", "DEBBIE AKROYD", "THORA TEMPLE"]}'),
('{ "_id" : "af1ded746d894b8a8919fc1b35860fb8", "title" : "GAMES BOWFINGER", "description" : "A Astounding Documentary of a Butler And a Explorer who must Challenge a Butler in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "119 min", "rating" : "PG-13", "actors" : ["JULIA MCQUEEN", "ANGELA HUDSON", "RIP WINSLET", "BURT POSEY", "MATTHEW LEIGH", "FRANCES TOMEI", "HUMPHREY WILLIS", "MARY KEITEL"]}'),
('{ "_id" : "6c8adde21e9f47149adfb2dd2979f88a", "title" : "GANDHI KWAI", "description" : "A Thoughtful Display of a Mad Scientist And a Secret Agent who must Chase a Boat in Berlin", "release_year" : "2006", "language" : "English", "duration" : "86 min", "rating" : "PG-13", "actors" : ["ZERO CAGE", "LUCILLE TRACY", "ANNE CRONYN", "PENELOPE PINKETT", "ANGELINA ASTAIRE", "MEG HAWKE", "GINA DEGENERES", "DARYL CRAWFORD"]}'),
('{ "_id" : "70ae4450587a4c71a21ae7897d49d8b2", "title" : "GANGS PRIDE", "description" : "A Taut Character Study of a Woman And a A Shark who must Confront a Frisbee in Berlin", "release_year" : "2006", "language" : "English", "duration" : "185 min", "rating" : "PG-13", "actors" : ["ELVIS MARX", "FRANCES DAY-LEWIS", "FAY WOOD", "KENNETH HOFFMAN"]}'),
('{ "_id" : "077b96d57f55441289adcc4114347c25", "title" : "GARDEN ISLAND", "description" : "A Unbelieveable Character Study of a Womanizer And a Madman who must Reach a Man in The Outback", "release_year" : "2006", "language" : "English", "duration" : "80 min", "rating" : "G", "actors" : ["MARY TANDY", "WARREN NOLTE", "JADA RYDER"]}'),
('{ "_id" : "0631a8bf8ef54c27b6677b41aef7ee07", "title" : "GASLIGHT CRUSADE", "description" : "A Amazing Epistle of a Boy And a Astronaut who must Redeem a Man in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "106 min", "rating" : "PG", "actors" : ["GRACE MOSTEL", "JULIA BARRYMORE", "WALTER TORN", "RICHARD PENN", "FAY WINSLET"]}'),
('{ "_id" : "f7f0c93465404b229570e5d2ade237e9", "title" : "GATHERING CALENDAR", "description" : "A Intrepid Tale of a Pioneer And a Moose who must Conquer a Frisbee in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "176 min", "rating" : "PG-13", "actors" : ["MICHAEL BENING", "BURT TEMPLE", "MERYL ALLEN"]}'),
('{ "_id" : "3406785fb1124173a55ec70e2641fd1d", "title" : "GENTLEMEN STAGE", "description" : "A Awe-Inspiring Reflection of a Monkey And a Student who must Overcome a Dentist in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "125 min", "rating" : "NC-17", "actors" : ["TOM MCKELLEN", "DARYL WAHLBERG", "MORGAN HOPKINS", "LIZA BERGMAN", "RITA REYNOLDS", "GRETA MALDEN", "HARVEY HOPE", "ED GUINESS"]}'),
('{ "_id" : "027578d9b2c04dd8a230b42ff623b440", "title" : "GHOST GROUNDHOG", "description" : "A Brilliant Panorama of a Madman And a Composer who must Succumb a Car in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "G", "actors" : ["DAN HARRIS", "KENNETH TORN", "KEVIN GARLAND", "RUSSELL TEMPLE", "RENEE BALL"]}'),
('{ "_id" : "966e776e7da842a18f9faf1430f0b0b3", "title" : "GHOSTBUSTERS ELF", "description" : "A Thoughtful Epistle of a Dog And a Feminist who must Chase a Composer in Berlin", "release_year" : "2006", "language" : "English", "duration" : "101 min", "rating" : "R", "actors" : ["JENNIFER DAVIS"]}'),
('{ "_id" : "9eb5ab23f0274f23a4c5ffc234548176", "title" : "GIANT TROOPERS", "description" : "A Fateful Display of a Feminist And a Monkey who must Vanquish a Monkey in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "102 min", "rating" : "R", "actors" : ["MATTHEW LEIGH"]}'),
('{ "_id" : "7dc83cd0dece49b0bd2657da6e390179", "title" : "GILBERT PELICAN", "description" : "A Fateful Tale of a Man And a Feminist who must Conquer a Crocodile in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "114 min", "rating" : "G", "actors" : ["NICK WAHLBERG", "SANDRA PECK", "RIP WINSLET", "RITA REYNOLDS"]}'),
('{ "_id" : "72c717564f164c8eacbec6d27ec56194", "title" : "GILMORE BOILED", "description" : "A Unbelieveable Documentary of a Boat And a Husband who must Succumb a Student in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "163 min", "rating" : "R", "actors" : ["WOODY HOFFMAN", "MENA TEMPLE", "MEG HAWKE", "CATE HARRIS", "MENA HOPPER", "BURT TEMPLE"]}'),
('{ "_id" : "97e1ee82475f49d5aa5c2243b9a49da6", "title" : "GLADIATOR WESTWARD", "description" : "A Astounding Reflection of a Squirrel And a Sumo Wrestler who must Sink a Dentist in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "173 min", "rating" : "PG", "actors" : ["JULIA MCQUEEN", "KIRK JOVOVICH", "ADAM GRANT", "CAMERON ZELLWEGER", "IAN TANDY", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "1b4a1aad7290498a91a276ccdef7c744", "title" : "GLASS DYING", "description" : "A Astounding Drama of a Frisbee And a Astronaut who must Fight a Dog in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "103 min", "rating" : "G", "actors" : ["MATTHEW LEIGH", "SUSAN DAVIS", "AL GARLAND", "MICHAEL BOLGER"]}'),
('{ "_id" : "5bc716166bc94fbbbf08fc3ddd35b861", "title" : "GLEAMING JAWBREAKER", "description" : "A Amazing Display of a Composer And a Forensic Psychologist who must Discover a Car in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "89 min", "rating" : "NC-17", "actors" : ["PENELOPE GUINESS", "MARY TANDY", "ALBERT NOLTE", "RIVER DEAN", "IAN TANDY", "NICK DEGENERES", "JOHN SUVARI", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "4e99adbf5edd4dda9952d3f5579e8e0a", "title" : "GLORY TRACY", "description" : "A Amazing Saga of a Woman And a Womanizer who must Discover a Cat in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "115 min", "rating" : "PG-13", "actors" : ["CHRISTIAN NEESON", "ADAM GRANT", "RALPH CRUZ", "RUSSELL TEMPLE", "WILLIAM HACKMAN", "DEBBIE AKROYD"]}'),
('{ "_id" : "4676e16a0a3d4092bfcf32cbb6ed24bc", "title" : "GO PURPLE", "description" : "A Fast-Paced Display of a Car And a Database Administrator who must Battle a Woman in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "54 min", "rating" : "R", "actors" : ["SEAN GUINESS", "SALMA NOLTE", "GENE MCKELLEN"]}'),
('{ "_id" : "7f8d854e6b10426694b4fdaf4b8753ea", "title" : "GODFATHER DIARY", "description" : "A Stunning Saga of a Lumberjack And a Squirrel who must Chase a Car in The Outback", "release_year" : "2006", "language" : "English", "duration" : "73 min", "rating" : "NC-17", "actors" : ["ZERO CAGE", "GREG CHAPLIN", "RITA REYNOLDS", "ED MANSFIELD", "LAURA BRODY", "REESE WEST"]}'),
('{ "_id" : "5b036f2111004a78ab7c23714b3996d1", "title" : "GOLD RIVER", "description" : "A Taut Documentary of a Database Administrator And a Waitress who must Reach a Mad Scientist in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "154 min", "rating" : "R", "actors" : ["GROUCHO DUNST", "RUSSELL TEMPLE"]}'),
('{ "_id" : "e45090f27a8047c8bce16582eee4166a", "title" : "GOLDFINGER SENSIBILITY", "description" : "A Insightful Drama of a Mad Scientist And a Hunter who must Defeat a Pastry Chef in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "93 min", "rating" : "G", "actors" : ["CHRISTIAN GABLE", "LUCILLE TRACY", "KEVIN GARLAND", "NICK DEGENERES"]}'),
('{ "_id" : "ad6ff05513d747c7a08b5e03b8f5579f", "title" : "GOLDMINE TYCOON", "description" : "A Brilliant Epistle of a Composer And a Frisbee who must Conquer a Husband in The Outback", "release_year" : "2006", "language" : "English", "duration" : "153 min", "rating" : "R", "actors" : ["SANDRA KILMER", "MAE HOFFMAN", "ALBERT NOLTE", "DARYL CRAWFORD", "GEOFFREY HESTON", "HUMPHREY WILLIS", "JOHN SUVARI"]}'),
('{ "_id" : "4cf5957f482e4a3785e900648cc01310", "title" : "GONE TROUBLE", "description" : "A Insightful Character Study of a Mad Cow And a Forensic Psychologist who must Conquer a A Shark in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "84 min", "rating" : "R", "actors" : ["SISSY SOBIESKI", "RICHARD PENN", "EMILY DEE", "CHRIS DEPP", "GROUCHO WILLIAMS"]}'),
('{ "_id" : "9da1d1cfb2684b78b2ed7d82dc16ec4d", "title" : "GOODFELLAS SALUTE", "description" : "A Unbelieveable Tale of a Dog And a Explorer who must Sink a Mad Cow in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "56 min", "rating" : "PG", "actors" : ["NICK WAHLBERG", "JOHNNY LOLLOBRIGIDA", "ELVIS MARX", "BEN WILLIS", "GINA DEGENERES", "SUSAN DAVIS", "FRANCES TOMEI", "REESE WEST"]}'),
('{ "_id" : "296faff3192d43468c77ba7756bd3644", "title" : "GORGEOUS BINGO", "description" : "A Action-Packed Display of a Sumo Wrestler And a Car who must Overcome a Waitress in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "108 min", "rating" : "R", "actors" : ["VIVIEN BERGEN", "SANDRA KILMER", "MEG HAWKE", "FRANCES TOMEI", "WHOOPI HURT", "GEOFFREY HESTON", "REESE WEST"]}'),
('{ "_id" : "e7eb9b6bd84c46a1af9d34fdfe66d828", "title" : "GOSFORD DONNIE", "description" : "A Epic Panorama of a Mad Scientist And a Monkey who must Redeem a Secret Agent in Berlin", "release_year" : "2006", "language" : "English", "duration" : "129 min", "rating" : "G", "actors" : ["ANGELA HUDSON", "JADA RYDER", "HUMPHREY GARLAND"]}'),
('{ "_id" : "61454509e2504614bda0da1b550147ee", "title" : "GRACELAND DYNAMITE", "description" : "A Taut Display of a Cat And a Girl who must Overcome a Database Administrator in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "140 min", "rating" : "R", "actors" : ["NATALIE HOPKINS", "CHRISTIAN NEESON", "BURT POSEY", "SIDNEY CROWE", "ALBERT JOHANSSON", "KENNETH HOFFMAN"]}'),
('{ "_id" : "0f2564eb59564a25add7a9f60fc3a1e3", "title" : "GRADUATE LORD", "description" : "A Lacklusture Epistle of a Girl And a A Shark who must Meet a Mad Scientist in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "156 min", "rating" : "G", "actors" : ["EWAN GOODING", "WHOOPI HURT"]}'),
('{ "_id" : "059997bd65b148679be6a6dc46612384", "title" : "GRAFFITI LOVE", "description" : "A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Build a Composer in Berlin", "release_year" : "2006", "language" : "English", "duration" : "117 min", "rating" : "PG", "actors" : ["JOHNNY CAGE", "CHRISTIAN NEESON", "KENNETH PALTROW", "GARY PENN", "SEAN GUINESS", "AUDREY BAILEY"]}'),
('{ "_id" : "988cc30b33874de3a89eea1366d3a969", "title" : "GRAIL FRANKENSTEIN", "description" : "A Unbelieveable Saga of a Teacher And a Monkey who must Fight a Girl in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "NC-17", "actors" : ["JOHNNY LOLLOBRIGIDA", "JAYNE NEESON", "DARYL WAHLBERG", "GRETA KEITEL", "AL GARLAND"]}'),
('{ "_id" : "17becb81920b4df982b8c957e602b437", "title" : "GRAPES FURY", "description" : "A Boring Yarn of a Mad Cow And a Sumo Wrestler who must Meet a Robot in Australia", "release_year" : "2006", "language" : "English", "duration" : "155 min", "rating" : "G", "actors" : ["CARMEN HUNT", "HENRY BERRY", "MARY TANDY", "LUCILLE DEE", "BURT TEMPLE"]}'),
('{ "_id" : "5ad1d56861814dabaef20948246c9519", "title" : "GREASE YOUTH", "description" : "A Emotional Panorama of a Secret Agent And a Waitress who must Escape a Composer in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "135 min", "rating" : "G", "actors" : ["KIRK JOVOVICH", "SIDNEY CROWE", "ADAM HOPPER"]}'),
('{ "_id" : "c828cbfaa3ba4f90b6231f5b5bf25830", "title" : "GREATEST NORTH", "description" : "A Astounding Character Study of a Secret Agent And a Robot who must Build a A Shark in Berlin", "release_year" : "2006", "language" : "English", "duration" : "93 min", "rating" : "NC-17", "actors" : ["HELEN VOIGHT", "RIP WINSLET", "MATTHEW LEIGH", "WARREN NOLTE", "CUBA BIRCH", "GREGORY GOODING"]}'),
('{ "_id" : "32f2b47a443849c69def02155635b9eb", "title" : "GREEDY ROOTS", "description" : "A Amazing Reflection of a A Shark And a Butler who must Chase a Hunter in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "166 min", "rating" : "R", "actors" : ["JENNIFER DAVIS", "GARY PENN", "WARREN NOLTE", "HARRISON BALE", "FAY WOOD", "ALAN DREYFUSS", "RENEE BALL", "MARY KEITEL"]}'),
('{ "_id" : "cf15c6dc4c6f4ae892cd986d678d2141", "title" : "GREEK EVERYONE", "description" : "A Stunning Display of a Butler And a Teacher who must Confront a A Shark in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "176 min", "rating" : "PG", "actors" : ["SISSY SOBIESKI", "BURT DUKAKIS", "RIP WINSLET", "CATE HARRIS"]}'),
('{ "_id" : "4ac1882a2da349649379e5f237982701", "title" : "GRINCH MASSAGE", "description" : "A Intrepid Display of a Madman And a Feminist who must Pursue a Pioneer in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "150 min", "rating" : "R", "actors" : ["UMA WOOD", "BURT DUKAKIS", "KIRSTEN AKROYD", "JIM MOSTEL", "WARREN JACKMAN", "MATTHEW CARREY"]}'),
('{ "_id" : "f8ab1c43bbd145e293079ce8b82da6a9", "title" : "GRIT CLOCKWORK", "description" : "A Thoughtful Display of a Dentist And a Squirrel who must Confront a Lumberjack in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "137 min", "rating" : "PG", "actors" : ["CAMERON ZELLWEGER", "KEVIN GARLAND", "GEOFFREY HESTON"]}'),
('{ "_id" : "aa5dde6afcfa435b993364e1374bd32e", "title" : "GROOVE FICTION", "description" : "A Unbelieveable Reflection of a Moose And a A Shark who must Defeat a Lumberjack in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "111 min", "rating" : "NC-17", "actors" : ["JOHNNY LOLLOBRIGIDA", "JODIE DEGENERES", "DAN HARRIS", "MINNIE ZELLWEGER", "HARRISON BALE", "JANE JACKMAN", "IAN TANDY"]}'),
('{ "_id" : "2434d92fe4fd4ff4ba71280143375722", "title" : "GROSSE WONDERFUL", "description" : "A Epic Drama of a Cat And a Explorer who must Redeem a Moose in Australia", "release_year" : "2006", "language" : "English", "duration" : "49 min", "rating" : "R", "actors" : ["SEAN GUINESS", "DAN STREEP", "CUBA ALLEN", "ALBERT JOHANSSON"]}'),
('{ "_id" : "93a1b40d4828408d9c7f9af2050c4f36", "title" : "GROUNDHOG UNCUT", "description" : "A Brilliant Panorama of a Astronaut And a Technical Writer who must Discover a Butler in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "139 min", "rating" : "PG-13", "actors" : ["UMA WOOD", "JULIA BARRYMORE", "JAYNE NEESON", "ADAM GRANT", "SEAN GUINESS", "RICHARD PENN", "GROUCHO WILLIAMS"]}'),
('{ "_id" : "ff14b5388df1468cbf3bfe3942b37fd0", "title" : "GUMP DATE", "description" : "A Intrepid Yarn of a Explorer And a Student who must Kill a Husband in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "53 min", "rating" : "NC-17", "actors" : ["DAN TORN", "MENA TEMPLE", "RIP WINSLET", "GENE HOPKINS", "RIVER DEAN", "JAYNE NOLTE"]}'),
('{ "_id" : "13c60d8c61cd42458913aeba3a7ae1a4", "title" : "GUN BONNIE", "description" : "A Boring Display of a Sumo Wrestler And a Husband who must Build a Waitress in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "100 min", "rating" : "G", "actors" : ["BURT DUKAKIS", "GROUCHO SINATRA", "IAN TANDY", "WILL WILSON", "MATTHEW CARREY"]}'),
('{ "_id" : "d8e8efc5c8ae43ea86caf2926c026130", "title" : "GUNFIGHT MOON", "description" : "A Epic Reflection of a Pastry Chef And a Explorer who must Reach a Dentist in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "70 min", "rating" : "NC-17", "actors" : ["CARMEN HUNT", "GINA DEGENERES", "KEVIN GARLAND", "RUSSELL CLOSE"]}'),
('{ "_id" : "51aad85a3f6b4bc0ab2264209a89c7f1", "title" : "GUNFIGHTER MUSSOLINI", "description" : "A Touching Saga of a Robot And a Boy who must Kill a Man in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "127 min", "rating" : "PG-13", "actors" : ["AUDREY OLIVIER", "JUDY DEAN", "SCARLETT DAMON", "RUSSELL CLOSE"]}'),
('{ "_id" : "4b5dfdbf7fd24e0caf2ada9fe40dcfca", "title" : "GUYS FALCON", "description" : "A Boring Story of a Woman And a Feminist who must Redeem a Squirrel in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "84 min", "rating" : "R", "actors" : ["RIP CRAWFORD", "BURT DUKAKIS", "RICHARD PENN", "MORGAN WILLIAMS", "RUSSELL CLOSE"]}'),
('{ "_id" : "2edd9f87308f4674b65c3007428056e9", "title" : "HALF OUTFIELD", "description" : "A Epic Epistle of a Database Administrator And a Crocodile who must Face a Madman in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "146 min", "rating" : "PG-13", "actors" : ["ANNE CRONYN", "GREG CHAPLIN", "SEAN GUINESS", "HARRISON BALE", "DARYL CRAWFORD", "DEBBIE AKROYD"]}'),
('{ "_id" : "e9fdd503bbd14071b42cbb8833261dae", "title" : "HALL CASSIDY", "description" : "A Beautiful Panorama of a Pastry Chef And a A Shark who must Battle a Pioneer in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "51 min", "rating" : "NC-17", "actors" : ["JOHNNY LOLLOBRIGIDA", "RIP CRAWFORD", "CAMERON WRAY", "GINA DEGENERES", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "ac03ad736e774d23aded6fa66ed2d3b3", "title" : "HALLOWEEN NUTS", "description" : "A Amazing Panorama of a Forensic Psychologist And a Technical Writer who must Fight a Dentist in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "47 min", "rating" : "PG-13", "actors" : ["ED CHASE", "AUDREY OLIVIER", "JUDE CRUISE", "JAYNE NEESON", "GROUCHO SINATRA", "SYLVESTER DERN", "ANGELA WITHERSPOON"]}'),
('{ "_id" : "d9cd8bdee4e04308857eef2003ae50c7", "title" : "HAMLET WISDOM", "description" : "A Touching Reflection of a Man And a Man who must Sink a Robot in The Outback", "release_year" : "2006", "language" : "English", "duration" : "146 min", "rating" : "R", "actors" : ["JOHNNY CAGE", "PENELOPE CRONYN", "WARREN JACKMAN", "FAY WINSLET", "CHRISTOPHER WEST"]}'),
('{ "_id" : "baad8722d606412ba905d5119521ae60", "title" : "HANDICAP BOONDOCK", "description" : "A Beautiful Display of a Pioneer And a Squirrel who must Vanquish a Sumo Wrestler in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "108 min", "rating" : "R", "actors" : ["ZERO CAGE", "GARY PHOENIX", "RENEE TRACY", "ALBERT NOLTE", "CATE HARRIS", "AL GARLAND", "MARY KEITEL"]}'),
('{ "_id" : "32ef6c279bc0405aba9acc5157c967b2", "title" : "HANGING DEEP", "description" : "A Action-Packed Yarn of a Boat And a Crocodile who must Build a Monkey in Berlin", "release_year" : "2006", "language" : "English", "duration" : "62 min", "rating" : "G", "actors" : ["MATTHEW JOHANSSON", "JOHNNY CAGE", "RIP WINSLET", "KENNETH PALTROW", "ANGELA WITHERSPOON", "MERYL GIBSON", "ROCK DUKAKIS"]}'),
('{ "_id" : "36e1850953c8408f9f1a8b9010a4574a", "title" : "HANKY OCTOBER", "description" : "A Boring Epistle of a Database Administrator And a Explorer who must Pursue a Madman in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "107 min", "rating" : "NC-17", "actors" : ["RICHARD PENN", "OLYMPIA PFEIFFER", "LISA MONROE"]}'),
('{ "_id" : "2462335322654f85a72ab854d20b945d", "title" : "HANOVER GALAXY", "description" : "A Stunning Reflection of a Girl And a Secret Agent who must Succumb a Boy in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "47 min", "rating" : "NC-17", "actors" : ["JENNIFER DAVIS", "KIRSTEN PALTROW", "JULIA MCQUEEN", "JAYNE NEESON", "ANGELA HUDSON", "SCARLETT DAMON", "KENNETH HOFFMAN"]}'),
('{ "_id" : "579e9f0b11f3413a9f97f0163caa3a22", "title" : "HAPPINESS UNITED", "description" : "A Action-Packed Panorama of a Husband And a Feminist who must Meet a Forensic Psychologist in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "100 min", "rating" : "G", "actors" : ["NICK WAHLBERG", "ADAM GRANT", "GROUCHO DUNST", "CUBA ALLEN", "MERYL GIBSON"]}'),
('{ "_id" : "bfc8748e6ea5419989e55d7c34eb75f4", "title" : "HARDLY ROBBERS", "description" : "A Emotional Character Study of a Hunter And a Car who must Kill a Woman in Berlin", "release_year" : "2006", "language" : "English", "duration" : "72 min", "rating" : "R", "actors" : ["KARL BERRY", "ANNE CRONYN", "GRETA MALDEN"]}'),
('{ "_id" : "63545223c70543c697189f2bc11df8d0", "title" : "HAROLD FRENCH", "description" : "A Stunning Saga of a Sumo Wrestler And a Student who must Outrace a Moose in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "168 min", "rating" : "NC-17", "actors" : ["TIM HACKMAN", "NATALIE HOPKINS", "PENELOPE CRONYN", "ED MANSFIELD", "HARVEY HOPE", "JON CHASE", "GENE MCKELLEN"]}'),
('{ "_id" : "95ad069e369e40da903a06656fdd82a1", "title" : "HARPER DYING", "description" : "A Awe-Inspiring Reflection of a Woman And a Cat who must Confront a Feminist in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "52 min", "rating" : "G", "actors" : ["KENNETH TORN", "KIM ALLEN", "ALBERT JOHANSSON", "FAY WINSLET"]}'),
('{ "_id" : "a0c6ffcafd9a48098f6f7008e2132d9c", "title" : "HARRY IDAHO", "description" : "A Taut Yarn of a Technical Writer And a Feminist who must Outrace a Dog in California", "release_year" : "2006", "language" : "English", "duration" : "121 min", "rating" : "PG-13", "actors" : ["FAY KILMER", "CAMERON ZELLWEGER", "MORGAN HOPKINS", "LUCILLE DEE", "MATTHEW CARREY", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "aba59ee796224a2d82292be66f363d0a", "title" : "HATE HANDICAP", "description" : "A Intrepid Reflection of a Mad Scientist And a Pioneer who must Overcome a Hunter in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "107 min", "rating" : "PG", "actors" : ["BOB FAWCETT", "KEVIN BLOOM", "RIVER DEAN"]}'),
('{ "_id" : "9ffa8fcf904c42c7b1825118fef97410", "title" : "HAUNTED ANTITRUST", "description" : "A Amazing Saga of a Man And a Dentist who must Reach a Technical Writer in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "76 min", "rating" : "NC-17", "actors" : ["CAMERON STREEP", "SEAN WILLIAMS", "FAY WINSLET", "ALAN DREYFUSS", "WILLIAM HACKMAN"]}'),
('{ "_id" : "6b329f86ebf3492890af6b048767b25a", "title" : "HAUNTING PIANIST", "description" : "A Fast-Paced Story of a Database Administrator And a Composer who must Defeat a Squirrel in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "181 min", "rating" : "R", "actors" : ["JAYNE NEESON", "CHARLIZE DENCH", "SEAN GUINESS", "GRETA MALDEN", "MARY KEITEL"]}'),
('{ "_id" : "e42056cfa91c4d149f99c72a274cc72e", "title" : "HAWK CHILL", "description" : "A Action-Packed Drama of a Mad Scientist And a Composer who must Outgun a Car in Australia", "release_year" : "2006", "language" : "English", "duration" : "47 min", "rating" : "PG-13", "actors" : ["REESE KILMER", "PARKER GOLDBERG", "ANNE CRONYN", "CARMEN HUNT", "CAMERON ZELLWEGER", "CATE MCQUEEN", "IAN TANDY"]}'),
('{ "_id" : "9ad8f78f57cc4ea384d14333a6be8418", "title" : "HEAD STRANGER", "description" : "A Thoughtful Saga of a Hunter And a Crocodile who must Confront a Dog in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "69 min", "rating" : "R", "actors" : ["GARY PHOENIX", "JESSICA BAILEY"]}'),
('{ "_id" : "6af5aafaea154bc6af3963caa1d96c34", "title" : "HEARTBREAKERS BRIGHT", "description" : "A Awe-Inspiring Documentary of a A Shark And a Dentist who must Outrace a Pastry Chef in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "59 min", "rating" : "G", "actors" : ["GINA DEGENERES", "KIM ALLEN", "OPRAH KILMER", "CHRISTOPHER WEST", "MATTHEW CARREY"]}'),
('{ "_id" : "b7d584eb7ee647638179ec175c24f4ad", "title" : "HEAVEN FREEDOM", "description" : "A Intrepid Story of a Butler And a Car who must Vanquish a Man in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "48 min", "rating" : "PG", "actors" : ["BURT DUKAKIS", "KIRK JOVOVICH", "CHARLIZE DENCH", "ADAM HOPPER", "RICHARD PENN", "MORGAN WILLIAMS", "ALBERT JOHANSSON", "FAY WINSLET", "OPRAH KILMER", "GREGORY GOODING"]}'),
('{ "_id" : "239fc5456e0641e59ce883b41442e1bd", "title" : "HEAVENLY GUN", "description" : "A Beautiful Yarn of a Forensic Psychologist And a Frisbee who must Battle a Moose in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "49 min", "rating" : "NC-17", "actors" : ["JOHNNY LOLLOBRIGIDA", "KEVIN BLOOM", "SPENCER DEPP", "KEVIN GARLAND", "MICHAEL BOLGER", "AUDREY BAILEY"]}'),
('{ "_id" : "318f11e7a0c64c8c9ca395a67f93c924", "title" : "HEAVYWEIGHTS BEAST", "description" : "A Unbelieveable Story of a Composer And a Dog who must Overcome a Womanizer in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "102 min", "rating" : "G", "actors" : ["BEN WILLIS", "DAN STREEP", "WARREN JACKMAN", "ROCK DUKAKIS", "BURT TEMPLE"]}'),
('{ "_id" : "c2ee7ff9822a4ea5b84d77e60f5656ec", "title" : "HEDWIG ALTER", "description" : "A Action-Packed Yarn of a Womanizer And a Lumberjack who must Chase a Sumo Wrestler in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "169 min", "rating" : "NC-17", "actors" : ["JAYNE NEESON", "JAMES PITT", "GENE HOPKINS", "DEBBIE AKROYD"]}'),
('{ "_id" : "c9def933d39041f9972b3caa0690859c", "title" : "HELLFIGHTERS SIERRA", "description" : "A Taut Reflection of a A Shark And a Dentist who must Battle a Boat in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "75 min", "rating" : "PG", "actors" : ["GRACE MOSTEL", "CUBA OLIVIER", "SANDRA KILMER", "MICHELLE MCCONAUGHEY", "JAMES PITT", "JIM MOSTEL", "SPENCER DEPP", "CAMERON ZELLWEGER", "PENELOPE MONROE", "ALBERT NOLTE", "ED MANSFIELD", "HARVEY HOPE"]}'),
('{ "_id" : "237e39ff65ad425687bd17ee1183b349", "title" : "HIGH ENCINO", "description" : "A Fateful Saga of a Waitress And a Hunter who must Outrace a Sumo Wrestler in Australia", "release_year" : "2006", "language" : "English", "duration" : "84 min", "rating" : "R", "actors" : ["VIVIEN BERGEN", "JULIA MCQUEEN", "GOLDIE BRODY", "MILLA KEITEL", "OPRAH KILMER", "ED GUINESS", "MERYL ALLEN"]}'),
('{ "_id" : "5a9456a31a564c1a878868cc2926126c", "title" : "HIGHBALL POTTER", "description" : "A Action-Packed Saga of a Husband And a Dog who must Redeem a Database Administrator in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "110 min", "rating" : "R", "actors" : ["KARL BERRY", "REESE KILMER", "CHRISTOPHER BERRY", "GRETA KEITEL", "MENA HOPPER"]}'),
('{ "_id" : "dc80f244125b4149ada79a889480af98", "title" : "HILLS NEIGHBORS", "description" : "A Epic Display of a Hunter And a Feminist who must Sink a Car in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "93 min", "rating" : "G", "actors" : ["VIVIEN BERGEN", "NATALIE HOPKINS", "DAN HARRIS", "CHRISTIAN AKROYD", "JON CHASE", "RENEE BALL"]}'),
('{ "_id" : "a66046f3c54f45f8981dd78bf27ef12f", "title" : "HOBBIT ALIEN", "description" : "A Emotional Drama of a Husband And a Girl who must Outgun a Composer in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "157 min", "rating" : "PG-13", "actors" : ["VIVIEN BERGEN", "ELVIS MARX", "DUSTIN TAUTOU", "WALTER TORN", "WARREN JACKMAN", "DARYL CRAWFORD", "LAURA BRODY", "REESE WEST"]}'),
('{ "_id" : "6befc26bb4ce438e99c11ee6dcc9973e", "title" : "HOCUS FRIDA", "description" : "A Awe-Inspiring Tale of a Girl And a Madman who must Outgun a Student in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "141 min", "rating" : "G", "actors" : ["SANDRA KILMER", "FRANCES TOMEI", "THORA TEMPLE"]}'),
('{ "_id" : "206f92ff53174e5f9d6d212c0e12fcde", "title" : "HOLES BRANNIGAN", "description" : "A Fast-Paced Reflection of a Technical Writer And a Student who must Fight a Boy in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "128 min", "rating" : "PG", "actors" : ["KARL BERRY", "KEVIN BLOOM", "NICK STALLONE", "NATALIE HOPKINS", "GARY PHOENIX", "DARYL WAHLBERG", "MORGAN MCDORMAND", "DAN STREEP", "ED MANSFIELD", "MATTHEW CARREY", "GREGORY GOODING"]}'),
('{ "_id" : "2e39b17146ea451686b6f3048dd833c8", "title" : "HOLIDAY GAMES", "description" : "A Insightful Reflection of a Waitress And a Madman who must Pursue a Boy in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "78 min", "rating" : "PG-13", "actors" : ["DAN HARRIS", "MINNIE ZELLWEGER", "SPENCER PECK", "MERYL GIBSON", "AL GARLAND", "DEBBIE AKROYD"]}'),
('{ "_id" : "e31e70d38416452b9db50cab4bf8fff8", "title" : "HOLLOW JEOPARDY", "description" : "A Beautiful Character Study of a Robot And a Astronaut who must Overcome a Boat in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "136 min", "rating" : "NC-17", "actors" : ["EMILY DEE", "JULIA ZELLWEGER"]}'),
('{ "_id" : "c0bf4928278548aa81a8d4b1322da013", "title" : "HOLLYWOOD ANONYMOUS", "description" : "A Fast-Paced Epistle of a Boy And a Explorer who must Escape a Dog in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "69 min", "rating" : "PG", "actors" : ["ANNE CRONYN", "HENRY BERRY", "CHRISTIAN NEESON", "RENEE TRACY", "GROUCHO WILLIAMS", "BELA WALKEN"]}'),
('{ "_id" : "21e58159df844054b8060ff5521e6af3", "title" : "HOLOCAUST HIGHBALL", "description" : "A Awe-Inspiring Yarn of a Composer And a Man who must Find a Robot in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "149 min", "rating" : "R", "actors" : ["CARMEN HUNT", "MARY TANDY", "DARYL WAHLBERG", "PENELOPE MONROE", "WILLIAM HACKMAN"]}'),
('{ "_id" : "6e754fca3ed24cdd83babe86fe38e4b2", "title" : "HOLY TADPOLE", "description" : "A Action-Packed Display of a Feminist And a Pioneer who must Pursue a Dog in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "88 min", "rating" : "R", "actors" : ["GOLDIE BRODY", "MORGAN MCDORMAND", "HARVEY HOPE"]}'),
('{ "_id" : "175335f6fa284eb5a1b0a01123ba31b4", "title" : "HOME PITY", "description" : "A Touching Panorama of a Man And a Secret Agent who must Challenge a Teacher in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "185 min", "rating" : "R", "actors" : ["KIRSTEN PALTROW", "BURT DUKAKIS", "CHRISTIAN AKROYD", "NICK DEGENERES", "AUDREY BAILEY", "JOHN SUVARI"]}'),
('{ "_id" : "b226f02c627347f4a7ca856104ab42d3", "title" : "HOMEWARD CIDER", "description" : "A Taut Reflection of a Astronaut And a Squirrel who must Fight a Squirrel in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "103 min", "rating" : "R", "actors" : ["UMA WOOD", "TIM HACKMAN", "BURT DUKAKIS", "ELLEN PRESLEY", "ALBERT JOHANSSON", "IAN TANDY", "MICHAEL BOLGER"]}'),
('{ "_id" : "71a8fdd0ad7540ea8acb6a8b5d4485c9", "title" : "HOMICIDE PEACH", "description" : "A Astounding Documentary of a Hunter And a Boy who must Confront a Boy in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "141 min", "rating" : "PG-13", "actors" : ["BOB FAWCETT", "FRANCES DAY-LEWIS", "JAYNE NEESON", "GROUCHO SINATRA", "MAE HOFFMAN", "KENNETH TORN", "HARRISON BALE", "ALBERT NOLTE"]}'),
('{ "_id" : "9f8459fb54e44636ae088dcb4136af58", "title" : "HONEY TIES", "description" : "A Taut Story of a Waitress And a Crocodile who must Outrace a Lumberjack in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "84 min", "rating" : "R", "actors" : ["ZERO CAGE", "KIRSTEN PALTROW", "JULIANNE DENCH", "ALBERT NOLTE", "ALBERT JOHANSSON"]}'),
('{ "_id" : "b4022c15fbcd4513a33ece29d5b4787b", "title" : "HOOK CHARIOTS", "description" : "A Insightful Story of a Boy And a Dog who must Redeem a Boy in Australia", "release_year" : "2006", "language" : "English", "duration" : "49 min", "rating" : "G", "actors" : ["ELVIS MARX", "MAE HOFFMAN", "GENE WILLIS", "GINA DEGENERES"]}'),
('{ "_id" : "dd0e2baf954b4c0e823f19395e9c7292", "title" : "HOOSIERS BIRDCAGE", "description" : "A Astounding Display of a Explorer And a Boat who must Vanquish a Car in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "176 min", "rating" : "G", "actors" : ["SISSY SOBIESKI", "TIM HACKMAN", "GOLDIE BRODY", "DARYL WAHLBERG", "WALTER TORN", "DARYL CRAWFORD", "GRETA KEITEL", "FAY WINSLET", "GRETA MALDEN", "HUMPHREY WILLIS"]}'),
('{ "_id" : "35c55db758a14ca6b1188e8b382055c4", "title" : "HOPE TOOTSIE", "description" : "A Amazing Documentary of a Student And a Sumo Wrestler who must Outgun a A Shark in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "139 min", "rating" : "NC-17", "actors" : ["GREG CHAPLIN", "RENEE TRACY", "JANE JACKMAN", "JULIA FAWCETT"]}'),
('{ "_id" : "a61d69527ae34132ae6456e51b6b6acb", "title" : "HORN WORKING", "description" : "A Stunning Display of a Mad Scientist And a Technical Writer who must Succumb a Monkey in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "95 min", "rating" : "PG", "actors" : ["ZERO CAGE", "ANNE CRONYN", "CHRISTIAN NEESON", "SEAN GUINESS", "MORGAN WILLIAMS", "JAYNE NOLTE", "WILL WILSON", "GENE MCKELLEN"]}'),
('{ "_id" : "fef06c636eaa416babb96aab31ec98ab", "title" : "HORROR REIGN", "description" : "A Touching Documentary of a A Shark And a Car who must Build a Husband in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "139 min", "rating" : "R", "actors" : ["JOE SWANK", "NICK STALLONE", "MARY TANDY", "CHRISTOPHER WEST", "KENNETH HOFFMAN"]}'),
('{ "_id" : "c80a816c9c1148e6aef1bc7cf51d6145", "title" : "HOTEL HAPPINESS", "description" : "A Thrilling Yarn of a Pastry Chef And a A Shark who must Challenge a Mad Scientist in The Outback", "release_year" : "2006", "language" : "English", "duration" : "181 min", "rating" : "PG-13", "actors" : ["SANDRA KILMER", "RIP WINSLET", "SUSAN DAVIS", "RENEE BALL"]}'),
('{ "_id" : "e46051965b5542e994939b7b775940bc", "title" : "HOURS RAGE", "description" : "A Fateful Story of a Explorer And a Feminist who must Meet a Technical Writer in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "122 min", "rating" : "NC-17", "actors" : ["ALEC WAYNE", "HENRY BERRY", "BURT POSEY", "RALPH CRUZ", "KIRSTEN AKROYD", "JANE JACKMAN"]}'),
('{ "_id" : "67fa31cdd17740efa40ed280f6cadeb3", "title" : "HOUSE DYNAMITE", "description" : "A Taut Story of a Pioneer And a Squirrel who must Battle a Student in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "109 min", "rating" : "R", "actors" : ["NATALIE HOPKINS", "JUDE CRUISE", "MEG HAWKE", "MATTHEW LEIGH", "VIVIEN BASINGER", "AL GARLAND", "MATTHEW CARREY", "DEBBIE AKROYD", "MICHAEL BOLGER"]}'),
('{ "_id" : "cc2a2fbe483d43658ee2b5b7fd819fb2", "title" : "HUMAN GRAFFITI", "description" : "A Beautiful Reflection of a Womanizer And a Sumo Wrestler who must Chase a Database Administrator in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "68 min", "rating" : "NC-17", "actors" : ["PENELOPE GUINESS", "FRED COSTNER", "AUDREY OLIVIER", "WILL WILSON"]}'),
('{ "_id" : "a34233c8b9744576ba9e33153ad7fcbc", "title" : "HUNCHBACK IMPOSSIBLE", "description" : "A Touching Yarn of a Frisbee And a Dentist who must Fight a Composer in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "151 min", "rating" : "PG-13", "actors" : ["GROUCHO DUNST", "WILLIAM HACKMAN"]}'),
('{ "_id" : "f3d0a6c988074fb180914d0d7d96e5b0", "title" : "HUNGER ROOF", "description" : "A Unbelieveable Yarn of a Student And a Database Administrator who must Outgun a Husband in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "105 min", "rating" : "G", "actors" : ["MERYL GIBSON"]}'),
('{ "_id" : "45765973ce9843bf8be0fc860ad420f5", "title" : "HUNTER ALTER", "description" : "A Emotional Drama of a Mad Cow And a Boat who must Redeem a Secret Agent in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "125 min", "rating" : "PG-13", "actors" : ["ED CHASE", "JON CHASE", "JEFF SILVERSTONE", "RENEE BALL"]}'),
('{ "_id" : "52a11a0721904d48ab4021410f7e1f8f", "title" : "HUNTING MUSKETEERS", "description" : "A Thrilling Reflection of a Pioneer And a Dentist who must Outrace a Womanizer in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "65 min", "rating" : "NC-17", "actors" : ["CARY MCCONAUGHEY", "SEAN GUINESS", "JULIANNE DENCH", "MICHAEL BENING", "WILLIAM HACKMAN"]}'),
('{ "_id" : "510ed33ba8154a06a25cf01879645fb5", "title" : "HURRICANE AFFAIR", "description" : "A Lacklusture Epistle of a Database Administrator And a Woman who must Meet a Hunter in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "49 min", "rating" : "PG", "actors" : ["KIRSTEN AKROYD", "RUSSELL BACALL", "FAY WINSLET"]}'),
('{ "_id" : "08b83ed030f246fc90dbabce42395e3a", "title" : "HUSTLER PARTY", "description" : "A Emotional Reflection of a Sumo Wrestler And a Monkey who must Conquer a Robot in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "83 min", "rating" : "NC-17", "actors" : ["ALEC WAYNE", "ANGELINA ASTAIRE", "MINNIE KILMER", "CHRISTOPHER WEST"]}'),
('{ "_id" : "edd75de24914436db081739d9677883a", "title" : "HYDE DOCTOR", "description" : "A Fanciful Documentary of a Boy And a Woman who must Redeem a Womanizer in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "100 min", "rating" : "G", "actors" : ["CUBA OLIVIER", "LUCILLE TRACY", "JAYNE NEESON", "BURT POSEY", "ELLEN PRESLEY", "GINA DEGENERES"]}'),
('{ "_id" : "d936fea155de44dd9979b55d6cba3b83", "title" : "HYSTERICAL GRAIL", "description" : "A Amazing Saga of a Madman And a Dentist who must Build a Car in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "150 min", "rating" : "PG", "actors" : ["BURT POSEY", "MINNIE ZELLWEGER", "CHARLIZE DENCH", "MEG HAWKE", "WALTER TORN", "JULIANNE DENCH", "MORGAN WILLIAMS", "LUCILLE DEE", "JAYNE NOLTE"]}'),
('{ "_id" : "29e2773177ca4f5683746ec26c035496", "title" : "ICE CROSSING", "description" : "A Fast-Paced Tale of a Butler And a Moose who must Overcome a Pioneer in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "131 min", "rating" : "R", "actors" : ["MENA TEMPLE", "JUDE CRUISE", "CHRISTOPHER BERRY", "EWAN GOODING", "JAYNE NOLTE", "OLYMPIA PFEIFFER"]}'),
('{ "_id" : "aa9aa7cb27cb436cba71bc83fe27b62d", "title" : "IDAHO LOVE", "description" : "A Fast-Paced Drama of a Student And a Crocodile who must Meet a Database Administrator in The Outback", "release_year" : "2006", "language" : "English", "duration" : "172 min", "rating" : "PG-13", "actors" : ["TOM MCKELLEN", "PARKER GOLDBERG", "RAY JOHANSSON", "FAY WOOD", "HUMPHREY WILLIS", "MICHAEL BOLGER"]}'),
('{ "_id" : "6612121ff3c34f6fbc732d48ce16f8a2", "title" : "IDENTITY LOVER", "description" : "A Boring Tale of a Composer And a Mad Cow who must Defeat a Car in The Outback", "release_year" : "2006", "language" : "English", "duration" : "119 min", "rating" : "PG-13", "actors" : ["SANDRA KILMER", "ALEC WAYNE", "LIZA BERGMAN", "SCARLETT BENING"]}'),
('{ "_id" : "7fcab5a5c56949408767b2ffe5041ecc", "title" : "IDOLS SNATCHERS", "description" : "A Insightful Drama of a Car And a Composer who must Fight a Man in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "84 min", "rating" : "NC-17", "actors" : ["TOM MCKELLEN", "ADAM GRANT", "SEAN WILLIAMS", "RUSSELL BACALL", "ALBERT NOLTE", "JANE JACKMAN", "OLYMPIA PFEIFFER", "MARY KEITEL"]}'),
('{ "_id" : "f93ed968d6834bfe810ab3025b8f2165", "title" : "IGBY MAKER", "description" : "A Epic Documentary of a Hunter And a Dog who must Outgun a Dog in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "160 min", "rating" : "NC-17", "actors" : ["BETTE NICHOLSON", "SEAN GUINESS", "DAN STREEP", "GEOFFREY HESTON", "MICHAEL BENING"]}'),
('{ "_id" : "0e7dccec69794dd79547d703eb39aaf1", "title" : "ILLUSION AMELIE", "description" : "A Emotional Epistle of a Boat And a Mad Scientist who must Outrace a Robot in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "122 min", "rating" : "R", "actors" : ["KENNETH PALTROW", "GENE WILLIS", "MORGAN MCDORMAND", "DARYL CRAWFORD", "GRETA KEITEL", "RICHARD PENN", "HUMPHREY GARLAND"]}'),
('{ "_id" : "97f5709c30e445df83fd6e6203c21ae5", "title" : "IMAGE PRINCESS", "description" : "A Lacklusture Panorama of a Secret Agent And a Crocodile who must Discover a Madman in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "178 min", "rating" : "PG-13", "actors" : ["ED CHASE", "ZERO CAGE", "FRED COSTNER", "BURT DUKAKIS", "MICHELLE MCCONAUGHEY", "SCARLETT DAMON", "WOODY JOLIE", "KIRSTEN AKROYD", "ELLEN PRESLEY", "GRETA KEITEL", "LUCILLE DEE"]}'),
('{ "_id" : "9c04fa0562974f9cbd767d99d33af8cb", "title" : "IMPACT ALADDIN", "description" : "A Epic Character Study of a Frisbee And a Moose who must Outgun a Technical Writer in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "180 min", "rating" : "PG-13", "actors" : ["VIVIEN BERGEN", "GINA DEGENERES", "WARREN JACKMAN"]}'),
('{ "_id" : "b8eb15e5aa144f07a4974acf27ee8ade", "title" : "IMPOSSIBLE PREJUDICE", "description" : "A Awe-Inspiring Yarn of a Monkey And a Hunter who must Chase a Teacher in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "103 min", "rating" : "NC-17", "actors" : ["FRED COSTNER", "RITA REYNOLDS", "CHRIS DEPP"]}'),
('{ "_id" : "694ff3c2111646c583a4607c07311dbf", "title" : "INCH JET", "description" : "A Fateful Saga of a Womanizer And a Student who must Defeat a Butler in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "167 min", "rating" : "NC-17", "actors" : ["UMA WOOD", "FRED COSTNER", "GOLDIE BRODY", "PARKER GOLDBERG", "MATTHEW CARREY"]}'),
('{ "_id" : "a86857ea96bc47399c0a5bb4e01756ed", "title" : "INDEPENDENCE HOTEL", "description" : "A Thrilling Tale of a Technical Writer And a Boy who must Face a Pioneer in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "157 min", "rating" : "NC-17", "actors" : ["KARL BERRY", "HELEN VOIGHT", "DAN HARRIS", "JAYNE NEESON", "GROUCHO SINATRA", "KENNETH TORN", "GROUCHO DUNST", "RIVER DEAN", "KIM ALLEN"]}'),
('{ "_id" : "d31a3d61c1b6477ebbac3260d3ed40a1", "title" : "INDIAN LOVE", "description" : "A Insightful Saga of a Mad Scientist And a Mad Scientist who must Kill a Astronaut in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "135 min", "rating" : "NC-17", "actors" : ["NICK WAHLBERG", "MATTHEW JOHANSSON", "TOM MCKELLEN", "CARY MCCONAUGHEY", "SCARLETT DAMON", "GINA DEGENERES", "RITA REYNOLDS", "RUSSELL TEMPLE", "JON CHASE", "GENE MCKELLEN"]}'),
('{ "_id" : "2521a66817e94f46b8650166f492ad1f", "title" : "INFORMER DOUBLE", "description" : "A Action-Packed Display of a Woman And a Dentist who must Redeem a Forensic Psychologist in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "74 min", "rating" : "NC-17", "actors" : ["RENEE TRACY", "KEVIN GARLAND", "IAN TANDY"]}'),
('{ "_id" : "29bff62c06ce4e4bae95b3fb7c48b758", "title" : "INNOCENT USUAL", "description" : "A Beautiful Drama of a Pioneer And a Crocodile who must Challenge a Student in The Outback", "release_year" : "2006", "language" : "English", "duration" : "178 min", "rating" : "PG-13", "actors" : ["DAN TORN", "CHRISTIAN AKROYD", "JAMES PITT"]}'),
('{ "_id" : "39fe6fceb4264afa948f265495678a18", "title" : "INSECTS STONE", "description" : "A Epic Display of a Butler And a Dog who must Vanquish a Crocodile in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "123 min", "rating" : "NC-17", "actors" : ["GARY PHOENIX", "MINNIE ZELLWEGER", "JON CHASE", "GREGORY GOODING"]}'),
('{ "_id" : "9fb55420c1184ecb91abdc54074b044a", "title" : "INSIDER ARIZONA", "description" : "A Astounding Saga of a Mad Scientist And a Hunter who must Pursue a Robot in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "78 min", "rating" : "NC-17", "actors" : ["DAN TORN", "JULIA MCQUEEN", "ALEC WAYNE", "KIRK JOVOVICH", "DAN HARRIS", "CATE MCQUEEN", "FAY WOOD", "BURT TEMPLE", "THORA TEMPLE"]}'),
('{ "_id" : "ad8a764e837243298847fbb65fc33685", "title" : "INSTINCT AIRPORT", "description" : "A Touching Documentary of a Mad Cow And a Explorer who must Confront a Butler in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "116 min", "rating" : "PG", "actors" : ["JENNIFER DAVIS", "GRACE MOSTEL", "CAMERON STREEP", "JOHNNY CAGE", "REESE KILMER", "PARKER GOLDBERG", "PENELOPE CRONYN", "SYLVESTER DERN", "RICHARD PENN", "GEOFFREY HESTON", "ED GUINESS"]}'),
('{ "_id" : "84f99016d44946d78a843d3b0d4b07d6", "title" : "INTENTIONS EMPIRE", "description" : "A Astounding Epistle of a Cat And a Cat who must Conquer a Mad Cow in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "107 min", "rating" : "PG-13", "actors" : ["ANGELINA ASTAIRE", "MARY KEITEL"]}'),
('{ "_id" : "594585bcc2a54d01b3e486dcb54dd92d", "title" : "INTERVIEW LIAISONS", "description" : "A Action-Packed Reflection of a Student And a Butler who must Discover a Database Administrator in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "59 min", "rating" : "R", "actors" : ["MENA TEMPLE", "JAYNE NEESON", "SCARLETT DAMON", "JOHN SUVARI", "THORA TEMPLE"]}'),
('{ "_id" : "d932a8a0a21e4ebfaa5fc8681f45e8fa", "title" : "INTOLERABLE INTENTIONS", "description" : "A Awe-Inspiring Story of a Monkey And a Pastry Chef who must Succumb a Womanizer in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "63 min", "rating" : "PG-13", "actors" : ["BURT DUKAKIS", "JOHNNY CAGE", "KENNETH PALTROW", "MICHELLE MCCONAUGHEY", "MEG HAWKE", "OLYMPIA PFEIFFER"]}'),
('{ "_id" : "ba4ca1724ec54ad2b58e35a2d30b2f64", "title" : "INTRIGUE WORST", "description" : "A Fanciful Character Study of a Explorer And a Mad Scientist who must Vanquish a Squirrel in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "181 min", "rating" : "G", "actors" : ["VAL BOLGER", "REESE KILMER", "GARY PENN", "GINA DEGENERES", "CATE HARRIS", "MERYL GIBSON", "FAY WOOD"]}'),
('{ "_id" : "3236dfc7c67046e5866742bfaf98fc94", "title" : "INVASION CYCLONE", "description" : "A Lacklusture Character Study of a Mad Scientist And a Womanizer who must Outrace a Explorer in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "97 min", "rating" : "PG", "actors" : ["WOODY JOLIE", "RENEE TRACY", "SCARLETT BENING", "FRANCES TOMEI", "EMILY DEE", "JAYNE NOLTE", "ED GUINESS"]}'),
('{ "_id" : "f1778ac671794b1db21fcd80880c480e", "title" : "IRON MOON", "description" : "A Fast-Paced Documentary of a Mad Cow And a Boy who must Pursue a Dentist in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "46 min", "rating" : "PG", "actors" : ["HELEN VOIGHT", "ANNE CRONYN", "RAY JOHANSSON", "GROUCHO DUNST", "FRANCES TOMEI", "CHRIS DEPP", "HARVEY HOPE", "HUMPHREY WILLIS"]}'),
('{ "_id" : "f7018c2a5375470ea870bf752e2d323d", "title" : "ISHTAR ROCKETEER", "description" : "A Astounding Saga of a Dog And a Squirrel who must Conquer a Dog in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "79 min", "rating" : "R", "actors" : ["KIRSTEN AKROYD", "SALMA NOLTE", "JADA RYDER", "JOHN SUVARI"]}'),
('{ "_id" : "8dcd3f09f2d44093a2471577daa4fd7c", "title" : "ISLAND EXORCIST", "description" : "A Fanciful Panorama of a Technical Writer And a Boy who must Find a Dentist in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "84 min", "rating" : "NC-17", "actors" : ["RAY JOHANSSON", "ANGELA HUDSON", "DARYL CRAWFORD"]}'),
('{ "_id" : "c4a1dd465a014c51bf1d0965a4ff013d", "title" : "ITALIAN AFRICAN", "description" : "A Astounding Character Study of a Monkey And a Moose who must Outgun a Cat in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "174 min", "rating" : "G", "actors" : ["VIVIEN BERGEN", "AUDREY BAILEY"]}'),
('{ "_id" : "eb76ce848cfb47688fdd044bbb9c8a82", "title" : "JACKET FRISCO", "description" : "A Insightful Reflection of a Womanizer And a Husband who must Conquer a Pastry Chef in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "181 min", "rating" : "PG-13", "actors" : ["BOB FAWCETT", "MILLA PECK", "MAE HOFFMAN", "CHARLIZE DENCH", "ELLEN PRESLEY", "KENNETH TORN", "ANGELA WITHERSPOON", "VIVIEN BASINGER", "AL GARLAND", "BELA WALKEN"]}'),
('{ "_id" : "49098093a55b43ddb0dee9a2948ac553", "title" : "JADE BUNCH", "description" : "A Insightful Panorama of a Squirrel And a Mad Cow who must Confront a Student in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "174 min", "rating" : "NC-17", "actors" : ["CARMEN HUNT", "DAN HARRIS", "ANGELINA ASTAIRE", "CAMERON ZELLWEGER", "ED MANSFIELD", "MERYL GIBSON", "RENEE BALL", "THORA TEMPLE"]}'),
('{ "_id" : "e0ec412e04e74fb9b746fc5ca8558811", "title" : "JAPANESE RUN", "description" : "A Awe-Inspiring Epistle of a Feminist And a Girl who must Sink a Girl in The Outback", "release_year" : "2006", "language" : "English", "duration" : "135 min", "rating" : "G", "actors" : ["VIVIEN BERGEN", "ANGELA HUDSON", "RALPH CRUZ", "MINNIE ZELLWEGER", "KENNETH TORN", "JIM MOSTEL", "KIM ALLEN", "BEN HARRIS", "JOHN SUVARI"]}'),
('{ "_id" : "d99c49dee6bb4672932176bb2b70514b", "title" : "JASON TRAP", "description" : "A Thoughtful Tale of a Woman And a A Shark who must Conquer a Dog in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "130 min", "rating" : "NC-17", "actors" : ["GOLDIE BRODY", "NATALIE HOPKINS", "ANGELA HUDSON", "BEN HARRIS", "MINNIE KILMER"]}'),
('{ "_id" : "4a2ed936cabd47fd9b5640be7934e13e", "title" : "JAWBREAKER BROOKLYN", "description" : "A Stunning Reflection of a Boat And a Pastry Chef who must Succumb a A Shark in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "118 min", "rating" : "PG", "actors" : ["CHRISTIAN GABLE", "JULIA MCQUEEN", "VAL BOLGER", "CHRISTIAN AKROYD", "JESSICA BAILEY"]}'),
('{ "_id" : "93afe06037344a4b834dbd33fb280039", "title" : "JAWS HARRY", "description" : "A Thrilling Display of a Database Administrator And a Monkey who must Overcome a Dog in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "112 min", "rating" : "G", "actors" : ["HELEN VOIGHT", "LUCILLE TRACY", "PARKER GOLDBERG", "MINNIE ZELLWEGER", "GRETA KEITEL"]}'),
('{ "_id" : "eb615f6e2bb54a0994525f538b39f4f1", "title" : "JEDI BENEATH", "description" : "A Astounding Reflection of a Explorer And a Dentist who must Pursue a Student in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "128 min", "rating" : "PG", "actors" : ["JAMES PITT", "LIZA BERGMAN", "JULIANNE DENCH", "JANE JACKMAN"]}'),
('{ "_id" : "1d954447f25c4916a4cd2328e51d04a3", "title" : "JEEPERS WEDDING", "description" : "A Astounding Display of a Composer And a Dog who must Kill a Pastry Chef in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "84 min", "rating" : "R", "actors" : ["ED CHASE", "CHRISTIAN GABLE", "WOODY JOLIE", "CHRISTOPHER BERRY", "JULIANNE DENCH", "MINNIE KILMER"]}'),
('{ "_id" : "a359505581c145638351ae1a5b8cbea6", "title" : "JEKYLL FROGMEN", "description" : "A Fanciful Epistle of a Student And a Astronaut who must Kill a Waitress in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "58 min", "rating" : "PG", "actors" : ["NICK WAHLBERG", "DAN STREEP", "JADA RYDER"]}'),
('{ "_id" : "3490cfa8e2d948df843b2a582eee6a1f", "title" : "JEOPARDY ENCINO", "description" : "A Boring Panorama of a Man And a Mad Cow who must Face a Explorer in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "102 min", "rating" : "R", "actors" : ["ALEC WAYNE", "GREG CHAPLIN", "GEOFFREY HESTON", "JULIA ZELLWEGER", "MARY KEITEL"]}'),
('{ "_id" : "520ac3a4eb5f462a830344e2da0e3d3b", "title" : "JERICHO MULAN", "description" : "A Amazing Yarn of a Hunter And a Butler who must Defeat a Boy in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "171 min", "rating" : "NC-17", "actors" : ["ELVIS MARX", "VIVIEN BASINGER", "WILLIAM HACKMAN", "LISA MONROE"]}'),
('{ "_id" : "eb26510948464d018b3d7e21aff50f74", "title" : "JERK PAYCHECK", "description" : "A Touching Character Study of a Pastry Chef And a Database Administrator who must Reach a A Shark in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "172 min", "rating" : "NC-17", "actors" : ["DAN TORN", "BURT DUKAKIS", "REESE KILMER", "JULIA BARRYMORE", "MILLA KEITEL", "RITA REYNOLDS", "CHRIS DEPP", "BELA WALKEN"]}'),
('{ "_id" : "2e40fbb987704531a5884c8a10e6de5e", "title" : "JERSEY SASSY", "description" : "A Lacklusture Documentary of a Madman And a Mad Cow who must Find a Feminist in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "60 min", "rating" : "PG", "actors" : ["NICK WAHLBERG", "ZERO CAGE", "VAL BOLGER", "FAY KILMER", "WALTER TORN", "CATE MCQUEEN", "ED MANSFIELD", "RIVER DEAN", "JOHN SUVARI"]}'),
('{ "_id" : "cc5c0833680e4d19849589d99a1d7dc6", "title" : "JET NEIGHBORS", "description" : "A Amazing Display of a Lumberjack And a Teacher who must Outrace a Woman in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "59 min", "rating" : "R", "actors" : ["FAY KILMER", "GREG CHAPLIN", "GENE WILLIS", "MINNIE KILMER", "HUMPHREY GARLAND", "MERYL ALLEN"]}'),
('{ "_id" : "a6f70d95ec26416da1f281347f7787ef", "title" : "JINGLE SAGEBRUSH", "description" : "A Epic Character Study of a Feminist And a Student who must Meet a Woman in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "124 min", "rating" : "PG-13", "actors" : ["KIM ALLEN", "GROUCHO WILLIAMS"]}'),
('{ "_id" : "aec714bccb3845aab1822a3ba42f0c90", "title" : "JOON NORTHWEST", "description" : "A Thrilling Panorama of a Technical Writer And a Car who must Discover a Forensic Psychologist in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "105 min", "rating" : "NC-17", "actors" : ["ALEC WAYNE", "CHARLIZE DENCH"]}'),
('{ "_id" : "9487dbaeafe74ce3b3f7722c575e38c5", "title" : "JUGGLER HARDLY", "description" : "A Epic Story of a Mad Cow And a Astronaut who must Challenge a Car in California", "release_year" : "2006", "language" : "English", "duration" : "54 min", "rating" : "PG-13", "actors" : ["MILLA PECK", "PENELOPE PINKETT", "CAMERON ZELLWEGER", "PENELOPE MONROE", "SALMA NOLTE", "MORGAN WILLIAMS", "EWAN GOODING", "MERYL GIBSON", "ED GUINESS"]}'),
('{ "_id" : "a40beb420aae4dacb4edcdfefa782372", "title" : "JUMANJI BLADE", "description" : "A Intrepid Yarn of a Husband And a Womanizer who must Pursue a Mad Scientist in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "121 min", "rating" : "G", "actors" : ["JENNIFER DAVIS", "BOB FAWCETT", "NICK STALLONE", "GARY PHOENIX", "MENA TEMPLE", "JIM MOSTEL"]}'),
('{ "_id" : "19e799430f8649c292158831f0166952", "title" : "JUMPING WRATH", "description" : "A Touching Epistle of a Monkey And a Feminist who must Discover a Boat in Berlin", "release_year" : "2006", "language" : "English", "duration" : "74 min", "rating" : "NC-17", "actors" : ["ELVIS MARX", "SANDRA KILMER", "ANGELA HUDSON", "JAMES PITT", "SUSAN DAVIS", "SALMA NOLTE", "CATE HARRIS", "ALAN DREYFUSS"]}'),
('{ "_id" : "517ce2a57ee04db1907d10e03d5728a4", "title" : "JUNGLE CLOSER", "description" : "A Boring Character Study of a Boy And a Woman who must Battle a Astronaut in Australia", "release_year" : "2006", "language" : "English", "duration" : "134 min", "rating" : "NC-17", "actors" : ["LUCILLE TRACY", "MENA TEMPLE", "BURT POSEY", "DAN STREEP", "HUMPHREY GARLAND", "CUBA BIRCH"]}'),
('{ "_id" : "4f762fdba7c94c6bbf709b586a81f3d4", "title" : "KANE EXORCIST", "description" : "A Epic Documentary of a Composer And a Robot who must Overcome a Car in Berlin", "release_year" : "2006", "language" : "English", "duration" : "92 min", "rating" : "R", "actors" : ["AUDREY OLIVIER", "BURT DUKAKIS", "HENRY BERRY", "CHRISTOPHER BERRY", "GROUCHO WILLIAMS"]}'),
('{ "_id" : "317cd0f32f26442491566dadd46393b8", "title" : "KARATE MOON", "description" : "A Astounding Yarn of a Womanizer And a Dog who must Reach a Waitress in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "120 min", "rating" : "PG-13", "actors" : ["JOHNNY CAGE", "SUSAN DAVIS", "JULIANNE DENCH", "JANE JACKMAN", "JADA RYDER", "KIM ALLEN", "MICHAEL BOLGER", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "2cb7c40e049e4ef5951d097c64d32962", "title" : "KENTUCKIAN GIANT", "description" : "A Stunning Yarn of a Woman And a Frisbee who must Escape a Waitress in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "169 min", "rating" : "PG", "actors" : ["VIVIEN BERGEN", "ELVIS MARX", "WARREN NOLTE", "RUSSELL CLOSE"]}'),
('{ "_id" : "b77f3f9eac51459286262eb47a23b727", "title" : "KICK SAVANNAH", "description" : "A Emotional Drama of a Monkey And a Robot who must Defeat a Monkey in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "179 min", "rating" : "PG-13", "actors" : ["ANGELA HUDSON", "JESSICA BAILEY", "GRETA MALDEN", "LAURENCE BULLOCK", "ALAN DREYFUSS", "MICHAEL BENING"]}'),
('{ "_id" : "8210c940a59d46668028c88f0edefd98", "title" : "KILL BROTHERHOOD", "description" : "A Touching Display of a Hunter And a Secret Agent who must Redeem a Husband in The Outback", "release_year" : "2006", "language" : "English", "duration" : "54 min", "rating" : "G", "actors" : ["KIRSTEN PALTROW", "RIP WINSLET", "WOODY JOLIE", "ALBERT NOLTE", "RIVER DEAN"]}'),
('{ "_id" : "4444716f0c5140f4953b3c119ee1dfe7", "title" : "KILLER INNOCENT", "description" : "A Fanciful Character Study of a Student And a Explorer who must Succumb a Composer in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "161 min", "rating" : "R", "actors" : ["BURT POSEY", "ANGELINA ASTAIRE", "DARYL WAHLBERG", "WHOOPI HURT", "MERYL ALLEN"]}'),
('{ "_id" : "9bf975e9e2794af09e0311ab2f494029", "title" : "KING EVOLUTION", "description" : "A Action-Packed Tale of a Boy And a Lumberjack who must Chase a Madman in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "184 min", "rating" : "NC-17", "actors" : ["PENELOPE GUINESS", "LUCILLE TRACY", "BURT DUKAKIS", "CUBA ALLEN", "RENEE BALL", "MARY KEITEL"]}'),
('{ "_id" : "89ee00aaef0b459895c150ef29822162", "title" : "KISS GLORY", "description" : "A Lacklusture Reflection of a Girl And a Husband who must Find a Robot in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "163 min", "rating" : "PG-13", "actors" : ["CUBA OLIVIER", "HELEN VOIGHT", "JULIA MCQUEEN", "TOM MIRANDA", "GROUCHO DUNST", "OPRAH KILMER", "HUMPHREY GARLAND"]}'),
('{ "_id" : "0f56af9f6b5e442e8f89a647d18ffc7e", "title" : "KISSING DOLLS", "description" : "A Insightful Reflection of a Pioneer And a Teacher who must Build a Composer in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "141 min", "rating" : "R", "actors" : ["TOM MCKELLEN", "JADA RYDER", "GEOFFREY HESTON"]}'),
('{ "_id" : "44fb9ef0872541a68b00b41c2963ce0c", "title" : "KNOCK WARLOCK", "description" : "A Unbelieveable Story of a Teacher And a Boat who must Confront a Moose in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "71 min", "rating" : "PG-13", "actors" : ["CUBA OLIVIER", "WOODY HOFFMAN", "AUDREY OLIVIER", "TOM MIRANDA", "REESE KILMER", "JUDE CRUISE"]}'),
('{ "_id" : "c304562a0d424100b6853d31353b1027", "title" : "KRAMER CHOCOLATE", "description" : "A Amazing Yarn of a Robot And a Pastry Chef who must Redeem a Mad Scientist in The Outback", "release_year" : "2006", "language" : "English", "duration" : "171 min", "rating" : "R", "actors" : ["JOHNNY LOLLOBRIGIDA", "BETTE NICHOLSON", "FRED COSTNER", "JULIA MCQUEEN", "REESE KILMER", "MILLA KEITEL", "WOODY JOLIE", "JULIANNE DENCH"]}'),
('{ "_id" : "8443d0dcb9c941ae9a002ca309975c07", "title" : "KWAI HOMEWARD", "description" : "A Amazing Drama of a Car And a Squirrel who must Pursue a Car in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "46 min", "rating" : "PG-13", "actors" : ["NATALIE HOPKINS", "MICHELLE MCCONAUGHEY", "JADA RYDER", "ANGELA WITHERSPOON", "FAY WOOD"]}'),
('{ "_id" : "cad44846240643d6ae7ec463edd00161", "title" : "LABYRINTH LEAGUE", "description" : "A Awe-Inspiring Saga of a Composer And a Frisbee who must Succumb a Pioneer in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "46 min", "rating" : "PG-13", "actors" : ["TOM MIRANDA", "GROUCHO SINATRA", "SCARLETT DAMON", "KIRSTEN AKROYD", "GROUCHO DUNST", "KENNETH HOFFMAN"]}'),
('{ "_id" : "6ab3b2af873c4bef9706acd25500521e", "title" : "LADY STAGE", "description" : "A Beautiful Character Study of a Woman And a Man who must Pursue a Explorer in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "67 min", "rating" : "PG", "actors" : ["PENELOPE GUINESS", "FRANCES DAY-LEWIS", "ANNE CRONYN", "RAY JOHANSSON", "PENELOPE CRONYN", "HARRISON BALE", "JEFF SILVERSTONE", "ROCK DUKAKIS"]}'),
('{ "_id" : "db0d37ba8dd04fbb90e9496b2afa4e72", "title" : "LADYBUGS ARMAGEDDON", "description" : "A Fateful Reflection of a Dog And a Mad Scientist who must Meet a Mad Scientist in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "113 min", "rating" : "NC-17", "actors" : ["KIRSTEN PALTROW", "WARREN NOLTE", "GRETA KEITEL", "MATTHEW CARREY"]}'),
('{ "_id" : "0a1fca3c96094079af2c04edbb01a651", "title" : "LAMBS CINCINATTI", "description" : "A Insightful Story of a Man And a Feminist who must Fight a Composer in Australia", "release_year" : "2006", "language" : "English", "duration" : "144 min", "rating" : "PG-13", "actors" : ["WOODY HOFFMAN", "VAL BOLGER", "REESE KILMER", "JULIA BARRYMORE", "MENA TEMPLE", "CHRISTIAN NEESON", "BURT POSEY", "SCARLETT DAMON", "WALTER TORN", "CAMERON ZELLWEGER", "LUCILLE DEE", "FAY WINSLET", "JAYNE NOLTE", "MENA HOPPER", "JULIA ZELLWEGER"]}'),
('{ "_id" : "029f0700cda74a629a6f7f8176cb953f", "title" : "LANGUAGE COWBOY", "description" : "A Epic Yarn of a Cat And a Madman who must Vanquish a Dentist in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "78 min", "rating" : "NC-17", "actors" : ["PENELOPE GUINESS", "BETTE NICHOLSON", "CHRISTOPHER BERRY", "WARREN JACKMAN", "WHOOPI HURT", "CUBA BIRCH"]}'),
('{ "_id" : "9be1d2c042004f4cbbda10fe8502de0d", "title" : "LAWLESS VISION", "description" : "A Insightful Yarn of a Boy And a Sumo Wrestler who must Outgun a Car in The Outback", "release_year" : "2006", "language" : "English", "duration" : "181 min", "rating" : "G", "actors" : ["JOE SWANK", "BOB FAWCETT", "PENELOPE PINKETT", "MICHAEL BOLGER"]}'),
('{ "_id" : "1dffc3bc86e54e70b12c7644f4b61710", "title" : "LAWRENCE LOVE", "description" : "A Fanciful Yarn of a Database Administrator And a Mad Cow who must Pursue a Womanizer in Berlin", "release_year" : "2006", "language" : "English", "duration" : "175 min", "rating" : "NC-17", "actors" : ["CHRISTOPHER BERRY", "SUSAN DAVIS"]}'),
('{ "_id" : "be946bb95e0d425bba95182cd9ff13e6", "title" : "LEAGUE HELLFIGHTERS", "description" : "A Thoughtful Saga of a A Shark And a Monkey who must Outgun a Student in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "110 min", "rating" : "PG-13", "actors" : ["JESSICA BAILEY", "KIRSTEN AKROYD", "KENNETH TORN", "JIM MOSTEL", "ALBERT JOHANSSON", "CUBA BIRCH"]}'),
('{ "_id" : "ab224bf657d1408085ddb6e9d280dafa", "title" : "LEATHERNECKS DWARFS", "description" : "A Fateful Reflection of a Dog And a Mad Cow who must Outrace a Teacher in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "153 min", "rating" : "PG-13", "actors" : ["KARL BERRY", "UMA WOOD", "BOB FAWCETT", "SPENCER DEPP", "SUSAN DAVIS", "PENELOPE MONROE", "IAN TANDY"]}'),
('{ "_id" : "3ce6620b6d2945bb833dcf56c7072a47", "title" : "LEBOWSKI SOLDIERS", "description" : "A Beautiful Epistle of a Secret Agent And a Pioneer who must Chase a Astronaut in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "69 min", "rating" : "PG-13", "actors" : ["JOE SWANK", "RICHARD PENN", "ALBERT JOHANSSON"]}'),
('{ "_id" : "e4b74a861d2f42cb97880a8a652b4f10", "title" : "LEGALLY SECRETARY", "description" : "A Astounding Tale of a A Shark And a Moose who must Meet a Womanizer in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "113 min", "rating" : "PG", "actors" : ["UMA WOOD", "HELEN VOIGHT", "CAMERON STREEP", "CARMEN HUNT", "JANE JACKMAN", "BELA WALKEN"]}'),
('{ "_id" : "eff98f7e0a364d82b402a6340bc0cd21", "title" : "LEGEND JEDI", "description" : "A Awe-Inspiring Epistle of a Pioneer And a Student who must Outgun a Crocodile in The Outback", "release_year" : "2006", "language" : "English", "duration" : "59 min", "rating" : "PG", "actors" : ["TOM MCKELLEN", "ANGELA HUDSON", "PENELOPE CRONYN", "CATE MCQUEEN"]}'),
('{ "_id" : "da3701addb5d422b91d52ae5ef027233", "title" : "LESSON CLEOPATRA", "description" : "A Emotional Display of a Man And a Explorer who must Build a Boy in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "167 min", "rating" : "NC-17", "actors" : ["BETTE NICHOLSON", "CARMEN HUNT", "CAMERON WRAY", "ANGELA HUDSON", "KENNETH TORN", "WALTER TORN", "WARREN NOLTE", "CUBA ALLEN", "LIZA BERGMAN", "JON CHASE", "LISA MONROE", "ROCK DUKAKIS"]}'),
('{ "_id" : "4685d39c1a16471b8ccdeafb95995986", "title" : "LIAISONS SWEET", "description" : "A Boring Drama of a A Shark And a Explorer who must Redeem a Waitress in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "140 min", "rating" : "PG", "actors" : ["NICK WAHLBERG", "MENA TEMPLE", "CHRISTIAN NEESON", "MEG HAWKE", "FAY WOOD", "MICHAEL BOLGER"]}'),
('{ "_id" : "dbbf20738fe54294b1f42bb42ea474f4", "title" : "LIBERTY MAGNIFICENT", "description" : "A Boring Drama of a Student And a Cat who must Sink a Technical Writer in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "138 min", "rating" : "G", "actors" : ["BETTE NICHOLSON", "ALEC WAYNE", "CHRISTIAN NEESON", "BEN WILLIS", "GREG CHAPLIN", "WILL WILSON", "CUBA BIRCH"]}'),
('{ "_id" : "1fbf47e0f09a493f9df3c88bb386fa8c", "title" : "LICENSE WEEKEND", "description" : "A Insightful Story of a Man And a Husband who must Overcome a Madman in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "91 min", "rating" : "NC-17", "actors" : ["NATALIE HOPKINS", "GROUCHO SINATRA", "GREG CHAPLIN", "SEAN GUINESS", "GINA DEGENERES", "DARYL CRAWFORD", "RUSSELL CLOSE", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "5e13016d9bee4970b5f1a8597e0ee325", "title" : "LIES TREATMENT", "description" : "A Fast-Paced Character Study of a Dentist And a Moose who must Defeat a Composer in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "147 min", "rating" : "NC-17", "actors" : ["HELEN VOIGHT", "JOHNNY CAGE", "DAN HARRIS", "KENNETH TORN", "WALTER TORN", "WARREN JACKMAN", "JON CHASE"]}'),
('{ "_id" : "a15ef78f63044ccd81dfbfb56a375bf6", "title" : "LIFE TWISTED", "description" : "A Thrilling Reflection of a Teacher And a Composer who must Find a Man in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "137 min", "rating" : "NC-17", "actors" : ["CHRISTIAN GABLE", "UMA WOOD", "MINNIE ZELLWEGER", "DARYL WAHLBERG", "CHRISTOPHER WEST", "GENE MCKELLEN", "MATTHEW CARREY", "REESE WEST"]}'),
('{ "_id" : "32b659a15564432bab03cd35ad182c55", "title" : "LIGHTS DEER", "description" : "A Unbelieveable Epistle of a Dog And a Woman who must Confront a Moose in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "174 min", "rating" : "R", "actors" : ["MATTHEW JOHANSSON", "TIM HACKMAN"]}'),
('{ "_id" : "7dfa1540ab5a466ca3644077e78c6e03", "title" : "LION UNCUT", "description" : "A Intrepid Display of a Pastry Chef And a Cat who must Kill a A Shark in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "50 min", "rating" : "PG", "actors" : ["UMA WOOD", "PENELOPE PINKETT", "BELA WALKEN"]}'),
('{ "_id" : "2ccc0a0b8dda4f59ae7c8bf68e694837", "title" : "LOATHING LEGALLY", "description" : "A Boring Epistle of a Pioneer And a Mad Scientist who must Escape a Frisbee in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "140 min", "rating" : "R", "actors" : ["AUDREY OLIVIER", "GARY PHOENIX", "SUSAN DAVIS", "MORGAN HOPKINS", "GRETA KEITEL"]}'),
('{ "_id" : "44412a53a84947709e7e181c68bd41bd", "title" : "LOCK REAR", "description" : "A Thoughtful Character Study of a Squirrel And a Technical Writer who must Outrace a Student in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "120 min", "rating" : "R", "actors" : ["WALTER TORN", "HARVEY HOPE"]}'),
('{ "_id" : "db0cee97264c4fac961528ff087f56e6", "title" : "LOLA AGENT", "description" : "A Astounding Tale of a Mad Scientist And a Husband who must Redeem a Database Administrator in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "PG", "actors" : ["LUCILLE TRACY", "TOM MIRANDA", "SCARLETT DAMON", "WOODY JOLIE", "KIM ALLEN", "GEOFFREY HESTON"]}'),
('{ "_id" : "c65203d03d5b45c7956ca2b213e6a679", "title" : "LOLITA WORLD", "description" : "A Thrilling Drama of a Girl And a Robot who must Redeem a Waitress in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "155 min", "rating" : "NC-17", "actors" : ["UMA WOOD"]}'),
('{ "_id" : "b4cd1f92886a4b83891d14139f5c140d", "title" : "LONELY ELEPHANT", "description" : "A Intrepid Story of a Student And a Dog who must Challenge a Explorer in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "67 min", "rating" : "G", "actors" : ["RIP CRAWFORD", "VAL BOLGER", "KENNETH PALTROW", "BEN WILLIS", "JAMES PITT", "CHARLIZE DENCH", "SEAN GUINESS", "WALTER TORN", "EWAN GOODING", "GROUCHO WILLIAMS", "ALAN DREYFUSS", "ROCK DUKAKIS"]}'),
('{ "_id" : "09b6d2b0a6ef4766a06c2a816fcdbb17", "title" : "LORD ARIZONA", "description" : "A Action-Packed Display of a Frisbee And a Pastry Chef who must Pursue a Crocodile in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "108 min", "rating" : "PG-13", "actors" : ["CHRISTIAN GABLE", "KIRSTEN PALTROW", "GROUCHO SINATRA", "SIDNEY CROWE", "JULIANNE DENCH", "MORGAN WILLIAMS"]}'),
('{ "_id" : "ed95853cb2944749a474aa2eee8f4ac4", "title" : "LOSE INCH", "description" : "A Stunning Reflection of a Student And a Technical Writer who must Battle a Butler in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "137 min", "rating" : "R", "actors" : ["LUCILLE TRACY", "HARRISON BALE", "MERYL ALLEN", "REESE WEST"]}'),
('{ "_id" : "92178284012e405b882758746da8ea16", "title" : "LOSER HUSTLER", "description" : "A Stunning Drama of a Robot And a Feminist who must Outgun a Butler in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "80 min", "rating" : "PG", "actors" : ["MATTHEW JOHANSSON", "ZERO CAGE", "WOODY HOFFMAN", "ADAM GRANT", "VIVIEN BASINGER"]}'),
('{ "_id" : "ded0344d2b5340999201d7d02e01b88d", "title" : "LOST BIRD", "description" : "A Emotional Character Study of a Robot And a A Shark who must Defeat a Technical Writer in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "98 min", "rating" : "PG-13", "actors" : ["KIRK JOVOVICH", "KENNETH TORN", "CUBA BIRCH"]}'),
('{ "_id" : "5773cb3bbc1c4138941688f372ad2aff", "title" : "LOUISIANA HARRY", "description" : "A Lacklusture Drama of a Girl And a Technical Writer who must Redeem a Monkey in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "70 min", "rating" : "PG-13", "actors" : ["HENRY BERRY", "GINA DEGENERES", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "2902dfc36c2e4f69839094eba4d9d2c4", "title" : "LOVE SUICIDES", "description" : "A Brilliant Panorama of a Hunter And a Explorer who must Pursue a Dentist in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "181 min", "rating" : "R", "actors" : ["JOHNNY LOLLOBRIGIDA", "TOM MIRANDA", "CHRISTIAN NEESON", "GRETA MALDEN"]}'),
('{ "_id" : "edc490f170314fff94d8bd9b74e344fa", "title" : "LOVELY JINGLE", "description" : "A Fanciful Yarn of a Crocodile And a Forensic Psychologist who must Discover a Crocodile in The Outback", "release_year" : "2006", "language" : "English", "duration" : "65 min", "rating" : "PG", "actors" : ["VIVIEN BERGEN", "DAN TORN", "ELVIS MARX", "SANDRA KILMER", "MINNIE KILMER", "MARY KEITEL"]}'),
('{ "_id" : "994cec1395de4c84a6f6d86f28fc3ef6", "title" : "LOVER TRUMAN", "description" : "A Emotional Yarn of a Robot And a Boy who must Outgun a Technical Writer in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "75 min", "rating" : "G", "actors" : ["VIVIEN BERGEN", "REESE KILMER", "CHRISTIAN NEESON", "MILLA KEITEL", "MENA HOPPER", "LISA MONROE", "THORA TEMPLE"]}'),
('{ "_id" : "500ec49a37f2405096bdc5fa905abcfd", "title" : "LOVERBOY ATTACKS", "description" : "A Boring Story of a Car And a Butler who must Build a Girl in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "162 min", "rating" : "PG-13", "actors" : ["LUCILLE TRACY", "KEVIN BLOOM", "PARKER GOLDBERG", "CARY MCCONAUGHEY", "MORGAN MCDORMAND", "ADAM HOPPER", "GROUCHO WILLIAMS", "RENEE BALL", "THORA TEMPLE"]}'),
('{ "_id" : "78b4ac74ff7f41fd83f49977ba21b790", "title" : "LUCK OPUS", "description" : "A Boring Display of a Moose And a Squirrel who must Outrace a Teacher in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "152 min", "rating" : "NC-17", "actors" : ["ED CHASE", "SUSAN DAVIS", "SCARLETT BENING", "JANE JACKMAN", "GEOFFREY HESTON", "MATTHEW CARREY"]}'),
('{ "_id" : "db5dd6b0c51b40bc8d1ec69846bd6388", "title" : "LUCKY FLYING", "description" : "A Lacklusture Character Study of a A Shark And a Man who must Find a Forensic Psychologist in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "97 min", "rating" : "PG-13", "actors" : ["NICK WAHLBERG", "KARL BERRY", "JULIA MCQUEEN", "PARKER GOLDBERG", "JAMES PITT", "KENNETH TORN", "JIM MOSTEL", "EWAN GOODING", "JADA RYDER", "ANGELA WITHERSPOON"]}'),
('{ "_id" : "0118bdfa4bc24e818ca21db8036ab718", "title" : "LUKE MUMMY", "description" : "A Taut Character Study of a Boy And a Robot who must Redeem a Mad Scientist in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "74 min", "rating" : "NC-17", "actors" : ["CUBA OLIVIER", "CHRISTIAN AKROYD", "ANGELA HUDSON", "BURT POSEY", "RITA REYNOLDS", "JOHN SUVARI", "BELA WALKEN", "MARY KEITEL", "JULIA FAWCETT"]}'),
('{ "_id" : "520fef968b904e07ba49719d067757f1", "title" : "LUST LOCK", "description" : "A Fanciful Panorama of a Hunter And a Dentist who must Meet a Secret Agent in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "52 min", "rating" : "G", "actors" : ["ANNE CRONYN", "CHARLIZE DENCH", "SEAN GUINESS", "SALMA NOLTE", "ED MANSFIELD", "JAYNE NOLTE", "MATTHEW CARREY"]}'),
('{ "_id" : "5194119c716b405f84bc79f6a741c700", "title" : "MADIGAN DORADO", "description" : "A Astounding Character Study of a A Shark And a A Shark who must Discover a Crocodile in The Outback", "release_year" : "2006", "language" : "English", "duration" : "116 min", "rating" : "R", "actors" : ["RAY JOHANSSON", "MILLA KEITEL", "MINNIE ZELLWEGER", "KIRSTEN AKROYD", "JON CHASE", "GENE MCKELLEN"]}'),
('{ "_id" : "c1c1a9d3cba04a94ac3dcf2680546d51", "title" : "MADISON TRAP", "description" : "A Awe-Inspiring Reflection of a Monkey And a Dentist who must Overcome a Pioneer in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "147 min", "rating" : "R", "actors" : ["RIP CRAWFORD", "JODIE DEGENERES", "WALTER TORN", "GREGORY GOODING", "THORA TEMPLE"]}'),
('{ "_id" : "705bf39480ef44369c36d811404076a7", "title" : "MADNESS ATTACKS", "description" : "A Fanciful Tale of a Squirrel And a Boat who must Defeat a Crocodile in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "178 min", "rating" : "PG-13", "actors" : ["FRANCES DAY-LEWIS", "SCARLETT DAMON", "KIRSTEN AKROYD", "SUSAN DAVIS", "FRANCES TOMEI", "HUMPHREY WILLIS", "MARY KEITEL"]}'),
('{ "_id" : "b7416d64a27f477a90163614ad54ef83", "title" : "MADRE GABLES", "description" : "A Intrepid Panorama of a Sumo Wrestler And a Forensic Psychologist who must Discover a Moose in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "98 min", "rating" : "PG-13", "actors" : ["TOM MIRANDA", "PENELOPE PINKETT", "DARYL WAHLBERG", "MATTHEW CARREY"]}'),
('{ "_id" : "06e861e28906448cb0ff1f0155df47af", "title" : "MAGIC MALLRATS", "description" : "A Touching Documentary of a Pastry Chef And a Pastry Chef who must Build a Mad Scientist in California", "release_year" : "2006", "language" : "English", "duration" : "117 min", "rating" : "PG", "actors" : ["ALEC WAYNE", "TOM MCKELLEN", "BURT POSEY", "KIRSTEN AKROYD"]}'),
('{ "_id" : "1e4d33a0bdca4fb5b3c6de8d35c1f115", "title" : "MAGNIFICENT CHITTY", "description" : "A Insightful Story of a Teacher And a Hunter who must Face a Mad Cow in California", "release_year" : "2006", "language" : "English", "duration" : "53 min", "rating" : "R", "actors" : ["FRED COSTNER", "GARY PENN", "GREG CHAPLIN", "KENNETH TORN", "GINA DEGENERES", "RENEE BALL", "CUBA BIRCH"]}'),
('{ "_id" : "9df44569a6fe42c6b7ee4f3deb1c2538", "title" : "MAGNOLIA FORRESTER", "description" : "A Thoughtful Documentary of a Composer And a Explorer who must Conquer a Dentist in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "171 min", "rating" : "PG-13", "actors" : ["SANDRA KILMER", "CHRISTIAN AKROYD", "GROUCHO SINATRA", "GRETA KEITEL", "LAURA BRODY", "OLYMPIA PFEIFFER", "AUDREY BAILEY"]}'),
('{ "_id" : "7099e3bca8af41faa18bba58cd5a033c", "title" : "MAGUIRE APACHE", "description" : "A Fast-Paced Reflection of a Waitress And a Hunter who must Defeat a Forensic Psychologist in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "74 min", "rating" : "NC-17", "actors" : ["NICK WAHLBERG", "SEAN WILLIAMS", "RENEE TRACY", "ALAN DREYFUSS"]}'),
('{ "_id" : "c4a828db06c84b15a47d92745f949893", "title" : "MAIDEN HOME", "description" : "A Lacklusture Saga of a Moose And a Teacher who must Kill a Forensic Psychologist in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "138 min", "rating" : "PG", "actors" : ["WOODY HOFFMAN", "CHRISTIAN AKROYD", "HENRY BERRY", "WOODY JOLIE", "KENNETH TORN", "DARYL WAHLBERG", "JAYNE NOLTE", "GREGORY GOODING"]}'),
('{ "_id" : "e4a99e3292234d49ae033713b9e7132d", "title" : "MAJESTIC FLOATS", "description" : "A Thrilling Character Study of a Moose And a Student who must Escape a Butler in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "130 min", "rating" : "PG", "actors" : ["JOE SWANK", "NATALIE HOPKINS", "GROUCHO SINATRA", "ED MANSFIELD", "JULIA ZELLWEGER"]}'),
('{ "_id" : "b2a8c55e088948e8a7626478aa71b7ba", "title" : "MAKER GABLES", "description" : "A Stunning Display of a Moose And a Database Administrator who must Pursue a Composer in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "136 min", "rating" : "PG-13", "actors" : ["CUBA OLIVIER", "VAL BOLGER", "CHRISTIAN AKROYD", "MARY TANDY", "RALPH CRUZ", "KIRSTEN AKROYD", "MEG HAWKE", "CUBA ALLEN", "KEVIN GARLAND", "RITA REYNOLDS", "LUCILLE DEE"]}'),
('{ "_id" : "df4ce02c14ff47d798b1b4effccf70ac", "title" : "MALKOVICH PET", "description" : "A Intrepid Reflection of a Waitress And a A Shark who must Kill a Squirrel in The Outback", "release_year" : "2006", "language" : "English", "duration" : "159 min", "rating" : "G", "actors" : ["GRACE MOSTEL", "MATTHEW JOHANSSON", "JADA RYDER", "FAY WINSLET", "LAURENCE BULLOCK", "MICHAEL BOLGER", "REESE WEST"]}'),
('{ "_id" : "bcaf0529588d4e18a74cd2db8374eeba", "title" : "MALLRATS UNITED", "description" : "A Thrilling Yarn of a Waitress And a Dentist who must Find a Hunter in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "133 min", "rating" : "PG", "actors" : ["NICK WAHLBERG", "VAL BOLGER", "CAMERON ZELLWEGER", "VIVIEN BASINGER", "MARY KEITEL"]}'),
('{ "_id" : "174272a228ee4ebcbafe4b3822ece7cf", "title" : "MALTESE HOPE", "description" : "A Fast-Paced Documentary of a Crocodile And a Sumo Wrestler who must Conquer a Explorer in California", "release_year" : "2006", "language" : "English", "duration" : "127 min", "rating" : "PG-13", "actors" : ["ANGELA HUDSON"]}'),
('{ "_id" : "d4803a5537824218805e151db731f4fa", "title" : "MANCHURIAN CURTAIN", "description" : "A Stunning Tale of a Mad Cow And a Boy who must Battle a Boy in Berlin", "release_year" : "2006", "language" : "English", "duration" : "177 min", "rating" : "PG", "actors" : ["RAY JOHANSSON", "ALBERT NOLTE"]}'),
('{ "_id" : "ba9b6d9936ce4ec9bf76f4073b13148a", "title" : "MANNEQUIN WORST", "description" : "A Astounding Saga of a Mad Cow And a Pastry Chef who must Discover a Husband in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "71 min", "rating" : "PG-13", "actors" : ["ANNE CRONYN", "MINNIE ZELLWEGER", "SIDNEY CROWE", "CUBA ALLEN", "GENE HOPKINS"]}'),
('{ "_id" : "dc7e5224cc9a42efa45c8e1429df5d26", "title" : "MARRIED GO", "description" : "A Fanciful Story of a Womanizer And a Dog who must Face a Forensic Psychologist in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "114 min", "rating" : "G", "actors" : ["GOLDIE BRODY", "FRANCES DAY-LEWIS", "GROUCHO DUNST"]}'),
('{ "_id" : "15c1adc7ab4044b09467d6149461bce0", "title" : "MARS ROMAN", "description" : "A Boring Drama of a Car And a Dog who must Succumb a Madman in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "62 min", "rating" : "NC-17", "actors" : ["ADAM GRANT", "RIVER DEAN", "OLYMPIA PFEIFFER", "MICHAEL BOLGER", "CUBA BIRCH", "JAYNE SILVERSTONE", "BELA WALKEN"]}'),
('{ "_id" : "2873c1f8f6ab4d7d80a88611c131b381", "title" : "MASK PEACH", "description" : "A Boring Character Study of a Student And a Robot who must Meet a Woman in California", "release_year" : "2006", "language" : "English", "duration" : "123 min", "rating" : "NC-17", "actors" : ["NICK WAHLBERG", "DAN TORN", "GARY PENN", "WOODY JOLIE", "MEG HAWKE", "SIDNEY CROWE", "WARREN NOLTE", "LUCILLE DEE", "LAURA BRODY", "JEFF SILVERSTONE", "RENEE BALL"]}'),
('{ "_id" : "488c61a9f70b4fafa4bb3e2832695555", "title" : "MASKED BUBBLE", "description" : "A Fanciful Documentary of a Pioneer And a Boat who must Pursue a Pioneer in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "151 min", "rating" : "PG-13", "actors" : ["GARY PENN", "ADAM HOPPER", "AUDREY BAILEY"]}'),
('{ "_id" : "76ce9fbd749a452881c997dae0457e81", "title" : "MASSACRE USUAL", "description" : "A Fateful Reflection of a Waitress And a Crocodile who must Challenge a Forensic Psychologist in California", "release_year" : "2006", "language" : "English", "duration" : "165 min", "rating" : "R", "actors" : ["SPENCER DEPP", "FAY WINSLET", "GENE MCKELLEN"]}'),
('{ "_id" : "5ccfce4e74364917b2350cc268baf01a", "title" : "MASSAGE IMAGE", "description" : "A Fateful Drama of a Frisbee And a Crocodile who must Vanquish a Dog in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "161 min", "rating" : "PG", "actors" : ["KEVIN BLOOM", "RIP CRAWFORD", "SCARLETT DAMON", "CHARLIZE DENCH", "KIRSTEN AKROYD", "CATE MCQUEEN", "MORGAN WILLIAMS", "KENNETH HOFFMAN", "ALAN DREYFUSS"]}'),
('{ "_id" : "1ec74875194148cc9f1ca004dbce2c0b", "title" : "MATRIX SNOWMAN", "description" : "A Action-Packed Saga of a Womanizer And a Woman who must Overcome a Student in California", "release_year" : "2006", "language" : "English", "duration" : "56 min", "rating" : "PG-13", "actors" : ["SANDRA PECK", "GARY PENN", "RUSSELL BACALL"]}'),
('{ "_id" : "a780d84fdefa4b8bb8170f901acab029", "title" : "MAUDE MOD", "description" : "A Beautiful Documentary of a Forensic Psychologist And a Cat who must Reach a Astronaut in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "72 min", "rating" : "R", "actors" : ["CARY MCCONAUGHEY", "JAMES PITT", "GROUCHO DUNST", "OLYMPIA PFEIFFER", "ED GUINESS", "ROCK DUKAKIS"]}'),
('{ "_id" : "9615dd9447d64e71a99c7ff0db67086c", "title" : "MEET CHOCOLATE", "description" : "A Boring Documentary of a Dentist And a Butler who must Confront a Monkey in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "80 min", "rating" : "G", "actors" : ["ZERO CAGE", "TIM HACKMAN", "PARKER GOLDBERG", "WARREN NOLTE", "WARREN JACKMAN", "GROUCHO WILLIAMS"]}'),
('{ "_id" : "7329707c63fa4a5484e9a68761980ffe", "title" : "MEMENTO ZOOLANDER", "description" : "A Touching Epistle of a Squirrel And a Explorer who must Redeem a Pastry Chef in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "77 min", "rating" : "NC-17", "actors" : ["TOM MIRANDA", "ANGELINA ASTAIRE", "KIRSTEN AKROYD", "SUSAN DAVIS", "ALBERT NOLTE", "MARY KEITEL"]}'),
('{ "_id" : "e483e4374df74d2791e93735d0f8edb2", "title" : "MENAGERIE RUSHMORE", "description" : "A Unbelieveable Panorama of a Composer And a Butler who must Overcome a Database Administrator in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "147 min", "rating" : "G", "actors" : ["BURT DUKAKIS", "RAY JOHANSSON"]}'),
('{ "_id" : "980b9288896c43119318d8185db83b0b", "title" : "MERMAID INSECTS", "description" : "A Lacklusture Drama of a Waitress And a Husband who must Fight a Husband in California", "release_year" : "2006", "language" : "English", "duration" : "104 min", "rating" : "NC-17", "actors" : ["FRANCES DAY-LEWIS", "SPENCER PECK", "WARREN JACKMAN", "EWAN GOODING", "GEOFFREY HESTON", "MARY KEITEL"]}'),
('{ "_id" : "651d7daeb517495d8eca655d58355dc6", "title" : "METAL ARMAGEDDON", "description" : "A Thrilling Display of a Lumberjack And a Crocodile who must Meet a Monkey in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "161 min", "rating" : "PG-13", "actors" : ["JOHNNY LOLLOBRIGIDA", "UMA WOOD", "ANGELA HUDSON", "GINA DEGENERES", "ALBERT JOHANSSON", "KENNETH HOFFMAN", "ALAN DREYFUSS", "MICHAEL BOLGER"]}'),
('{ "_id" : "fe6d8e6d59d649a489fb0e12f8f44a87", "title" : "METROPOLIS COMA", "description" : "A Emotional Saga of a Database Administrator And a Pastry Chef who must Confront a Teacher in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "64 min", "rating" : "PG-13", "actors" : ["VAL BOLGER", "DUSTIN TAUTOU", "RAY JOHANSSON", "GENE WILLIS", "JIM MOSTEL", "CUBA ALLEN"]}'),
('{ "_id" : "413949231cc04b5f88e3d55bf17643f3", "title" : "MICROCOSMOS PARADISE", "description" : "A Touching Character Study of a Boat And a Student who must Sink a A Shark in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "105 min", "rating" : "PG-13", "actors" : ["HELEN VOIGHT", "MENA TEMPLE", "ELLEN PRESLEY", "KEVIN GARLAND", "GRETA MALDEN", "JON CHASE"]}'),
('{ "_id" : "caaa0c2902614944a8ae7b7a76577099", "title" : "MIDNIGHT WESTWARD", "description" : "A Taut Reflection of a Husband And a A Shark who must Redeem a Pastry Chef in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "86 min", "rating" : "G", "actors" : ["WOODY HOFFMAN", "MILLA PECK", "ADAM GRANT", "JAMES PITT", "GINA DEGENERES", "GEOFFREY HESTON", "GRETA MALDEN", "OPRAH KILMER", "HUMPHREY GARLAND"]}'),
('{ "_id" : "5c5c6f74e9564288948ce411b6f8aa33", "title" : "MIDSUMMER GROUNDHOG", "description" : "A Fateful Panorama of a Moose And a Dog who must Chase a Crocodile in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "48 min", "rating" : "G", "actors" : ["JADA RYDER", "BELA WALKEN"]}'),
('{ "_id" : "01f9b2c453604094a05afafbc8294fec", "title" : "MIGHTY LUCK", "description" : "A Astounding Epistle of a Mad Scientist And a Pioneer who must Escape a Database Administrator in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "122 min", "rating" : "PG", "actors" : ["JULIA BARRYMORE", "MENA TEMPLE", "JESSICA BAILEY", "JULIANNE DENCH", "WHOOPI HURT", "RIVER DEAN", "RUSSELL CLOSE", "BELA WALKEN"]}'),
('{ "_id" : "deaeba7808c648339c774ce09d205d07", "title" : "MILE MULAN", "description" : "A Lacklusture Epistle of a Cat And a Husband who must Confront a Boy in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "64 min", "rating" : "PG", "actors" : ["MENA TEMPLE", "ANGELA HUDSON", "JULIANNE DENCH"]}'),
('{ "_id" : "fe197dadac0b4ec099b5f5e471cef819", "title" : "MILLION ACE", "description" : "A Brilliant Documentary of a Womanizer And a Squirrel who must Find a Technical Writer in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "142 min", "rating" : "PG-13", "actors" : ["CHRISTIAN AKROYD", "SCARLETT DAMON", "RENEE TRACY", "BEN HARRIS", "JOHN SUVARI"]}'),
('{ "_id" : "24ea7b26c9934cbd9fa8fea3b14fd1e4", "title" : "MINDS TRUMAN", "description" : "A Taut Yarn of a Mad Scientist And a Crocodile who must Outgun a Database Administrator in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "149 min", "rating" : "PG-13", "actors" : ["ANNE CRONYN", "BURT POSEY", "SCARLETT DAMON", "CHRIS DEPP", "MATTHEW CARREY", "JULIA ZELLWEGER"]}'),
('{ "_id" : "7d4ce5ba527a47059a84113d1dfe8236", "title" : "MINE TITANS", "description" : "A Amazing Yarn of a Robot And a Womanizer who must Discover a Forensic Psychologist in Berlin", "release_year" : "2006", "language" : "English", "duration" : "166 min", "rating" : "PG-13", "actors" : ["NICK DEGENERES", "HUMPHREY GARLAND"]}'),
('{ "_id" : "8d46135344854ff89bab60ca153938f2", "title" : "MINORITY KISS", "description" : "A Insightful Display of a Lumberjack And a Sumo Wrestler who must Meet a Man in The Outback", "release_year" : "2006", "language" : "English", "duration" : "59 min", "rating" : "G", "actors" : ["VIVIEN BASINGER"]}'),
('{ "_id" : "787936ae7cb748fca2b752a3ce533b2e", "title" : "MIRACLE VIRTUAL", "description" : "A Touching Epistle of a Butler And a Boy who must Find a Mad Scientist in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "162 min", "rating" : "PG-13", "actors" : ["FRED COSTNER"]}'),
('{ "_id" : "32f5d7b84d31463fae9fd18f7ebcc5b0", "title" : "MISSION ZOOLANDER", "description" : "A Intrepid Story of a Sumo Wrestler And a Teacher who must Meet a A Shark in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "164 min", "rating" : "PG-13", "actors" : ["FRED COSTNER", "KEVIN BLOOM", "TOM MCKELLEN", "PENELOPE CRONYN", "LUCILLE DEE"]}'),
('{ "_id" : "39e8846c0c5245a6b7a25d694c906900", "title" : "MIXED DOORS", "description" : "A Taut Drama of a Womanizer And a Lumberjack who must Succumb a Pioneer in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "180 min", "rating" : "PG-13", "actors" : ["CARMEN HUNT", "MICHELLE MCCONAUGHEY", "DAN STREEP", "ALBERT NOLTE", "IAN TANDY", "MICHAEL BOLGER"]}'),
('{ "_id" : "c3063cc32a40463da947044ffc020616", "title" : "MOB DUFFEL", "description" : "A Unbelieveable Documentary of a Frisbee And a Boat who must Meet a Boy in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "105 min", "rating" : "G", "actors" : ["CAMERON STREEP", "SISSY SOBIESKI", "TIM HACKMAN", "CHRISTIAN NEESON", "MATTHEW LEIGH", "GROUCHO DUNST"]}'),
('{ "_id" : "f62db3a4708745ed9e2c3d7a705a6dcd", "title" : "MOCKINGBIRD HOLLYWOOD", "description" : "A Thoughtful Panorama of a Man And a Car who must Sink a Composer in Berlin", "release_year" : "2006", "language" : "English", "duration" : "60 min", "rating" : "PG", "actors" : ["JULIA MCQUEEN", "SEAN GUINESS", "ADAM HOPPER"]}'),
('{ "_id" : "4af1f6360e634f3397d57ccefed313cc", "title" : "MOD SECRETARY", "description" : "A Boring Documentary of a Mad Cow And a Cat who must Build a Lumberjack in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "77 min", "rating" : "NC-17", "actors" : ["CHRISTIAN GABLE", "ZERO CAGE", "GOLDIE BRODY", "WHOOPI HURT", "LISA MONROE", "BELA WALKEN"]}'),
('{ "_id" : "96665e5abee44890a9ab09b68a54aff6", "title" : "MODEL FISH", "description" : "A Beautiful Panorama of a Boat And a Crocodile who must Outrace a Dog in Australia", "release_year" : "2006", "language" : "English", "duration" : "175 min", "rating" : "NC-17", "actors" : ["UMA WOOD", "VAL BOLGER", "RICHARD PENN", "GENE HOPKINS", "MERYL GIBSON", "HARVEY HOPE", "ED GUINESS", "MARY KEITEL"]}'),
('{ "_id" : "9ffacf5b50fa4824808fec3f81134b49", "title" : "MODERN DORADO", "description" : "A Awe-Inspiring Story of a Butler And a Sumo Wrestler who must Redeem a Boy in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "74 min", "rating" : "PG", "actors" : ["LUCILLE TRACY", "JUDY DEAN", "JAMES PITT", "JULIANNE DENCH", "CATE HARRIS"]}'),
('{ "_id" : "5e357bf578b64cfc9591d19694e1e35b", "title" : "MONEY HAROLD", "description" : "A Touching Tale of a Explorer And a Boat who must Defeat a Robot in Australia", "release_year" : "2006", "language" : "English", "duration" : "135 min", "rating" : "PG", "actors" : ["ALEC WAYNE", "BURT DUKAKIS", "GENE WILLIS", "PENELOPE MONROE", "JANE JACKMAN", "IAN TANDY", "DEBBIE AKROYD"]}'),
('{ "_id" : "05ccb14113a844b0a116f774feac243b", "title" : "MONSOON CAUSE", "description" : "A Astounding Tale of a Crocodile And a Car who must Outrace a Squirrel in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "182 min", "rating" : "PG", "actors" : ["NICK STALLONE", "NATALIE HOPKINS", "MINNIE ZELLWEGER", "ALBERT JOHANSSON", "WILLIAM HACKMAN"]}'),
('{ "_id" : "7b7a9b443ddc4bc58d7c993b809af6f0", "title" : "MONSTER SPARTACUS", "description" : "A Fast-Paced Story of a Waitress And a Cat who must Fight a Girl in Australia", "release_year" : "2006", "language" : "English", "duration" : "107 min", "rating" : "PG", "actors" : ["JUDE CRUISE", "WARREN JACKMAN", "GRETA KEITEL", "KIM ALLEN", "ALAN DREYFUSS", "JOHN SUVARI", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "c35403fae31d4d8289868d4ea0da31eb", "title" : "MONTEREY LABYRINTH", "description" : "A Awe-Inspiring Drama of a Monkey And a Composer who must Escape a Feminist in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "158 min", "rating" : "G", "actors" : ["KARL BERRY", "JULIA MCQUEEN", "DAN HARRIS", "JULIANNE DENCH", "FAY WOOD", "ROCK DUKAKIS"]}'),
('{ "_id" : "1046a72c556b4f60915866bba89ba425", "title" : "MONTEZUMA COMMAND", "description" : "A Thrilling Reflection of a Waitress And a Butler who must Battle a Butler in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "126 min", "rating" : "NC-17", "actors" : ["CUBA OLIVIER", "RICHARD PENN"]}'),
('{ "_id" : "06485ad4070142709eb8601517a8ba98", "title" : "MOON BUNCH", "description" : "A Beautiful Tale of a Astronaut And a Mad Cow who must Challenge a Cat in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "83 min", "rating" : "PG", "actors" : ["ANNE CRONYN"]}'),
('{ "_id" : "3869ad2c1a404fad9f388001c310e3a5", "title" : "MOONSHINE CABIN", "description" : "A Thoughtful Display of a Astronaut And a Feminist who must Chase a Frisbee in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "171 min", "rating" : "PG-13", "actors" : ["JODIE DEGENERES", "CARMEN HUNT", "WILLIAM HACKMAN", "MATTHEW CARREY", "GREGORY GOODING"]}'),
('{ "_id" : "8b504a38b031432cb1e04c2f1bad19f1", "title" : "MOONWALKER FOOL", "description" : "A Epic Drama of a Feminist And a Pioneer who must Sink a Composer in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "184 min", "rating" : "G", "actors" : ["ZERO CAGE", "UMA WOOD", "WOODY HOFFMAN", "RAY JOHANSSON", "DARYL CRAWFORD", "HUMPHREY GARLAND", "MARY KEITEL"]}'),
('{ "_id" : "70c57d2a397b4839b4a03b29bcd50aad", "title" : "MOSQUITO ARMAGEDDON", "description" : "A Thoughtful Character Study of a Waitress And a Feminist who must Build a Teacher in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "57 min", "rating" : "G", "actors" : ["GOLDIE BRODY", "KIRK JOVOVICH", "NICK STALLONE", "REESE WEST"]}'),
('{ "_id" : "2104adda7fab43a08ad2f2ec3c3e5b87", "title" : "MOTHER OLEANDER", "description" : "A Boring Tale of a Husband And a Boy who must Fight a Squirrel in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "103 min", "rating" : "R", "actors" : ["FRANCES DAY-LEWIS", "GROUCHO SINATRA", "SPENCER PECK", "WHOOPI HURT", "ANGELA WITHERSPOON"]}'),
('{ "_id" : "153fd67cad824026aa4919f44e9ca2ec", "title" : "MOTIONS DETAILS", "description" : "A Awe-Inspiring Reflection of a Dog And a Student who must Kill a Car in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "166 min", "rating" : "PG", "actors" : ["UMA WOOD", "ELVIS MARX", "BURT DUKAKIS", "PENELOPE PINKETT", "JIM MOSTEL", "WALTER TORN", "PENELOPE CRONYN", "LAURA BRODY"]}'),
('{ "_id" : "e1577f50c33d40f3b63b4aa7e4b4be37", "title" : "MOULIN WAKE", "description" : "A Astounding Story of a Forensic Psychologist And a Cat who must Battle a Teacher in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "79 min", "rating" : "PG-13", "actors" : ["JESSICA BAILEY", "SCARLETT BENING", "VIVIEN BASINGER"]}'),
('{ "_id" : "951d60e2b57c40939b3ea335e7ac82d6", "title" : "MOURNING PURPLE", "description" : "A Lacklusture Display of a Waitress And a Lumberjack who must Chase a Pioneer in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "146 min", "rating" : "PG", "actors" : ["CHRISTIAN AKROYD", "KENNETH PESCI", "ALBERT NOLTE", "DARYL CRAWFORD", "EWAN GOODING", "MERYL GIBSON", "WILL WILSON"]}'),
('{ "_id" : "db35e87b668f4afd85110ef701ea8e9e", "title" : "MOVIE SHAKESPEARE", "description" : "A Insightful Display of a Database Administrator And a Student who must Build a Hunter in Berlin", "release_year" : "2006", "language" : "English", "duration" : "53 min", "rating" : "PG", "actors" : ["HELEN VOIGHT", "CAMERON STREEP", "FAY KILMER", "GINA DEGENERES", "CAMERON ZELLWEGER", "RUSSELL BACALL", "MORGAN WILLIAMS", "RIVER DEAN"]}'),
('{ "_id" : "d720a20f26344d4899cca5c827b34d50", "title" : "MULAN MOON", "description" : "A Emotional Saga of a Womanizer And a Pioneer who must Overcome a Dentist in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "160 min", "rating" : "G", "actors" : ["NICK STALLONE", "ANGELINA ASTAIRE", "GRETA MALDEN", "MATTHEW CARREY", "JULIA FAWCETT"]}'),
('{ "_id" : "6d92163b4b4145b8b0acf371eb042e83", "title" : "MULHOLLAND BEAST", "description" : "A Awe-Inspiring Display of a Husband And a Squirrel who must Battle a Sumo Wrestler in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "157 min", "rating" : "PG", "actors" : ["PENELOPE GUINESS", "BETTE NICHOLSON", "KIRK JOVOVICH", "JUDE CRUISE", "WALTER TORN", "EWAN GOODING"]}'),
('{ "_id" : "23c4ca0dea7445eeb566fb1726107d8e", "title" : "MUMMY CREATURES", "description" : "A Fateful Character Study of a Crocodile And a Monkey who must Meet a Dentist in Australia", "release_year" : "2006", "language" : "English", "duration" : "160 min", "rating" : "NC-17", "actors" : ["HELEN VOIGHT", "KEVIN BLOOM", "TIM HACKMAN", "GOLDIE BRODY", "ANGELINA ASTAIRE", "SPENCER PECK", "WALTER TORN", "SIDNEY CROWE", "GINA DEGENERES", "RUSSELL BACALL", "DAN STREEP", "ROCK DUKAKIS", "AUDREY BAILEY"]}'),
('{ "_id" : "fa749b46b675456e92951941219663a6", "title" : "MUPPET MILE", "description" : "A Lacklusture Story of a Madman And a Teacher who must Kill a Frisbee in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "50 min", "rating" : "PG", "actors" : ["RIP WINSLET", "MAE HOFFMAN", "CHRIS BRIDGES", "PENELOPE CRONYN", "HARRISON BALE", "CATE HARRIS", "BEN HARRIS", "AL GARLAND"]}'),
('{ "_id" : "545e5484309c4fdca744bf56696dda9a", "title" : "MURDER ANTITRUST", "description" : "A Brilliant Yarn of a Car And a Database Administrator who must Escape a Boy in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "166 min", "rating" : "PG", "actors" : ["KIRK JOVOVICH", "MARY TANDY", "CHRISTOPHER BERRY", "SUSAN DAVIS", "CAMERON ZELLWEGER", "WHOOPI HURT", "JADA RYDER", "OLYMPIA PFEIFFER"]}'),
('{ "_id" : "24ee551fd2ec471cafd39a3443c45a73", "title" : "MUSCLE BRIGHT", "description" : "A Stunning Panorama of a Sumo Wrestler And a Husband who must Redeem a Madman in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "185 min", "rating" : "G", "actors" : ["SEAN WILLIAMS", "MATTHEW LEIGH", "GROUCHO WILLIAMS", "JEFF SILVERSTONE", "MATTHEW CARREY"]}'),
('{ "_id" : "5bba883cbf634ae88a43114c6bb1ac56", "title" : "MUSIC BOONDOCK", "description" : "A Thrilling Tale of a Butler And a Astronaut who must Battle a Explorer in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "129 min", "rating" : "R", "actors" : ["MORGAN WILLIAMS", "HUMPHREY WILLIS", "MICHAEL BENING"]}'),
('{ "_id" : "3d5c32d1973749bb81f33465813dd29f", "title" : "MUSKETEERS WAIT", "description" : "A Touching Yarn of a Student And a Moose who must Fight a Mad Cow in Australia", "release_year" : "2006", "language" : "English", "duration" : "73 min", "rating" : "PG", "actors" : ["BEN HARRIS"]}'),
('{ "_id" : "cad1f28bc54d43e09ca635a648bc6317", "title" : "MUSSOLINI SPOILERS", "description" : "A Thrilling Display of a Boat And a Monkey who must Meet a Composer in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "180 min", "rating" : "G", "actors" : ["VIVIEN BERGEN", "DAN TORN", "JUDY DEAN", "FAY KILMER", "KENNETH PALTROW", "CARY MCCONAUGHEY", "OPRAH KILMER"]}'),
('{ "_id" : "90a01ec677754c6a8daac3ec2218b7b2", "title" : "MYSTIC TRUMAN", "description" : "A Epic Yarn of a Teacher And a Hunter who must Outgun a Explorer in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "92 min", "rating" : "NC-17", "actors" : ["SCARLETT DAMON", "KEVIN GARLAND", "RIVER DEAN", "HUMPHREY WILLIS"]}'),
('{ "_id" : "f82d4a61890640d2a210bcc69181125a", "title" : "NAME DETECTIVE", "description" : "A Touching Saga of a Sumo Wrestler And a Cat who must Pursue a Mad Scientist in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "178 min", "rating" : "PG-13", "actors" : ["WARREN JACKMAN", "CATE MCQUEEN", "JOHN SUVARI"]}'),
('{ "_id" : "1ce9f555a5f74c52995a3fd5b651b128", "title" : "NASH CHOCOLAT", "description" : "A Epic Reflection of a Monkey And a Mad Cow who must Kill a Forensic Psychologist in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "180 min", "rating" : "PG-13", "actors" : ["JUDY DEAN", "ANGELA HUDSON", "BEN WILLIS", "HARRISON BALE", "BEN HARRIS", "HUMPHREY GARLAND", "BELA WALKEN"]}'),
('{ "_id" : "a2a9ea590a3b4b7b9d7d3fd32d01c37f", "title" : "NATIONAL STORY", "description" : "A Taut Epistle of a Mad Scientist And a Girl who must Escape a Monkey in California", "release_year" : "2006", "language" : "English", "duration" : "92 min", "rating" : "NC-17", "actors" : ["JENNIFER DAVIS", "RAY JOHANSSON", "JAMES PITT", "RITA REYNOLDS", "GRETA MALDEN", "VIVIEN BASINGER", "WILLIAM HACKMAN"]}'),
('{ "_id" : "5413b0b997f3428a8a507ff9ecc5b6cb", "title" : "NATURAL STOCK", "description" : "A Fast-Paced Story of a Sumo Wrestler And a Girl who must Defeat a Car in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "50 min", "rating" : "PG-13", "actors" : ["MILLA KEITEL", "SUSAN DAVIS", "KEVIN GARLAND", "RENEE BALL"]}'),
('{ "_id" : "484dd4ad52c142ec9ab236c1fd586785", "title" : "NECKLACE OUTBREAK", "description" : "A Astounding Epistle of a Database Administrator And a Mad Scientist who must Pursue a Cat in California", "release_year" : "2006", "language" : "English", "duration" : "132 min", "rating" : "PG", "actors" : ["ED CHASE", "GRACE MOSTEL", "MILLA PECK", "TOM MCKELLEN", "KIRSTEN AKROYD", "JIM MOSTEL", "MICHAEL BENING", "JOHN SUVARI"]}'),
('{ "_id" : "b8afc1831eef4acb8324021f7b01ae20", "title" : "NEIGHBORS CHARADE", "description" : "A Fanciful Reflection of a Crocodile And a Astronaut who must Outrace a Feminist in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "161 min", "rating" : "R", "actors" : ["WOODY HOFFMAN", "TOM MCKELLEN", "RALPH CRUZ", "SCARLETT DAMON", "DARYL WAHLBERG", "MORGAN MCDORMAND", "WILL WILSON"]}'),
('{ "_id" : "3bbd5cff3e2c4c44956aba8b7a56014a", "title" : "NEMO CAMPUS", "description" : "A Lacklusture Reflection of a Monkey And a Squirrel who must Outrace a Womanizer in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "131 min", "rating" : "NC-17", "actors" : ["FAY KILMER", "KENNETH PESCI", "JIM MOSTEL", "SALMA NOLTE", "ED MANSFIELD"]}'),
('{ "_id" : "a77be846217e4ca4a97f0595d5caea34", "title" : "NETWORK PEAK", "description" : "A Unbelieveable Reflection of a Butler And a Boat who must Outgun a Mad Scientist in California", "release_year" : "2006", "language" : "English", "duration" : "75 min", "rating" : "PG-13", "actors" : ["KIRK JOVOVICH", "NATALIE HOPKINS", "ELLEN PRESLEY"]}'),
('{ "_id" : "8c6f12c3cfd545dcadd9e552f092cb60", "title" : "NEWSIES STORY", "description" : "A Action-Packed Character Study of a Dog And a Lumberjack who must Outrace a Moose in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "159 min", "rating" : "G", "actors" : ["RALPH CRUZ", "JIM MOSTEL", "SYLVESTER DERN", "DAN STREEP", "NICK DEGENERES", "MICHAEL BENING", "JEFF SILVERSTONE", "JOHN SUVARI"]}'),
('{ "_id" : "e939053f867548ddabba8321193137fd", "title" : "NEWTON LABYRINTH", "description" : "A Intrepid Character Study of a Moose And a Waitress who must Find a A Shark in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "75 min", "rating" : "PG", "actors" : ["SEAN WILLIAMS", "GREG CHAPLIN", "ALBERT NOLTE", "AUDREY BAILEY"]}'),
('{ "_id" : "505b01935d5b4ec983420b486657bf69", "title" : "NIGHTMARE CHILL", "description" : "A Brilliant Display of a Robot And a Butler who must Fight a Waitress in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "149 min", "rating" : "PG", "actors" : ["WALTER TORN", "GENE HOPKINS"]}'),
('{ "_id" : "e7dc60527a9745db840d1f8c661761e5", "title" : "NONE SPIKING", "description" : "A Boring Reflection of a Secret Agent And a Astronaut who must Face a Composer in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "83 min", "rating" : "NC-17", "actors" : ["WOODY HOFFMAN", "SUSAN DAVIS", "KIM ALLEN", "OLYMPIA PFEIFFER", "MATTHEW CARREY", "RENEE BALL"]}'),
('{ "_id" : "de2d5c2edee149a39e540ab1a53d3295", "title" : "NOON PAPI", "description" : "A Unbelieveable Character Study of a Mad Scientist And a Astronaut who must Find a Pioneer in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "57 min", "rating" : "G", "actors" : ["CUBA OLIVIER", "MILLA KEITEL", "ADAM HOPPER", "VIVIEN BASINGER", "LAURENCE BULLOCK", "WILL WILSON"]}'),
('{ "_id" : "77147cda65a04c12bc464b6ba83678d2", "title" : "NORTH TEQUILA", "description" : "A Beautiful Character Study of a Mad Cow And a Robot who must Reach a Womanizer in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "67 min", "rating" : "NC-17", "actors" : ["GARY PHOENIX", "GARY PENN", "DARYL WAHLBERG", "LUCILLE DEE", "MINNIE KILMER"]}'),
('{ "_id" : "bb9561d5d82540b1b95917971aa95d22", "title" : "NORTHWEST POLISH", "description" : "A Boring Character Study of a Boy And a A Shark who must Outrace a Womanizer in The Outback", "release_year" : "2006", "language" : "English", "duration" : "172 min", "rating" : "PG", "actors" : ["MICHELLE MCCONAUGHEY", "MAE HOFFMAN", "RITA REYNOLDS", "LAURENCE BULLOCK", "JEFF SILVERSTONE", "CUBA BIRCH", "REESE WEST", "MARY KEITEL"]}'),
('{ "_id" : "1eb69ea7a5534033ba7dc01b0fe3827f", "title" : "NOTORIOUS REUNION", "description" : "A Amazing Epistle of a Woman And a Squirrel who must Fight a Hunter in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "128 min", "rating" : "NC-17", "actors" : ["KIM ALLEN", "JAYNE NOLTE"]}'),
('{ "_id" : "a51de6093c1e4fdfb58975befe243074", "title" : "NOTTING SPEAKEASY", "description" : "A Thoughtful Display of a Butler And a Womanizer who must Find a Waitress in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "48 min", "rating" : "PG-13", "actors" : ["MINNIE ZELLWEGER", "IAN TANDY"]}'),
('{ "_id" : "ef423938de9648d890395967542b85f7", "title" : "NOVOCAINE FLIGHT", "description" : "A Fanciful Display of a Student And a Teacher who must Outgun a Crocodile in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "64 min", "rating" : "G", "actors" : ["KARL BERRY", "BEN WILLIS", "GREG CHAPLIN", "WALTER TORN", "RUSSELL TEMPLE", "MICHAEL BOLGER"]}'),
('{ "_id" : "e97447c676054d65aca2f3b4f246b257", "title" : "NUTS TIES", "description" : "A Thoughtful Drama of a Explorer And a Womanizer who must Meet a Teacher in California", "release_year" : "2006", "language" : "English", "duration" : "145 min", "rating" : "NC-17", "actors" : ["NATALIE HOPKINS", "CHRISTIAN AKROYD"]}'),
('{ "_id" : "1410e56351074e00b48dabb1377925ec", "title" : "OCTOBER SUBMARINE", "description" : "A Taut Epistle of a Monkey And a Boy who must Confront a Husband in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "54 min", "rating" : "PG-13", "actors" : ["GRACE MOSTEL", "CAMERON WRAY", "SEAN GUINESS", "LIZA BERGMAN", "EMILY DEE"]}'),
('{ "_id" : "1f3c6cafe21f4901aaf6a16ac0e1a0c1", "title" : "ODDS BOOGIE", "description" : "A Thrilling Yarn of a Feminist And a Madman who must Battle a Hunter in Berlin", "release_year" : "2006", "language" : "English", "duration" : "48 min", "rating" : "NC-17", "actors" : ["ELVIS MARX", "MAE HOFFMAN", "CHRIS BRIDGES", "GEOFFREY HESTON", "KENNETH HOFFMAN"]}'),
('{ "_id" : "80b30b9f1aac492bbacf40d6adfecf6c", "title" : "OKLAHOMA JUMANJI", "description" : "A Thoughtful Drama of a Dentist And a Womanizer who must Meet a Husband in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "58 min", "rating" : "PG", "actors" : ["PENELOPE GUINESS", "JENNIFER DAVIS", "KARL BERRY", "CUBA OLIVIER", "RIP CRAWFORD", "CHRISTIAN AKROYD", "CARY MCCONAUGHEY", "RICHARD PENN", "BELA WALKEN"]}'),
('{ "_id" : "ed8d35b635e24726adaa166aa8c5f645", "title" : "OLEANDER CLUE", "description" : "A Boring Story of a Teacher And a Monkey who must Succumb a Forensic Psychologist in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "161 min", "rating" : "PG", "actors" : ["ZERO CAGE", "SANDRA KILMER", "PENELOPE PINKETT", "SEAN WILLIAMS", "GREG CHAPLIN", "JIM MOSTEL", "WARREN JACKMAN", "EWAN GOODING", "OPRAH KILMER", "RUSSELL CLOSE"]}'),
('{ "_id" : "466d1eac654646a88a2bf503036ac247", "title" : "OPEN AFRICAN", "description" : "A Lacklusture Drama of a Secret Agent And a Explorer who must Discover a Car in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "131 min", "rating" : "PG", "actors" : ["GRACE MOSTEL", "JULIA MCQUEEN", "SISSY SOBIESKI", "JUDE CRUISE", "MILLA KEITEL", "GINA DEGENERES", "ADAM HOPPER", "VIVIEN BASINGER", "JULIA ZELLWEGER"]}'),
('{ "_id" : "0f29212d14f24a06bff79fbbe4ea097d", "title" : "OPERATION OPERATION", "description" : "A Intrepid Character Study of a Man And a Frisbee who must Overcome a Madman in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "156 min", "rating" : "G", "actors" : ["CHRISTIAN AKROYD", "ADAM GRANT", "GREGORY GOODING"]}'),
('{ "_id" : "e9429c7801e645b7ae36e9add47ed2df", "title" : "OPPOSITE NECKLACE", "description" : "A Fateful Epistle of a Crocodile And a Moose who must Kill a Explorer in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "92 min", "rating" : "PG", "actors" : ["CHRISTIAN NEESON", "MATTHEW LEIGH", "GROUCHO DUNST", "LUCILLE DEE", "GROUCHO WILLIAMS", "DEBBIE AKROYD"]}'),
('{ "_id" : "0e1ec134b4df46ba9ac4116f4ccf0060", "title" : "OPUS ICE", "description" : "A Fast-Paced Drama of a Hunter And a Boy who must Discover a Feminist in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "102 min", "rating" : "R", "actors" : ["SEAN WILLIAMS", "DARYL CRAWFORD", "HUMPHREY GARLAND", "JULIA FAWCETT"]}'),
('{ "_id" : "e6f0e126488f49278fddb9df8f100ba6", "title" : "ORANGE GRAPES", "description" : "A Astounding Documentary of a Butler And a Womanizer who must Face a Dog in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "76 min", "rating" : "PG-13", "actors" : ["MEG HAWKE", "CUBA ALLEN", "PENELOPE MONROE", "KEVIN GARLAND", "KIM ALLEN"]}'),
('{ "_id" : "5bdc9998f598484daf374edd6c51ab8b", "title" : "ORDER BETRAYED", "description" : "A Amazing Saga of a Dog And a A Shark who must Challenge a Cat in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "120 min", "rating" : "PG-13", "actors" : ["ANGELINA ASTAIRE", "SPENCER DEPP", "MORGAN HOPKINS", "PENELOPE MONROE", "GRETA MALDEN", "KENNETH HOFFMAN", "HUMPHREY GARLAND"]}'),
('{ "_id" : "75d7e74b3b8440afb3ea784ed89ef4d1", "title" : "ORIENT CLOSER", "description" : "A Astounding Epistle of a Technical Writer And a Teacher who must Fight a Squirrel in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "118 min", "rating" : "R", "actors" : ["LUCILLE TRACY", "SCARLETT DAMON", "MATTHEW LEIGH", "CAMERON ZELLWEGER"]}'),
('{ "_id" : "007707f091cb453798144029df14d89b", "title" : "OSCAR GOLD", "description" : "A Insightful Tale of a Database Administrator And a Dog who must Face a Madman in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "115 min", "rating" : "PG", "actors" : ["BOB FAWCETT", "RIP CRAWFORD", "DUSTIN TAUTOU", "ELLEN PRESLEY", "HARVEY HOPE", "AL GARLAND"]}'),
('{ "_id" : "fc4902f4c0204d618da2a376d2a7d93a", "title" : "OTHERS SOUP", "description" : "A Lacklusture Documentary of a Mad Cow And a Madman who must Sink a Moose in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "118 min", "rating" : "PG", "actors" : ["FRANCES DAY-LEWIS", "NATALIE HOPKINS", "BURT POSEY", "OLYMPIA PFEIFFER"]}'),
('{ "_id" : "1ccad1fd81054c8d8837161a1974f681", "title" : "OUTBREAK DIVINE", "description" : "A Unbelieveable Yarn of a Database Administrator And a Woman who must Succumb a A Shark in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "169 min", "rating" : "NC-17", "actors" : ["ALEC WAYNE", "RAY JOHANSSON", "MAE HOFFMAN", "JAMES PITT", "FAY WOOD"]}'),
('{ "_id" : "3f9babaa1e3949ec96dfa0aaa209ec81", "title" : "OUTFIELD MASSACRE", "description" : "A Thoughtful Drama of a Husband And a Secret Agent who must Pursue a Database Administrator in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "129 min", "rating" : "NC-17", "actors" : ["DAN STREEP", "JANE JACKMAN", "WHOOPI HURT", "JAYNE NOLTE"]}'),
('{ "_id" : "62cf9faecfe5465a901ac3f487555f7a", "title" : "OUTLAW HANKY", "description" : "A Thoughtful Story of a Astronaut And a Composer who must Conquer a Dog in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "148 min", "rating" : "PG-13", "actors" : ["ELVIS MARX", "GOLDIE BRODY", "TOM MIRANDA", "CHRISTIAN NEESON", "ANGELINA ASTAIRE", "WARREN NOLTE", "JULIA ZELLWEGER"]}'),
('{ "_id" : "8b91b191601c4496bab2335dd41a6df6", "title" : "OZ LIAISONS", "description" : "A Epic Yarn of a Mad Scientist And a Cat who must Confront a Womanizer in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "R", "actors" : ["SANDRA KILMER", "PENELOPE PINKETT", "CHRISTIAN NEESON", "SIDNEY CROWE", "WARREN JACKMAN", "SALMA NOLTE", "ED MANSFIELD", "FAY WINSLET", "GROUCHO WILLIAMS", "GENE MCKELLEN", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "2187a4e9f46c4ec597685f3b857f0ecc", "title" : "PACIFIC AMISTAD", "description" : "A Thrilling Yarn of a Dog And a Moose who must Kill a Pastry Chef in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "144 min", "rating" : "G", "actors" : ["JOHNNY LOLLOBRIGIDA", "JOE SWANK", "DUSTIN TAUTOU", "ANGELINA ASTAIRE", "SUSAN DAVIS", "CATE MCQUEEN", "ED GUINESS", "HUMPHREY GARLAND"]}'),
('{ "_id" : "d390ff024a274825921fbd3c5986ebea", "title" : "PACKER MADIGAN", "description" : "A Epic Display of a Sumo Wrestler And a Forensic Psychologist who must Build a Woman in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "84 min", "rating" : "PG-13", "actors" : ["TIM HACKMAN"]}'),
('{ "_id" : "4a5130d69d434101bd4f0b3c29af1e74", "title" : "PAJAMA JAWBREAKER", "description" : "A Emotional Drama of a Boy And a Technical Writer who must Redeem a Sumo Wrestler in California", "release_year" : "2006", "language" : "English", "duration" : "126 min", "rating" : "R", "actors" : ["LUCILLE TRACY", "WOODY HOFFMAN", "WARREN NOLTE", "RICHARD PENN", "WILL WILSON"]}'),
('{ "_id" : "728ca2f8a7914e14a86c000a1aa20482", "title" : "PANIC CLUB", "description" : "A Fanciful Display of a Teacher And a Crocodile who must Succumb a Girl in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "102 min", "rating" : "G", "actors" : ["CAMERON STREEP", "DAN STREEP", "HARVEY HOPE"]}'),
('{ "_id" : "de3c8651424a467e90ffbf2de449f2b3", "title" : "PANKY SUBMARINE", "description" : "A Touching Documentary of a Dentist And a Sumo Wrestler who must Overcome a Boy in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "93 min", "rating" : "G", "actors" : ["RIP WINSLET", "MICHELLE MCCONAUGHEY", "SPENCER PECK", "GROUCHO DUNST", "RUSSELL BACALL", "LIZA BERGMAN", "SALMA NOLTE", "JULIA ZELLWEGER"]}'),
('{ "_id" : "c2206e6c66ce4f1cbb44abc2182dbadc", "title" : "PANTHER REDS", "description" : "A Brilliant Panorama of a Moose And a Man who must Reach a Teacher in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "109 min", "rating" : "NC-17", "actors" : ["BEN WILLIS", "SUSAN DAVIS", "WARREN NOLTE", "GENE HOPKINS", "HARVEY HOPE"]}'),
('{ "_id" : "08d1527431304c1ea3b5b35ef97466d0", "title" : "PAPI NECKLACE", "description" : "A Fanciful Display of a Car And a Monkey who must Escape a Squirrel in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "128 min", "rating" : "PG", "actors" : ["MEG HAWKE", "MORGAN HOPKINS", "CUBA ALLEN"]}'),
('{ "_id" : "6f4100238efd4605b9aeeb81afec5506", "title" : "PARADISE SABRINA", "description" : "A Intrepid Yarn of a Car And a Moose who must Outrace a Crocodile in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "48 min", "rating" : "PG-13", "actors" : ["JODIE DEGENERES", "PENELOPE CRONYN", "SYLVESTER DERN", "JEFF SILVERSTONE"]}'),
('{ "_id" : "b8103d0ff8b24c308b06d09c035578c1", "title" : "PARIS WEEKEND", "description" : "A Intrepid Story of a Squirrel And a Crocodile who must Defeat a Monkey in The Outback", "release_year" : "2006", "language" : "English", "duration" : "121 min", "rating" : "PG-13", "actors" : ["PENELOPE PINKETT", "HENRY BERRY", "ANGELA HUDSON", "LIZA BERGMAN", "GEOFFREY HESTON", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "fd657e7bcdfd443fa75a910e11006cf9", "title" : "PARK CITIZEN", "description" : "A Taut Epistle of a Sumo Wrestler And a Girl who must Face a Husband in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "109 min", "rating" : "PG-13", "actors" : ["GROUCHO DUNST", "PENELOPE MONROE", "RIVER DEAN", "OPRAH KILMER", "AL GARLAND", "MICHAEL BENING"]}'),
('{ "_id" : "56690c8cbe114051a450627bd3bca320", "title" : "PARTY KNOCK", "description" : "A Fateful Display of a Technical Writer And a Butler who must Battle a Sumo Wrestler in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "107 min", "rating" : "PG", "actors" : ["RIVER DEAN", "CHRIS DEPP"]}'),
('{ "_id" : "9f49b4a7b8ac4b589db3bfd684198b09", "title" : "PAST SUICIDES", "description" : "A Intrepid Tale of a Madman And a Astronaut who must Challenge a Hunter in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "157 min", "rating" : "PG-13", "actors" : ["GENE WILLIS", "HARRISON BALE", "KIM ALLEN", "GRETA MALDEN", "GROUCHO WILLIAMS", "HUMPHREY GARLAND"]}'),
('{ "_id" : "ca530f2410934087814aa475e5d7f951", "title" : "PATHS CONTROL", "description" : "A Astounding Documentary of a Butler And a Cat who must Find a Frisbee in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "118 min", "rating" : "PG", "actors" : ["VAL BOLGER", "ANNE CRONYN", "KIRSTEN AKROYD", "SUSAN DAVIS", "ROCK DUKAKIS"]}'),
('{ "_id" : "dc275457e22049149ba6ac0b8542019e", "title" : "PATIENT SISTER", "description" : "A Emotional Epistle of a Squirrel And a Robot who must Confront a Lumberjack in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "99 min", "rating" : "NC-17", "actors" : ["LUCILLE TRACY", "VAL BOLGER", "MILLA KEITEL", "SEAN GUINESS"]}'),
('{ "_id" : "04cfcdda0dc54eb7be577704c572d515", "title" : "PATRIOT ROMAN", "description" : "A Taut Saga of a Robot And a Database Administrator who must Challenge a Astronaut in California", "release_year" : "2006", "language" : "English", "duration" : "65 min", "rating" : "PG", "actors" : ["CARMEN HUNT", "ALBERT NOLTE", "KIM ALLEN", "RENEE BALL"]}'),
('{ "_id" : "14057263ba594a478d6f99bc29841241", "title" : "PATTON INTERVIEW", "description" : "A Thrilling Documentary of a Composer And a Secret Agent who must Succumb a Cat in Berlin", "release_year" : "2006", "language" : "English", "duration" : "175 min", "rating" : "PG", "actors" : ["JOHNNY LOLLOBRIGIDA", "TOM MIRANDA", "HENRY BERRY", "RIP WINSLET", "SEAN WILLIAMS", "CATE MCQUEEN", "WHOOPI HURT", "GEOFFREY HESTON", "MICHAEL BOLGER"]}'),
('{ "_id" : "5c1e1e788c6448ddbffc94b9f245f131", "title" : "PAYCHECK WAIT", "description" : "A Awe-Inspiring Reflection of a Boy And a Man who must Discover a Moose in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "145 min", "rating" : "PG-13", "actors" : ["GARY PENN", "RUSSELL BACALL", "LIZA BERGMAN"]}'),
('{ "_id" : "b9445a55eb9741819389f15b339fd12b", "title" : "PEACH INNOCENT", "description" : "A Action-Packed Drama of a Monkey And a Dentist who must Chase a Butler in Berlin", "release_year" : "2006", "language" : "English", "duration" : "160 min", "rating" : "PG-13", "actors" : ["TIM HACKMAN", "MILLA PECK", "GARY PENN", "BURT POSEY", "GROUCHO WILLIAMS"]}'),
('{ "_id" : "58df5eae98174917846cb0b1bd57faae", "title" : "PEAK FOREVER", "description" : "A Insightful Reflection of a Boat And a Secret Agent who must Vanquish a Astronaut in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "80 min", "rating" : "PG", "actors" : ["AUDREY OLIVIER", "KENNETH PESCI", "ANGELA WITHERSPOON", "DEBBIE AKROYD", "GREGORY GOODING"]}'),
('{ "_id" : "91dc0df11ab34194a054c0c174930c3a", "title" : "PEARL DESTINY", "description" : "A Lacklusture Yarn of a Astronaut And a Pastry Chef who must Sink a Dog in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "74 min", "rating" : "NC-17", "actors" : ["TIM HACKMAN", "CAMERON ZELLWEGER", "DARYL CRAWFORD", "HARVEY HOPE"]}'),
('{ "_id" : "0b6fbe408a8f48bba422cfc1aa030d87", "title" : "PELICAN COMFORTS", "description" : "A Epic Documentary of a Boy And a Monkey who must Pursue a Astronaut in Berlin", "release_year" : "2006", "language" : "English", "duration" : "48 min", "rating" : "PG", "actors" : ["BOB FAWCETT", "JULIA BARRYMORE", "GROUCHO SINATRA", "WHOOPI HURT", "RUSSELL TEMPLE"]}'),
('{ "_id" : "a67324298f7f424a96a625c0085dd149", "title" : "PERDITION FARGO", "description" : "A Fast-Paced Story of a Car And a Cat who must Outgun a Hunter in Berlin", "release_year" : "2006", "language" : "English", "duration" : "99 min", "rating" : "NC-17", "actors" : ["JOE SWANK", "RIP WINSLET", "HARRISON BALE", "CATE MCQUEEN", "RENEE BALL"]}'),
('{ "_id" : "d21ea05f16964c5eb45cb6d12a96f0ca", "title" : "PERFECT GROOVE", "description" : "A Thrilling Yarn of a Dog And a Dog who must Build a Husband in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "82 min", "rating" : "PG-13", "actors" : ["KARL BERRY", "NATALIE HOPKINS", "BEN WILLIS", "JIM MOSTEL", "JAYNE NOLTE", "LAURENCE BULLOCK"]}'),
('{ "_id" : "2dcb53df83a447648cf5bd324fc6035a", "title" : "PERSONAL LADYBUGS", "description" : "A Epic Saga of a Hunter And a Technical Writer who must Conquer a Cat in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "118 min", "rating" : "PG-13", "actors" : ["BOB FAWCETT", "SANDRA KILMER", "TOM MIRANDA", "WARREN NOLTE", "SALMA NOLTE", "CATE HARRIS", "HUMPHREY WILLIS", "KENNETH HOFFMAN", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "bf39397338f1489487930808c0e53cc5", "title" : "PET HAUNTING", "description" : "A Unbelieveable Reflection of a Explorer And a Boat who must Conquer a Woman in California", "release_year" : "2006", "language" : "English", "duration" : "99 min", "rating" : "PG", "actors" : ["JODIE DEGENERES", "GROUCHO SINATRA", "MORGAN HOPKINS", "BEN HARRIS", "LAURA BRODY", "NICK DEGENERES", "JOHN SUVARI"]}'),
('{ "_id" : "053a75c26cff4e3785bc6642f786390a", "title" : "PHANTOM GLORY", "description" : "A Beautiful Documentary of a Astronaut And a Crocodile who must Discover a Madman in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "60 min", "rating" : "NC-17", "actors" : ["CARMEN HUNT", "GROUCHO DUNST"]}'),
('{ "_id" : "94af27d4484343219b37599f2ee59f07", "title" : "PHILADELPHIA WIFE", "description" : "A Taut Yarn of a Hunter And a Astronaut who must Conquer a Database Administrator in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "137 min", "rating" : "PG-13", "actors" : ["MARY TANDY", "SEAN GUINESS"]}'),
('{ "_id" : "152effc6fbc44dd4bc117d544e0b1533", "title" : "PIANIST OUTFIELD", "description" : "A Intrepid Story of a Boy And a Technical Writer who must Pursue a Lumberjack in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "136 min", "rating" : "NC-17", "actors" : ["PENELOPE CRONYN", "MICHAEL BENING", "DEBBIE AKROYD", "JOHN SUVARI", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "765230d10efa414996a80400bc248417", "title" : "PICKUP DRIVING", "description" : "A Touching Documentary of a Husband And a Boat who must Meet a Pastry Chef in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "77 min", "rating" : "G", "actors" : ["JODIE DEGENERES", "GARY PHOENIX", "MINNIE ZELLWEGER", "ELLEN PRESLEY", "WILL WILSON"]}'),
('{ "_id" : "ba058f6d11f44b5cb11387f55b2a6175", "title" : "PILOT HOOSIERS", "description" : "A Awe-Inspiring Reflection of a Crocodile And a Sumo Wrestler who must Meet a Forensic Psychologist in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "50 min", "rating" : "PG", "actors" : ["JULIA MCQUEEN", "WOODY HOFFMAN", "HENRY BERRY", "SPENCER PECK", "CAMERON ZELLWEGER", "DEBBIE AKROYD", "AUDREY BAILEY"]}'),
('{ "_id" : "0218da07dd51490a85741d3e8456950e", "title" : "PINOCCHIO SIMON", "description" : "A Action-Packed Reflection of a Mad Scientist And a A Shark who must Find a Feminist in California", "release_year" : "2006", "language" : "English", "duration" : "103 min", "rating" : "PG", "actors" : ["KIRSTEN PALTROW", "REESE KILMER", "RALPH CRUZ", "ELLEN PRESLEY", "CAMERON ZELLWEGER", "MORGAN HOPKINS", "RIVER DEAN", "BEN HARRIS", "MERYL GIBSON", "LAURA BRODY", "JOHN SUVARI"]}'),
('{ "_id" : "e814d9a6e04141eba73b57357c6e7c0d", "title" : "PIRATES ROXANNE", "description" : "A Stunning Drama of a Woman And a Lumberjack who must Overcome a A Shark in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "100 min", "rating" : "PG", "actors" : ["HUMPHREY WILLIS"]}'),
('{ "_id" : "c9869ddf448845c795ae0c59026018c6", "title" : "PITTSBURGH HUNCHBACK", "description" : "A Thrilling Epistle of a Boy And a Boat who must Find a Student in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "134 min", "rating" : "PG-13", "actors" : ["RIP CRAWFORD", "JULIA MCQUEEN", "PENELOPE MONROE", "AUDREY BAILEY", "JOHN SUVARI"]}'),
('{ "_id" : "55d99349815f4362b621608aeeabb5ec", "title" : "PITY BOUND", "description" : "A Boring Panorama of a Feminist And a Moose who must Defeat a Database Administrator in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "60 min", "rating" : "NC-17", "actors" : ["GOLDIE BRODY", "ANGELA HUDSON", "ALBERT NOLTE", "GENE HOPKINS", "GENE MCKELLEN"]}'),
('{ "_id" : "ac2198f481c5430a8b1bf81e48496404", "title" : "PIZZA JUMANJI", "description" : "A Epic Saga of a Cat And a Squirrel who must Outgun a Robot in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "173 min", "rating" : "NC-17", "actors" : ["DARYL CRAWFORD", "HARVEY HOPE", "GENE MCKELLEN", "HUMPHREY GARLAND", "BELA WALKEN"]}'),
('{ "_id" : "1aa812100cd34926b252a7e57df6e638", "title" : "PLATOON INSTINCT", "description" : "A Thrilling Panorama of a Man And a Woman who must Reach a Woman in Australia", "release_year" : "2006", "language" : "English", "duration" : "132 min", "rating" : "PG-13", "actors" : ["ED CHASE", "JUDE CRUISE", "FRANCES TOMEI", "RUSSELL TEMPLE", "WILL WILSON"]}'),
('{ "_id" : "d2bd595d4cb841d4a622837b3cfbe0db", "title" : "PLUTO OLEANDER", "description" : "A Action-Packed Reflection of a Car And a Moose who must Outgun a Car in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "84 min", "rating" : "R", "actors" : ["KIRSTEN PALTROW", "BEN WILLIS", "KIRSTEN AKROYD", "CHRIS BRIDGES", "SIDNEY CROWE", "HARRISON BALE", "ED MANSFIELD"]}'),
('{ "_id" : "5b4ac319b1f04323aa0d2fe302754286", "title" : "POCUS PULP", "description" : "A Intrepid Yarn of a Frisbee And a Dog who must Build a Astronaut in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "138 min", "rating" : "NC-17", "actors" : ["JOHNNY LOLLOBRIGIDA", "TOM MIRANDA", "RALPH CRUZ", "GROUCHO DUNST", "RIVER DEAN"]}'),
('{ "_id" : "aca0bb440a794d33bc75b2911ea4a3d8", "title" : "POLISH BROOKLYN", "description" : "A Boring Character Study of a Database Administrator And a Lumberjack who must Reach a Madman in The Outback", "release_year" : "2006", "language" : "English", "duration" : "61 min", "rating" : "PG", "actors" : ["VIVIEN BERGEN", "ELVIS MARX", "KEVIN BLOOM", "RIP CRAWFORD", "JAYNE NEESON", "RALPH CRUZ", "MORGAN WILLIAMS", "FAY WINSLET", "IAN TANDY", "ALAN DREYFUSS"]}'),
('{ "_id" : "43a50629994743d4bc1eda7050167441", "title" : "POLLOCK DELIVERANCE", "description" : "A Intrepid Story of a Madman And a Frisbee who must Outgun a Boat in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "137 min", "rating" : "PG", "actors" : ["GOLDIE BRODY", "CARMEN HUNT", "DUSTIN TAUTOU", "GROUCHO SINATRA", "BURT TEMPLE", "JULIA FAWCETT"]}'),
('{ "_id" : "e1e99252d99145a9b2951cb9ca8c8d57", "title" : "POND SEATTLE", "description" : "A Stunning Drama of a Teacher And a Boat who must Battle a Feminist in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "185 min", "rating" : "PG-13", "actors" : ["DARYL WAHLBERG", "GENE HOPKINS", "RIVER DEAN"]}'),
('{ "_id" : "591fb380545d4657bd1eb504b27cb06e", "title" : "POSEIDON FOREVER", "description" : "A Thoughtful Epistle of a Womanizer And a Monkey who must Vanquish a Dentist in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "159 min", "rating" : "PG-13", "actors" : ["JENNIFER DAVIS", "GRACE MOSTEL", "SANDRA KILMER", "PENELOPE MONROE", "EWAN GOODING", "REESE WEST"]}'),
('{ "_id" : "2570161e3f0c46a380b4d4f397e24766", "title" : "POTLUCK MIXED", "description" : "A Beautiful Story of a Dog And a Technical Writer who must Outgun a Student in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "179 min", "rating" : "G", "actors" : ["BETTE NICHOLSON", "SCARLETT DAMON", "MATTHEW LEIGH", "KIM ALLEN", "LAURENCE BULLOCK", "GREGORY GOODING"]}'),
('{ "_id" : "9fc7dee911de4dbcb836495befe970aa", "title" : "POTTER CONNECTICUT", "description" : "A Thrilling Epistle of a Frisbee And a Cat who must Fight a Technical Writer in Berlin", "release_year" : "2006", "language" : "English", "duration" : "115 min", "rating" : "PG", "actors" : ["WARREN NOLTE", "WARREN JACKMAN", "CATE MCQUEEN", "JANE JACKMAN", "WHOOPI HURT", "AL GARLAND", "AUDREY BAILEY"]}'),
('{ "_id" : "a8d31a8512664949ac0111c47e5c97cb", "title" : "PREJUDICE OLEANDER", "description" : "A Epic Saga of a Boy And a Dentist who must Outrace a Madman in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "98 min", "rating" : "PG-13", "actors" : ["CHRISTIAN GABLE", "MILLA PECK", "VAL BOLGER", "DUSTIN TAUTOU", "RAY JOHANSSON", "ANGELA HUDSON", "CARY MCCONAUGHEY", "SYLVESTER DERN", "KENNETH HOFFMAN", "MICHAEL BOLGER"]}'),
('{ "_id" : "75599261900e4faeafeb8856b087b6e4", "title" : "PRESIDENT BANG", "description" : "A Fateful Panorama of a Technical Writer And a Moose who must Battle a Robot in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "144 min", "rating" : "PG", "actors" : ["JULIA MCQUEEN", "CUBA ALLEN", "LUCILLE DEE", "DEBBIE AKROYD", "AUDREY BAILEY"]}'),
('{ "_id" : "5923a151a0294f959970c343bb6531a0", "title" : "PRIDE ALAMO", "description" : "A Thoughtful Drama of a A Shark And a Forensic Psychologist who must Vanquish a Student in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "114 min", "rating" : "NC-17", "actors" : ["GOLDIE BRODY", "WARREN NOLTE", "CATE MCQUEEN", "GRETA MALDEN"]}'),
('{ "_id" : "83cad2bae56b4a4baed1b3b503f48543", "title" : "PRIMARY GLASS", "description" : "A Fateful Documentary of a Pastry Chef And a Butler who must Build a Dog in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "53 min", "rating" : "G", "actors" : ["JOE SWANK", "KEVIN BLOOM", "VAL BOLGER", "MENA TEMPLE", "MARY TANDY", "CHARLIZE DENCH", "JAYNE NOLTE"]}'),
('{ "_id" : "ff0d2d47d1254a2181670cfa96ede5c3", "title" : "PRINCESS GIANT", "description" : "A Thrilling Yarn of a Pastry Chef And a Monkey who must Battle a Monkey in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "71 min", "rating" : "NC-17", "actors" : ["CHRISTIAN AKROYD", "ADAM HOPPER", "MERYL GIBSON", "HUMPHREY WILLIS", "ED GUINESS"]}'),
('{ "_id" : "5bdfc4320a03419f84ef7a81ebea4d7f", "title" : "PRIVATE DROP", "description" : "A Stunning Story of a Technical Writer And a Hunter who must Succumb a Secret Agent in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "106 min", "rating" : "PG", "actors" : ["NICK STALLONE", "KIRSTEN AKROYD", "ELLEN PRESLEY", "CAMERON ZELLWEGER", "JON CHASE"]}'),
('{ "_id" : "023205238cc647c8ac8c2c0f4fede0ca", "title" : "PRIX UNDEFEATED", "description" : "A Stunning Saga of a Mad Scientist And a Boat who must Overcome a Dentist in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "115 min", "rating" : "R", "actors" : ["KIRSTEN PALTROW", "SISSY SOBIESKI", "GOLDIE BRODY", "SUSAN DAVIS", "SYLVESTER DERN", "RUSSELL BACALL", "MORGAN HOPKINS"]}'),
('{ "_id" : "d9ca24ee544b4b3590e3ad8e8a079f72", "title" : "PSYCHO SHRUNK", "description" : "A Amazing Panorama of a Crocodile And a Explorer who must Fight a Husband in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "155 min", "rating" : "PG-13", "actors" : ["OLYMPIA PFEIFFER"]}'),
('{ "_id" : "cc3dcb35d4374e66b04b22fe92035843", "title" : "PULP BEVERLY", "description" : "A Unbelieveable Display of a Dog And a Crocodile who must Outrace a Man in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "89 min", "rating" : "G", "actors" : ["KIRSTEN PALTROW", "DUSTIN TAUTOU", "SUSAN DAVIS", "WARREN NOLTE", "GRETA KEITEL", "WHOOPI HURT", "ANGELA WITHERSPOON"]}'),
('{ "_id" : "3059c265ad4c489ba8340cad35858986", "title" : "PUNK DIVORCE", "description" : "A Fast-Paced Tale of a Pastry Chef And a Boat who must Face a Frisbee in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "100 min", "rating" : "PG", "actors" : ["CHRISTIAN GABLE", "GOLDIE BRODY", "CHRISTIAN NEESON", "JAMES PITT", "HARRISON BALE", "MORGAN WILLIAMS", "GEOFFREY HESTON"]}'),
('{ "_id" : "9dbd498406064ad2b67e2b7d5936bece", "title" : "PURE RUNNER", "description" : "A Thoughtful Documentary of a Student And a Madman who must Challenge a Squirrel in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "121 min", "rating" : "NC-17", "actors" : ["CAMERON STREEP", "MILLA KEITEL"]}'),
('{ "_id" : "38226065b21d4c1faac9634f60e567a7", "title" : "PURPLE MOVIE", "description" : "A Boring Display of a Pastry Chef And a Sumo Wrestler who must Discover a Frisbee in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "88 min", "rating" : "R", "actors" : ["TOM MCKELLEN", "FRANCES DAY-LEWIS", "CHRIS BRIDGES", "DARYL CRAWFORD", "FAY WOOD", "MENA HOPPER", "MICHAEL BENING", "AUDREY BAILEY"]}'),
('{ "_id" : "edf5ae89b3ff4c2aa892802d52d69723", "title" : "QUEEN LUKE", "description" : "A Astounding Story of a Girl And a Boy who must Challenge a Composer in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "163 min", "rating" : "PG", "actors" : ["MARY TANDY", "RIP WINSLET", "SPENCER PECK", "EWAN GOODING", "RIVER DEAN", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "8351dc10a6a64872895b3e3ea0bf6289", "title" : "QUEST MUSSOLINI", "description" : "A Fateful Drama of a Husband And a Sumo Wrestler who must Battle a Pastry Chef in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "177 min", "rating" : "R", "actors" : ["JUDY DEAN", "JUDE CRUISE", "JAYNE NEESON", "GARY PENN", "RENEE TRACY"]}'),
('{ "_id" : "7907762e5b1545d3bbc0f781b329747d", "title" : "QUILLS BULL", "description" : "A Thoughtful Story of a Pioneer And a Woman who must Reach a Moose in Australia", "release_year" : "2006", "language" : "English", "duration" : "112 min", "rating" : "R", "actors" : ["FAY WINSLET", "LISA MONROE", "AUDREY BAILEY", "JOHN SUVARI"]}'),
('{ "_id" : "2c79684376764c31b7b80e8fb52e2d3d", "title" : "RACER EGG", "description" : "A Emotional Display of a Monkey And a Waitress who must Reach a Secret Agent in California", "release_year" : "2006", "language" : "English", "duration" : "147 min", "rating" : "NC-17", "actors" : ["ZERO CAGE", "ANNE CRONYN", "FAY KILMER", "ANGELINA ASTAIRE", "RALPH CRUZ", "BURT TEMPLE"]}'),
('{ "_id" : "244504f88989407e99fcbe7fc713d630", "title" : "RAGE GAMES", "description" : "A Fast-Paced Saga of a Astronaut And a Secret Agent who must Escape a Hunter in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "120 min", "rating" : "R", "actors" : ["SCARLETT DAMON", "CHRIS BRIDGES", "RENEE TRACY", "ALBERT NOLTE", "KEVIN GARLAND", "JADA RYDER", "GROUCHO WILLIAMS"]}'),
('{ "_id" : "400f450517d64b10a15ac43c03d4b0a9", "title" : "RAGING AIRPLANE", "description" : "A Astounding Display of a Secret Agent And a Technical Writer who must Escape a Mad Scientist in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "154 min", "rating" : "R", "actors" : ["BOB FAWCETT", "MINNIE ZELLWEGER", "JOHN SUVARI"]}'),
('{ "_id" : "e500be64c04c46308ec5c683454b4a2a", "title" : "RAIDERS ANTITRUST", "description" : "A Amazing Drama of a Teacher And a Feminist who must Meet a Woman in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "82 min", "rating" : "PG-13", "actors" : ["JENNIFER DAVIS", "MILLA PECK", "KIRSTEN AKROYD", "KENNETH TORN", "WALTER TORN", "JADA RYDER"]}'),
('{ "_id" : "5c2982d6c19d4aa98ae952a864e43cbe", "title" : "RAINBOW SHOCK", "description" : "A Action-Packed Story of a Hunter And a Boy who must Discover a Lumberjack in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "74 min", "rating" : "PG", "actors" : ["TOM MIRANDA", "DUSTIN TAUTOU", "KENNETH TORN", "JANE JACKMAN", "KIM ALLEN", "GRETA MALDEN"]}'),
('{ "_id" : "0c67652a78184ccf92b5a970724350e6", "title" : "RANDOM GO", "description" : "A Fateful Drama of a Frisbee And a Student who must Confront a Cat in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "73 min", "rating" : "NC-17", "actors" : ["JENNIFER DAVIS", "LUCILLE TRACY", "BURT DUKAKIS", "REESE KILMER", "CARMEN HUNT", "JUDE CRUISE", "ANGELA HUDSON", "SPENCER DEPP", "HARRISON BALE", "HARVEY HOPE", "NICK DEGENERES", "DEBBIE AKROYD", "THORA TEMPLE"]}'),
('{ "_id" : "f164cde167c240718520d5c3471018cc", "title" : "RANGE MOONWALKER", "description" : "A Insightful Documentary of a Hunter And a Dentist who must Confront a Crocodile in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "147 min", "rating" : "PG", "actors" : ["RIP CRAWFORD", "BURT DUKAKIS", "PENELOPE MONROE", "RUSSELL CLOSE"]}'),
('{ "_id" : "85f3f4fc67d548468ed8be4bc7539a27", "title" : "REAP UNFAITHFUL", "description" : "A Thrilling Epistle of a Composer And a Sumo Wrestler who must Challenge a Mad Cow in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "136 min", "rating" : "PG-13", "actors" : ["CHRISTIAN GABLE", "KARL BERRY", "BURT DUKAKIS", "ANNE CRONYN"]}'),
('{ "_id" : "1560ce3b051046b1aff3603c5468e411", "title" : "REAR TRADING", "description" : "A Awe-Inspiring Reflection of a Forensic Psychologist And a Secret Agent who must Succumb a Pastry Chef in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "97 min", "rating" : "NC-17", "actors" : ["FRED COSTNER", "DAN TORN", "LUCILLE TRACY", "NATALIE HOPKINS", "JUDE CRUISE", "KENNETH PESCI", "PENELOPE MONROE", "LAURENCE BULLOCK"]}'),
('{ "_id" : "bb13a6f251ec479f813de68aae6b0dea", "title" : "REBEL AIRPORT", "description" : "A Intrepid Yarn of a Database Administrator And a Boat who must Outrace a Husband in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "73 min", "rating" : "G", "actors" : ["UMA WOOD", "SEAN WILLIAMS", "SPENCER PECK", "SPENCER DEPP", "SALMA NOLTE", "EMILY DEE"]}'),
('{ "_id" : "b6446ef693e04f31b641b7bca1e93a22", "title" : "RECORDS ZORRO", "description" : "A Amazing Drama of a Mad Scientist And a Composer who must Build a Husband in The Outback", "release_year" : "2006", "language" : "English", "duration" : "182 min", "rating" : "PG", "actors" : ["JAYNE NEESON", "BEN WILLIS", "MORGAN HOPKINS", "RITA REYNOLDS", "EWAN GOODING", "CHRISTOPHER WEST", "WILLIAM HACKMAN", "MERYL ALLEN"]}'),
('{ "_id" : "ef7bc973fa8e4312b2054694c8cc5221", "title" : "REDEMPTION COMFORTS", "description" : "A Emotional Documentary of a Dentist And a Woman who must Battle a Mad Scientist in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "179 min", "rating" : "NC-17", "actors" : ["AUDREY OLIVIER", "KENNETH PALTROW", "MILLA KEITEL", "ALBERT JOHANSSON", "DEBBIE AKROYD"]}'),
('{ "_id" : "472035b11b7541138f3593b8b115ce61", "title" : "REDS POCUS", "description" : "A Lacklusture Yarn of a Sumo Wrestler And a Squirrel who must Redeem a Monkey in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "182 min", "rating" : "PG-13", "actors" : ["JENNIFER DAVIS", "JODIE DEGENERES", "SPENCER PECK", "CHRIS BRIDGES", "WARREN NOLTE"]}'),
('{ "_id" : "f03b65f1d07148a5a8e0ebe4425af2a5", "title" : "REEF SALUTE", "description" : "A Action-Packed Saga of a Teacher And a Lumberjack who must Battle a Dentist in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "123 min", "rating" : "NC-17", "actors" : ["JOE SWANK", "KENNETH PALTROW", "PENELOPE MONROE", "MICHAEL BENING"]}'),
('{ "_id" : "6b99e0e48ea24f2eaf3c9886f2787bb3", "title" : "REIGN GENTLEMEN", "description" : "A Emotional Yarn of a Composer And a Man who must Escape a Butler in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "82 min", "rating" : "PG-13", "actors" : ["ALEC WAYNE", "JOHNNY CAGE", "MORGAN HOPKINS"]}'),
('{ "_id" : "341f502fa17d426180c83c373ff9fc1e", "title" : "REMEMBER DIARY", "description" : "A Insightful Tale of a Technical Writer And a Waitress who must Conquer a Monkey in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "110 min", "rating" : "R", "actors" : ["JODIE DEGENERES", "KENNETH TORN", "JEFF SILVERSTONE", "REESE WEST"]}'),
('{ "_id" : "d2c27836a5c24f60bddd027cdf958ae4", "title" : "REQUIEM TYCOON", "description" : "A Unbelieveable Character Study of a Cat And a Database Administrator who must Pursue a Teacher in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "167 min", "rating" : "R", "actors" : ["ANNE CRONYN", "MENA TEMPLE", "MARY TANDY", "JESSICA BAILEY", "MICHELLE MCCONAUGHEY", "CHRIS BRIDGES", "JULIANNE DENCH", "GRETA KEITEL"]}'),
('{ "_id" : "c33fb41ae82b4d71b7379806413bf268", "title" : "RESERVOIR ADAPTATION", "description" : "A Intrepid Drama of a Teacher And a Moose who must Kill a Car in California", "release_year" : "2006", "language" : "English", "duration" : "61 min", "rating" : "PG-13", "actors" : ["CHRISTIAN AKROYD", "JESSICA BAILEY", "JIM MOSTEL", "MORGAN HOPKINS", "SCARLETT BENING", "KIM ALLEN", "JON CHASE", "GENE MCKELLEN"]}'),
('{ "_id" : "e4842873e8554ee8a6a2d44d49d25db9", "title" : "RESURRECTION SILVERADO", "description" : "A Epic Yarn of a Robot And a Explorer who must Challenge a Girl in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "117 min", "rating" : "PG", "actors" : ["MENA TEMPLE", "MAE HOFFMAN", "KEVIN GARLAND", "RICHARD PENN", "KENNETH HOFFMAN"]}'),
('{ "_id" : "13a61ed671724c09b1aaf0783ae59685", "title" : "REUNION WITCHES", "description" : "A Unbelieveable Documentary of a Database Administrator And a Frisbee who must Redeem a Mad Scientist in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "63 min", "rating" : "R", "actors" : ["KARL BERRY", "DAN HARRIS", "KIRSTEN AKROYD", "MEG HAWKE", "WALTER TORN", "RUSSELL BACALL", "JAYNE NOLTE"]}'),
('{ "_id" : "75aec3f6221a4b199375a90da73683bf", "title" : "RIDER CADDYSHACK", "description" : "A Taut Reflection of a Monkey And a Womanizer who must Chase a Moose in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "177 min", "rating" : "PG", "actors" : ["UMA WOOD", "ANNE CRONYN", "SCARLETT DAMON", "JAMES PITT", "WHOOPI HURT", "BEN HARRIS", "WILLIAM HACKMAN", "JEFF SILVERSTONE", "JULIA ZELLWEGER"]}'),
('{ "_id" : "847551e82dcf47b78d36b2dfcc928939", "title" : "RIDGEMONT SUBMARINE", "description" : "A Unbelieveable Drama of a Waitress And a Composer who must Sink a Mad Cow in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "46 min", "rating" : "PG-13", "actors" : ["JOHNNY LOLLOBRIGIDA", "JULIANNE DENCH", "WHOOPI HURT", "MICHAEL BOLGER", "JULIA FAWCETT"]}'),
('{ "_id" : "b7772b7ac6444bf78eb6507e93e85e5e", "title" : "RIGHT CRANES", "description" : "A Fateful Character Study of a Boat And a Cat who must Find a Database Administrator in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "153 min", "rating" : "PG-13", "actors" : ["ELVIS MARX", "BURT DUKAKIS", "PARKER GOLDBERG", "JESSICA BAILEY", "CAMERON ZELLWEGER", "WHOOPI HURT", "ALBERT JOHANSSON"]}'),
('{ "_id" : "74b01155638a422cba75da6377ccdd2f", "title" : "RINGS HEARTBREAKERS", "description" : "A Amazing Yarn of a Sumo Wrestler And a Boat who must Conquer a Waitress in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "58 min", "rating" : "G", "actors" : ["JOHNNY LOLLOBRIGIDA", "RIP CRAWFORD", "SANDRA PECK", "JUDY DEAN", "NATALIE HOPKINS", "SYLVESTER DERN", "CAMERON ZELLWEGER", "MORGAN HOPKINS", "MINNIE KILMER", "ED GUINESS", "JEFF SILVERSTONE"]}'),
('{ "_id" : "6392d65348df47a79afb6bbcd353fe34", "title" : "RIVER OUTLAW", "description" : "A Thrilling Character Study of a Squirrel And a Lumberjack who must Face a Hunter in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "149 min", "rating" : "PG-13", "actors" : ["KIRSTEN PALTROW", "GARY PHOENIX", "WARREN NOLTE", "LISA MONROE"]}'),
('{ "_id" : "f1fa99c444304b1e922f32ffe2bd6888", "title" : "ROAD ROXANNE", "description" : "A Boring Character Study of a Waitress And a Astronaut who must Fight a Crocodile in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "158 min", "rating" : "R", "actors" : ["HELEN VOIGHT", "KIRSTEN PALTROW", "JULIA BARRYMORE", "GARY PHOENIX", "CHRIS BRIDGES", "ALBERT JOHANSSON", "LAURENCE BULLOCK", "CUBA BIRCH"]}'),
('{ "_id" : "303c128f00ba4d468ebe0601f24de0d6", "title" : "ROBBERS JOON", "description" : "A Thoughtful Story of a Mad Scientist And a Waitress who must Confront a Forensic Psychologist in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "102 min", "rating" : "PG-13", "actors" : ["MILLA PECK", "ANGELA HUDSON", "MATTHEW LEIGH", "CUBA ALLEN", "JADA RYDER"]}'),
('{ "_id" : "a7c8027e98cc40209c21ffa7494b17f1", "title" : "ROBBERY BRIGHT", "description" : "A Taut Reflection of a Robot And a Squirrel who must Fight a Boat in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "134 min", "rating" : "R", "actors" : ["GOLDIE BRODY", "WHOOPI HURT"]}'),
('{ "_id" : "a2129c3b793f4833afeb95d7aca06e52", "title" : "ROCK INSTINCT", "description" : "A Astounding Character Study of a Robot And a Moose who must Overcome a Astronaut in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "102 min", "rating" : "G", "actors" : ["MILLA PECK", "JOHNNY CAGE", "JULIA BARRYMORE", "GARY PHOENIX", "JUDE CRUISE", "CAMERON ZELLWEGER", "AL GARLAND", "ED GUINESS"]}'),
('{ "_id" : "99024c9065744e0082f06af98a991295", "title" : "ROCKETEER MOTHER", "description" : "A Awe-Inspiring Character Study of a Robot And a Sumo Wrestler who must Discover a Womanizer in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "178 min", "rating" : "PG-13", "actors" : ["JUDY DEAN", "TOM MIRANDA", "CHRIS BRIDGES", "RENEE TRACY", "WARREN JACKMAN", "MERYL ALLEN", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "0cebb67386a44d3cb31ee70030da9083", "title" : "ROCKY WAR", "description" : "A Fast-Paced Display of a Squirrel And a Explorer who must Outgun a Mad Scientist in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "145 min", "rating" : "PG-13", "actors" : ["SISSY SOBIESKI", "PENELOPE CRONYN", "RENEE TRACY"]}'),
('{ "_id" : "d6c6f258dc714bf5a822f3634e6b7103", "title" : "ROLLERCOASTER BRINGING", "description" : "A Beautiful Drama of a Robot And a Lumberjack who must Discover a Technical Writer in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "153 min", "rating" : "PG-13", "actors" : ["HARRISON BALE", "CATE HARRIS", "JON CHASE"]}'),
('{ "_id" : "23cd57e889c8429589f6b7d010d3203d", "title" : "ROMAN PUNK", "description" : "A Thoughtful Panorama of a Mad Cow And a Student who must Battle a Forensic Psychologist in Berlin", "release_year" : "2006", "language" : "English", "duration" : "81 min", "rating" : "NC-17", "actors" : ["JIM MOSTEL", "WARREN NOLTE"]}'),
('{ "_id" : "65ff4d51772448c0b4298df14078abbe", "title" : "ROOF CHAMPION", "description" : "A Lacklusture Reflection of a Car And a Explorer who must Find a Monkey in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "101 min", "rating" : "R", "actors" : ["NICK WAHLBERG", "ELVIS MARX", "DAN STREEP", "SCARLETT BENING", "WHOOPI HURT"]}'),
('{ "_id" : "ecb70dbd016743bda2f93928b23f29e1", "title" : "ROOM ROMAN", "description" : "A Awe-Inspiring Panorama of a Composer And a Secret Agent who must Sink a Composer in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "60 min", "rating" : "PG", "actors" : ["WOODY HOFFMAN", "SEAN WILLIAMS"]}'),
('{ "_id" : "6efef204535d4388b40aa4f651da76d0", "title" : "ROOTS REMEMBER", "description" : "A Brilliant Drama of a Mad Cow And a Hunter who must Escape a Hunter in Berlin", "release_year" : "2006", "language" : "English", "duration" : "89 min", "rating" : "PG-13", "actors" : ["JOHNNY CAGE", "BURT POSEY", "ELLEN PRESLEY", "WALTER TORN", "WARREN NOLTE", "CAMERON ZELLWEGER", "EWAN GOODING", "GROUCHO WILLIAMS", "LISA MONROE", "MATTHEW CARREY"]}'),
('{ "_id" : "9b2d5c6722ae40939793ead015996d5a", "title" : "ROSES TREASURE", "description" : "A Astounding Panorama of a Monkey And a Secret Agent who must Defeat a Woman in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "162 min", "rating" : "PG-13", "actors" : ["CUBA OLIVIER", "MORGAN WILLIAMS", "HUMPHREY GARLAND", "BURT TEMPLE", "MARY KEITEL"]}'),
('{ "_id" : "0944d2c56da14134b795b5e3cab9e374", "title" : "ROUGE SQUAD", "description" : "A Awe-Inspiring Drama of a Astronaut And a Frisbee who must Conquer a Mad Scientist in Australia", "release_year" : "2006", "language" : "English", "duration" : "118 min", "rating" : "NC-17", "actors" : ["PENELOPE MONROE", "EWAN GOODING", "JON CHASE", "REESE WEST"]}'),
('{ "_id" : "6a8462be9c9548829038fc7276789044", "title" : "ROXANNE REBEL", "description" : "A Astounding Story of a Pastry Chef And a Database Administrator who must Fight a Man in The Outback", "release_year" : "2006", "language" : "English", "duration" : "171 min", "rating" : "R", "actors" : ["JOHNNY CAGE", "RIP WINSLET", "MILLA KEITEL", "LUCILLE DEE", "JOHN SUVARI"]}'),
('{ "_id" : "4df7adb8d83f4affaa40664dcd546d87", "title" : "RUGRATS SHAKESPEARE", "description" : "A Touching Saga of a Crocodile And a Crocodile who must Discover a Technical Writer in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "109 min", "rating" : "PG-13", "actors" : ["JUDY DEAN", "GARY PENN", "DARYL WAHLBERG", "MORGAN HOPKINS", "KIM ALLEN", "CUBA BIRCH"]}'),
('{ "_id" : "cddbe8c53ffc447db139cc8ce9f37e8f", "title" : "RULES HUMAN", "description" : "A Beautiful Epistle of a Astronaut And a Student who must Confront a Monkey in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "153 min", "rating" : "R", "actors" : ["PENELOPE GUINESS", "DUSTIN TAUTOU", "CARY MCCONAUGHEY", "KEVIN GARLAND", "HARVEY HOPE"]}'),
('{ "_id" : "88f11afbaa8c4c43930a63329b513d7a", "title" : "RUN PACIFIC", "description" : "A Touching Tale of a Cat And a Pastry Chef who must Conquer a Pastry Chef in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "145 min", "rating" : "R", "actors" : ["BOB FAWCETT", "GARY PHOENIX", "DAN HARRIS", "MAE HOFFMAN", "WOODY JOLIE", "SIDNEY CROWE"]}'),
('{ "_id" : "6c769c12928a44ffbd2eec20f13eb9c5", "title" : "RUNAWAY TENENBAUMS", "description" : "A Thoughtful Documentary of a Boat And a Man who must Meet a Boat in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "181 min", "rating" : "NC-17", "actors" : ["NICK STALLONE", "WARREN JACKMAN", "GENE MCKELLEN"]}'),
('{ "_id" : "3552ba126921499fb573b2a09732b7cb", "title" : "RUNNER MADIGAN", "description" : "A Thoughtful Documentary of a Crocodile And a Robot who must Outrace a Womanizer in The Outback", "release_year" : "2006", "language" : "English", "duration" : "101 min", "rating" : "NC-17", "actors" : ["MATTHEW JOHANSSON", "JOE SWANK", "BOB FAWCETT", "CHRISTIAN NEESON", "GREG CHAPLIN", "GROUCHO DUNST", "CATE HARRIS", "REESE WEST"]}'),
('{ "_id" : "12f09410d93940499a6af49a498fcd65", "title" : "RUSH GOODFELLAS", "description" : "A Emotional Display of a Man And a Dentist who must Challenge a Squirrel in Australia", "release_year" : "2006", "language" : "English", "duration" : "48 min", "rating" : "PG", "actors" : ["KIRK JOVOVICH", "MAE HOFFMAN", "SYLVESTER DERN", "ANGELA WITHERSPOON", "ALAN DREYFUSS"]}'),
('{ "_id" : "ae7c91b04c454e34a153f9b09a777aa3", "title" : "RUSHMORE MERMAID", "description" : "A Boring Story of a Woman And a Moose who must Reach a Husband in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "150 min", "rating" : "PG-13", "actors" : ["NICK WAHLBERG", "MILLA PECK", "JOHNNY CAGE", "PENELOPE PINKETT", "HENRY BERRY", "HARRISON BALE", "FAY WOOD"]}'),
('{ "_id" : "8c6dc6971021408ba8bc113c5f41e36a", "title" : "SABRINA MIDNIGHT", "description" : "A Emotional Story of a Squirrel And a Crocodile who must Succumb a Husband in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "99 min", "rating" : "PG", "actors" : ["KEVIN BLOOM", "CHRISTIAN AKROYD", "MEG HAWKE", "CHRIS DEPP"]}'),
('{ "_id" : "9706cd3a22414f2884219821f21ed5d8", "title" : "SADDLE ANTITRUST", "description" : "A Stunning Epistle of a Feminist And a A Shark who must Battle a Woman in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "80 min", "rating" : "PG-13", "actors" : ["BOB FAWCETT", "ADAM HOPPER", "MINNIE KILMER"]}'),
('{ "_id" : "911d5e8972f34d7cb7d93eb5e68632c4", "title" : "SAGEBRUSH CLUELESS", "description" : "A Insightful Story of a Lumberjack And a Hunter who must Kill a Boy in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "106 min", "rating" : "G", "actors" : ["LUCILLE TRACY", "FRANCES DAY-LEWIS", "SEAN WILLIAMS", "MEG HAWKE", "MORGAN MCDORMAND", "IAN TANDY", "ALAN DREYFUSS"]}'),
('{ "_id" : "98a86f3fd11e4d8b9a59516109ac346d", "title" : "SAINTS BRIDE", "description" : "A Fateful Tale of a Technical Writer And a Composer who must Pursue a Explorer in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "125 min", "rating" : "G", "actors" : ["GRACE MOSTEL", "FRED COSTNER", "RIP CRAWFORD", "SUSAN DAVIS", "MORGAN WILLIAMS", "MENA HOPPER", "GROUCHO WILLIAMS", "JON CHASE", "REESE WEST", "MARY KEITEL"]}'),
('{ "_id" : "10e514b162c6424a981a1f172355846e", "title" : "SALUTE APOLLO", "description" : "A Awe-Inspiring Character Study of a Boy And a Feminist who must Sink a Crocodile in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "73 min", "rating" : "R", "actors" : ["VIVIEN BERGEN", "SPENCER DEPP", "CATE MCQUEEN", "JADA RYDER"]}'),
('{ "_id" : "8d1afaa96a4449b38c43076165d662b5", "title" : "SAMURAI LION", "description" : "A Fast-Paced Story of a Pioneer And a Astronaut who must Reach a Boat in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "110 min", "rating" : "G", "actors" : ["ANGELINA ASTAIRE", "GREG CHAPLIN"]}'),
('{ "_id" : "3a3a60007a6b4a25ab165e4131e99149", "title" : "SANTA PARIS", "description" : "A Emotional Documentary of a Moose And a Car who must Redeem a Mad Cow in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "154 min", "rating" : "PG", "actors" : ["KENNETH PALTROW", "SCARLETT DAMON", "MINNIE ZELLWEGER", "RUSSELL TEMPLE", "OLYMPIA PFEIFFER", "MICHAEL BOLGER"]}'),
('{ "_id" : "45949a93a2c34a1994e7881f2bcb1f3a", "title" : "SASSY PACKER", "description" : "A Fast-Paced Documentary of a Dog And a Teacher who must Find a Moose in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "154 min", "rating" : "G", "actors" : ["GROUCHO SINATRA", "ANGELA WITHERSPOON", "LISA MONROE"]}'),
('{ "_id" : "c92262b3d9a240649b8ae1463b456a8d", "title" : "SATISFACTION CONFIDENTIAL", "description" : "A Lacklusture Yarn of a Dentist And a Butler who must Meet a Secret Agent in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "75 min", "rating" : "G", "actors" : ["CAMERON WRAY", "GROUCHO DUNST", "KEVIN GARLAND", "GENE MCKELLEN", "JOHN SUVARI"]}'),
('{ "_id" : "5e16050d05984e84ae969d8bf1136349", "title" : "SATURDAY LAMBS", "description" : "A Thoughtful Reflection of a Mad Scientist And a Moose who must Kill a Husband in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "150 min", "rating" : "G", "actors" : ["VIVIEN BERGEN", "RIP CRAWFORD", "PENELOPE PINKETT", "BURT POSEY", "BEN WILLIS", "JAMES PITT", "GRETA KEITEL", "MENA HOPPER", "GENE MCKELLEN"]}'),
('{ "_id" : "fc48a6758fb0421b9a6a981fd28a4e0e", "title" : "SATURN NAME", "description" : "A Fateful Epistle of a Butler And a Boy who must Redeem a Teacher in Berlin", "release_year" : "2006", "language" : "English", "duration" : "182 min", "rating" : "R", "actors" : ["ANGELINA ASTAIRE", "CHRIS BRIDGES"]}'),
('{ "_id" : "2f27dc3515704bfbb09df272c908329d", "title" : "SAVANNAH TOWN", "description" : "A Awe-Inspiring Tale of a Astronaut And a Database Administrator who must Chase a Secret Agent in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "84 min", "rating" : "PG-13", "actors" : ["GRACE MOSTEL", "SANDRA KILMER", "PARKER GOLDBERG", "CHRISTIAN NEESON", "JESSICA BAILEY", "MINNIE KILMER"]}'),
('{ "_id" : "ec6becc6c5234a7aa2bc589e8706e013", "title" : "SCALAWAG DUCK", "description" : "A Fateful Reflection of a Car And a Teacher who must Confront a Waitress in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "183 min", "rating" : "NC-17", "actors" : ["REESE KILMER", "JUDE CRUISE", "CHRISTIAN NEESON", "GROUCHO SINATRA", "CHRIS DEPP"]}'),
('{ "_id" : "d26ba56b070a4fe4b80a0ab6ff554847", "title" : "SCARFACE BANG", "description" : "A Emotional Yarn of a Teacher And a Girl who must Find a Teacher in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "102 min", "rating" : "PG-13", "actors" : ["PARKER GOLDBERG", "ELLEN PRESLEY", "CATE HARRIS", "EMILY DEE", "BEN HARRIS", "IAN TANDY", "RENEE BALL"]}'),
('{ "_id" : "bb804f01af934f88800763770b7f631c", "title" : "SCHOOL JACKET", "description" : "A Intrepid Yarn of a Monkey And a Boy who must Fight a Composer in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "151 min", "rating" : "PG-13", "actors" : ["MATTHEW JOHANSSON", "DAN HARRIS", "MARY TANDY", "MAE HOFFMAN", "CHRIS DEPP", "ED GUINESS", "JAYNE SILVERSTONE", "REESE WEST"]}'),
('{ "_id" : "eb4760fe6ff240ec99fabd33c0160207", "title" : "SCISSORHANDS SLUMS", "description" : "A Awe-Inspiring Drama of a Girl And a Technical Writer who must Meet a Feminist in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "147 min", "rating" : "G", "actors" : ["GRACE MOSTEL", "HELEN VOIGHT", "JULIA BARRYMORE", "JANE JACKMAN", "ROCK DUKAKIS"]}'),
('{ "_id" : "4c4b7b88293e492aa577f25d886bbe67", "title" : "SCORPION APOLLO", "description" : "A Awe-Inspiring Documentary of a Technical Writer And a Husband who must Meet a Monkey in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "137 min", "rating" : "NC-17", "actors" : ["MATTHEW JOHANSSON", "BOB FAWCETT", "JULIA MCQUEEN", "HENRY BERRY", "SEAN GUINESS", "LIZA BERGMAN", "KEVIN GARLAND", "GROUCHO WILLIAMS"]}'),
('{ "_id" : "f8e9ee71955342e4baca7a62d9ccea60", "title" : "SEA VIRGIN", "description" : "A Fast-Paced Documentary of a Technical Writer And a Pastry Chef who must Escape a Moose in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "80 min", "rating" : "PG", "actors" : ["GOLDIE BRODY", "DUSTIN TAUTOU", "GARY PENN", "RUSSELL BACALL", "CATE HARRIS", "EMILY DEE", "WILLIAM HACKMAN", "HUMPHREY GARLAND"]}'),
('{ "_id" : "a489a0f3903047468533ae9dc0fc96c6", "title" : "SEABISCUIT PUNK", "description" : "A Insightful Saga of a Man And a Forensic Psychologist who must Discover a Mad Cow in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "112 min", "rating" : "NC-17", "actors" : ["ADAM GRANT", "SEAN WILLIAMS", "ROCK DUKAKIS"]}'),
('{ "_id" : "2b1965e75ef843e9b42113bc4410bcc5", "title" : "SEARCHERS WAIT", "description" : "A Fast-Paced Tale of a Car And a Mad Scientist who must Kill a Womanizer in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "182 min", "rating" : "NC-17", "actors" : ["SUSAN DAVIS", "GINA DEGENERES", "CATE MCQUEEN", "ROCK DUKAKIS"]}'),
('{ "_id" : "d811ec4f06084cd198470d8ff1878b15", "title" : "SEATTLE EXPECATIONS", "description" : "A Insightful Reflection of a Crocodile And a Sumo Wrestler who must Meet a Technical Writer in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "110 min", "rating" : "PG-13", "actors" : ["ELVIS MARX", "MILLA PECK", "KENNETH TORN", "SCARLETT BENING", "FAY WOOD", "GREGORY GOODING"]}'),
('{ "_id" : "75e89fed657e488fa9acbaf7ad9df9f4", "title" : "SECRET GROUNDHOG", "description" : "A Astounding Story of a Cat And a Database Administrator who must Build a Technical Writer in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "90 min", "rating" : "PG", "actors" : ["FAY KILMER", "MAE HOFFMAN", "ANGELA WITHERSPOON"]}'),
('{ "_id" : "82d8a96e3ae046b5a5728069dd9582f9", "title" : "SECRETARY ROUGE", "description" : "A Action-Packed Panorama of a Mad Cow And a Composer who must Discover a Robot in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "158 min", "rating" : "PG", "actors" : ["JULIA BARRYMORE", "BEN WILLIS", "ELLEN PRESLEY", "CAMERON ZELLWEGER", "JAYNE NOLTE", "JEFF SILVERSTONE"]}'),
('{ "_id" : "cf690f8fa6b841fbbb1324ab8fc4b95a", "title" : "SECRETS PARADISE", "description" : "A Fateful Saga of a Cat And a Frisbee who must Kill a Girl in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "109 min", "rating" : "G", "actors" : ["REESE KILMER", "GENE WILLIS", "RENEE TRACY", "WHOOPI HURT", "KENNETH HOFFMAN", "WILLIAM HACKMAN"]}'),
('{ "_id" : "5fda792ab66342808fc00f2211660018", "title" : "SENSE GREEK", "description" : "A Taut Saga of a Lumberjack And a Pastry Chef who must Escape a Sumo Wrestler in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "54 min", "rating" : "R", "actors" : ["FRED COSTNER", "AUDREY OLIVIER", "JODIE DEGENERES", "SPENCER DEPP", "AL GARLAND", "OLYMPIA PFEIFFER", "RENEE BALL"]}'),
('{ "_id" : "60db269af22c4f5a8d9d5044521f7a82", "title" : "SENSIBILITY REAR", "description" : "A Emotional Tale of a Robot And a Sumo Wrestler who must Redeem a Pastry Chef in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "98 min", "rating" : "PG", "actors" : ["CHRISTIAN NEESON", "MILLA KEITEL", "BURT POSEY", "GROUCHO DUNST", "LIZA BERGMAN", "MICHAEL BENING"]}'),
('{ "_id" : "99c9b41e8c1945bc96b5cab6b08008cf", "title" : "SEVEN SWARM", "description" : "A Unbelieveable Character Study of a Dog And a Mad Cow who must Kill a Monkey in Berlin", "release_year" : "2006", "language" : "English", "duration" : "127 min", "rating" : "R", "actors" : ["CAMERON STREEP", "DAN HARRIS", "CAMERON WRAY", "ANGELINA ASTAIRE", "GINA DEGENERES", "ED MANSFIELD", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "7e68317e0cee43f8b1af77ea97055af4", "title" : "SHAKESPEARE SADDLE", "description" : "A Fast-Paced Panorama of a Lumberjack And a Database Administrator who must Defeat a Madman in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "60 min", "rating" : "PG-13", "actors" : ["CHRISTIAN GABLE", "SANDRA KILMER", "JAMES PITT", "CHRIS BRIDGES", "WARREN JACKMAN", "RUSSELL TEMPLE"]}'),
('{ "_id" : "520401e3ab6f4e29b99cbec45d3562b3", "title" : "SHANE DARKNESS", "description" : "A Action-Packed Saga of a Moose And a Lumberjack who must Find a Woman in Berlin", "release_year" : "2006", "language" : "English", "duration" : "93 min", "rating" : "PG", "actors" : ["CUBA OLIVIER", "HENRY BERRY", "RENEE TRACY"]}'),
('{ "_id" : "1a29f3c59862480d93317d46c2b6c096", "title" : "SHANGHAI TYCOON", "description" : "A Fast-Paced Character Study of a Crocodile And a Lumberjack who must Build a Husband in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "47 min", "rating" : "PG", "actors" : ["LUCILLE TRACY", "JODIE DEGENERES", "NICK STALLONE", "HENRY BERRY", "BEN WILLIS", "DAN STREEP", "LAURA BRODY", "JULIA FAWCETT"]}'),
('{ "_id" : "b1ec20e519a0442fbb4e7460aff0b1a9", "title" : "SHAWSHANK BUBBLE", "description" : "A Lacklusture Story of a Moose And a Monkey who must Confront a Butler in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "80 min", "rating" : "PG", "actors" : ["BOB FAWCETT", "VAL BOLGER", "KENNETH PESCI", "SYLVESTER DERN", "RENEE TRACY", "SCARLETT BENING", "ANGELA WITHERSPOON", "IAN TANDY", "CHRISTOPHER WEST", "JULIA FAWCETT"]}'),
('{ "_id" : "f529993d429b435bad4aa9f6e7a45220", "title" : "SHEPHERD MIDSUMMER", "description" : "A Thoughtful Drama of a Robot And a Womanizer who must Kill a Lumberjack in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "113 min", "rating" : "R", "actors" : ["SYLVESTER DERN", "WARREN JACKMAN", "JULIANNE DENCH", "OPRAH KILMER", "MERYL ALLEN"]}'),
('{ "_id" : "6d96c5c2bb1c4727b15f0b617b7ff375", "title" : "SHINING ROSES", "description" : "A Awe-Inspiring Character Study of a Astronaut And a Forensic Psychologist who must Challenge a Madman in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "125 min", "rating" : "G", "actors" : ["JULIA BARRYMORE", "WOODY JOLIE", "SUSAN DAVIS", "CATE HARRIS", "HUMPHREY GARLAND"]}'),
('{ "_id" : "bb75ab41735c4d6cb44279950bc5afa6", "title" : "SHIP WONDERLAND", "description" : "A Thrilling Saga of a Monkey And a Frisbee who must Escape a Explorer in The Outback", "release_year" : "2006", "language" : "English", "duration" : "104 min", "rating" : "R", "actors" : ["AUDREY OLIVIER", "MAE HOFFMAN", "RALPH CRUZ", "KENNETH TORN", "CUBA ALLEN", "WARREN JACKMAN", "NICK DEGENERES", "CUBA BIRCH"]}'),
('{ "_id" : "e657d3d3033b4507a6c0e2ef58bd6d7e", "title" : "SHOCK CABIN", "description" : "A Fateful Tale of a Mad Cow And a Crocodile who must Meet a Husband in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "79 min", "rating" : "PG-13", "actors" : ["LAURA BRODY"]}'),
('{ "_id" : "acca6a62c88b4c8cb9cc3af239e98fe8", "title" : "SHOOTIST SUPERFLY", "description" : "A Fast-Paced Story of a Crocodile And a A Shark who must Sink a Pioneer in Berlin", "release_year" : "2006", "language" : "English", "duration" : "67 min", "rating" : "PG-13", "actors" : ["WOODY HOFFMAN", "JULIA BARRYMORE", "FAY KILMER"]}'),
('{ "_id" : "1c628bb80cd541ba93ba600682e91b81", "title" : "SHOW LORD", "description" : "A Fanciful Saga of a Student And a Girl who must Find a Butler in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "167 min", "rating" : "PG-13", "actors" : ["KENNETH PALTROW", "KEVIN GARLAND"]}'),
('{ "_id" : "056ff418cdcd453d8950699b46d34aaa", "title" : "SHREK LICENSE", "description" : "A Fateful Yarn of a Secret Agent And a Feminist who must Find a Feminist in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "154 min", "rating" : "PG-13", "actors" : ["FRANCES DAY-LEWIS", "RIVER DEAN", "EMILY DEE"]}'),
('{ "_id" : "ad951c7dc65f430fbc5d1410459e4451", "title" : "SHRUNK DIVINE", "description" : "A Fateful Character Study of a Waitress And a Technical Writer who must Battle a Hunter in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "139 min", "rating" : "R", "actors" : ["WOODY HOFFMAN", "SISSY SOBIESKI", "TOM MCKELLEN", "MARY TANDY"]}'),
('{ "_id" : "4baffe3e03d44dbea1574a095c870087", "title" : "SIDE ARK", "description" : "A Stunning Panorama of a Crocodile And a Womanizer who must Meet a Feminist in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "52 min", "rating" : "G", "actors" : ["HELEN VOIGHT", "AUDREY OLIVIER", "JADA RYDER", "CHRIS DEPP", "LAURENCE BULLOCK", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "3eb8400f33e641c382f0baee8505a654", "title" : "SIEGE MADRE", "description" : "A Boring Tale of a Frisbee And a Crocodile who must Vanquish a Moose in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "111 min", "rating" : "R", "actors" : ["CUBA OLIVIER", "RIP CRAWFORD", "NATALIE HOPKINS", "DAN HARRIS", "SIDNEY CROWE", "SALMA NOLTE", "BELA WALKEN"]}'),
('{ "_id" : "2a41793e0c0741d89ba543512f1f55a1", "title" : "SIERRA DIVIDE", "description" : "A Emotional Character Study of a Frisbee And a Mad Scientist who must Build a Madman in California", "release_year" : "2006", "language" : "English", "duration" : "135 min", "rating" : "NC-17", "actors" : ["JIM MOSTEL", "WALTER TORN", "GINA DEGENERES", "RUSSELL BACALL", "MARY KEITEL"]}'),
('{ "_id" : "f82875d259ae40c4b71ac9073830adf6", "title" : "SILENCE KANE", "description" : "A Emotional Drama of a Sumo Wrestler And a Dentist who must Confront a Sumo Wrestler in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "67 min", "rating" : "R", "actors" : ["SANDRA PECK", "REESE KILMER", "RENEE TRACY", "MICHAEL BENING"]}'),
('{ "_id" : "83eee2e642dd4edbbe3df92e292d60ad", "title" : "SILVERADO GOLDFINGER", "description" : "A Stunning Epistle of a Sumo Wrestler And a Man who must Challenge a Waitress in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "74 min", "rating" : "PG", "actors" : ["JENNIFER DAVIS", "KIRSTEN PALTROW", "TOM MIRANDA", "JANE JACKMAN", "AL GARLAND"]}'),
('{ "_id" : "7d68248ec3aa4331a15fbb0b604591ff", "title" : "SIMON NORTH", "description" : "A Thrilling Documentary of a Technical Writer And a A Shark who must Face a Pioneer in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "51 min", "rating" : "NC-17", "actors" : ["JOHNNY CAGE", "JODIE DEGENERES", "VIVIEN BASINGER"]}'),
('{ "_id" : "938c77271fe4437e9f21c5fdc63b1d32", "title" : "SINNERS ATLANTIS", "description" : "A Epic Display of a Dog And a Boat who must Succumb a Mad Scientist in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "126 min", "rating" : "PG-13", "actors" : ["HELEN VOIGHT", "CHRISTIAN AKROYD", "LAURA BRODY", "LAURENCE BULLOCK"]}'),
('{ "_id" : "4d573cea1d474b1498090ce325a972c4", "title" : "SISTER FREDDY", "description" : "A Stunning Saga of a Butler And a Woman who must Pursue a Explorer in Australia", "release_year" : "2006", "language" : "English", "duration" : "152 min", "rating" : "PG-13", "actors" : ["SUSAN DAVIS", "HUMPHREY WILLIS", "GREGORY GOODING"]}'),
('{ "_id" : "37f6b08f4bb74392a6bc15abfdf62d42", "title" : "SKY MIRACLE", "description" : "A Epic Drama of a Mad Scientist And a Explorer who must Succumb a Waitress in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "132 min", "rating" : "PG", "actors" : ["ELVIS MARX", "SISSY SOBIESKI", "WOODY JOLIE", "KIRSTEN AKROYD", "WALTER TORN", "WARREN JACKMAN", "MERYL GIBSON", "GRETA MALDEN", "LAURA BRODY", "LAURENCE BULLOCK", "JON CHASE", "AUDREY BAILEY"]}'),
('{ "_id" : "1d0232a5f5814e60b0ccc80c181359e8", "title" : "SLACKER LIAISONS", "description" : "A Fast-Paced Tale of a A Shark And a Student who must Meet a Crocodile in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "179 min", "rating" : "R", "actors" : ["RALPH CRUZ", "KENNETH PESCI", "WOODY JOLIE", "SANDRA KILMER"]}'),
('{ "_id" : "e2ff93e248f948fb8f248fa5c0870a84", "title" : "SLEEPING SUSPECTS", "description" : "A Stunning Reflection of a Sumo Wrestler And a Explorer who must Sink a Frisbee in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "129 min", "rating" : "PG-13", "actors" : ["KIRSTEN PALTROW", "SANDRA KILMER", "MILLA KEITEL", "WILL WILSON"]}'),
('{ "_id" : "cc4a072f1b7e4121bf97377e82050e57", "title" : "SLEEPLESS MONSOON", "description" : "A Amazing Saga of a Moose And a Pastry Chef who must Escape a Butler in Australia", "release_year" : "2006", "language" : "English", "duration" : "64 min", "rating" : "G", "actors" : ["GRACE MOSTEL", "JULIA MCQUEEN", "HENRY BERRY", "DARYL CRAWFORD"]}'),
('{ "_id" : "fbe5038554c1490f91267bdc8835653a", "title" : "SLEEPY JAPANESE", "description" : "A Emotional Epistle of a Moose And a Composer who must Fight a Technical Writer in The Outback", "release_year" : "2006", "language" : "English", "duration" : "137 min", "rating" : "PG", "actors" : ["GRACE MOSTEL", "ADAM HOPPER", "RICHARD PENN", "ED MANSFIELD", "AUDREY BAILEY", "MARY KEITEL"]}'),
('{ "_id" : "f40cdbdbd6dc4a02997dc2d1a2159e7b", "title" : "SLEUTH ORIENT", "description" : "A Fateful Character Study of a Husband And a Dog who must Find a Feminist in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "87 min", "rating" : "NC-17", "actors" : ["RALPH CRUZ", "CHRISTOPHER BERRY", "MORGAN MCDORMAND", "HARVEY HOPE", "AL GARLAND", "WILL WILSON", "BURT TEMPLE"]}'),
('{ "_id" : "7488ab49b6a04c62a587290e9cf1acc2", "title" : "SLING LUKE", "description" : "A Intrepid Character Study of a Robot And a Monkey who must Reach a Secret Agent in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "84 min", "rating" : "R", "actors" : ["DAN TORN", "GREG CHAPLIN", "ED MANSFIELD"]}'),
('{ "_id" : "f066fab2f13845cca8045ca9f6906646", "title" : "SLIPPER FIDELITY", "description" : "A Taut Reflection of a Secret Agent And a Man who must Redeem a Explorer in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "156 min", "rating" : "PG-13", "actors" : ["CAMERON WRAY", "JAMES PITT", "GRETA KEITEL", "JANE JACKMAN", "AL GARLAND", "MICHAEL BENING", "JEFF SILVERSTONE"]}'),
('{ "_id" : "24322ef0922e426497bc778e44076375", "title" : "SLUMS DUCK", "description" : "A Amazing Character Study of a Teacher And a Database Administrator who must Defeat a Waitress in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "147 min", "rating" : "PG", "actors" : ["REESE KILMER", "WALTER TORN", "RUSSELL TEMPLE"]}'),
('{ "_id" : "7c16c7a0a5784ec2a38c81931e617afb", "title" : "SMILE EARRING", "description" : "A Intrepid Drama of a Teacher And a Butler who must Build a Pastry Chef in Berlin", "release_year" : "2006", "language" : "English", "duration" : "60 min", "rating" : "G", "actors" : ["NICK WAHLBERG", "JOHNNY LOLLOBRIGIDA", "JOE SWANK", "ANNE CRONYN", "GROUCHO SINATRA", "RUSSELL TEMPLE", "ED GUINESS", "JEFF SILVERSTONE"]}'),
('{ "_id" : "3cd208ad0f374133883b7e4ad130e44a", "title" : "SMOKING BARBARELLA", "description" : "A Lacklusture Saga of a Mad Cow And a Mad Scientist who must Sink a Cat in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "50 min", "rating" : "PG-13", "actors" : ["KARL BERRY", "ALEC WAYNE", "CARMEN HUNT", "MINNIE ZELLWEGER", "RENEE TRACY", "VIVIEN BASINGER"]}'),
('{ "_id" : "ad6e21f746d84ecfa6ec78e94a7bfb32", "title" : "SMOOCHY CONTROL", "description" : "A Thrilling Documentary of a Husband And a Feminist who must Face a Mad Scientist in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "184 min", "rating" : "R", "actors" : ["DARYL WAHLBERG", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "19328462baa842b48380b2cc54ab18a3", "title" : "SNATCH SLIPPER", "description" : "A Insightful Panorama of a Woman And a Feminist who must Defeat a Forensic Psychologist in Berlin", "release_year" : "2006", "language" : "English", "duration" : "110 min", "rating" : "PG", "actors" : ["SCARLETT BENING", "CATE MCQUEEN", "RITA REYNOLDS"]}'),
('{ "_id" : "972c721a2b6e4c849cd788ecedd6db0d", "title" : "SNATCHERS MONTEZUMA", "description" : "A Boring Epistle of a Sumo Wrestler And a Woman who must Escape a Man in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "74 min", "rating" : "PG-13", "actors" : ["JOE SWANK", "TIM HACKMAN", "GOLDIE BRODY", "FAY KILMER", "SPENCER DEPP", "KENNETH HOFFMAN", "ROCK DUKAKIS", "BELA WALKEN", "REESE WEST"]}'),
('{ "_id" : "5236aa1ad2ac48b59ee140ad54fd388f", "title" : "SNOWMAN ROLLERCOASTER", "description" : "A Fateful Display of a Lumberjack And a Girl who must Succumb a Mad Cow in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "62 min", "rating" : "G", "actors" : ["UMA WOOD", "WOODY HOFFMAN", "MATTHEW CARREY"]}'),
('{ "_id" : "faee471dd7de4f9ab6df9f3169032b3d", "title" : "SOLDIERS EVOLUTION", "description" : "A Lacklusture Panorama of a A Shark And a Pioneer who must Confront a Student in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "185 min", "rating" : "R", "actors" : ["JOHNNY LOLLOBRIGIDA", "UMA WOOD", "CUBA OLIVIER", "JUDY DEAN", "SEAN GUINESS", "RUSSELL BACALL", "MINNIE KILMER", "ED GUINESS", "MARY KEITEL"]}'),
('{ "_id" : "9be3d328dd2e42dbaccb327fbf8c8842", "title" : "SOMETHING DUCK", "description" : "A Boring Character Study of a Car And a Husband who must Outgun a Frisbee in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "180 min", "rating" : "NC-17", "actors" : ["ED MANSFIELD", "LAURA BRODY", "MICHAEL BOLGER"]}'),
('{ "_id" : "057e8a0ccf8f45e6887411f5bd27e1d1", "title" : "SONG HEDWIG", "description" : "A Amazing Documentary of a Man And a Husband who must Confront a Squirrel in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "165 min", "rating" : "PG-13", "actors" : ["KENNETH PESCI", "KEVIN GARLAND", "DEBBIE AKROYD", "GREGORY GOODING", "JOHN SUVARI"]}'),
('{ "_id" : "2195bffaa1054ae69b38acbebf67dbcc", "title" : "SONS INTERVIEW", "description" : "A Taut Character Study of a Explorer And a Mad Cow who must Battle a Hunter in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "184 min", "rating" : "NC-17", "actors" : ["SANDRA KILMER", "PARKER GOLDBERG", "WHOOPI HURT", "HUMPHREY WILLIS", "JEFF SILVERSTONE", "CUBA BIRCH"]}'),
('{ "_id" : "f4031f9e3f334acb8c1a5bdbeec57bb2", "title" : "SORORITY QUEEN", "description" : "A Fast-Paced Display of a Squirrel And a Composer who must Fight a Forensic Psychologist in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "184 min", "rating" : "NC-17", "actors" : ["RIP CRAWFORD", "CATE HARRIS", "RIVER DEAN", "BEN HARRIS"]}'),
('{ "_id" : "156ec422bd7842c5aad6dd56f677331a", "title" : "SOUP WISDOM", "description" : "A Fast-Paced Display of a Robot And a Butler who must Defeat a Butler in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "169 min", "rating" : "R", "actors" : ["MATTHEW LEIGH", "KIM ALLEN"]}'),
('{ "_id" : "ccb5ee5936e3497ca3169b122514ea1d", "title" : "SOUTH WAIT", "description" : "A Amazing Documentary of a Car And a Robot who must Escape a Lumberjack in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "143 min", "rating" : "R", "actors" : ["MICHELLE MCCONAUGHEY", "GARY PENN"]}'),
('{ "_id" : "8454c5062e984a4b856466c59f57b2b4", "title" : "SPARTACUS CHEAPER", "description" : "A Thrilling Panorama of a Pastry Chef And a Secret Agent who must Overcome a Student in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "52 min", "rating" : "NC-17", "actors" : ["CHRIS BRIDGES", "VIVIEN BASINGER", "JEFF SILVERSTONE"]}'),
('{ "_id" : "e37e9c42a56d4ba89cd4c57238b026b3", "title" : "SPEAKEASY DATE", "description" : "A Lacklusture Drama of a Forensic Psychologist And a Car who must Redeem a Man in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "165 min", "rating" : "PG-13", "actors" : ["NICK STALLONE", "KIRSTEN AKROYD", "HARVEY HOPE"]}'),
('{ "_id" : "dfafd8c163344cbd80cdf16008f6abbe", "title" : "SPEED SUIT", "description" : "A Brilliant Display of a Frisbee And a Mad Scientist who must Succumb a Robot in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "124 min", "rating" : "PG-13", "actors" : ["BETTE NICHOLSON", "SANDRA KILMER", "MEG HAWKE", "DARYL CRAWFORD", "CHRIS DEPP", "WILL WILSON"]}'),
('{ "_id" : "606c0e0b86ad442cb2428767ac6d8af9", "title" : "SPICE SORORITY", "description" : "A Fateful Display of a Pioneer And a Hunter who must Defeat a Husband in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "141 min", "rating" : "NC-17", "actors" : ["ED CHASE", "WOODY HOFFMAN", "TOM MCKELLEN", "KIRK JOVOVICH", "FAY KILMER", "SCARLETT DAMON", "MORGAN MCDORMAND", "MICHAEL BENING", "JON CHASE", "GENE MCKELLEN", "GREGORY GOODING"]}'),
('{ "_id" : "16aa0b4562ab4199bb5b4d7ab7ad9d00", "title" : "SPIKING ELEMENT", "description" : "A Lacklusture Epistle of a Dentist And a Technical Writer who must Find a Dog in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "79 min", "rating" : "G", "actors" : ["DARYL WAHLBERG", "SUSAN DAVIS", "WALTER TORN", "WILLIAM HACKMAN", "DEBBIE AKROYD", "BURT TEMPLE"]}'),
('{ "_id" : "b1f1f73eb3cb445e8b21a414d7bfde04", "title" : "SPINAL ROCKY", "description" : "A Lacklusture Epistle of a Sumo Wrestler And a Squirrel who must Defeat a Explorer in California", "release_year" : "2006", "language" : "English", "duration" : "138 min", "rating" : "PG-13", "actors" : ["CAMERON STREEP", "PARKER GOLDBERG", "NATALIE HOPKINS", "MARY TANDY", "CHRISTOPHER BERRY", "CHRIS BRIDGES", "RUSSELL BACALL", "CATE HARRIS"]}'),
('{ "_id" : "c2253d60d72f4b61ab66f73d3bb89023", "title" : "SPIRIT FLINTSTONES", "description" : "A Brilliant Yarn of a Cat And a Car who must Confront a Explorer in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "149 min", "rating" : "R", "actors" : ["JULIA MCQUEEN", "PARKER GOLDBERG", "HENRY BERRY", "JAMES PITT", "SPENCER PECK", "PENELOPE MONROE", "WHOOPI HURT", "RIVER DEAN", "VIVIEN BASINGER", "MICHAEL BENING", "GREGORY GOODING"]}'),
('{ "_id" : "653e3d3bd6be4e5880d53ffe3a3d103e", "title" : "SPIRITED CASUALTIES", "description" : "A Taut Story of a Waitress And a Man who must Face a Car in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "138 min", "rating" : "PG-13", "actors" : ["GOLDIE BRODY", "CHRISTIAN NEESON", "SIDNEY CROWE", "GINA DEGENERES", "RENEE TRACY"]}'),
('{ "_id" : "6babb94807e04c729645e676f58537f9", "title" : "SPLASH GUMP", "description" : "A Taut Saga of a Crocodile And a Boat who must Conquer a Hunter in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "175 min", "rating" : "PG", "actors" : ["PENELOPE GUINESS", "JENNIFER DAVIS", "UMA WOOD", "CAMERON STREEP", "CHRISTIAN NEESON", "RAY JOHANSSON", "GENE WILLIS", "MORGAN WILLIAMS", "HUMPHREY WILLIS", "AL GARLAND"]}'),
('{ "_id" : "45af7ebbce5f4d48b450a5e35ac971d0", "title" : "SPLENDOR PATTON", "description" : "A Taut Story of a Dog And a Explorer who must Find a Astronaut in Berlin", "release_year" : "2006", "language" : "English", "duration" : "134 min", "rating" : "R", "actors" : ["UMA WOOD", "SANDRA KILMER", "KIRK JOVOVICH", "ADAM GRANT", "BEN WILLIS", "CHARLIZE DENCH", "CHRISTOPHER WEST", "AL GARLAND", "GROUCHO WILLIAMS", "BELA WALKEN"]}'),
('{ "_id" : "34fa4e72fdc74879b91aa2fe5b0249ec", "title" : "SPOILERS HELLFIGHTERS", "description" : "A Fanciful Story of a Technical Writer And a Squirrel who must Defeat a Dog in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "151 min", "rating" : "G", "actors" : ["RIP WINSLET", "MICHELLE MCCONAUGHEY", "MILLA KEITEL", "DARYL CRAWFORD", "HUMPHREY WILLIS", "GREGORY GOODING", "BURT TEMPLE"]}'),
('{ "_id" : "f9603e49729440e8a4516f9561f2fc9e", "title" : "SPY MILE", "description" : "A Thrilling Documentary of a Feminist And a Feminist who must Confront a Feminist in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "112 min", "rating" : "PG-13", "actors" : ["WOODY HOFFMAN", "JOHNNY CAGE", "HENRY BERRY", "ELLEN PRESLEY", "JIM MOSTEL", "SIDNEY CROWE", "WHOOPI HURT", "GRETA MALDEN"]}'),
('{ "_id" : "553cb826495744e3ac7a79fa4e32caf1", "title" : "SQUAD FISH", "description" : "A Fast-Paced Display of a Pastry Chef And a Dog who must Kill a Teacher in Berlin", "release_year" : "2006", "language" : "English", "duration" : "136 min", "rating" : "PG", "actors" : ["AUDREY OLIVIER", "PARKER GOLDBERG", "MILLA KEITEL", "FRANCES TOMEI", "MATTHEW CARREY"]}'),
('{ "_id" : "540d0f975f1f4ef7ad0a21a786a80f09", "title" : "STAGE WORLD", "description" : "A Lacklusture Panorama of a Woman And a Frisbee who must Chase a Crocodile in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "PG", "actors" : ["WALTER TORN", "BELA WALKEN"]}'),
('{ "_id" : "25bd55c0342f493aa86c36ab8efb2e3c", "title" : "STAGECOACH ARMAGEDDON", "description" : "A Touching Display of a Pioneer And a Butler who must Chase a Car in California", "release_year" : "2006", "language" : "English", "duration" : "112 min", "rating" : "R", "actors" : ["KARL BERRY", "SANDRA PECK", "WOODY JOLIE", "SEAN GUINESS", "KIRSTEN AKROYD", "MORGAN HOPKINS"]}'),
('{ "_id" : "cefc4e17f52b465ab535c83ec4834870", "title" : "STALLION SUNDANCE", "description" : "A Fast-Paced Tale of a Car And a Dog who must Outgun a A Shark in Australia", "release_year" : "2006", "language" : "English", "duration" : "130 min", "rating" : "PG-13", "actors" : ["VAL BOLGER", "TOM MCKELLEN", "RIP WINSLET", "WOODY JOLIE", "KENNETH PESCI", "KEVIN GARLAND", "JON CHASE"]}'),
('{ "_id" : "512837bd248d46288eb2ea39028e30bf", "title" : "STAMPEDE DISTURBING", "description" : "A Unbelieveable Tale of a Woman And a Lumberjack who must Fight a Frisbee in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "75 min", "rating" : "R", "actors" : ["VAL BOLGER", "NATALIE HOPKINS", "RIP WINSLET", "MAE HOFFMAN", "CATE HARRIS", "VIVIEN BASINGER"]}'),
('{ "_id" : "b14ddb3d553a49af9bf2d47ff5f875ed", "title" : "STAR OPERATION", "description" : "A Insightful Character Study of a Girl And a Car who must Pursue a Mad Cow in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "181 min", "rating" : "PG", "actors" : ["JOHNNY LOLLOBRIGIDA", "SUSAN DAVIS", "MORGAN MCDORMAND", "MORGAN WILLIAMS", "WILL WILSON"]}'),
('{ "_id" : "8df6fdcebd6c42ac9def2a3b63f9d870", "title" : "STATE WASTELAND", "description" : "A Beautiful Display of a Cat And a Pastry Chef who must Outrace a Mad Cow in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "113 min", "rating" : "NC-17", "actors" : ["DAN TORN", "SANDRA KILMER", "PENELOPE PINKETT", "ED MANSFIELD", "JADA RYDER", "MERYL GIBSON", "WILLIAM HACKMAN"]}'),
('{ "_id" : "42b4d4a13941468f80962d988e7de936", "title" : "STEEL SANTA", "description" : "A Fast-Paced Yarn of a Composer And a Frisbee who must Face a Moose in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "143 min", "rating" : "NC-17", "actors" : ["UMA WOOD", "JAMES PITT", "MARY KEITEL"]}'),
('{ "_id" : "926c9433374346b29699ab71b4f8597a", "title" : "STEERS ARMAGEDDON", "description" : "A Stunning Character Study of a Car And a Girl who must Succumb a Car in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "140 min", "rating" : "PG", "actors" : ["DAN HARRIS", "DAN STREEP", "FAY WOOD", "OPRAH KILMER"]}'),
('{ "_id" : "8e3e4b82dac94451b12f51db75f88369", "title" : "STEPMOM DREAM", "description" : "A Touching Epistle of a Crocodile And a Teacher who must Build a Forensic Psychologist in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "48 min", "rating" : "NC-17", "actors" : ["WALTER TORN", "ANGELA WITHERSPOON", "DEBBIE AKROYD", "MICHAEL BOLGER"]}'),
('{ "_id" : "ab3f75bf421547fc9215e77376e9ef0e", "title" : "STING PERSONAL", "description" : "A Fanciful Drama of a Frisbee And a Dog who must Fight a Madman in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "93 min", "rating" : "NC-17", "actors" : ["GRACE MOSTEL", "AUDREY OLIVIER", "GENE WILLIS", "SPENCER DEPP", "HARRISON BALE", "KEVIN GARLAND", "BEN HARRIS"]}'),
('{ "_id" : "6876350b7190480782573fd7d59bbb13", "title" : "STOCK GLASS", "description" : "A Boring Epistle of a Crocodile And a Lumberjack who must Outgun a Moose in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "160 min", "rating" : "PG", "actors" : ["VIVIEN BERGEN", "GARY PHOENIX", "CAMERON ZELLWEGER", "LIZA BERGMAN", "MINNIE KILMER", "KENNETH HOFFMAN", "JEFF SILVERSTONE"]}'),
('{ "_id" : "55d55aef789d4dba9564132438376512", "title" : "STONE FIRE", "description" : "A Intrepid Drama of a Astronaut And a Crocodile who must Find a Boat in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "94 min", "rating" : "G", "actors" : ["MILLA KEITEL"]}'),
('{ "_id" : "56093d601c9f407f9088a32bfb7e0c2a", "title" : "STORM HAPPINESS", "description" : "A Insightful Drama of a Feminist And a A Shark who must Vanquish a Boat in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "57 min", "rating" : "NC-17", "actors" : ["CHRISTOPHER BERRY", "GINA DEGENERES", "CATE HARRIS", "IAN TANDY", "KENNETH HOFFMAN", "OLYMPIA PFEIFFER", "ROCK DUKAKIS", "GREGORY GOODING"]}'),
('{ "_id" : "a0c78fb8f0d0440f97361b4c3630f0c5", "title" : "STORY SIDE", "description" : "A Lacklusture Saga of a Boy And a Cat who must Sink a Dentist in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "163 min", "rating" : "R", "actors" : ["ZERO CAGE", "ANGELINA ASTAIRE", "SPENCER DEPP", "HARVEY HOPE", "RUSSELL CLOSE"]}'),
('{ "_id" : "33e4de65d506422090aa5b2e60a73fb6", "title" : "STRAIGHT HOURS", "description" : "A Boring Panorama of a Secret Agent And a Girl who must Sink a Waitress in The Outback", "release_year" : "2006", "language" : "English", "duration" : "151 min", "rating" : "R", "actors" : ["DAN HARRIS", "HUMPHREY WILLIS", "BURT TEMPLE"]}'),
('{ "_id" : "6fef9c5aad764700975ce6d0b53b54ba", "title" : "STRANGELOVE DESIRE", "description" : "A Awe-Inspiring Panorama of a Lumberjack And a Waitress who must Defeat a Crocodile in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "103 min", "rating" : "NC-17", "actors" : ["JUDE CRUISE", "RAY JOHANSSON", "ANGELA HUDSON", "GROUCHO SINATRA", "WALTER TORN", "CUBA ALLEN", "ALAN DREYFUSS", "MICHAEL BENING", "ED GUINESS"]}'),
('{ "_id" : "c156d4f8867849c68d6e4f45f8818039", "title" : "STRANGER STRANGERS", "description" : "A Awe-Inspiring Yarn of a Womanizer And a Explorer who must Fight a Woman in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "139 min", "rating" : "G", "actors" : ["HELEN VOIGHT", "SANDRA KILMER", "AUDREY OLIVIER", "VAL BOLGER", "TOM MCKELLEN", "DUSTIN TAUTOU", "MAE HOFFMAN", "MICHAEL BENING", "CUBA BIRCH"]}'),
('{ "_id" : "c1737539c3264e2b82091e1bac1f0d1d", "title" : "STRANGERS GRAFFITI", "description" : "A Brilliant Character Study of a Secret Agent And a Man who must Find a Cat in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "119 min", "rating" : "R", "actors" : ["ZERO CAGE", "JULIA MCQUEEN", "NICK STALLONE", "SEAN WILLIAMS", "JAYNE NOLTE"]}'),
('{ "_id" : "8dfec632f4ab469887fda851490ba552", "title" : "STREAK RIDGEMONT", "description" : "A Astounding Character Study of a Hunter And a Waitress who must Sink a Man in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "132 min", "rating" : "PG-13", "actors" : ["SANDRA KILMER", "SEAN GUINESS", "DARYL WAHLBERG"]}'),
('{ "_id" : "8761e1f94f904a43baaa8c8d00992240", "title" : "STREETCAR INTENTIONS", "description" : "A Insightful Character Study of a Waitress And a Crocodile who must Sink a Waitress in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "73 min", "rating" : "R", "actors" : ["VIVIEN BERGEN", "SANDRA KILMER", "CHRISTIAN AKROYD", "MICHELLE MCCONAUGHEY", "ELLEN PRESLEY", "RUSSELL BACALL", "LAURENCE BULLOCK"]}'),
('{ "_id" : "3b9ca55ed8af49798fa570c0900ada98", "title" : "STRICTLY SCARFACE", "description" : "A Touching Reflection of a Crocodile And a Dog who must Chase a Hunter in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "144 min", "rating" : "PG-13", "actors" : ["GREG CHAPLIN", "DARYL CRAWFORD", "WHOOPI HURT", "ALAN DREYFUSS"]}'),
('{ "_id" : "d5042993cc0a41b9a5b4996e66e6fa41", "title" : "SUBMARINE BED", "description" : "A Amazing Display of a Car And a Monkey who must Fight a Teacher in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "127 min", "rating" : "R", "actors" : ["JENNIFER DAVIS", "PENELOPE PINKETT", "CHRISTIAN AKROYD", "RALPH CRUZ", "SEAN GUINESS", "SIDNEY CROWE", "GROUCHO DUNST", "WARREN JACKMAN", "SCARLETT BENING", "GREGORY GOODING", "MARY KEITEL"]}'),
('{ "_id" : "9510efe6bbe54719b45b51995f2a7e03", "title" : "SUGAR WONKA", "description" : "A Touching Story of a Dentist And a Database Administrator who must Conquer a Astronaut in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "114 min", "rating" : "PG", "actors" : ["MATTHEW JOHANSSON", "CHRISTOPHER BERRY", "GINA DEGENERES", "JADA RYDER", "JON CHASE"]}'),
('{ "_id" : "573e16ffd0034283b186218877064171", "title" : "SUICIDES SILENCE", "description" : "A Emotional Character Study of a Car And a Girl who must Face a Composer in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "93 min", "rating" : "G", "actors" : ["RAY JOHANSSON", "JULIANNE DENCH", "FRANCES TOMEI"]}'),
('{ "_id" : "69f2daffe97c49e4913238b53bfc5c00", "title" : "SUIT WALLS", "description" : "A Touching Panorama of a Lumberjack And a Frisbee who must Build a Dog in Australia", "release_year" : "2006", "language" : "English", "duration" : "111 min", "rating" : "R", "actors" : ["TOM MIRANDA", "PENELOPE PINKETT", "JESSICA BAILEY", "MORGAN MCDORMAND", "GENE HOPKINS"]}'),
('{ "_id" : "5a1e75c9098f4361a75af89828634cbd", "title" : "SUMMER SCARFACE", "description" : "A Emotional Panorama of a Lumberjack And a Hunter who must Meet a Girl in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "53 min", "rating" : "G", "actors" : ["ALEC WAYNE", "DAN HARRIS", "DUSTIN TAUTOU", "ANGELINA ASTAIRE", "MEG HAWKE", "EWAN GOODING", "CATE HARRIS", "RUSSELL CLOSE"]}'),
('{ "_id" : "187dbbcbb73740e9b54783eda8406351", "title" : "SUN CONFESSIONS", "description" : "A Beautiful Display of a Mad Cow And a Dog who must Redeem a Waitress in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "141 min", "rating" : "R", "actors" : ["DAN TORN", "LUCILLE TRACY", "SYLVESTER DERN", "CATE HARRIS", "JADA RYDER"]}'),
('{ "_id" : "b0068443bd284acda86f12877b83ac90", "title" : "SUNDANCE INVASION", "description" : "A Epic Drama of a Lumberjack And a Explorer who must Confront a Hunter in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "92 min", "rating" : "NC-17", "actors" : ["KENNETH PALTROW", "CHARLIZE DENCH", "SIDNEY CROWE", "RENEE TRACY", "FAY WINSLET", "LAURENCE BULLOCK", "DEBBIE AKROYD"]}'),
('{ "_id" : "7041b712ad214eba90bbdb85c6ca1532", "title" : "SUNRISE LEAGUE", "description" : "A Beautiful Epistle of a Madman And a Butler who must Face a Crocodile in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "135 min", "rating" : "PG-13", "actors" : ["JOHNNY LOLLOBRIGIDA", "JOE SWANK", "TOM MIRANDA", "SEAN WILLIAMS", "RUSSELL BACALL"]}'),
('{ "_id" : "4998cbdaf8024162b4e5e0b6ce2ccf15", "title" : "SUNSET RACER", "description" : "A Awe-Inspiring Reflection of a Astronaut And a A Shark who must Defeat a Forensic Psychologist in California", "release_year" : "2006", "language" : "English", "duration" : "48 min", "rating" : "NC-17", "actors" : ["ANGELINA ASTAIRE", "GROUCHO DUNST", "MORGAN MCDORMAND"]}'),
('{ "_id" : "738fb15f4ecc40479731f93df3e3f93c", "title" : "SUPER WYOMING", "description" : "A Action-Packed Saga of a Pastry Chef And a Explorer who must Discover a A Shark in The Outback", "release_year" : "2006", "language" : "English", "duration" : "58 min", "rating" : "PG", "actors" : ["TOM MIRANDA", "NICK DEGENERES", "HUMPHREY GARLAND"]}'),
('{ "_id" : "0ede0c8fe9c1418f9d021904404b2fac", "title" : "SUPERFLY TRIP", "description" : "A Beautiful Saga of a Lumberjack And a Teacher who must Build a Technical Writer in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "114 min", "rating" : "PG", "actors" : ["JOHNNY CAGE", "DAN HARRIS", "SEAN GUINESS", "WARREN JACKMAN", "RICHARD PENN", "MENA HOPPER", "MATTHEW CARREY"]}'),
('{ "_id" : "5fab68137164419789e965add4898459", "title" : "SUSPECTS QUILLS", "description" : "A Emotional Epistle of a Pioneer And a Crocodile who must Battle a Man in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "47 min", "rating" : "PG", "actors" : ["JOHNNY CAGE", "MICHELLE MCCONAUGHEY", "MINNIE ZELLWEGER", "RUSSELL BACALL", "GRETA KEITEL", "VIVIEN BASINGER", "JEFF SILVERSTONE", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "57b7eaa8f6614488a759229e59f27cae", "title" : "SWARM GOLD", "description" : "A Insightful Panorama of a Crocodile And a Boat who must Conquer a Sumo Wrestler in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "123 min", "rating" : "PG-13", "actors" : ["JESSICA BAILEY", "BURT POSEY", "ANGELINA ASTAIRE", "WOODY JOLIE", "SPENCER PECK", "MATTHEW CARREY"]}'),
('{ "_id" : "16bc87c265c04c978805b4aff70f067a", "title" : "SWEDEN SHINING", "description" : "A Taut Documentary of a Car And a Robot who must Conquer a Boy in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "176 min", "rating" : "PG", "actors" : ["KARL BERRY", "KEVIN BLOOM", "MARY TANDY", "ALBERT JOHANSSON", "MARY KEITEL"]}'),
('{ "_id" : "1b23344e79224bf4bbdfa58a6e5891a1", "title" : "SWEET BROTHERHOOD", "description" : "A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Chase a Forensic Psychologist in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "185 min", "rating" : "R", "actors" : ["MILLA KEITEL", "SPENCER DEPP", "RIVER DEAN", "OLYMPIA PFEIFFER", "JON CHASE", "MERYL ALLEN"]}'),
('{ "_id" : "9f8b3096b2ff4ac5b5cc133b1f498b2e", "title" : "SWEETHEARTS SUSPECTS", "description" : "A Brilliant Character Study of a Frisbee And a Sumo Wrestler who must Confront a Woman in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "108 min", "rating" : "G", "actors" : ["JOE SWANK", "HELEN VOIGHT", "JULIA MCQUEEN", "BEN WILLIS", "JAYNE NOLTE"]}'),
('{ "_id" : "1453cc82429249159712e0757be009de", "title" : "TADPOLE PARK", "description" : "A Beautiful Tale of a Frisbee And a Moose who must Vanquish a Dog in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "155 min", "rating" : "PG", "actors" : ["HELEN VOIGHT", "ADAM GRANT", "ELLEN PRESLEY", "GENE WILLIS", "GRETA MALDEN", "JEFF SILVERSTONE", "MATTHEW CARREY", "AUDREY BAILEY"]}'),
('{ "_id" : "096281f83c8d4671bbf388bd388ad451", "title" : "TALENTED HOMICIDE", "description" : "A Lacklusture Panorama of a Dentist And a Forensic Psychologist who must Outrace a Pioneer in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "173 min", "rating" : "PG", "actors" : ["BURT DUKAKIS", "NICK STALLONE", "MINNIE ZELLWEGER", "JANE JACKMAN", "JADA RYDER"]}'),
('{ "_id" : "9337a12ec4904deabcd5eb40656fc1f0", "title" : "TARZAN VIDEOTAPE", "description" : "A Fast-Paced Display of a Lumberjack And a Mad Scientist who must Succumb a Sumo Wrestler in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "91 min", "rating" : "PG-13", "actors" : ["TOM MCKELLEN", "TOM MIRANDA", "LAURA BRODY"]}'),
('{ "_id" : "6d3f86459f2b4a0888d5475762cd13da", "title" : "TAXI KICK", "description" : "A Amazing Epistle of a Girl And a Woman who must Outrace a Waitress in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "64 min", "rating" : "PG-13", "actors" : ["BOB FAWCETT", "KENNETH PALTROW", "WOODY JOLIE", "SPENCER DEPP", "ALBERT NOLTE", "MENA HOPPER"]}'),
('{ "_id" : "58d19e1aa11d4e5a899cd341944fa0a9", "title" : "TEEN APOLLO", "description" : "A Awe-Inspiring Drama of a Dog And a Man who must Escape a Robot in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "74 min", "rating" : "G", "actors" : ["MILLA PECK", "NICK STALLONE", "CARMEN HUNT", "GREG CHAPLIN", "RIVER DEAN"]}'),
('{ "_id" : "f9d5ac3f491c4ab49588d818c0b3c6b9", "title" : "TELEGRAPH VOYAGE", "description" : "A Fateful Yarn of a Husband And a Dog who must Battle a Waitress in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "148 min", "rating" : "PG", "actors" : ["WOODY HOFFMAN", "CARMEN HUNT", "GINA DEGENERES", "LUCILLE DEE", "VIVIEN BASINGER", "MICHAEL BENING", "THORA TEMPLE"]}'),
('{ "_id" : "0a20daabc4274385b2d2b5c6b0e80df6", "title" : "TELEMARK HEARTBREAKERS", "description" : "A Action-Packed Panorama of a Technical Writer And a Man who must Build a Forensic Psychologist in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "152 min", "rating" : "PG-13", "actors" : ["KARL BERRY", "HELEN VOIGHT", "JULIA MCQUEEN", "SISSY SOBIESKI", "GROUCHO SINATRA", "SEAN GUINESS", "JAYNE NOLTE", "GEOFFREY HESTON", "VIVIEN BASINGER", "HARVEY HOPE", "MICHAEL BOLGER"]}'),
('{ "_id" : "3dea695d413545e6b881ca0e897001a9", "title" : "TEMPLE ATTRACTION", "description" : "A Action-Packed Saga of a Forensic Psychologist And a Woman who must Battle a Womanizer in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "71 min", "rating" : "PG", "actors" : ["MILLA PECK", "KENNETH PESCI", "GROUCHO DUNST", "JANE JACKMAN", "CHRISTOPHER WEST"]}'),
('{ "_id" : "57eadd7acce04144a6deda66eeaaa41d", "title" : "TENENBAUMS COMMAND", "description" : "A Taut Display of a Pioneer And a Man who must Reach a Girl in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "99 min", "rating" : "PG-13", "actors" : ["SCARLETT BENING", "RICHARD PENN", "LAURENCE BULLOCK", "MICHAEL BOLGER", "CUBA BIRCH"]}'),
('{ "_id" : "159045f2820e4681a3b9f54a2953da23", "title" : "TEQUILA PAST", "description" : "A Action-Packed Panorama of a Mad Scientist And a Robot who must Challenge a Student in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "53 min", "rating" : "PG", "actors" : ["DAN TORN", "NICK STALLONE", "CHRIS DEPP"]}'),
('{ "_id" : "c1802b34e05c4c539599ca18302b7171", "title" : "TERMINATOR CLUB", "description" : "A Touching Story of a Crocodile And a Girl who must Sink a Man in The Gulf of Mexico", "release_year" : "2006", "language" : "English", "duration" : "88 min", "rating" : "R", "actors" : ["LIZA BERGMAN", "HUMPHREY WILLIS"]}'),
('{ "_id" : "0533794cc17545138680ee689f833f9f", "title" : "TEXAS WATCH", "description" : "A Awe-Inspiring Yarn of a Student And a Teacher who must Fight a Teacher in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "179 min", "rating" : "NC-17", "actors" : ["RIP CRAWFORD", "SYLVESTER DERN", "LIZA BERGMAN", "LUCILLE DEE", "IAN TANDY", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "841f0163e2424c20b1a88b88f916750e", "title" : "THEORY MERMAID", "description" : "A Fateful Yarn of a Composer And a Monkey who must Vanquish a Womanizer in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "184 min", "rating" : "PG-13", "actors" : ["CUBA OLIVIER", "FRED COSTNER", "WILL WILSON", "MENA HOPPER", "MARY KEITEL", "JULIA FAWCETT"]}'),
('{ "_id" : "5d8605a049094001aa0872bb42b81303", "title" : "THIEF PELICAN", "description" : "A Touching Documentary of a Madman And a Mad Scientist who must Outrace a Feminist in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "135 min", "rating" : "PG-13", "actors" : ["KIRSTEN PALTROW", "JOHNNY CAGE", "JAMES PITT", "WARREN NOLTE", "HARRISON BALE", "RENEE TRACY", "JAYNE NOLTE"]}'),
('{ "_id" : "022929c880394a0486c68c23a2bea184", "title" : "THIN SAGEBRUSH", "description" : "A Emotional Drama of a Husband And a Lumberjack who must Build a Cat in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "53 min", "rating" : "PG-13", "actors" : ["ZERO CAGE", "RALPH CRUZ"]}'),
('{ "_id" : "c3131ec78a6e483783f1a9c798de6eb9", "title" : "TIES HUNGER", "description" : "A Insightful Saga of a Astronaut And a Explorer who must Pursue a Mad Scientist in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "111 min", "rating" : "R", "actors" : ["JOE SWANK", "JULIA MCQUEEN", "PARKER GOLDBERG", "KIRSTEN AKROYD", "JAYNE NOLTE", "WILL WILSON"]}'),
('{ "_id" : "1c02e01d591c4c898b4ed5924188be56", "title" : "TIGHTS DAWN", "description" : "A Thrilling Epistle of a Boat And a Secret Agent who must Face a Boy in A Baloon", "release_year" : "2006", "language" : "English", "duration" : "172 min", "rating" : "R", "actors" : ["VIVIEN BERGEN", "TOM MIRANDA", "MORGAN HOPKINS", "IAN TANDY", "WILLIAM HACKMAN"]}'),
('{ "_id" : "34165633c7254c6183cdaaea40a9cf6f", "title" : "TIMBERLAND SKY", "description" : "A Boring Display of a Man And a Dog who must Redeem a Girl in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "69 min", "rating" : "G", "actors" : ["GARY PHOENIX", "JUDE CRUISE", "BEN HARRIS", "CHRISTOPHER WEST"]}'),
('{ "_id" : "06add28202044ae981aba22fcccd977f", "title" : "TITANIC BOONDOCK", "description" : "A Brilliant Reflection of a Feminist And a Dog who must Fight a Boy in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "104 min", "rating" : "R", "actors" : ["BETTE NICHOLSON", "DAN HARRIS", "PENELOPE CRONYN", "WARREN NOLTE", "JULIANNE DENCH", "EWAN GOODING", "JAYNE NOLTE", "GEOFFREY HESTON", "WILL WILSON", "OLYMPIA PFEIFFER", "MATTHEW CARREY", "MARY KEITEL"]}'),
('{ "_id" : "89d3e3085365492ba332e7e182077313", "title" : "TITANS JERK", "description" : "A Unbelieveable Panorama of a Feminist And a Sumo Wrestler who must Challenge a Technical Writer in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "91 min", "rating" : "PG", "actors" : ["KIRSTEN PALTROW", "DAN HARRIS", "CAMERON WRAY", "WOODY JOLIE", "GREG CHAPLIN", "SIDNEY CROWE", "KIM ALLEN"]}'),
('{ "_id" : "3563887dfb67474db0b85de466e5c8f2", "title" : "TOMATOES HELLFIGHTERS", "description" : "A Thoughtful Epistle of a Madman And a Astronaut who must Overcome a Monkey in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "68 min", "rating" : "PG", "actors" : ["JODIE DEGENERES", "GROUCHO DUNST", "WARREN NOLTE", "CAMERON ZELLWEGER", "PENELOPE MONROE", "RICHARD PENN", "ANGELA WITHERSPOON", "VIVIEN BASINGER", "KENNETH HOFFMAN"]}'),
('{ "_id" : "705845ddfd834009957ae4ec28a18a4f", "title" : "TOMORROW HUSTLER", "description" : "A Thoughtful Story of a Moose And a Husband who must Face a Secret Agent in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "142 min", "rating" : "R", "actors" : ["MATTHEW JOHANSSON", "REESE KILMER", "GARY PHOENIX", "MINNIE ZELLWEGER", "MATTHEW LEIGH", "GEOFFREY HESTON"]}'),
('{ "_id" : "e4bc1402ca764864a02ea8e853e816c7", "title" : "TOOTSIE PILOT", "description" : "A Awe-Inspiring Documentary of a Womanizer And a Pastry Chef who must Kill a Lumberjack in Berlin", "release_year" : "2006", "language" : "English", "duration" : "157 min", "rating" : "PG", "actors" : ["ZERO CAGE", "NICK STALLONE", "GENE HOPKINS", "VIVIEN BASINGER", "CUBA BIRCH"]}'),
('{ "_id" : "3433703323524cda87ff8e20b944892e", "title" : "TORQUE BOUND", "description" : "A Emotional Display of a Crocodile And a Husband who must Reach a Man in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "179 min", "rating" : "G", "actors" : ["UMA WOOD", "NATALIE HOPKINS", "ADAM HOPPER", "GENE HOPKINS", "KENNETH HOFFMAN"]}'),
('{ "_id" : "d07da74e4913457ebfb6749e7f06b52d", "title" : "TOURIST PELICAN", "description" : "A Boring Story of a Butler And a Astronaut who must Outrace a Pioneer in Australia", "release_year" : "2006", "language" : "English", "duration" : "152 min", "rating" : "PG-13", "actors" : ["PENELOPE MONROE", "BEN HARRIS", "OLYMPIA PFEIFFER"]}'),
('{ "_id" : "d0f74b2c45114fb783c6d9bc8cf7f870", "title" : "TOWERS HURRICANE", "description" : "A Fateful Display of a Monkey And a Car who must Sink a Husband in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "144 min", "rating" : "NC-17", "actors" : ["CATE MCQUEEN", "ADAM HOPPER", "RUSSELL TEMPLE", "CUBA BIRCH"]}'),
('{ "_id" : "082538cc35ee4133a071e768e4185842", "title" : "TOWN ARK", "description" : "A Awe-Inspiring Documentary of a Moose And a Madman who must Meet a Dog in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "136 min", "rating" : "R", "actors" : ["GRACE MOSTEL", "VAL BOLGER", "REESE KILMER", "WARREN JACKMAN"]}'),
('{ "_id" : "aeff45043a0e47f2aabacf3a84f7bf6f", "title" : "TRACY CIDER", "description" : "A Touching Reflection of a Database Administrator And a Madman who must Build a Lumberjack in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "142 min", "rating" : "G", "actors" : ["GRACE MOSTEL", "REESE KILMER", "SEAN GUINESS"]}'),
('{ "_id" : "73a224695e7b46e38b5cfaac35479246", "title" : "TRADING PINOCCHIO", "description" : "A Emotional Character Study of a Student And a Explorer who must Discover a Frisbee in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "170 min", "rating" : "PG", "actors" : ["BETTE NICHOLSON", "NICK STALLONE", "MILLA KEITEL"]}'),
('{ "_id" : "01feb77ec4c74305ab8a184f922d4446", "title" : "TRAFFIC HOBBIT", "description" : "A Amazing Epistle of a Squirrel And a Lumberjack who must Succumb a Database Administrator in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "139 min", "rating" : "G", "actors" : ["JOE SWANK", "DARYL WAHLBERG", "MATTHEW LEIGH", "OLYMPIA PFEIFFER"]}'),
('{ "_id" : "8e990f214cf74a1e8b1353b5d024967d", "title" : "TRAIN BUNCH", "description" : "A Thrilling Character Study of a Robot And a Squirrel who must Face a Dog in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "71 min", "rating" : "R", "actors" : ["RIP CRAWFORD", "JULIA MCQUEEN", "PENELOPE CRONYN", "ADAM HOPPER"]}'),
('{ "_id" : "5984770ce6e443758e76de27b13d81fb", "title" : "TRAINSPOTTING STRANGERS", "description" : "A Fast-Paced Drama of a Pioneer And a Mad Cow who must Challenge a Madman in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "132 min", "rating" : "PG-13", "actors" : ["GREG CHAPLIN", "GINA DEGENERES", "RITA REYNOLDS", "RUSSELL TEMPLE"]}'),
('{ "_id" : "6749012bea2b4c488aa2af2e2914a40f", "title" : "TRAMP OTHERS", "description" : "A Brilliant Display of a Composer And a Cat who must Succumb a A Shark in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "171 min", "rating" : "PG", "actors" : ["RIP CRAWFORD", "SIDNEY CROWE", "JADA RYDER", "RIVER DEAN", "RENEE BALL", "BELA WALKEN"]}'),
('{ "_id" : "7b517f9f79f5426797dd50e3f2cd409f", "title" : "TRANSLATION SUMMER", "description" : "A Touching Reflection of a Man And a Monkey who must Pursue a Womanizer in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "168 min", "rating" : "PG-13", "actors" : ["TOM MIRANDA", "LAURA BRODY", "MATTHEW CARREY"]}'),
('{ "_id" : "90ce91d5e47848489b08cd52d67e6745", "title" : "TRAP GUYS", "description" : "A Unbelieveable Story of a Boy And a Mad Cow who must Challenge a Database Administrator in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "110 min", "rating" : "G", "actors" : ["VIVIEN BERGEN", "WOODY HOFFMAN", "KENNETH PESCI", "ALBERT NOLTE", "HUMPHREY WILLIS", "WILLIAM HACKMAN", "BELA WALKEN"]}'),
('{ "_id" : "b0f9a969fe08455ca8fd56e0508d2a99", "title" : "TREASURE COMMAND", "description" : "A Emotional Saga of a Car And a Madman who must Discover a Pioneer in California", "release_year" : "2006", "language" : "English", "duration" : "102 min", "rating" : "PG-13", "actors" : ["JENNIFER DAVIS", "MARY TANDY", "ELLEN PRESLEY", "SPENCER DEPP", "CATE HARRIS", "ALBERT JOHANSSON", "OPRAH KILMER"]}'),
('{ "_id" : "bfb6c877680a4ae9b6eaf5170a5bffa3", "title" : "TREATMENT JEKYLL", "description" : "A Boring Story of a Teacher And a Student who must Outgun a Cat in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "87 min", "rating" : "PG", "actors" : ["GRACE MOSTEL", "SCARLETT DAMON", "SIDNEY CROWE", "DARYL CRAWFORD", "GENE MCKELLEN"]}'),
('{ "_id" : "63afcf3d252e43edb15b60212aa00b27", "title" : "TRIP NEWTON", "description" : "A Fanciful Character Study of a Lumberjack And a Car who must Discover a Cat in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "64 min", "rating" : "PG-13", "actors" : ["WOODY JOLIE", "PENELOPE MONROE", "KEVIN GARLAND", "MATTHEW CARREY"]}'),
('{ "_id" : "45a22fabcb004be1bc03f56e0e5da87c", "title" : "TROJAN TOMORROW", "description" : "A Astounding Panorama of a Husband And a Sumo Wrestler who must Pursue a Boat in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "52 min", "rating" : "PG", "actors" : ["ELVIS MARX", "JODIE DEGENERES", "ANGELINA ASTAIRE", "CHRIS BRIDGES", "MATTHEW LEIGH", "SUSAN DAVIS", "CATE MCQUEEN", "THORA TEMPLE"]}'),
('{ "_id" : "b27c5a79657141a1988d110c8ba2eeaf", "title" : "TROOPERS METAL", "description" : "A Fanciful Drama of a Monkey And a Feminist who must Sink a Man in Berlin", "release_year" : "2006", "language" : "English", "duration" : "115 min", "rating" : "R", "actors" : ["JULIA BARRYMORE", "PENELOPE PINKETT", "MORGAN MCDORMAND", "RUSSELL TEMPLE", "GRETA MALDEN"]}'),
('{ "_id" : "cf896769670b4bae98d4e835cbb8b766", "title" : "TROUBLE DATE", "description" : "A Lacklusture Panorama of a Forensic Psychologist And a Woman who must Kill a Explorer in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "61 min", "rating" : "PG", "actors" : ["CHRISTIAN GABLE", "KEVIN BLOOM", "JUDY DEAN", "KENNETH PALTROW", "JADA RYDER", "RUSSELL CLOSE", "RENEE BALL", "GREGORY GOODING"]}'),
('{ "_id" : "a11a454deac04fc4928141e0ebfcfff3", "title" : "TRUMAN CRAZY", "description" : "A Thrilling Epistle of a Moose And a Boy who must Meet a Database Administrator in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "92 min", "rating" : "G", "actors" : ["BURT DUKAKIS", "CARMEN HUNT", "MARY TANDY", "JESSICA BAILEY", "SIDNEY CROWE", "GENE HOPKINS"]}'),
('{ "_id" : "41bc3e01c1ab446eaacf3782c5c11457", "title" : "TURN STAR", "description" : "A Stunning Tale of a Man And a Monkey who must Chase a Student in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "80 min", "rating" : "G", "actors" : ["MAE HOFFMAN", "ELLEN PRESLEY", "REESE WEST"]}'),
('{ "_id" : "794ae4654a2343aab7f3539a6744fb6d", "title" : "TUXEDO MILE", "description" : "A Boring Drama of a Man And a Forensic Psychologist who must Face a Frisbee in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "152 min", "rating" : "R", "actors" : ["DAN TORN", "KIRK JOVOVICH", "MORGAN WILLIAMS"]}'),
('{ "_id" : "98b0570398e3494082004ec53e9d2309", "title" : "TWISTED PIRATES", "description" : "A Touching Display of a Frisbee And a Boat who must Kill a Girl in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "152 min", "rating" : "PG", "actors" : ["NATALIE HOPKINS", "JUDE CRUISE", "ADAM GRANT"]}'),
('{ "_id" : "0ad2d0b856df431c98643479625ea481", "title" : "TYCOON GATHERING", "description" : "A Emotional Display of a Husband And a A Shark who must Succumb a Madman in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "82 min", "rating" : "G", "actors" : ["VIVIEN BERGEN", "SPENCER DEPP", "CAMERON ZELLWEGER", "MINNIE KILMER", "MICHAEL BOLGER", "BELA WALKEN"]}'),
('{ "_id" : "b50faf6d3cf94382b4b263ac59c02508", "title" : "UNBREAKABLE KARATE", "description" : "A Amazing Character Study of a Robot And a Student who must Chase a Robot in Australia", "release_year" : "2006", "language" : "English", "duration" : "62 min", "rating" : "G", "actors" : ["KIRSTEN PALTROW", "GOLDIE BRODY", "REESE KILMER", "BURT POSEY", "WARREN NOLTE", "DARYL CRAWFORD", "HARVEY HOPE", "MICHAEL BOLGER"]}'),
('{ "_id" : "535f72ddeca84834a70732d70a453299", "title" : "UNCUT SUICIDES", "description" : "A Intrepid Yarn of a Explorer And a Pastry Chef who must Pursue a Mad Cow in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "172 min", "rating" : "PG-13", "actors" : ["RAY JOHANSSON", "MORGAN HOPKINS", "JANE JACKMAN", "RUSSELL TEMPLE", "HARVEY HOPE", "ALAN DREYFUSS", "MATTHEW CARREY"]}'),
('{ "_id" : "00c0ad7309ec45ca9ef1ae54a3ca6456", "title" : "UNDEFEATED DALMATIONS", "description" : "A Unbelieveable Display of a Crocodile And a Feminist who must Overcome a Moose in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "107 min", "rating" : "PG-13", "actors" : ["TOM MIRANDA", "FRANCES DAY-LEWIS", "ALBERT JOHANSSON"]}'),
('{ "_id" : "d669271a8c6d42a5a449428a4bfe8c0f", "title" : "UNFAITHFUL KILL", "description" : "A Taut Documentary of a Waitress And a Mad Scientist who must Battle a Technical Writer in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "78 min", "rating" : "R", "actors" : ["JULIA BARRYMORE", "GREG CHAPLIN", "DARYL WAHLBERG", "LUCILLE DEE", "WHOOPI HURT", "KIM ALLEN", "LAURENCE BULLOCK", "RENEE BALL"]}'),
('{ "_id" : "c9bb0446a7344cbea1749ea176c63c2f", "title" : "UNFORGIVEN ZOOLANDER", "description" : "A Taut Epistle of a Monkey And a Sumo Wrestler who must Vanquish a A Shark in A Baloon Factory", "release_year" : "2006", "language" : "English", "duration" : "129 min", "rating" : "PG", "actors" : ["JENNIFER DAVIS", "CUBA OLIVIER", "JULIA BARRYMORE", "NATALIE HOPKINS", "HARVEY HOPE", "ED GUINESS", "MARY KEITEL"]}'),
('{ "_id" : "b92050853a5943e28b490108c1a8e84e", "title" : "UNITED PILOT", "description" : "A Fast-Paced Reflection of a Cat And a Mad Cow who must Fight a Car in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "164 min", "rating" : "R", "actors" : ["VAL BOLGER", "REESE KILMER", "RAY JOHANSSON", "SEAN GUINESS", "MENA HOPPER", "ROCK DUKAKIS"]}'),
('{ "_id" : "0f588df90f2e422ab445fe4c19c56a07", "title" : "UNTOUCHABLES SUNRISE", "description" : "A Amazing Documentary of a Woman And a Astronaut who must Outrace a Teacher in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "120 min", "rating" : "NC-17", "actors" : ["JOE SWANK", "FRANCES DAY-LEWIS", "PENELOPE CRONYN", "RENEE TRACY", "JULIANNE DENCH"]}'),
('{ "_id" : "4a6e2945649c426b98af94ba866802e5", "title" : "UPRISING UPTOWN", "description" : "A Fanciful Reflection of a Boy And a Butler who must Pursue a Woman in Berlin", "release_year" : "2006", "language" : "English", "duration" : "174 min", "rating" : "NC-17", "actors" : ["ANNE CRONYN", "GENE HOPKINS", "BEN HARRIS", "HARVEY HOPE", "WILL WILSON"]}'),
('{ "_id" : "a5199f3e5d6a49e083d4d56cd8c00942", "title" : "UPTOWN YOUNG", "description" : "A Fateful Documentary of a Dog And a Hunter who must Pursue a Teacher in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "84 min", "rating" : "PG", "actors" : ["ZERO CAGE", "ALEC WAYNE", "TIM HACKMAN", "HENRY BERRY", "MARY TANDY", "SUSAN DAVIS", "ALAN DREYFUSS"]}'),
('{ "_id" : "1f3fd9b4f6fe47cdb7969d6f6f411852", "title" : "USUAL UNTOUCHABLES", "description" : "A Touching Display of a Explorer And a Lumberjack who must Fight a Forensic Psychologist in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "128 min", "rating" : "PG-13", "actors" : ["CHRISTIAN GABLE", "AUDREY OLIVIER", "GREG CHAPLIN", "KENNETH PESCI", "KIRSTEN AKROYD"]}'),
('{ "_id" : "f96dcaa41ad74919960fefc7734b091e", "title" : "VACATION BOONDOCK", "description" : "A Fanciful Character Study of a Secret Agent And a Mad Scientist who must Reach a Teacher in Australia", "release_year" : "2006", "language" : "English", "duration" : "145 min", "rating" : "R", "actors" : ["CHRISTIAN GABLE", "FAY KILMER", "MEG HAWKE", "GRETA KEITEL", "ADAM HOPPER", "LISA MONROE"]}'),
('{ "_id" : "9e914139decc4646a6cd3ac6b19d1e7f", "title" : "VALENTINE VANISHING", "description" : "A Thrilling Display of a Husband And a Butler who must Reach a Pastry Chef in California", "release_year" : "2006", "language" : "English", "duration" : "48 min", "rating" : "PG-13", "actors" : ["BURT DUKAKIS", "ED GUINESS"]}'),
('{ "_id" : "794b44d16ed548d9bb0c0b62bfe0ab09", "title" : "VALLEY PACKER", "description" : "A Astounding Documentary of a Astronaut And a Boy who must Outrace a Sumo Wrestler in Berlin", "release_year" : "2006", "language" : "English", "duration" : "73 min", "rating" : "G", "actors" : ["TOM MIRANDA", "CAMERON WRAY", "BEN WILLIS", "SUSAN DAVIS"]}'),
('{ "_id" : "fa46505492ca4ce78b7de5b6a28e4956", "title" : "VAMPIRE WHALE", "description" : "A Epic Story of a Lumberjack And a Monkey who must Confront a Pioneer in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "126 min", "rating" : "NC-17", "actors" : ["JOHNNY CAGE", "MEG HAWKE", "RICHARD PENN", "ED MANSFIELD", "ALAN DREYFUSS"]}'),
('{ "_id" : "d0452033d9124b80b38ef07698ee0fa8", "title" : "VANILLA DAY", "description" : "A Fast-Paced Saga of a Girl And a Forensic Psychologist who must Redeem a Girl in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "122 min", "rating" : "NC-17", "actors" : ["GROUCHO DUNST", "WHOOPI HURT"]}'),
('{ "_id" : "67a9e54d32c941c3a00cf037a8439e44", "title" : "VANISHED GARDEN", "description" : "A Intrepid Character Study of a Squirrel And a A Shark who must Kill a Lumberjack in California", "release_year" : "2006", "language" : "English", "duration" : "142 min", "rating" : "R", "actors" : ["SANDRA KILMER", "ANGELINA ASTAIRE"]}'),
('{ "_id" : "7a43410a785b4f8c809abacf255dbc3d", "title" : "VANISHING ROCKY", "description" : "A Brilliant Reflection of a Man And a Woman who must Conquer a Pioneer in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "123 min", "rating" : "NC-17", "actors" : ["MATTHEW JOHANSSON", "DAN HARRIS", "GARY PENN", "SUSAN DAVIS", "GENE HOPKINS"]}'),
('{ "_id" : "a3361c6614904384b133b83733872145", "title" : "VARSITY TRIP", "description" : "A Action-Packed Character Study of a Astronaut And a Explorer who must Reach a Monkey in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "NC-17", "actors" : ["NICK STALLONE", "MENA TEMPLE", "BURT TEMPLE"]}'),
('{ "_id" : "feb8841fd8b549ab8686b312adb43218", "title" : "VELVET TERMINATOR", "description" : "A Lacklusture Tale of a Pastry Chef And a Technical Writer who must Confront a Crocodile in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "173 min", "rating" : "R", "actors" : ["ZERO CAGE", "JOHNNY CAGE", "ANGELA HUDSON", "SEAN WILLIAMS", "CARY MCCONAUGHEY", "CUBA ALLEN", "DARYL CRAWFORD", "MINNIE KILMER", "MERYL ALLEN"]}'),
('{ "_id" : "7e1b49bb037d4af0a4e2bd339d46d000", "title" : "VERTIGO NORTHWEST", "description" : "A Unbelieveable Display of a Mad Scientist And a Mad Scientist who must Outgun a Mad Cow in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "90 min", "rating" : "R", "actors" : ["PENELOPE GUINESS", "DAN STREEP", "WARREN JACKMAN", "BELA WALKEN"]}'),
('{ "_id" : "d0b8cc91e548490d965f2d5aaed954f5", "title" : "VICTORY ACADEMY", "description" : "A Insightful Epistle of a Mad Scientist And a Explorer who must Challenge a Cat in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "64 min", "rating" : "PG-13", "actors" : ["GARY PHOENIX", "KENNETH PESCI", "DEBBIE AKROYD", "CUBA BIRCH", "MERYL ALLEN"]}'),
('{ "_id" : "07b32d670c2c48d683bcdc95e973a8e2", "title" : "VIDEOTAPE ARSENIC", "description" : "A Lacklusture Display of a Girl And a Astronaut who must Succumb a Student in Australia", "release_year" : "2006", "language" : "English", "duration" : "145 min", "rating" : "NC-17", "actors" : ["RALPH CRUZ", "CHRISTOPHER BERRY", "SUSAN DAVIS", "IAN TANDY", "RUSSELL CLOSE"]}'),
('{ "_id" : "47594de89f364710bb3cc0dcc062c52d", "title" : "VIETNAM SMOOCHY", "description" : "A Lacklusture Display of a Butler And a Man who must Sink a Explorer in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "174 min", "rating" : "PG-13", "actors" : ["JODIE DEGENERES", "MATTHEW LEIGH"]}'),
('{ "_id" : "027cd447321a4d5fab6e12a7cc955348", "title" : "VILLAIN DESPERATE", "description" : "A Boring Yarn of a Pioneer And a Feminist who must Redeem a Cat in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "76 min", "rating" : "PG-13", "actors" : ["DUSTIN TAUTOU", "CARY MCCONAUGHEY"]}'),
('{ "_id" : "79dad629d10d409babc65e49ce040040", "title" : "VIRGIN DAISY", "description" : "A Awe-Inspiring Documentary of a Robot And a Mad Scientist who must Reach a Database Administrator in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "179 min", "rating" : "PG-13", "actors" : ["DAN TORN", "ALEC WAYNE", "NICK STALLONE", "JULIA BARRYMORE", "CAMERON WRAY", "SPENCER DEPP", "CATE MCQUEEN", "NICK DEGENERES"]}'),
('{ "_id" : "f1ca442438b84c8eb5dedb9f20fb6a6a", "title" : "VIRGINIAN PLUTO", "description" : "A Emotional Panorama of a Dentist And a Crocodile who must Meet a Boy in Berlin", "release_year" : "2006", "language" : "English", "duration" : "164 min", "rating" : "R", "actors" : ["KARL BERRY", "SANDRA PECK", "CAMERON WRAY", "JESSICA BAILEY", "GENE WILLIS", "PENELOPE CRONYN", "ALBERT JOHANSSON", "THORA TEMPLE"]}'),
('{ "_id" : "eb6920699b834af08ba73b0e3e89965e", "title" : "VIRTUAL SPOILERS", "description" : "A Fateful Tale of a Database Administrator And a Squirrel who must Discover a Student in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "144 min", "rating" : "NC-17", "actors" : ["DUSTIN TAUTOU", "GARY PENN", "JON CHASE"]}'),
('{ "_id" : "a4bcaa6281bc412994eea958bf9cb743", "title" : "VISION TORQUE", "description" : "A Thoughtful Documentary of a Dog And a Man who must Sink a Man in A Shark Tank", "release_year" : "2006", "language" : "English", "duration" : "59 min", "rating" : "PG-13", "actors" : ["MENA TEMPLE", "MEG HAWKE", "RUSSELL TEMPLE", "CHRISTOPHER WEST", "AL GARLAND"]}'),
('{ "_id" : "6dd497e50b0b47849f5534f223cc9671", "title" : "VOICE PEACH", "description" : "A Amazing Panorama of a Pioneer And a Student who must Overcome a Mad Scientist in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "139 min", "rating" : "PG-13", "actors" : ["VIVIEN BERGEN", "HELEN VOIGHT", "AL GARLAND"]}'),
('{ "_id" : "fc584648b07d45729a8e2b0060fe528e", "title" : "VOLCANO TEXAS", "description" : "A Awe-Inspiring Yarn of a Hunter And a Feminist who must Challenge a Dentist in The Outback", "release_year" : "2006", "language" : "English", "duration" : "157 min", "rating" : "NC-17", "actors" : ["CUBA OLIVIER", "ALBERT NOLTE", "CATE MCQUEEN", "RUSSELL TEMPLE", "RUSSELL CLOSE"]}'),
('{ "_id" : "a266a6c96c394db6a6c1a9802713399c", "title" : "VOLUME HOUSE", "description" : "A Boring Tale of a Dog And a Woman who must Meet a Dentist in California", "release_year" : "2006", "language" : "English", "duration" : "132 min", "rating" : "PG", "actors" : ["AUDREY OLIVIER", "GARY PENN", "KENNETH TORN", "CHRIS DEPP", "REESE WEST"]}'),
('{ "_id" : "fbcffb4402104f17a4af5aa0afd66b72", "title" : "VOYAGE LEGALLY", "description" : "A Epic Tale of a Squirrel And a Hunter who must Conquer a Boy in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "78 min", "rating" : "PG-13", "actors" : ["CARMEN HUNT", "JAYNE NEESON", "ANGELA HUDSON", "MARY TANDY", "MEG HAWKE"]}'),
('{ "_id" : "0f33517323724a8bb5b89be233fb4a5d", "title" : "WAGON JAWS", "description" : "A Intrepid Drama of a Moose And a Boat who must Kill a Explorer in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "152 min", "rating" : "PG", "actors" : ["NICK STALLONE", "HENRY BERRY", "SPENCER PECK", "HARRISON BALE", "RICHARD PENN", "MARY KEITEL"]}'),
('{ "_id" : "e0a8b8f9b2ed46d5bc4b2e0e30fd2db2", "title" : "WAIT CIDER", "description" : "A Intrepid Epistle of a Woman And a Forensic Psychologist who must Succumb a Astronaut in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "112 min", "rating" : "PG-13", "actors" : ["WOODY HOFFMAN", "MICHELLE MCCONAUGHEY", "KEVIN GARLAND", "ANGELA WITHERSPOON", "KIM ALLEN", "JAYNE NOLTE", "OLYMPIA PFEIFFER", "BURT TEMPLE", "JULIA FAWCETT"]}'),
('{ "_id" : "cdc384bbbfc4457c922b49f812a3d926", "title" : "WAKE JAWS", "description" : "A Beautiful Saga of a Feminist And a Composer who must Challenge a Moose in Berlin", "release_year" : "2006", "language" : "English", "duration" : "73 min", "rating" : "G", "actors" : ["WOODY JOLIE", "SIDNEY CROWE", "MERYL GIBSON", "CHRIS DEPP", "KENNETH HOFFMAN"]}'),
('{ "_id" : "9cc952f61ac24d61863c93ba0d64723f", "title" : "WALLS ARTIST", "description" : "A Insightful Panorama of a Teacher And a Teacher who must Overcome a Mad Cow in An Abandoned Fun House", "release_year" : "2006", "language" : "English", "duration" : "135 min", "rating" : "PG", "actors" : ["CHRIS BRIDGES", "SYLVESTER DERN", "HARRISON BALE", "ALBERT JOHANSSON", "JEFF SILVERSTONE"]}'),
('{ "_id" : "bcedc3c756054b1e8ae92afe74c09d1f", "title" : "WANDA CHAMBER", "description" : "A Insightful Drama of a A Shark And a Pioneer who must Find a Womanizer in The Outback", "release_year" : "2006", "language" : "English", "duration" : "107 min", "rating" : "PG-13", "actors" : ["BURT DUKAKIS", "ADAM GRANT", "SEAN WILLIAMS", "MILLA KEITEL", "MATTHEW LEIGH", "DAN STREEP", "GENE MCKELLEN"]}'),
('{ "_id" : "c47bf898bc8f4c66ac3ca67e92f75039", "title" : "WAR NOTTING", "description" : "A Boring Drama of a Teacher And a Sumo Wrestler who must Challenge a Secret Agent in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "80 min", "rating" : "G", "actors" : ["GRACE MOSTEL", "HELEN VOIGHT", "NATALIE HOPKINS", "MARY TANDY", "MINNIE ZELLWEGER", "CUBA ALLEN", "SALMA NOLTE", "FAY WINSLET", "HUMPHREY WILLIS"]}'),
('{ "_id" : "1e95f6786efa4bd48efd085077ad3605", "title" : "WARDROBE PHANTOM", "description" : "A Action-Packed Display of a Mad Cow And a Astronaut who must Kill a Car in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "178 min", "rating" : "G", "actors" : ["NICK WAHLBERG", "KIRK JOVOVICH", "ANGELINA ASTAIRE", "WALTER TORN", "WARREN NOLTE", "RIVER DEAN", "GREGORY GOODING", "THORA TEMPLE"]}'),
('{ "_id" : "a98d9b127fec4e71b93ba67b16f0fb45", "title" : "WARLOCK WEREWOLF", "description" : "A Astounding Yarn of a Pioneer And a Crocodile who must Defeat a A Shark in The Outback", "release_year" : "2006", "language" : "English", "duration" : "83 min", "rating" : "G", "actors" : ["GRACE MOSTEL", "HELEN VOIGHT", "WILL WILSON", "GROUCHO WILLIAMS", "HUMPHREY GARLAND", "AUDREY BAILEY"]}'),
('{ "_id" : "5d4ca9a3c15349ec9c8e8dade9c14eca", "title" : "WARS PLUTO", "description" : "A Taut Reflection of a Teacher And a Database Administrator who must Chase a Madman in The Sahara Desert", "release_year" : "2006", "language" : "English", "duration" : "128 min", "rating" : "G", "actors" : ["MARY TANDY", "MINNIE ZELLWEGER", "ED GUINESS", "BURT TEMPLE"]}'),
('{ "_id" : "24b7437f5b1f44a0b0762c8130d26648", "title" : "WASH HEAVENLY", "description" : "A Awe-Inspiring Reflection of a Cat And a Pioneer who must Escape a Hunter in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "161 min", "rating" : "R", "actors" : ["MENA TEMPLE", "SPENCER PECK", "SUSAN DAVIS", "MORGAN MCDORMAND", "SALMA NOLTE"]}'),
('{ "_id" : "9a0d18deca674b10a15f19e8ad1270a8", "title" : "WASTELAND DIVINE", "description" : "A Fanciful Story of a Database Administrator And a Womanizer who must Fight a Database Administrator in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "PG", "actors" : ["LUCILLE TRACY", "CAMERON ZELLWEGER", "DARYL CRAWFORD", "JAYNE NOLTE", "AL GARLAND", "JAYNE SILVERSTONE"]}'),
('{ "_id" : "508f08a1c0694d998ebd7ad3467a252f", "title" : "WATCH TRACY", "description" : "A Fast-Paced Yarn of a Dog And a Frisbee who must Conquer a Hunter in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "78 min", "rating" : "PG", "actors" : ["VAL BOLGER", "FAY KILMER", "CARY MCCONAUGHEY", "GROUCHO SINATRA", "JEFF SILVERSTONE"]}'),
('{ "_id" : "d5548059882f4ee1b25fa864d7a4277f", "title" : "WATERFRONT DELIVERANCE", "description" : "A Unbelieveable Documentary of a Dentist And a Technical Writer who must Build a Womanizer in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "61 min", "rating" : "G", "actors" : ["JOE SWANK", "CHRISTIAN GABLE", "ELVIS MARX", "MICHELLE MCCONAUGHEY", "SEAN WILLIAMS", "BEN HARRIS"]}'),
('{ "_id" : "341fc81db6064b41871df9dfe20e5911", "title" : "WATERSHIP FRONTIER", "description" : "A Emotional Yarn of a Boat And a Crocodile who must Meet a Moose in Soviet Georgia", "release_year" : "2006", "language" : "English", "duration" : "112 min", "rating" : "G", "actors" : ["MILLA PECK", "DAN HARRIS", "ANGELA HUDSON", "ALBERT NOLTE", "CATE MCQUEEN", "MICHAEL BOLGER"]}'),
('{ "_id" : "bd6bf8e657514936bf052ca0abf15931", "title" : "WEDDING APOLLO", "description" : "A Action-Packed Tale of a Student And a Waitress who must Conquer a Lumberjack in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "70 min", "rating" : "PG", "actors" : ["ED CHASE", "CHRISTIAN GABLE", "UMA WOOD", "VAL BOLGER", "WARREN NOLTE", "HARRISON BALE", "LIZA BERGMAN", "ALBERT JOHANSSON", "IAN TANDY", "HUMPHREY GARLAND"]}'),
('{ "_id" : "0057b02f021544a1ba8d05fc4044d1be", "title" : "WEEKEND PERSONAL", "description" : "A Fast-Paced Documentary of a Car And a Butler who must Find a Frisbee in A Jet Boat", "release_year" : "2006", "language" : "English", "duration" : "134 min", "rating" : "R", "actors" : ["ED CHASE", "FRED COSTNER", "JULIA MCQUEEN", "JIM MOSTEL", "SPENCER DEPP", "SYLVESTER DERN", "GRETA MALDEN", "VIVIEN BASINGER", "HUMPHREY GARLAND", "REESE WEST"]}'),
('{ "_id" : "b712a0dba9314b1faa4497efdf1c5806", "title" : "WEREWOLF LOLA", "description" : "A Fanciful Story of a Man And a Sumo Wrestler who must Outrace a Student in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "79 min", "rating" : "G", "actors" : ["CUBA OLIVIER", "GROUCHO SINATRA", "KENNETH PESCI", "GENE WILLIS", "BEN HARRIS", "VIVIEN BASINGER", "OPRAH KILMER"]}'),
('{ "_id" : "5636d43a6b24445f9b46cb2077367117", "title" : "WEST LION", "description" : "A Intrepid Drama of a Butler And a Lumberjack who must Challenge a Database Administrator in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "159 min", "rating" : "G", "actors" : ["ZERO CAGE", "CAMERON STREEP", "SEAN WILLIAMS", "CARY MCCONAUGHEY", "MORGAN HOPKINS", "CUBA ALLEN", "ALBERT JOHANSSON", "HUMPHREY GARLAND", "GREGORY GOODING"]}'),
('{ "_id" : "8ba12e41ebd14e63a8e62361bbf4cc6b", "title" : "WESTWARD SEABISCUIT", "description" : "A Lacklusture Tale of a Butler And a Husband who must Face a Boy in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "52 min", "rating" : "NC-17", "actors" : ["PENELOPE GUINESS", "VIVIEN BERGEN", "PENELOPE PINKETT", "CHARLIZE DENCH", "KEVIN GARLAND", "LUCILLE DEE"]}'),
('{ "_id" : "9ef3f4de310c4dabbee6fac59c8607a2", "title" : "WHALE BIKINI", "description" : "A Intrepid Story of a Pastry Chef And a Database Administrator who must Kill a Feminist in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "109 min", "rating" : "PG-13", "actors" : ["ED CHASE", "AUDREY OLIVIER", "HENRY BERRY", "RIP WINSLET", "GREGORY GOODING"]}'),
('{ "_id" : "306d465c6cd046ebb7bee2911f89afda", "title" : "WHISPERER GIANT", "description" : "A Intrepid Story of a Dentist And a Hunter who must Confront a Monkey in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "59 min", "rating" : "PG-13", "actors" : ["MILLA PECK", "JESSICA BAILEY", "BELA WALKEN"]}'),
('{ "_id" : "8489e1455e0b43a4945f14dbdd010e91", "title" : "WIFE TURN", "description" : "A Awe-Inspiring Epistle of a Teacher And a Feminist who must Confront a Pioneer in Ancient Japan", "release_year" : "2006", "language" : "English", "duration" : "183 min", "rating" : "NC-17", "actors" : ["WOODY HOFFMAN", "JULIA BARRYMORE", "GINA DEGENERES", "CAMERON ZELLWEGER", "GRETA MALDEN", "MICHAEL BOLGER"]}'),
('{ "_id" : "4fe7e1a56e6443aabc57bb17286d09c6", "title" : "WILD APOLLO", "description" : "A Beautiful Story of a Monkey And a Sumo Wrestler who must Conquer a A Shark in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "181 min", "rating" : "R", "actors" : ["JOE SWANK", "GARY PHOENIX", "LISA MONROE", "REESE WEST"]}'),
('{ "_id" : "7b6261037d454035a5888ee5b0ac6a6b", "title" : "WILLOW TRACY", "description" : "A Brilliant Panorama of a Boat And a Astronaut who must Challenge a Teacher in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "137 min", "rating" : "R", "actors" : ["REESE KILMER", "JAMES PITT"]}'),
('{ "_id" : "ec61b4886855420386b0fdae3aa033c4", "title" : "WIND PHANTOM", "description" : "A Touching Saga of a Madman And a Forensic Psychologist who must Build a Sumo Wrestler in An Abandoned Mine Shaft", "release_year" : "2006", "language" : "English", "duration" : "111 min", "rating" : "R", "actors" : ["CHARLIZE DENCH", "ED GUINESS", "RENEE BALL"]}'),
('{ "_id" : "30771585934843448740be099bacf021", "title" : "WINDOW SIDE", "description" : "A Astounding Character Study of a Womanizer And a Hunter who must Escape a Robot in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "R", "actors" : ["LUCILLE TRACY", "ANNE CRONYN", "GINA DEGENERES", "WILLIAM HACKMAN"]}'),
('{ "_id" : "19b1cbe81d1641a2b5cf635c1f21d6e1", "title" : "WISDOM WORKER", "description" : "A Unbelieveable Saga of a Forensic Psychologist And a Student who must Face a Squirrel in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "98 min", "rating" : "R", "actors" : ["SISSY SOBIESKI", "REESE KILMER", "WOODY JOLIE", "JIM MOSTEL", "SUSAN DAVIS", "LAURA BRODY", "WILLIAM HACKMAN"]}'),
('{ "_id" : "5a6e3aa8381a4312a912058605302dc0", "title" : "WITCHES PANIC", "description" : "A Awe-Inspiring Drama of a Secret Agent And a Hunter who must Fight a Moose in Nigeria", "release_year" : "2006", "language" : "English", "duration" : "100 min", "rating" : "NC-17", "actors" : ["RALPH CRUZ", "SPENCER DEPP", "WALTER TORN", "REESE WEST"]}'),
('{ "_id" : "4b4bf1664fb2439fb40f95719040b75d", "title" : "WIZARD COLDBLOODED", "description" : "A Lacklusture Display of a Robot And a Girl who must Defeat a Sumo Wrestler in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "75 min", "rating" : "PG", "actors" : ["PENELOPE GUINESS", "CHRISTIAN GABLE", "TIM HACKMAN", "PARKER GOLDBERG", "ANNE CRONYN", "MENA TEMPLE", "RAY JOHANSSON", "SUSAN DAVIS", "WALTER TORN"]}'),
('{ "_id" : "4e9c9944fd254c4ba53298fa4e19b46b", "title" : "WOLVES DESIRE", "description" : "A Fast-Paced Drama of a Squirrel And a Robot who must Succumb a Technical Writer in A Manhattan Penthouse", "release_year" : "2006", "language" : "English", "duration" : "55 min", "rating" : "NC-17", "actors" : ["SANDRA KILMER", "JAYNE NEESON", "CAMERON WRAY", "JESSICA BAILEY", "MORGAN HOPKINS", "GRETA KEITEL"]}'),
('{ "_id" : "f056ca8258f94356915af7a3306dcc09", "title" : "WOMEN DORADO", "description" : "A Insightful Documentary of a Waitress And a Butler who must Vanquish a Composer in Australia", "release_year" : "2006", "language" : "English", "duration" : "126 min", "rating" : "R", "actors" : ["NICK STALLONE", "CHRISTOPHER BERRY", "ELLEN PRESLEY", "JIM MOSTEL", "MICHAEL BENING"]}'),
('{ "_id" : "3cf0f841d27546f1bdd38d6959c64b04", "title" : "WON DARES", "description" : "A Unbelieveable Documentary of a Teacher And a Monkey who must Defeat a Explorer in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "105 min", "rating" : "PG", "actors" : ["CHRISTIAN GABLE", "KIRSTEN PALTROW", "LISA MONROE", "RUSSELL CLOSE", "JULIA ZELLWEGER"]}'),
('{ "_id" : "b1188336741e42e6b2ec09a8fa43da85", "title" : "WONDERFUL DROP", "description" : "A Boring Panorama of a Woman And a Madman who must Overcome a Butler in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "126 min", "rating" : "NC-17", "actors" : ["DUSTIN TAUTOU", "SUSAN DAVIS", "PENELOPE CRONYN", "HUMPHREY WILLIS"]}'),
('{ "_id" : "780673c484804fefb174b46755fe0363", "title" : "WONDERLAND CHRISTMAS", "description" : "A Awe-Inspiring Character Study of a Waitress And a Car who must Pursue a Mad Scientist in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "111 min", "rating" : "PG", "actors" : ["CUBA OLIVIER", "WOODY JOLIE", "CHRIS BRIDGES", "HARRISON BALE", "HUMPHREY GARLAND"]}'),
('{ "_id" : "20996ee25c0d4ea4912ed5b0a8a059ea", "title" : "WONKA SEA", "description" : "A Brilliant Saga of a Boat And a Mad Scientist who must Meet a Moose in Ancient India", "release_year" : "2006", "language" : "English", "duration" : "85 min", "rating" : "NC-17", "actors" : ["JULIA MCQUEEN", "HENRY BERRY"]}'),
('{ "_id" : "6168fa96966640f280c1c259029ce6a1", "title" : "WORDS HUNTER", "description" : "A Action-Packed Reflection of a Composer And a Mad Scientist who must Face a Pioneer in A MySQL Convention", "release_year" : "2006", "language" : "English", "duration" : "116 min", "rating" : "PG", "actors" : ["GENE WILLIS", "SUSAN DAVIS", "SCARLETT BENING", "ADAM HOPPER", "FAY WINSLET", "IAN TANDY"]}'),
('{ "_id" : "3414dbe6fbaf41a59bcebf8eec2df643", "title" : "WORKER TARZAN", "description" : "A Action-Packed Yarn of a Secret Agent And a Technical Writer who must Battle a Sumo Wrestler in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "139 min", "rating" : "R", "actors" : ["ZERO CAGE", "PENELOPE PINKETT", "JAYNE NEESON", "SUSAN DAVIS", "RUSSELL BACALL", "JULIANNE DENCH", "MINNIE KILMER", "MERYL GIBSON", "ROCK DUKAKIS"]}'),
('{ "_id" : "a3ca64306eef431fa7b36f9aa01d2797", "title" : "WORKING MICROCOSMOS", "description" : "A Stunning Epistle of a Dentist And a Dog who must Kill a Madman in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "74 min", "rating" : "R", "actors" : ["VAL BOLGER", "KENNETH TORN", "LUCILLE DEE", "GEOFFREY HESTON", "ROCK DUKAKIS"]}'),
('{ "_id" : "f2597733c4e64405be8be8969730a26b", "title" : "WORLD LEATHERNECKS", "description" : "A Unbelieveable Tale of a Pioneer And a Astronaut who must Overcome a Robot in An Abandoned Amusement Park", "release_year" : "2006", "language" : "English", "duration" : "171 min", "rating" : "PG-13", "actors" : ["GARY PHOENIX", "PENELOPE PINKETT", "CHRISTIAN NEESON", "JAYNE NEESON", "CHRIS BRIDGES", "SIDNEY CROWE", "VIVIEN BASINGER", "DEBBIE AKROYD"]}'),
('{ "_id" : "7ec3652d655b44a69b585b7f3ab82566", "title" : "WORST BANGER", "description" : "A Thrilling Drama of a Madman And a Dentist who must Conquer a Boy in The Outback", "release_year" : "2006", "language" : "English", "duration" : "185 min", "rating" : "PG", "actors" : ["PARKER GOLDBERG", "KIRSTEN AKROYD", "SPENCER DEPP", "MATTHEW CARREY"]}'),
('{ "_id" : "130123f317c54a55886e5ecaa809ff8f", "title" : "WRATH MILE", "description" : "A Intrepid Reflection of a Technical Writer And a Hunter who must Defeat a Sumo Wrestler in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "176 min", "rating" : "NC-17", "actors" : ["SPENCER DEPP", "CATE HARRIS", "RUSSELL TEMPLE", "KENNETH HOFFMAN"]}'),
('{ "_id" : "db600ddb109540a59e48d69535f8a8c0", "title" : "WRONG BEHAVIOR", "description" : "A Emotional Saga of a Crocodile And a Sumo Wrestler who must Discover a Mad Cow in New Orleans", "release_year" : "2006", "language" : "English", "duration" : "178 min", "rating" : "PG-13", "actors" : ["MILLA PECK", "GARY PHOENIX", "CARY MCCONAUGHEY", "SIDNEY CROWE", "MORGAN MCDORMAND", "ED MANSFIELD", "MENA HOPPER", "GREGORY GOODING", "THORA TEMPLE"]}'),
('{ "_id" : "288b3d2fb4ee4d58b63bd7aa194b3aa7", "title" : "WYOMING STORM", "description" : "A Awe-Inspiring Panorama of a Robot And a Boat who must Overcome a Feminist in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "100 min", "rating" : "PG-13", "actors" : ["BETTE NICHOLSON", "WOODY HOFFMAN", "SIDNEY CROWE", "HARRISON BALE", "PENELOPE MONROE", "JULIA ZELLWEGER"]}'),
('{ "_id" : "e35ea24334fd48d0bd425c1d52a4da9b", "title" : "YENTL IDAHO", "description" : "A Amazing Display of a Robot And a Astronaut who must Fight a Womanizer in Berlin", "release_year" : "2006", "language" : "English", "duration" : "86 min", "rating" : "R", "actors" : ["REESE WEST"]}'),
('{ "_id" : "98f634c6888b497c9083eacc2fd3db08", "title" : "YOUNG LANGUAGE", "description" : "A Unbelieveable Yarn of a Boat And a Database Administrator who must Meet a Boy in The First Manned Space Station", "release_year" : "2006", "language" : "English", "duration" : "183 min", "rating" : "G", "actors" : ["ED CHASE", "JULIA MCQUEEN", "JAMES PITT", "CHRISTOPHER WEST", "MENA HOPPER"]}'),
('{ "_id" : "2000182103c24026bb33d0a3f25af6e4", "title" : "YOUTH KICK", "description" : "A Touching Drama of a Teacher And a Cat who must Challenge a Technical Writer in A U-Boat", "release_year" : "2006", "language" : "English", "duration" : "179 min", "rating" : "NC-17", "actors" : ["SANDRA KILMER", "VAL BOLGER", "SCARLETT BENING", "IAN TANDY", "MARY KEITEL"]}'),
('{ "_id" : "9328d786e1914a35aae3927482cde551", "title" : "ZHIVAGO CORE", "description" : "A Fateful Yarn of a Composer And a Man who must Face a Boy in The Canadian Rockies", "release_year" : "2006", "language" : "English", "duration" : "105 min", "rating" : "NC-17", "actors" : ["UMA WOOD", "NICK STALLONE", "GARY PENN", "SALMA NOLTE", "KENNETH HOFFMAN", "WILLIAM HACKMAN"]}'),
('{ "_id" : "ad8e90d61fd64dd8a418538c6077fb70", "title" : "ZOOLANDER FICTION", "description" : "A Fateful Reflection of a Waitress And a Boat who must Discover a Sumo Wrestler in Ancient China", "release_year" : "2006", "language" : "English", "duration" : "101 min", "rating" : "R", "actors" : ["CARMEN HUNT", "MARY TANDY", "PENELOPE CRONYN", "WHOOPI HURT", "JADA RYDER"]}'),
('{ "_id" : "7bf3123281e64777b70be80ad271f6af", "title" : "ZORRO ARK", "description" : "A Intrepid Panorama of a Mad Scientist And a Boy who must Redeem a Boy in A Monastery", "release_year" : "2006", "language" : "English", "duration" : "50 min", "rating" : "NC-17", "actors" : ["IAN TANDY", "NICK DEGENERES", "LISA MONROE"] }');

INSERT INTO `users` (`doc`) VALUES('{"_id" : "6e2ff14eeeca4c55a201180e1928da18", "name" : "Benita Jacks", "email" : "benita410@fakemail.com", "password" : "Jacks728" }'), 
('{"_id" : "4a6ccf7eb8434ffba0fd049c5f73e0d7", "name" : "Malorie Falcone", "email" : "malorie1174@fakemail.com", "password" : "Falcone316" }'), 
('{"_id" : "f0d10342e6464f74a67b62045301453d", "name" : "Warner Kight", "email" : "warner994@fakemail.com", "password" : "Kight1189" }'), 
('{"_id" : "a54ebf376a6d4122bdaf8c11a855587f", "name" : "Lynette Bragg", "email" : "lynette1755@fakemail.com", "password" : "Bragg243" }'), 
('{"_id" : "31938bacd35242a49a41e1673222ad5f", "name" : "Brittaney Mcsweeney", "email" : "brittaney1479@fakemail.com", "password" : "Mcsweeney747" }'), 
('{"_id" : "dece283d074a4997afa0ca4af2edf294", "name" : "Horace Michaelson", "email" : "horace809@fakemail.com", "password" : "Michaelson813" }'), 
('{"_id" : "4d0f9c2ccb0a4f7e9be9940684ba3856", "name" : "Adriane Iwamoto", "email" : "adriane910@fakemail.com", "password" : "Iwamoto1461" }'), 
('{"_id" : "85951c3fb7aa428f8525db4053de21c1", "name" : "Elda Longshore", "email" : "elda1742@fakemail.com", "password" : "Longshore764" }'), 
('{"_id" : "b938884e4b9f45c1bff8cacddab807e9", "name" : "Jenine Moro", "email" : "jenine896@fakemail.com", "password" : "Moro1847" }'), 
('{"_id" : "5e6caab9417d46fbb6e9efad3f06585f", "name" : "Leida Aquirre", "email" : "leida136@fakemail.com", "password" : "Aquirre77" }');

INSERT INTO `character` (`name`, `age`, `gender`, `universe`, `base`) VALUES
('Sarah Palmer', 31, 'female', 'Halo 4', TRUE),
('Avery Johnson', 78, 'male', 'Halo', TRUE),
('Miranda Keys', 27, 'female', 'Halo 2', TRUE),
('Catherine Halsey', 66, 'female', 'Halo: Reach', TRUE),
('Catherine-B320', 22, 'female', 'Halo: Reach', TRUE),
('Jun-A266', 34, 'male', 'Halo: Reach', TRUE),
('Jorge-052', 41, 'male', 'Halo: Reach', TRUE),
('Emile-A239', 29, 'male', 'Halo: Reach', TRUE),
('Carter-A259', 32, 'male', 'Halo: Reach', TRUE),
('John-117', 47, 'male', 'Halo', TRUE),
('Linda-058', 47, 'female', 'Halo 5', TRUE),
('Jameson Locke', 29, 'male', 'Halo 5', TRUE),
('Kelly-087', 48, 'female', 'Halo 5', TRUE),
('Frederic-104', 47, 'male', 'Halo 5', TRUE),
('Edward Buck', 48, 'male', 'Halo 5', TRUE),
('Holly Tanaka', 28, 'female', 'Halo 5', TRUE),
('Olympia Vale', 22, 'female', 'Halo 5', TRUE),
('Thane Krios 2', 39, 'male', 'Mass Effect 2', TRUE),
('Jeff Moreau', 30, 'male', 'Mass Effect', TRUE),
('Jacob Taylor', 28, 'male', 'Mass Effect 2', TRUE),
('Kasumi Goto', 25, 'female', 'Mass Effect 2', TRUE),
('Jacqueline Nought', 24, 'female', 'Mass Effect 2', TRUE),
('Saren Arterius', 44, 'male', 'Mass Effect', TRUE),
('Mordin Solus', 50, 'male', 'Mass Effect 2', TRUE),
('David Anderson', 48, 'male', 'Mass Effect', TRUE),
('Zaeed Massani', 55, 'male', 'Mass Effect 2', TRUE),
('Kaidan Alenko', 35, 'male', 'Mass Effect', TRUE);