# coding: utf-8
# Modified Work: Copyright (c) 2018, 2021, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# Original Work: Copyright (c) 2018 Character Encoding Detector contributors.  https://github.com/chardet

#!/usr/bin/env python
# -*- coding: utf-8 -*-

from .sbcharsetprober import SingleByteCharSetModel


# 3: Positive
# 2: Likely
# 1: Unlikely
# 0: Negative

RUSSIAN_LANG_MODEL = {
    37: {  # 'А'
        37: 0,  # 'А'
        44: 1,  # 'Б'
        33: 1,  # 'В'
        46: 1,  # 'Г'
        41: 1,  # 'Д'
        48: 1,  # 'Е'
        56: 1,  # 'Ж'
        51: 1,  # 'З'
        42: 1,  # 'И'
        60: 1,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 2,  # 'Н'
        34: 1,  # 'О'
        35: 1,  # 'П'
        45: 1,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 1,  # 'У'
        53: 1,  # 'Ф'
        55: 1,  # 'Х'
        58: 1,  # 'Ц'
        50: 1,  # 'Ч'
        57: 1,  # 'Ш'
        63: 1,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 1,  # 'Ю'
        43: 1,  # 'Я'
        3: 1,  # 'а'
        21: 2,  # 'б'
        10: 2,  # 'в'
        19: 2,  # 'г'
        13: 2,  # 'д'
        2: 0,  # 'е'
        24: 1,  # 'ж'
        20: 1,  # 'з'
        4: 0,  # 'и'
        23: 1,  # 'й'
        11: 2,  # 'к'
        8: 3,  # 'л'
        12: 2,  # 'м'
        5: 2,  # 'н'
        1: 0,  # 'о'
        15: 2,  # 'п'
        9: 2,  # 'р'
        7: 2,  # 'с'
        6: 2,  # 'т'
        14: 2,  # 'у'
        39: 2,  # 'ф'
        26: 2,  # 'х'
        28: 0,  # 'ц'
        22: 1,  # 'ч'
        25: 2,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 1,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    44: {  # 'Б'
        37: 1,  # 'А'
        44: 0,  # 'Б'
        33: 1,  # 'В'
        46: 1,  # 'Г'
        41: 0,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 0,  # 'П'
        45: 1,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 1,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 1,  # 'Я'
        3: 2,  # 'а'
        21: 0,  # 'б'
        10: 0,  # 'в'
        19: 0,  # 'г'
        13: 1,  # 'д'
        2: 3,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 2,  # 'л'
        12: 0,  # 'м'
        5: 0,  # 'н'
        1: 3,  # 'о'
        15: 0,  # 'п'
        9: 2,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 2,  # 'ы'
        17: 1,  # 'ь'
        30: 2,  # 'э'
        27: 1,  # 'ю'
        16: 1,  # 'я'
    },
    33: {  # 'В'
        37: 2,  # 'А'
        44: 0,  # 'Б'
        33: 1,  # 'В'
        46: 0,  # 'Г'
        41: 1,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 1,  # 'П'
        45: 1,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 1,  # 'Ш'
        63: 0,  # 'Щ'
        62: 1,  # 'Ы'
        61: 1,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 1,  # 'Я'
        3: 2,  # 'а'
        21: 1,  # 'б'
        10: 1,  # 'в'
        19: 1,  # 'г'
        13: 2,  # 'д'
        2: 3,  # 'е'
        24: 0,  # 'ж'
        20: 2,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 1,  # 'к'
        8: 2,  # 'л'
        12: 2,  # 'м'
        5: 2,  # 'н'
        1: 3,  # 'о'
        15: 2,  # 'п'
        9: 2,  # 'р'
        7: 3,  # 'с'
        6: 2,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 1,  # 'х'
        28: 1,  # 'ц'
        22: 2,  # 'ч'
        25: 1,  # 'ш'
        29: 0,  # 'щ'
        54: 1,  # 'ъ'
        18: 3,  # 'ы'
        17: 1,  # 'ь'
        30: 2,  # 'э'
        27: 0,  # 'ю'
        16: 1,  # 'я'
    },
    46: {  # 'Г'
        37: 1,  # 'А'
        44: 1,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 1,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 1,  # 'П'
        45: 1,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 2,  # 'а'
        21: 0,  # 'б'
        10: 1,  # 'в'
        19: 0,  # 'г'
        13: 2,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 2,  # 'л'
        12: 1,  # 'м'
        5: 1,  # 'н'
        1: 3,  # 'о'
        15: 0,  # 'п'
        9: 2,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 1,  # 'ь'
        30: 1,  # 'э'
        27: 1,  # 'ю'
        16: 0,  # 'я'
    },
    41: {  # 'Д'
        37: 1,  # 'А'
        44: 0,  # 'Б'
        33: 1,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 2,  # 'Е'
        56: 1,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 0,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 0,  # 'П'
        45: 1,  # 'Р'
        32: 1,  # 'С'
        40: 0,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 1,  # 'Ц'
        50: 1,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 1,  # 'Ы'
        61: 1,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 1,  # 'Я'
        3: 3,  # 'а'
        21: 0,  # 'б'
        10: 2,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 2,  # 'е'
        24: 3,  # 'ж'
        20: 1,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 2,  # 'л'
        12: 1,  # 'м'
        5: 1,  # 'н'
        1: 3,  # 'о'
        15: 0,  # 'п'
        9: 2,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 1,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 1,  # 'ы'
        17: 1,  # 'ь'
        30: 2,  # 'э'
        27: 1,  # 'ю'
        16: 1,  # 'я'
    },
    48: {  # 'Е'
        37: 1,  # 'А'
        44: 1,  # 'Б'
        33: 1,  # 'В'
        46: 1,  # 'Г'
        41: 1,  # 'Д'
        48: 1,  # 'Е'
        56: 1,  # 'Ж'
        51: 1,  # 'З'
        42: 1,  # 'И'
        60: 1,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 2,  # 'Н'
        34: 1,  # 'О'
        35: 1,  # 'П'
        45: 2,  # 'Р'
        32: 2,  # 'С'
        40: 1,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 1,  # 'Х'
        58: 1,  # 'Ц'
        50: 1,  # 'Ч'
        57: 1,  # 'Ш'
        63: 1,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 1,  # 'Я'
        3: 0,  # 'а'
        21: 0,  # 'б'
        10: 2,  # 'в'
        19: 2,  # 'г'
        13: 2,  # 'д'
        2: 2,  # 'е'
        24: 1,  # 'ж'
        20: 1,  # 'з'
        4: 0,  # 'и'
        23: 2,  # 'й'
        11: 1,  # 'к'
        8: 2,  # 'л'
        12: 2,  # 'м'
        5: 1,  # 'н'
        1: 0,  # 'о'
        15: 1,  # 'п'
        9: 1,  # 'р'
        7: 3,  # 'с'
        6: 0,  # 'т'
        14: 0,  # 'у'
        39: 1,  # 'ф'
        26: 1,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 1,  # 'ш'
        29: 2,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 1,  # 'ю'
        16: 0,  # 'я'
    },
    56: {  # 'Ж'
        37: 1,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 1,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 1,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 2,  # 'а'
        21: 1,  # 'б'
        10: 0,  # 'в'
        19: 1,  # 'г'
        13: 1,  # 'д'
        2: 2,  # 'е'
        24: 1,  # 'ж'
        20: 0,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 0,  # 'л'
        12: 1,  # 'м'
        5: 0,  # 'н'
        1: 2,  # 'о'
        15: 0,  # 'п'
        9: 1,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 2,  # 'ю'
        16: 0,  # 'я'
    },
    51: {  # 'З'
        37: 1,  # 'А'
        44: 0,  # 'Б'
        33: 1,  # 'В'
        46: 1,  # 'Г'
        41: 1,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 0,  # 'П'
        45: 1,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 1,  # 'Ы'
        61: 1,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 1,  # 'б'
        10: 2,  # 'в'
        19: 0,  # 'г'
        13: 2,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 1,  # 'л'
        12: 1,  # 'м'
        5: 2,  # 'н'
        1: 2,  # 'о'
        15: 0,  # 'п'
        9: 1,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 1,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 1,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 0,  # 'ю'
        16: 1,  # 'я'
    },
    42: {  # 'И'
        37: 1,  # 'А'
        44: 1,  # 'Б'
        33: 1,  # 'В'
        46: 1,  # 'Г'
        41: 1,  # 'Д'
        48: 2,  # 'Е'
        56: 1,  # 'Ж'
        51: 1,  # 'З'
        42: 1,  # 'И'
        60: 1,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 1,  # 'П'
        45: 1,  # 'Р'
        32: 2,  # 'С'
        40: 1,  # 'Т'
        52: 0,  # 'У'
        53: 1,  # 'Ф'
        55: 1,  # 'Х'
        58: 1,  # 'Ц'
        50: 1,  # 'Ч'
        57: 0,  # 'Ш'
        63: 1,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 1,  # 'Ю'
        43: 1,  # 'Я'
        3: 1,  # 'а'
        21: 2,  # 'б'
        10: 2,  # 'в'
        19: 2,  # 'г'
        13: 2,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 2,  # 'з'
        4: 1,  # 'и'
        23: 0,  # 'й'
        11: 1,  # 'к'
        8: 2,  # 'л'
        12: 2,  # 'м'
        5: 2,  # 'н'
        1: 1,  # 'о'
        15: 1,  # 'п'
        9: 2,  # 'р'
        7: 2,  # 'с'
        6: 2,  # 'т'
        14: 1,  # 'у'
        39: 1,  # 'ф'
        26: 2,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 1,  # 'ш'
        29: 1,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 1,  # 'ю'
        16: 0,  # 'я'
    },
    60: {  # 'Й'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 1,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 0,  # 'М'
        31: 1,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 1,  # 'Х'
        58: 1,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 0,  # 'а'
        21: 0,  # 'б'
        10: 0,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 1,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 0,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 0,  # 'л'
        12: 0,  # 'м'
        5: 0,  # 'н'
        1: 2,  # 'о'
        15: 0,  # 'п'
        9: 0,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 0,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    36: {  # 'К'
        37: 2,  # 'А'
        44: 0,  # 'Б'
        33: 1,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 1,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 1,  # 'Л'
        38: 0,  # 'М'
        31: 1,  # 'Н'
        34: 2,  # 'О'
        35: 1,  # 'П'
        45: 1,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 1,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 0,  # 'б'
        10: 1,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 2,  # 'л'
        12: 0,  # 'м'
        5: 1,  # 'н'
        1: 3,  # 'о'
        15: 0,  # 'п'
        9: 2,  # 'р'
        7: 2,  # 'с'
        6: 2,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 1,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 1,  # 'ы'
        17: 1,  # 'ь'
        30: 2,  # 'э'
        27: 1,  # 'ю'
        16: 0,  # 'я'
    },
    49: {  # 'Л'
        37: 2,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 1,  # 'Г'
        41: 0,  # 'Д'
        48: 1,  # 'Е'
        56: 1,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 0,  # 'Н'
        34: 1,  # 'О'
        35: 1,  # 'П'
        45: 0,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 1,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 1,  # 'Ы'
        61: 1,  # 'Ь'
        47: 0,  # 'Э'
        59: 1,  # 'Ю'
        43: 1,  # 'Я'
        3: 2,  # 'а'
        21: 0,  # 'б'
        10: 0,  # 'в'
        19: 1,  # 'г'
        13: 0,  # 'д'
        2: 2,  # 'е'
        24: 1,  # 'ж'
        20: 0,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 1,  # 'л'
        12: 0,  # 'м'
        5: 1,  # 'н'
        1: 2,  # 'о'
        15: 0,  # 'п'
        9: 0,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 1,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 1,  # 'ы'
        17: 1,  # 'ь'
        30: 2,  # 'э'
        27: 2,  # 'ю'
        16: 1,  # 'я'
    },
    38: {  # 'М'
        37: 1,  # 'А'
        44: 1,  # 'Б'
        33: 1,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 1,  # 'П'
        45: 1,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 1,  # 'У'
        53: 1,  # 'Ф'
        55: 1,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 1,  # 'Ы'
        61: 0,  # 'Ь'
        47: 1,  # 'Э'
        59: 0,  # 'Ю'
        43: 1,  # 'Я'
        3: 3,  # 'а'
        21: 0,  # 'б'
        10: 0,  # 'в'
        19: 1,  # 'г'
        13: 0,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 1,  # 'л'
        12: 1,  # 'м'
        5: 2,  # 'н'
        1: 3,  # 'о'
        15: 0,  # 'п'
        9: 1,  # 'р'
        7: 1,  # 'с'
        6: 0,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 3,  # 'ы'
        17: 1,  # 'ь'
        30: 2,  # 'э'
        27: 1,  # 'ю'
        16: 1,  # 'я'
    },
    31: {  # 'Н'
        37: 2,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 1,  # 'Г'
        41: 1,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 1,  # 'З'
        42: 2,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 0,  # 'П'
        45: 1,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 1,  # 'У'
        53: 1,  # 'Ф'
        55: 1,  # 'Х'
        58: 1,  # 'Ц'
        50: 1,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 1,  # 'Ы'
        61: 1,  # 'Ь'
        47: 1,  # 'Э'
        59: 0,  # 'Ю'
        43: 1,  # 'Я'
        3: 3,  # 'а'
        21: 0,  # 'б'
        10: 0,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 3,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 0,  # 'л'
        12: 0,  # 'м'
        5: 0,  # 'н'
        1: 3,  # 'о'
        15: 0,  # 'п'
        9: 1,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 3,  # 'у'
        39: 0,  # 'ф'
        26: 1,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 1,  # 'ы'
        17: 2,  # 'ь'
        30: 1,  # 'э'
        27: 1,  # 'ю'
        16: 1,  # 'я'
    },
    34: {  # 'О'
        37: 0,  # 'А'
        44: 1,  # 'Б'
        33: 1,  # 'В'
        46: 1,  # 'Г'
        41: 2,  # 'Д'
        48: 1,  # 'Е'
        56: 1,  # 'Ж'
        51: 1,  # 'З'
        42: 1,  # 'И'
        60: 1,  # 'Й'
        36: 1,  # 'К'
        49: 2,  # 'Л'
        38: 1,  # 'М'
        31: 2,  # 'Н'
        34: 1,  # 'О'
        35: 1,  # 'П'
        45: 2,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 1,  # 'У'
        53: 1,  # 'Ф'
        55: 1,  # 'Х'
        58: 0,  # 'Ц'
        50: 1,  # 'Ч'
        57: 1,  # 'Ш'
        63: 1,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 1,  # 'Я'
        3: 1,  # 'а'
        21: 2,  # 'б'
        10: 1,  # 'в'
        19: 2,  # 'г'
        13: 2,  # 'д'
        2: 0,  # 'е'
        24: 1,  # 'ж'
        20: 1,  # 'з'
        4: 0,  # 'и'
        23: 1,  # 'й'
        11: 2,  # 'к'
        8: 2,  # 'л'
        12: 1,  # 'м'
        5: 3,  # 'н'
        1: 0,  # 'о'
        15: 2,  # 'п'
        9: 2,  # 'р'
        7: 2,  # 'с'
        6: 2,  # 'т'
        14: 1,  # 'у'
        39: 1,  # 'ф'
        26: 2,  # 'х'
        28: 1,  # 'ц'
        22: 2,  # 'ч'
        25: 2,  # 'ш'
        29: 1,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    35: {  # 'П'
        37: 1,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 1,  # 'Л'
        38: 0,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 1,  # 'П'
        45: 2,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 1,  # 'Ы'
        61: 1,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 1,  # 'Я'
        3: 2,  # 'а'
        21: 0,  # 'б'
        10: 0,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 2,  # 'л'
        12: 0,  # 'м'
        5: 1,  # 'н'
        1: 3,  # 'о'
        15: 0,  # 'п'
        9: 3,  # 'р'
        7: 1,  # 'с'
        6: 1,  # 'т'
        14: 2,  # 'у'
        39: 1,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 1,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 1,  # 'ы'
        17: 2,  # 'ь'
        30: 1,  # 'э'
        27: 0,  # 'ю'
        16: 2,  # 'я'
    },
    45: {  # 'Р'
        37: 2,  # 'А'
        44: 1,  # 'Б'
        33: 1,  # 'В'
        46: 1,  # 'Г'
        41: 1,  # 'Д'
        48: 2,  # 'Е'
        56: 1,  # 'Ж'
        51: 0,  # 'З'
        42: 2,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 2,  # 'О'
        35: 0,  # 'П'
        45: 1,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 1,  # 'Х'
        58: 1,  # 'Ц'
        50: 1,  # 'Ч'
        57: 1,  # 'Ш'
        63: 0,  # 'Щ'
        62: 1,  # 'Ы'
        61: 1,  # 'Ь'
        47: 1,  # 'Э'
        59: 1,  # 'Ю'
        43: 1,  # 'Я'
        3: 3,  # 'а'
        21: 0,  # 'б'
        10: 1,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 2,  # 'е'
        24: 1,  # 'ж'
        20: 0,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 0,  # 'л'
        12: 0,  # 'м'
        5: 0,  # 'н'
        1: 3,  # 'о'
        15: 0,  # 'п'
        9: 1,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 2,  # 'ы'
        17: 0,  # 'ь'
        30: 1,  # 'э'
        27: 1,  # 'ю'
        16: 2,  # 'я'
    },
    32: {  # 'С'
        37: 1,  # 'А'
        44: 1,  # 'Б'
        33: 1,  # 'В'
        46: 1,  # 'Г'
        41: 1,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 1,  # 'П'
        45: 1,  # 'Р'
        32: 1,  # 'С'
        40: 2,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 1,  # 'Х'
        58: 1,  # 'Ц'
        50: 1,  # 'Ч'
        57: 1,  # 'Ш'
        63: 0,  # 'Щ'
        62: 1,  # 'Ы'
        61: 1,  # 'Ь'
        47: 1,  # 'Э'
        59: 1,  # 'Ю'
        43: 1,  # 'Я'
        3: 2,  # 'а'
        21: 1,  # 'б'
        10: 2,  # 'в'
        19: 1,  # 'г'
        13: 2,  # 'д'
        2: 3,  # 'е'
        24: 1,  # 'ж'
        20: 1,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 2,  # 'к'
        8: 2,  # 'л'
        12: 2,  # 'м'
        5: 2,  # 'н'
        1: 2,  # 'о'
        15: 2,  # 'п'
        9: 2,  # 'р'
        7: 1,  # 'с'
        6: 3,  # 'т'
        14: 2,  # 'у'
        39: 1,  # 'ф'
        26: 1,  # 'х'
        28: 1,  # 'ц'
        22: 1,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 1,  # 'ъ'
        18: 1,  # 'ы'
        17: 1,  # 'ь'
        30: 2,  # 'э'
        27: 1,  # 'ю'
        16: 1,  # 'я'
    },
    40: {  # 'Т'
        37: 1,  # 'А'
        44: 0,  # 'Б'
        33: 1,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 2,  # 'О'
        35: 0,  # 'П'
        45: 1,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 1,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 1,  # 'Ы'
        61: 1,  # 'Ь'
        47: 1,  # 'Э'
        59: 1,  # 'Ю'
        43: 1,  # 'Я'
        3: 3,  # 'а'
        21: 1,  # 'б'
        10: 2,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 3,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 1,  # 'к'
        8: 1,  # 'л'
        12: 0,  # 'м'
        5: 0,  # 'н'
        1: 3,  # 'о'
        15: 0,  # 'п'
        9: 2,  # 'р'
        7: 1,  # 'с'
        6: 0,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 1,  # 'щ'
        54: 0,  # 'ъ'
        18: 3,  # 'ы'
        17: 1,  # 'ь'
        30: 2,  # 'э'
        27: 1,  # 'ю'
        16: 1,  # 'я'
    },
    52: {  # 'У'
        37: 1,  # 'А'
        44: 1,  # 'Б'
        33: 1,  # 'В'
        46: 1,  # 'Г'
        41: 1,  # 'Д'
        48: 1,  # 'Е'
        56: 1,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 1,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 1,  # 'П'
        45: 1,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 1,  # 'Х'
        58: 0,  # 'Ц'
        50: 1,  # 'Ч'
        57: 1,  # 'Ш'
        63: 1,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 1,  # 'Ю'
        43: 0,  # 'Я'
        3: 1,  # 'а'
        21: 2,  # 'б'
        10: 2,  # 'в'
        19: 1,  # 'г'
        13: 2,  # 'д'
        2: 1,  # 'е'
        24: 2,  # 'ж'
        20: 2,  # 'з'
        4: 2,  # 'и'
        23: 1,  # 'й'
        11: 1,  # 'к'
        8: 2,  # 'л'
        12: 2,  # 'м'
        5: 1,  # 'н'
        1: 2,  # 'о'
        15: 1,  # 'п'
        9: 2,  # 'р'
        7: 2,  # 'с'
        6: 2,  # 'т'
        14: 0,  # 'у'
        39: 1,  # 'ф'
        26: 1,  # 'х'
        28: 1,  # 'ц'
        22: 2,  # 'ч'
        25: 1,  # 'ш'
        29: 1,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 2,  # 'э'
        27: 1,  # 'ю'
        16: 0,  # 'я'
    },
    53: {  # 'Ф'
        37: 1,  # 'А'
        44: 1,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 1,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 1,  # 'О'
        35: 0,  # 'П'
        45: 1,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 2,  # 'а'
        21: 0,  # 'б'
        10: 0,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 2,  # 'л'
        12: 0,  # 'м'
        5: 0,  # 'н'
        1: 2,  # 'о'
        15: 0,  # 'п'
        9: 2,  # 'р'
        7: 0,  # 'с'
        6: 1,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 1,  # 'ь'
        30: 2,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    55: {  # 'Х'
        37: 1,  # 'А'
        44: 0,  # 'Б'
        33: 1,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 2,  # 'а'
        21: 0,  # 'б'
        10: 2,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 2,  # 'л'
        12: 1,  # 'м'
        5: 0,  # 'н'
        1: 2,  # 'о'
        15: 0,  # 'п'
        9: 2,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 1,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 1,  # 'ь'
        30: 1,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    58: {  # 'Ц'
        37: 1,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 1,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 1,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 1,  # 'а'
        21: 0,  # 'б'
        10: 1,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 0,  # 'л'
        12: 0,  # 'м'
        5: 0,  # 'н'
        1: 0,  # 'о'
        15: 0,  # 'п'
        9: 0,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 1,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 1,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 1,  # 'ю'
        16: 0,  # 'я'
    },
    50: {  # 'Ч'
        37: 1,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 1,  # 'Н'
        34: 0,  # 'О'
        35: 1,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 1,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 1,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 2,  # 'а'
        21: 0,  # 'б'
        10: 0,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 1,  # 'л'
        12: 0,  # 'м'
        5: 0,  # 'н'
        1: 1,  # 'о'
        15: 0,  # 'п'
        9: 1,  # 'р'
        7: 0,  # 'с'
        6: 3,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 1,  # 'ь'
        30: 0,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    57: {  # 'Ш'
        37: 1,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 0,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 1,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 2,  # 'а'
        21: 0,  # 'б'
        10: 1,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 1,  # 'и'
        23: 0,  # 'й'
        11: 1,  # 'к'
        8: 2,  # 'л'
        12: 1,  # 'м'
        5: 1,  # 'н'
        1: 2,  # 'о'
        15: 2,  # 'п'
        9: 1,  # 'р'
        7: 0,  # 'с'
        6: 2,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 1,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 1,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 1,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    63: {  # 'Щ'
        37: 1,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 1,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 1,  # 'а'
        21: 0,  # 'б'
        10: 0,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 1,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 1,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 0,  # 'л'
        12: 0,  # 'м'
        5: 0,  # 'н'
        1: 1,  # 'о'
        15: 0,  # 'п'
        9: 0,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 1,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    62: {  # 'Ы'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 1,  # 'В'
        46: 1,  # 'Г'
        41: 0,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 1,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 0,  # 'О'
        35: 1,  # 'П'
        45: 1,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 1,  # 'Х'
        58: 1,  # 'Ц'
        50: 0,  # 'Ч'
        57: 1,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 0,  # 'а'
        21: 0,  # 'б'
        10: 0,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 0,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 0,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 0,  # 'л'
        12: 0,  # 'м'
        5: 0,  # 'н'
        1: 0,  # 'о'
        15: 0,  # 'п'
        9: 0,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 0,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    61: {  # 'Ь'
        37: 0,  # 'А'
        44: 1,  # 'Б'
        33: 1,  # 'В'
        46: 0,  # 'Г'
        41: 1,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 0,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 1,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 1,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 1,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 1,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 1,  # 'Ю'
        43: 1,  # 'Я'
        3: 0,  # 'а'
        21: 0,  # 'б'
        10: 0,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 0,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 0,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 0,  # 'л'
        12: 0,  # 'м'
        5: 0,  # 'н'
        1: 0,  # 'о'
        15: 0,  # 'п'
        9: 0,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 0,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    47: {  # 'Э'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 1,  # 'В'
        46: 0,  # 'Г'
        41: 1,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 1,  # 'Й'
        36: 1,  # 'К'
        49: 1,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 0,  # 'О'
        35: 1,  # 'П'
        45: 1,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 1,  # 'а'
        21: 1,  # 'б'
        10: 2,  # 'в'
        19: 1,  # 'г'
        13: 2,  # 'д'
        2: 0,  # 'е'
        24: 1,  # 'ж'
        20: 0,  # 'з'
        4: 0,  # 'и'
        23: 2,  # 'й'
        11: 2,  # 'к'
        8: 2,  # 'л'
        12: 2,  # 'м'
        5: 2,  # 'н'
        1: 0,  # 'о'
        15: 1,  # 'п'
        9: 2,  # 'р'
        7: 1,  # 'с'
        6: 3,  # 'т'
        14: 1,  # 'у'
        39: 1,  # 'ф'
        26: 1,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 1,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    59: {  # 'Ю'
        37: 1,  # 'А'
        44: 1,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 1,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 1,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 1,  # 'Р'
        32: 0,  # 'С'
        40: 1,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 1,  # 'Ч'
        57: 0,  # 'Ш'
        63: 1,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 0,  # 'а'
        21: 1,  # 'б'
        10: 0,  # 'в'
        19: 1,  # 'г'
        13: 1,  # 'д'
        2: 0,  # 'е'
        24: 1,  # 'ж'
        20: 0,  # 'з'
        4: 0,  # 'и'
        23: 0,  # 'й'
        11: 1,  # 'к'
        8: 2,  # 'л'
        12: 1,  # 'м'
        5: 2,  # 'н'
        1: 0,  # 'о'
        15: 1,  # 'п'
        9: 1,  # 'р'
        7: 1,  # 'с'
        6: 0,  # 'т'
        14: 0,  # 'у'
        39: 0,  # 'ф'
        26: 1,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    43: {  # 'Я'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 1,  # 'В'
        46: 1,  # 'Г'
        41: 0,  # 'Д'
        48: 1,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 1,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 1,  # 'С'
        40: 1,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 1,  # 'Х'
        58: 0,  # 'Ц'
        50: 1,  # 'Ч'
        57: 0,  # 'Ш'
        63: 1,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 1,  # 'Ю'
        43: 1,  # 'Я'
        3: 0,  # 'а'
        21: 1,  # 'б'
        10: 1,  # 'в'
        19: 1,  # 'г'
        13: 1,  # 'д'
        2: 0,  # 'е'
        24: 0,  # 'ж'
        20: 1,  # 'з'
        4: 0,  # 'и'
        23: 1,  # 'й'
        11: 1,  # 'к'
        8: 1,  # 'л'
        12: 1,  # 'м'
        5: 2,  # 'н'
        1: 0,  # 'о'
        15: 1,  # 'п'
        9: 1,  # 'р'
        7: 1,  # 'с'
        6: 0,  # 'т'
        14: 0,  # 'у'
        39: 0,  # 'ф'
        26: 1,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 1,  # 'ш'
        29: 1,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    3: {  # 'а'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 1,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 1,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 2,  # 'а'
        21: 3,  # 'б'
        10: 3,  # 'в'
        19: 3,  # 'г'
        13: 3,  # 'д'
        2: 3,  # 'е'
        24: 3,  # 'ж'
        20: 3,  # 'з'
        4: 3,  # 'и'
        23: 3,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 3,  # 'м'
        5: 3,  # 'н'
        1: 2,  # 'о'
        15: 3,  # 'п'
        9: 3,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 3,  # 'у'
        39: 2,  # 'ф'
        26: 3,  # 'х'
        28: 3,  # 'ц'
        22: 3,  # 'ч'
        25: 3,  # 'ш'
        29: 3,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 2,  # 'э'
        27: 3,  # 'ю'
        16: 3,  # 'я'
    },
    21: {  # 'б'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 1,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 2,  # 'б'
        10: 2,  # 'в'
        19: 1,  # 'г'
        13: 2,  # 'д'
        2: 3,  # 'е'
        24: 2,  # 'ж'
        20: 1,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 2,  # 'к'
        8: 3,  # 'л'
        12: 2,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 1,  # 'п'
        9: 3,  # 'р'
        7: 3,  # 'с'
        6: 2,  # 'т'
        14: 3,  # 'у'
        39: 0,  # 'ф'
        26: 2,  # 'х'
        28: 1,  # 'ц'
        22: 1,  # 'ч'
        25: 2,  # 'ш'
        29: 3,  # 'щ'
        54: 2,  # 'ъ'
        18: 3,  # 'ы'
        17: 2,  # 'ь'
        30: 1,  # 'э'
        27: 2,  # 'ю'
        16: 3,  # 'я'
    },
    10: {  # 'в'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 2,  # 'б'
        10: 2,  # 'в'
        19: 2,  # 'г'
        13: 3,  # 'д'
        2: 3,  # 'е'
        24: 1,  # 'ж'
        20: 3,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 2,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 3,  # 'п'
        9: 3,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 3,  # 'у'
        39: 1,  # 'ф'
        26: 2,  # 'х'
        28: 2,  # 'ц'
        22: 2,  # 'ч'
        25: 3,  # 'ш'
        29: 2,  # 'щ'
        54: 2,  # 'ъ'
        18: 3,  # 'ы'
        17: 3,  # 'ь'
        30: 1,  # 'э'
        27: 1,  # 'ю'
        16: 3,  # 'я'
    },
    19: {  # 'г'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 1,  # 'б'
        10: 2,  # 'в'
        19: 1,  # 'г'
        13: 3,  # 'д'
        2: 3,  # 'е'
        24: 0,  # 'ж'
        20: 1,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 2,  # 'к'
        8: 3,  # 'л'
        12: 2,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 0,  # 'п'
        9: 3,  # 'р'
        7: 2,  # 'с'
        6: 2,  # 'т'
        14: 3,  # 'у'
        39: 1,  # 'ф'
        26: 1,  # 'х'
        28: 1,  # 'ц'
        22: 2,  # 'ч'
        25: 1,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 1,  # 'ы'
        17: 1,  # 'ь'
        30: 1,  # 'э'
        27: 1,  # 'ю'
        16: 0,  # 'я'
    },
    13: {  # 'д'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 2,  # 'б'
        10: 3,  # 'в'
        19: 2,  # 'г'
        13: 2,  # 'д'
        2: 3,  # 'е'
        24: 2,  # 'ж'
        20: 2,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 2,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 2,  # 'п'
        9: 3,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 3,  # 'у'
        39: 1,  # 'ф'
        26: 2,  # 'х'
        28: 3,  # 'ц'
        22: 2,  # 'ч'
        25: 2,  # 'ш'
        29: 1,  # 'щ'
        54: 2,  # 'ъ'
        18: 3,  # 'ы'
        17: 3,  # 'ь'
        30: 1,  # 'э'
        27: 2,  # 'ю'
        16: 3,  # 'я'
    },
    2: {  # 'е'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 2,  # 'а'
        21: 3,  # 'б'
        10: 3,  # 'в'
        19: 3,  # 'г'
        13: 3,  # 'д'
        2: 3,  # 'е'
        24: 3,  # 'ж'
        20: 3,  # 'з'
        4: 2,  # 'и'
        23: 3,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 3,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 3,  # 'п'
        9: 3,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 2,  # 'у'
        39: 2,  # 'ф'
        26: 3,  # 'х'
        28: 3,  # 'ц'
        22: 3,  # 'ч'
        25: 3,  # 'ш'
        29: 3,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 1,  # 'э'
        27: 2,  # 'ю'
        16: 3,  # 'я'
    },
    24: {  # 'ж'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 2,  # 'б'
        10: 1,  # 'в'
        19: 2,  # 'г'
        13: 3,  # 'д'
        2: 3,  # 'е'
        24: 2,  # 'ж'
        20: 1,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 2,  # 'к'
        8: 2,  # 'л'
        12: 1,  # 'м'
        5: 3,  # 'н'
        1: 2,  # 'о'
        15: 1,  # 'п'
        9: 2,  # 'р'
        7: 2,  # 'с'
        6: 1,  # 'т'
        14: 3,  # 'у'
        39: 1,  # 'ф'
        26: 0,  # 'х'
        28: 1,  # 'ц'
        22: 2,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 1,  # 'ы'
        17: 2,  # 'ь'
        30: 1,  # 'э'
        27: 1,  # 'ю'
        16: 1,  # 'я'
    },
    20: {  # 'з'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 3,  # 'б'
        10: 3,  # 'в'
        19: 3,  # 'г'
        13: 3,  # 'д'
        2: 3,  # 'е'
        24: 2,  # 'ж'
        20: 2,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 3,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 0,  # 'п'
        9: 3,  # 'р'
        7: 2,  # 'с'
        6: 2,  # 'т'
        14: 3,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 1,  # 'ц'
        22: 2,  # 'ч'
        25: 1,  # 'ш'
        29: 0,  # 'щ'
        54: 2,  # 'ъ'
        18: 3,  # 'ы'
        17: 2,  # 'ь'
        30: 1,  # 'э'
        27: 1,  # 'ю'
        16: 3,  # 'я'
    },
    4: {  # 'и'
        37: 1,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 1,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 3,  # 'б'
        10: 3,  # 'в'
        19: 3,  # 'г'
        13: 3,  # 'д'
        2: 3,  # 'е'
        24: 3,  # 'ж'
        20: 3,  # 'з'
        4: 3,  # 'и'
        23: 3,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 3,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 3,  # 'п'
        9: 3,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 2,  # 'у'
        39: 2,  # 'ф'
        26: 3,  # 'х'
        28: 3,  # 'ц'
        22: 3,  # 'ч'
        25: 3,  # 'ш'
        29: 3,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 2,  # 'э'
        27: 3,  # 'ю'
        16: 3,  # 'я'
    },
    23: {  # 'й'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 1,  # 'а'
        21: 1,  # 'б'
        10: 1,  # 'в'
        19: 2,  # 'г'
        13: 3,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 2,  # 'з'
        4: 1,  # 'и'
        23: 0,  # 'й'
        11: 2,  # 'к'
        8: 2,  # 'л'
        12: 2,  # 'м'
        5: 3,  # 'н'
        1: 2,  # 'о'
        15: 1,  # 'п'
        9: 2,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 1,  # 'у'
        39: 2,  # 'ф'
        26: 1,  # 'х'
        28: 2,  # 'ц'
        22: 3,  # 'ч'
        25: 2,  # 'ш'
        29: 1,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 1,  # 'э'
        27: 1,  # 'ю'
        16: 2,  # 'я'
    },
    11: {  # 'к'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 1,  # 'б'
        10: 3,  # 'в'
        19: 1,  # 'г'
        13: 1,  # 'д'
        2: 3,  # 'е'
        24: 2,  # 'ж'
        20: 2,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 2,  # 'к'
        8: 3,  # 'л'
        12: 1,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 0,  # 'п'
        9: 3,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 3,  # 'у'
        39: 1,  # 'ф'
        26: 2,  # 'х'
        28: 2,  # 'ц'
        22: 1,  # 'ч'
        25: 2,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 1,  # 'ы'
        17: 1,  # 'ь'
        30: 1,  # 'э'
        27: 1,  # 'ю'
        16: 1,  # 'я'
    },
    8: {  # 'л'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 2,  # 'б'
        10: 2,  # 'в'
        19: 3,  # 'г'
        13: 2,  # 'д'
        2: 3,  # 'е'
        24: 3,  # 'ж'
        20: 2,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 2,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 2,  # 'п'
        9: 1,  # 'р'
        7: 3,  # 'с'
        6: 2,  # 'т'
        14: 3,  # 'у'
        39: 2,  # 'ф'
        26: 2,  # 'х'
        28: 1,  # 'ц'
        22: 3,  # 'ч'
        25: 2,  # 'ш'
        29: 1,  # 'щ'
        54: 0,  # 'ъ'
        18: 3,  # 'ы'
        17: 3,  # 'ь'
        30: 1,  # 'э'
        27: 3,  # 'ю'
        16: 3,  # 'я'
    },
    12: {  # 'м'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 2,  # 'б'
        10: 2,  # 'в'
        19: 2,  # 'г'
        13: 1,  # 'д'
        2: 3,  # 'е'
        24: 1,  # 'ж'
        20: 1,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 2,  # 'к'
        8: 3,  # 'л'
        12: 2,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 2,  # 'п'
        9: 2,  # 'р'
        7: 3,  # 'с'
        6: 2,  # 'т'
        14: 3,  # 'у'
        39: 2,  # 'ф'
        26: 2,  # 'х'
        28: 2,  # 'ц'
        22: 2,  # 'ч'
        25: 1,  # 'ш'
        29: 1,  # 'щ'
        54: 0,  # 'ъ'
        18: 3,  # 'ы'
        17: 2,  # 'ь'
        30: 2,  # 'э'
        27: 1,  # 'ю'
        16: 3,  # 'я'
    },
    5: {  # 'н'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 2,  # 'б'
        10: 2,  # 'в'
        19: 3,  # 'г'
        13: 3,  # 'д'
        2: 3,  # 'е'
        24: 2,  # 'ж'
        20: 2,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 3,  # 'к'
        8: 2,  # 'л'
        12: 1,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 1,  # 'п'
        9: 2,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 3,  # 'у'
        39: 2,  # 'ф'
        26: 2,  # 'х'
        28: 3,  # 'ц'
        22: 3,  # 'ч'
        25: 2,  # 'ш'
        29: 2,  # 'щ'
        54: 1,  # 'ъ'
        18: 3,  # 'ы'
        17: 3,  # 'ь'
        30: 1,  # 'э'
        27: 3,  # 'ю'
        16: 3,  # 'я'
    },
    1: {  # 'о'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 2,  # 'а'
        21: 3,  # 'б'
        10: 3,  # 'в'
        19: 3,  # 'г'
        13: 3,  # 'д'
        2: 3,  # 'е'
        24: 3,  # 'ж'
        20: 3,  # 'з'
        4: 3,  # 'и'
        23: 3,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 3,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 3,  # 'п'
        9: 3,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 2,  # 'у'
        39: 2,  # 'ф'
        26: 3,  # 'х'
        28: 2,  # 'ц'
        22: 3,  # 'ч'
        25: 3,  # 'ш'
        29: 3,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 2,  # 'э'
        27: 3,  # 'ю'
        16: 3,  # 'я'
    },
    15: {  # 'п'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 1,  # 'б'
        10: 0,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 3,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 2,  # 'к'
        8: 3,  # 'л'
        12: 1,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 2,  # 'п'
        9: 3,  # 'р'
        7: 2,  # 'с'
        6: 2,  # 'т'
        14: 3,  # 'у'
        39: 1,  # 'ф'
        26: 0,  # 'х'
        28: 2,  # 'ц'
        22: 2,  # 'ч'
        25: 1,  # 'ш'
        29: 1,  # 'щ'
        54: 0,  # 'ъ'
        18: 3,  # 'ы'
        17: 2,  # 'ь'
        30: 1,  # 'э'
        27: 1,  # 'ю'
        16: 3,  # 'я'
    },
    9: {  # 'р'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 2,  # 'б'
        10: 3,  # 'в'
        19: 3,  # 'г'
        13: 3,  # 'д'
        2: 3,  # 'е'
        24: 3,  # 'ж'
        20: 2,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 3,  # 'к'
        8: 2,  # 'л'
        12: 3,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 2,  # 'п'
        9: 2,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 3,  # 'у'
        39: 2,  # 'ф'
        26: 3,  # 'х'
        28: 2,  # 'ц'
        22: 2,  # 'ч'
        25: 3,  # 'ш'
        29: 2,  # 'щ'
        54: 0,  # 'ъ'
        18: 3,  # 'ы'
        17: 3,  # 'ь'
        30: 2,  # 'э'
        27: 2,  # 'ю'
        16: 3,  # 'я'
    },
    7: {  # 'с'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 1,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 2,  # 'б'
        10: 3,  # 'в'
        19: 2,  # 'г'
        13: 3,  # 'д'
        2: 3,  # 'е'
        24: 2,  # 'ж'
        20: 2,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 3,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 3,  # 'п'
        9: 3,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 3,  # 'у'
        39: 2,  # 'ф'
        26: 3,  # 'х'
        28: 2,  # 'ц'
        22: 3,  # 'ч'
        25: 2,  # 'ш'
        29: 1,  # 'щ'
        54: 2,  # 'ъ'
        18: 3,  # 'ы'
        17: 3,  # 'ь'
        30: 2,  # 'э'
        27: 3,  # 'ю'
        16: 3,  # 'я'
    },
    6: {  # 'т'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 2,  # 'б'
        10: 3,  # 'в'
        19: 2,  # 'г'
        13: 2,  # 'д'
        2: 3,  # 'е'
        24: 1,  # 'ж'
        20: 1,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 2,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 2,  # 'п'
        9: 3,  # 'р'
        7: 3,  # 'с'
        6: 2,  # 'т'
        14: 3,  # 'у'
        39: 2,  # 'ф'
        26: 2,  # 'х'
        28: 2,  # 'ц'
        22: 2,  # 'ч'
        25: 2,  # 'ш'
        29: 2,  # 'щ'
        54: 2,  # 'ъ'
        18: 3,  # 'ы'
        17: 3,  # 'ь'
        30: 2,  # 'э'
        27: 2,  # 'ю'
        16: 3,  # 'я'
    },
    14: {  # 'у'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 2,  # 'а'
        21: 3,  # 'б'
        10: 3,  # 'в'
        19: 3,  # 'г'
        13: 3,  # 'д'
        2: 3,  # 'е'
        24: 3,  # 'ж'
        20: 3,  # 'з'
        4: 2,  # 'и'
        23: 2,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 3,  # 'м'
        5: 3,  # 'н'
        1: 2,  # 'о'
        15: 3,  # 'п'
        9: 3,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 1,  # 'у'
        39: 2,  # 'ф'
        26: 3,  # 'х'
        28: 2,  # 'ц'
        22: 3,  # 'ч'
        25: 3,  # 'ш'
        29: 3,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 2,  # 'э'
        27: 3,  # 'ю'
        16: 2,  # 'я'
    },
    39: {  # 'ф'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 1,  # 'б'
        10: 0,  # 'в'
        19: 1,  # 'г'
        13: 0,  # 'д'
        2: 3,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 1,  # 'к'
        8: 2,  # 'л'
        12: 1,  # 'м'
        5: 1,  # 'н'
        1: 3,  # 'о'
        15: 1,  # 'п'
        9: 2,  # 'р'
        7: 2,  # 'с'
        6: 2,  # 'т'
        14: 2,  # 'у'
        39: 2,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 1,  # 'ч'
        25: 1,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 2,  # 'ы'
        17: 1,  # 'ь'
        30: 2,  # 'э'
        27: 1,  # 'ю'
        16: 1,  # 'я'
    },
    26: {  # 'х'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 0,  # 'б'
        10: 3,  # 'в'
        19: 1,  # 'г'
        13: 1,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 1,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 1,  # 'к'
        8: 2,  # 'л'
        12: 2,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 1,  # 'п'
        9: 3,  # 'р'
        7: 2,  # 'с'
        6: 2,  # 'т'
        14: 2,  # 'у'
        39: 1,  # 'ф'
        26: 1,  # 'х'
        28: 1,  # 'ц'
        22: 1,  # 'ч'
        25: 2,  # 'ш'
        29: 0,  # 'щ'
        54: 1,  # 'ъ'
        18: 0,  # 'ы'
        17: 1,  # 'ь'
        30: 1,  # 'э'
        27: 1,  # 'ю'
        16: 0,  # 'я'
    },
    28: {  # 'ц'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 1,  # 'б'
        10: 2,  # 'в'
        19: 1,  # 'г'
        13: 1,  # 'д'
        2: 3,  # 'е'
        24: 0,  # 'ж'
        20: 1,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 2,  # 'к'
        8: 1,  # 'л'
        12: 1,  # 'м'
        5: 1,  # 'н'
        1: 3,  # 'о'
        15: 0,  # 'п'
        9: 1,  # 'р'
        7: 0,  # 'с'
        6: 1,  # 'т'
        14: 3,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 1,  # 'ц'
        22: 0,  # 'ч'
        25: 1,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 3,  # 'ы'
        17: 1,  # 'ь'
        30: 0,  # 'э'
        27: 1,  # 'ю'
        16: 0,  # 'я'
    },
    22: {  # 'ч'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 1,  # 'б'
        10: 1,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 3,  # 'е'
        24: 1,  # 'ж'
        20: 0,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 3,  # 'к'
        8: 2,  # 'л'
        12: 1,  # 'м'
        5: 3,  # 'н'
        1: 2,  # 'о'
        15: 0,  # 'п'
        9: 2,  # 'р'
        7: 1,  # 'с'
        6: 3,  # 'т'
        14: 3,  # 'у'
        39: 1,  # 'ф'
        26: 1,  # 'х'
        28: 0,  # 'ц'
        22: 1,  # 'ч'
        25: 2,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 3,  # 'ь'
        30: 0,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    25: {  # 'ш'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 1,  # 'б'
        10: 2,  # 'в'
        19: 1,  # 'г'
        13: 0,  # 'д'
        2: 3,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 2,  # 'м'
        5: 3,  # 'н'
        1: 3,  # 'о'
        15: 2,  # 'п'
        9: 2,  # 'р'
        7: 1,  # 'с'
        6: 2,  # 'т'
        14: 3,  # 'у'
        39: 2,  # 'ф'
        26: 1,  # 'х'
        28: 1,  # 'ц'
        22: 1,  # 'ч'
        25: 1,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 3,  # 'ь'
        30: 1,  # 'э'
        27: 1,  # 'ю'
        16: 0,  # 'я'
    },
    29: {  # 'щ'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 3,  # 'а'
        21: 0,  # 'б'
        10: 1,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 3,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 3,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 0,  # 'л'
        12: 1,  # 'м'
        5: 2,  # 'н'
        1: 1,  # 'о'
        15: 0,  # 'п'
        9: 2,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 2,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 2,  # 'ь'
        30: 0,  # 'э'
        27: 0,  # 'ю'
        16: 0,  # 'я'
    },
    54: {  # 'ъ'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 0,  # 'а'
        21: 0,  # 'б'
        10: 0,  # 'в'
        19: 0,  # 'г'
        13: 0,  # 'д'
        2: 2,  # 'е'
        24: 0,  # 'ж'
        20: 0,  # 'з'
        4: 0,  # 'и'
        23: 0,  # 'й'
        11: 0,  # 'к'
        8: 0,  # 'л'
        12: 0,  # 'м'
        5: 0,  # 'н'
        1: 0,  # 'о'
        15: 0,  # 'п'
        9: 0,  # 'р'
        7: 0,  # 'с'
        6: 0,  # 'т'
        14: 0,  # 'у'
        39: 0,  # 'ф'
        26: 0,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 0,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 1,  # 'ю'
        16: 2,  # 'я'
    },
    18: {  # 'ы'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 0,  # 'а'
        21: 3,  # 'б'
        10: 3,  # 'в'
        19: 2,  # 'г'
        13: 2,  # 'д'
        2: 3,  # 'е'
        24: 2,  # 'ж'
        20: 2,  # 'з'
        4: 2,  # 'и'
        23: 3,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 3,  # 'м'
        5: 3,  # 'н'
        1: 1,  # 'о'
        15: 3,  # 'п'
        9: 3,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 1,  # 'у'
        39: 0,  # 'ф'
        26: 3,  # 'х'
        28: 2,  # 'ц'
        22: 3,  # 'ч'
        25: 3,  # 'ш'
        29: 2,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 0,  # 'ю'
        16: 2,  # 'я'
    },
    17: {  # 'ь'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 0,  # 'а'
        21: 2,  # 'б'
        10: 2,  # 'в'
        19: 2,  # 'г'
        13: 2,  # 'д'
        2: 3,  # 'е'
        24: 1,  # 'ж'
        20: 3,  # 'з'
        4: 2,  # 'и'
        23: 0,  # 'й'
        11: 3,  # 'к'
        8: 0,  # 'л'
        12: 3,  # 'м'
        5: 3,  # 'н'
        1: 2,  # 'о'
        15: 2,  # 'п'
        9: 1,  # 'р'
        7: 3,  # 'с'
        6: 2,  # 'т'
        14: 0,  # 'у'
        39: 2,  # 'ф'
        26: 1,  # 'х'
        28: 2,  # 'ц'
        22: 2,  # 'ч'
        25: 3,  # 'ш'
        29: 2,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 1,  # 'э'
        27: 3,  # 'ю'
        16: 3,  # 'я'
    },
    30: {  # 'э'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 1,  # 'М'
        31: 1,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 1,  # 'Р'
        32: 1,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 1,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 0,  # 'а'
        21: 1,  # 'б'
        10: 1,  # 'в'
        19: 1,  # 'г'
        13: 2,  # 'д'
        2: 1,  # 'е'
        24: 0,  # 'ж'
        20: 1,  # 'з'
        4: 0,  # 'и'
        23: 2,  # 'й'
        11: 2,  # 'к'
        8: 2,  # 'л'
        12: 2,  # 'м'
        5: 2,  # 'н'
        1: 0,  # 'о'
        15: 2,  # 'п'
        9: 2,  # 'р'
        7: 2,  # 'с'
        6: 3,  # 'т'
        14: 1,  # 'у'
        39: 2,  # 'ф'
        26: 1,  # 'х'
        28: 0,  # 'ц'
        22: 0,  # 'ч'
        25: 1,  # 'ш'
        29: 0,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 1,  # 'э'
        27: 1,  # 'ю'
        16: 1,  # 'я'
    },
    27: {  # 'ю'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 2,  # 'а'
        21: 3,  # 'б'
        10: 1,  # 'в'
        19: 2,  # 'г'
        13: 3,  # 'д'
        2: 1,  # 'е'
        24: 2,  # 'ж'
        20: 2,  # 'з'
        4: 1,  # 'и'
        23: 1,  # 'й'
        11: 2,  # 'к'
        8: 2,  # 'л'
        12: 2,  # 'м'
        5: 2,  # 'н'
        1: 1,  # 'о'
        15: 2,  # 'п'
        9: 2,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 0,  # 'у'
        39: 1,  # 'ф'
        26: 2,  # 'х'
        28: 2,  # 'ц'
        22: 2,  # 'ч'
        25: 2,  # 'ш'
        29: 3,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 1,  # 'э'
        27: 2,  # 'ю'
        16: 1,  # 'я'
    },
    16: {  # 'я'
        37: 0,  # 'А'
        44: 0,  # 'Б'
        33: 0,  # 'В'
        46: 0,  # 'Г'
        41: 0,  # 'Д'
        48: 0,  # 'Е'
        56: 0,  # 'Ж'
        51: 0,  # 'З'
        42: 0,  # 'И'
        60: 0,  # 'Й'
        36: 0,  # 'К'
        49: 0,  # 'Л'
        38: 0,  # 'М'
        31: 0,  # 'Н'
        34: 0,  # 'О'
        35: 0,  # 'П'
        45: 0,  # 'Р'
        32: 0,  # 'С'
        40: 0,  # 'Т'
        52: 0,  # 'У'
        53: 0,  # 'Ф'
        55: 0,  # 'Х'
        58: 0,  # 'Ц'
        50: 0,  # 'Ч'
        57: 0,  # 'Ш'
        63: 0,  # 'Щ'
        62: 0,  # 'Ы'
        61: 0,  # 'Ь'
        47: 0,  # 'Э'
        59: 0,  # 'Ю'
        43: 0,  # 'Я'
        3: 0,  # 'а'
        21: 2,  # 'б'
        10: 3,  # 'в'
        19: 2,  # 'г'
        13: 3,  # 'д'
        2: 3,  # 'е'
        24: 3,  # 'ж'
        20: 3,  # 'з'
        4: 2,  # 'и'
        23: 2,  # 'й'
        11: 3,  # 'к'
        8: 3,  # 'л'
        12: 3,  # 'м'
        5: 3,  # 'н'
        1: 0,  # 'о'
        15: 2,  # 'п'
        9: 2,  # 'р'
        7: 3,  # 'с'
        6: 3,  # 'т'
        14: 1,  # 'у'
        39: 1,  # 'ф'
        26: 3,  # 'х'
        28: 2,  # 'ц'
        22: 2,  # 'ч'
        25: 2,  # 'ш'
        29: 3,  # 'щ'
        54: 0,  # 'ъ'
        18: 0,  # 'ы'
        17: 0,  # 'ь'
        30: 0,  # 'э'
        27: 2,  # 'ю'
        16: 2,  # 'я'
    },
}

# 255: Undefined characters that did not exist in training text
# 254: Carriage/Return
# 253: symbol (punctuation) that does not belong to word
# 252: 0 - 9
# 251: Control characters

# Character Mapping Table(s):
IBM866_RUSSIAN_CHAR_TO_ORDER = {
     0: 255,  # '\x00'
     1: 255,  # '\x01'
     2: 255,  # '\x02'
     3: 255,  # '\x03'
     4: 255,  # '\x04'
     5: 255,  # '\x05'
     6: 255,  # '\x06'
     7: 255,  # '\x07'
     8: 255,  # '\x08'
     9: 255,  # '\t'
     10: 254,  # '\n'
     11: 255,  # '\x0b'
     12: 255,  # '\x0c'
     13: 254,  # '\r'
     14: 255,  # '\x0e'
     15: 255,  # '\x0f'
     16: 255,  # '\x10'
     17: 255,  # '\x11'
     18: 255,  # '\x12'
     19: 255,  # '\x13'
     20: 255,  # '\x14'
     21: 255,  # '\x15'
     22: 255,  # '\x16'
     23: 255,  # '\x17'
     24: 255,  # '\x18'
     25: 255,  # '\x19'
     26: 255,  # '\x1a'
     27: 255,  # '\x1b'
     28: 255,  # '\x1c'
     29: 255,  # '\x1d'
     30: 255,  # '\x1e'
     31: 255,  # '\x1f'
     32: 253,  # ' '
     33: 253,  # '!'
     34: 253,  # '"'
     35: 253,  # '#'
     36: 253,  # '$'
     37: 253,  # '%'
     38: 253,  # '&'
     39: 253,  # "'"
     40: 253,  # '('
     41: 253,  # ')'
     42: 253,  # '*'
     43: 253,  # '+'
     44: 253,  # ','
     45: 253,  # '-'
     46: 253,  # '.'
     47: 253,  # '/'
     48: 252,  # '0'
     49: 252,  # '1'
     50: 252,  # '2'
     51: 252,  # '3'
     52: 252,  # '4'
     53: 252,  # '5'
     54: 252,  # '6'
     55: 252,  # '7'
     56: 252,  # '8'
     57: 252,  # '9'
     58: 253,  # ':'
     59: 253,  # ';'
     60: 253,  # '<'
     61: 253,  # '='
     62: 253,  # '>'
     63: 253,  # '?'
     64: 253,  # '@'
     65: 142,  # 'A'
     66: 143,  # 'B'
     67: 144,  # 'C'
     68: 145,  # 'D'
     69: 146,  # 'E'
     70: 147,  # 'F'
     71: 148,  # 'G'
     72: 149,  # 'H'
     73: 150,  # 'I'
     74: 151,  # 'J'
     75: 152,  # 'K'
     76: 74,  # 'L'
     77: 153,  # 'M'
     78: 75,  # 'N'
     79: 154,  # 'O'
     80: 155,  # 'P'
     81: 156,  # 'Q'
     82: 157,  # 'R'
     83: 158,  # 'S'
     84: 159,  # 'T'
     85: 160,  # 'U'
     86: 161,  # 'V'
     87: 162,  # 'W'
     88: 163,  # 'X'
     89: 164,  # 'Y'
     90: 165,  # 'Z'
     91: 253,  # '['
     92: 253,  # '\\'
     93: 253,  # ']'
     94: 253,  # '^'
     95: 253,  # '_'
     96: 253,  # '`'
     97: 71,  # 'a'
     98: 172,  # 'b'
     99: 66,  # 'c'
     100: 173,  # 'd'
     101: 65,  # 'e'
     102: 174,  # 'f'
     103: 76,  # 'g'
     104: 175,  # 'h'
     105: 64,  # 'i'
     106: 176,  # 'j'
     107: 177,  # 'k'
     108: 77,  # 'l'
     109: 72,  # 'm'
     110: 178,  # 'n'
     111: 69,  # 'o'
     112: 67,  # 'p'
     113: 179,  # 'q'
     114: 78,  # 'r'
     115: 73,  # 's'
     116: 180,  # 't'
     117: 181,  # 'u'
     118: 79,  # 'v'
     119: 182,  # 'w'
     120: 183,  # 'x'
     121: 184,  # 'y'
     122: 185,  # 'z'
     123: 253,  # '{'
     124: 253,  # '|'
     125: 253,  # '}'
     126: 253,  # '~'
     127: 253,  # '\x7f'
     128: 37,  # 'А'
     129: 44,  # 'Б'
     130: 33,  # 'В'
     131: 46,  # 'Г'
     132: 41,  # 'Д'
     133: 48,  # 'Е'
     134: 56,  # 'Ж'
     135: 51,  # 'З'
     136: 42,  # 'И'
     137: 60,  # 'Й'
     138: 36,  # 'К'
     139: 49,  # 'Л'
     140: 38,  # 'М'
     141: 31,  # 'Н'
     142: 34,  # 'О'
     143: 35,  # 'П'
     144: 45,  # 'Р'
     145: 32,  # 'С'
     146: 40,  # 'Т'
     147: 52,  # 'У'
     148: 53,  # 'Ф'
     149: 55,  # 'Х'
     150: 58,  # 'Ц'
     151: 50,  # 'Ч'
     152: 57,  # 'Ш'
     153: 63,  # 'Щ'
     154: 70,  # 'Ъ'
     155: 62,  # 'Ы'
     156: 61,  # 'Ь'
     157: 47,  # 'Э'
     158: 59,  # 'Ю'
     159: 43,  # 'Я'
     160: 3,  # 'а'
     161: 21,  # 'б'
     162: 10,  # 'в'
     163: 19,  # 'г'
     164: 13,  # 'д'
     165: 2,  # 'е'
     166: 24,  # 'ж'
     167: 20,  # 'з'
     168: 4,  # 'и'
     169: 23,  # 'й'
     170: 11,  # 'к'
     171: 8,  # 'л'
     172: 12,  # 'м'
     173: 5,  # 'н'
     174: 1,  # 'о'
     175: 15,  # 'п'
     176: 191,  # '░'
     177: 192,  # '▒'
     178: 193,  # '▓'
     179: 194,  # '│'
     180: 195,  # '┤'
     181: 196,  # '╡'
     182: 197,  # '╢'
     183: 198,  # '╖'
     184: 199,  # '╕'
     185: 200,  # '╣'
     186: 201,  # '║'
     187: 202,  # '╗'
     188: 203,  # '╝'
     189: 204,  # '╜'
     190: 205,  # '╛'
     191: 206,  # '┐'
     192: 207,  # '└'
     193: 208,  # '┴'
     194: 209,  # '┬'
     195: 210,  # '├'
     196: 211,  # '─'
     197: 212,  # '┼'
     198: 213,  # '╞'
     199: 214,  # '╟'
     200: 215,  # '╚'
     201: 216,  # '╔'
     202: 217,  # '╩'
     203: 218,  # '╦'
     204: 219,  # '╠'
     205: 220,  # '═'
     206: 221,  # '╬'
     207: 222,  # '╧'
     208: 223,  # '╨'
     209: 224,  # '╤'
     210: 225,  # '╥'
     211: 226,  # '╙'
     212: 227,  # '╘'
     213: 228,  # '╒'
     214: 229,  # '╓'
     215: 230,  # '╫'
     216: 231,  # '╪'
     217: 232,  # '┘'
     218: 233,  # '┌'
     219: 234,  # '█'
     220: 235,  # '▄'
     221: 236,  # '▌'
     222: 237,  # '▐'
     223: 238,  # '▀'
     224: 9,  # 'р'
     225: 7,  # 'с'
     226: 6,  # 'т'
     227: 14,  # 'у'
     228: 39,  # 'ф'
     229: 26,  # 'х'
     230: 28,  # 'ц'
     231: 22,  # 'ч'
     232: 25,  # 'ш'
     233: 29,  # 'щ'
     234: 54,  # 'ъ'
     235: 18,  # 'ы'
     236: 17,  # 'ь'
     237: 30,  # 'э'
     238: 27,  # 'ю'
     239: 16,  # 'я'
     240: 239,  # 'Ё'
     241: 68,  # 'ё'
     242: 240,  # 'Є'
     243: 241,  # 'є'
     244: 242,  # 'Ї'
     245: 243,  # 'ї'
     246: 244,  # 'Ў'
     247: 245,  # 'ў'
     248: 246,  # '°'
     249: 247,  # '∙'
     250: 248,  # '·'
     251: 249,  # '√'
     252: 250,  # '№'
     253: 251,  # '¤'
     254: 252,  # '■'
     255: 255,  # '\xa0'
}

IBM866_RUSSIAN_MODEL = SingleByteCharSetModel(charset_name='IBM866',
                                              language='Russian',
                                              char_to_order_map=IBM866_RUSSIAN_CHAR_TO_ORDER,
                                              language_model=RUSSIAN_LANG_MODEL,
                                              typical_positive_ratio=0.976601,
                                              keep_ascii_letters=False,
                                              alphabet='ЁАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяё')

WINDOWS_1251_RUSSIAN_CHAR_TO_ORDER = {
     0: 255,  # '\x00'
     1: 255,  # '\x01'
     2: 255,  # '\x02'
     3: 255,  # '\x03'
     4: 255,  # '\x04'
     5: 255,  # '\x05'
     6: 255,  # '\x06'
     7: 255,  # '\x07'
     8: 255,  # '\x08'
     9: 255,  # '\t'
     10: 254,  # '\n'
     11: 255,  # '\x0b'
     12: 255,  # '\x0c'
     13: 254,  # '\r'
     14: 255,  # '\x0e'
     15: 255,  # '\x0f'
     16: 255,  # '\x10'
     17: 255,  # '\x11'
     18: 255,  # '\x12'
     19: 255,  # '\x13'
     20: 255,  # '\x14'
     21: 255,  # '\x15'
     22: 255,  # '\x16'
     23: 255,  # '\x17'
     24: 255,  # '\x18'
     25: 255,  # '\x19'
     26: 255,  # '\x1a'
     27: 255,  # '\x1b'
     28: 255,  # '\x1c'
     29: 255,  # '\x1d'
     30: 255,  # '\x1e'
     31: 255,  # '\x1f'
     32: 253,  # ' '
     33: 253,  # '!'
     34: 253,  # '"'
     35: 253,  # '#'
     36: 253,  # '$'
     37: 253,  # '%'
     38: 253,  # '&'
     39: 253,  # "'"
     40: 253,  # '('
     41: 253,  # ')'
     42: 253,  # '*'
     43: 253,  # '+'
     44: 253,  # ','
     45: 253,  # '-'
     46: 253,  # '.'
     47: 253,  # '/'
     48: 252,  # '0'
     49: 252,  # '1'
     50: 252,  # '2'
     51: 252,  # '3'
     52: 252,  # '4'
     53: 252,  # '5'
     54: 252,  # '6'
     55: 252,  # '7'
     56: 252,  # '8'
     57: 252,  # '9'
     58: 253,  # ':'
     59: 253,  # ';'
     60: 253,  # '<'
     61: 253,  # '='
     62: 253,  # '>'
     63: 253,  # '?'
     64: 253,  # '@'
     65: 142,  # 'A'
     66: 143,  # 'B'
     67: 144,  # 'C'
     68: 145,  # 'D'
     69: 146,  # 'E'
     70: 147,  # 'F'
     71: 148,  # 'G'
     72: 149,  # 'H'
     73: 150,  # 'I'
     74: 151,  # 'J'
     75: 152,  # 'K'
     76: 74,  # 'L'
     77: 153,  # 'M'
     78: 75,  # 'N'
     79: 154,  # 'O'
     80: 155,  # 'P'
     81: 156,  # 'Q'
     82: 157,  # 'R'
     83: 158,  # 'S'
     84: 159,  # 'T'
     85: 160,  # 'U'
     86: 161,  # 'V'
     87: 162,  # 'W'
     88: 163,  # 'X'
     89: 164,  # 'Y'
     90: 165,  # 'Z'
     91: 253,  # '['
     92: 253,  # '\\'
     93: 253,  # ']'
     94: 253,  # '^'
     95: 253,  # '_'
     96: 253,  # '`'
     97: 71,  # 'a'
     98: 172,  # 'b'
     99: 66,  # 'c'
     100: 173,  # 'd'
     101: 65,  # 'e'
     102: 174,  # 'f'
     103: 76,  # 'g'
     104: 175,  # 'h'
     105: 64,  # 'i'
     106: 176,  # 'j'
     107: 177,  # 'k'
     108: 77,  # 'l'
     109: 72,  # 'm'
     110: 178,  # 'n'
     111: 69,  # 'o'
     112: 67,  # 'p'
     113: 179,  # 'q'
     114: 78,  # 'r'
     115: 73,  # 's'
     116: 180,  # 't'
     117: 181,  # 'u'
     118: 79,  # 'v'
     119: 182,  # 'w'
     120: 183,  # 'x'
     121: 184,  # 'y'
     122: 185,  # 'z'
     123: 253,  # '{'
     124: 253,  # '|'
     125: 253,  # '}'
     126: 253,  # '~'
     127: 253,  # '\x7f'
     128: 191,  # 'Ђ'
     129: 192,  # 'Ѓ'
     130: 193,  # '‚'
     131: 194,  # 'ѓ'
     132: 195,  # '„'
     133: 196,  # '…'
     134: 197,  # '†'
     135: 198,  # '‡'
     136: 199,  # '€'
     137: 200,  # '‰'
     138: 201,  # 'Љ'
     139: 202,  # '‹'
     140: 203,  # 'Њ'
     141: 204,  # 'Ќ'
     142: 205,  # 'Ћ'
     143: 206,  # 'Џ'
     144: 207,  # 'ђ'
     145: 208,  # '‘'
     146: 209,  # '’'
     147: 210,  # '“'
     148: 211,  # '”'
     149: 212,  # '•'
     150: 213,  # '–'
     151: 214,  # '—'
     152: 215,  # None
     153: 216,  # '™'
     154: 217,  # 'љ'
     155: 218,  # '›'
     156: 219,  # 'њ'
     157: 220,  # 'ќ'
     158: 221,  # 'ћ'
     159: 222,  # 'џ'
     160: 223,  # '\xa0'
     161: 224,  # 'Ў'
     162: 225,  # 'ў'
     163: 226,  # 'Ј'
     164: 227,  # '¤'
     165: 228,  # 'Ґ'
     166: 229,  # '¦'
     167: 230,  # '§'
     168: 231,  # 'Ё'
     169: 232,  # '©'
     170: 233,  # 'Є'
     171: 234,  # '«'
     172: 235,  # '¬'
     173: 236,  # '\xad'
     174: 237,  # '®'
     175: 238,  # 'Ї'
     176: 239,  # '°'
     177: 240,  # '±'
     178: 241,  # 'І'
     179: 242,  # 'і'
     180: 243,  # 'ґ'
     181: 244,  # 'µ'
     182: 245,  # '¶'
     183: 246,  # '·'
     184: 68,  # 'ё'
     185: 247,  # '№'
     186: 248,  # 'є'
     187: 249,  # '»'
     188: 250,  # 'ј'
     189: 251,  # 'Ѕ'
     190: 252,  # 'ѕ'
     191: 253,  # 'ї'
     192: 37,  # 'А'
     193: 44,  # 'Б'
     194: 33,  # 'В'
     195: 46,  # 'Г'
     196: 41,  # 'Д'
     197: 48,  # 'Е'
     198: 56,  # 'Ж'
     199: 51,  # 'З'
     200: 42,  # 'И'
     201: 60,  # 'Й'
     202: 36,  # 'К'
     203: 49,  # 'Л'
     204: 38,  # 'М'
     205: 31,  # 'Н'
     206: 34,  # 'О'
     207: 35,  # 'П'
     208: 45,  # 'Р'
     209: 32,  # 'С'
     210: 40,  # 'Т'
     211: 52,  # 'У'
     212: 53,  # 'Ф'
     213: 55,  # 'Х'
     214: 58,  # 'Ц'
     215: 50,  # 'Ч'
     216: 57,  # 'Ш'
     217: 63,  # 'Щ'
     218: 70,  # 'Ъ'
     219: 62,  # 'Ы'
     220: 61,  # 'Ь'
     221: 47,  # 'Э'
     222: 59,  # 'Ю'
     223: 43,  # 'Я'
     224: 3,  # 'а'
     225: 21,  # 'б'
     226: 10,  # 'в'
     227: 19,  # 'г'
     228: 13,  # 'д'
     229: 2,  # 'е'
     230: 24,  # 'ж'
     231: 20,  # 'з'
     232: 4,  # 'и'
     233: 23,  # 'й'
     234: 11,  # 'к'
     235: 8,  # 'л'
     236: 12,  # 'м'
     237: 5,  # 'н'
     238: 1,  # 'о'
     239: 15,  # 'п'
     240: 9,  # 'р'
     241: 7,  # 'с'
     242: 6,  # 'т'
     243: 14,  # 'у'
     244: 39,  # 'ф'
     245: 26,  # 'х'
     246: 28,  # 'ц'
     247: 22,  # 'ч'
     248: 25,  # 'ш'
     249: 29,  # 'щ'
     250: 54,  # 'ъ'
     251: 18,  # 'ы'
     252: 17,  # 'ь'
     253: 30,  # 'э'
     254: 27,  # 'ю'
     255: 16,  # 'я'
}

WINDOWS_1251_RUSSIAN_MODEL = SingleByteCharSetModel(charset_name='windows-1251',
                                                    language='Russian',
                                                    char_to_order_map=WINDOWS_1251_RUSSIAN_CHAR_TO_ORDER,
                                                    language_model=RUSSIAN_LANG_MODEL,
                                                    typical_positive_ratio=0.976601,
                                                    keep_ascii_letters=False,
                                                    alphabet='ЁАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяё')

IBM855_RUSSIAN_CHAR_TO_ORDER = {
     0: 255,  # '\x00'
     1: 255,  # '\x01'
     2: 255,  # '\x02'
     3: 255,  # '\x03'
     4: 255,  # '\x04'
     5: 255,  # '\x05'
     6: 255,  # '\x06'
     7: 255,  # '\x07'
     8: 255,  # '\x08'
     9: 255,  # '\t'
     10: 254,  # '\n'
     11: 255,  # '\x0b'
     12: 255,  # '\x0c'
     13: 254,  # '\r'
     14: 255,  # '\x0e'
     15: 255,  # '\x0f'
     16: 255,  # '\x10'
     17: 255,  # '\x11'
     18: 255,  # '\x12'
     19: 255,  # '\x13'
     20: 255,  # '\x14'
     21: 255,  # '\x15'
     22: 255,  # '\x16'
     23: 255,  # '\x17'
     24: 255,  # '\x18'
     25: 255,  # '\x19'
     26: 255,  # '\x1a'
     27: 255,  # '\x1b'
     28: 255,  # '\x1c'
     29: 255,  # '\x1d'
     30: 255,  # '\x1e'
     31: 255,  # '\x1f'
     32: 253,  # ' '
     33: 253,  # '!'
     34: 253,  # '"'
     35: 253,  # '#'
     36: 253,  # '$'
     37: 253,  # '%'
     38: 253,  # '&'
     39: 253,  # "'"
     40: 253,  # '('
     41: 253,  # ')'
     42: 253,  # '*'
     43: 253,  # '+'
     44: 253,  # ','
     45: 253,  # '-'
     46: 253,  # '.'
     47: 253,  # '/'
     48: 252,  # '0'
     49: 252,  # '1'
     50: 252,  # '2'
     51: 252,  # '3'
     52: 252,  # '4'
     53: 252,  # '5'
     54: 252,  # '6'
     55: 252,  # '7'
     56: 252,  # '8'
     57: 252,  # '9'
     58: 253,  # ':'
     59: 253,  # ';'
     60: 253,  # '<'
     61: 253,  # '='
     62: 253,  # '>'
     63: 253,  # '?'
     64: 253,  # '@'
     65: 142,  # 'A'
     66: 143,  # 'B'
     67: 144,  # 'C'
     68: 145,  # 'D'
     69: 146,  # 'E'
     70: 147,  # 'F'
     71: 148,  # 'G'
     72: 149,  # 'H'
     73: 150,  # 'I'
     74: 151,  # 'J'
     75: 152,  # 'K'
     76: 74,  # 'L'
     77: 153,  # 'M'
     78: 75,  # 'N'
     79: 154,  # 'O'
     80: 155,  # 'P'
     81: 156,  # 'Q'
     82: 157,  # 'R'
     83: 158,  # 'S'
     84: 159,  # 'T'
     85: 160,  # 'U'
     86: 161,  # 'V'
     87: 162,  # 'W'
     88: 163,  # 'X'
     89: 164,  # 'Y'
     90: 165,  # 'Z'
     91: 253,  # '['
     92: 253,  # '\\'
     93: 253,  # ']'
     94: 253,  # '^'
     95: 253,  # '_'
     96: 253,  # '`'
     97: 71,  # 'a'
     98: 172,  # 'b'
     99: 66,  # 'c'
     100: 173,  # 'd'
     101: 65,  # 'e'
     102: 174,  # 'f'
     103: 76,  # 'g'
     104: 175,  # 'h'
     105: 64,  # 'i'
     106: 176,  # 'j'
     107: 177,  # 'k'
     108: 77,  # 'l'
     109: 72,  # 'm'
     110: 178,  # 'n'
     111: 69,  # 'o'
     112: 67,  # 'p'
     113: 179,  # 'q'
     114: 78,  # 'r'
     115: 73,  # 's'
     116: 180,  # 't'
     117: 181,  # 'u'
     118: 79,  # 'v'
     119: 182,  # 'w'
     120: 183,  # 'x'
     121: 184,  # 'y'
     122: 185,  # 'z'
     123: 253,  # '{'
     124: 253,  # '|'
     125: 253,  # '}'
     126: 253,  # '~'
     127: 253,  # '\x7f'
     128: 191,  # 'ђ'
     129: 192,  # 'Ђ'
     130: 193,  # 'ѓ'
     131: 194,  # 'Ѓ'
     132: 68,  # 'ё'
     133: 195,  # 'Ё'
     134: 196,  # 'є'
     135: 197,  # 'Є'
     136: 198,  # 'ѕ'
     137: 199,  # 'Ѕ'
     138: 200,  # 'і'
     139: 201,  # 'І'
     140: 202,  # 'ї'
     141: 203,  # 'Ї'
     142: 204,  # 'ј'
     143: 205,  # 'Ј'
     144: 206,  # 'љ'
     145: 207,  # 'Љ'
     146: 208,  # 'њ'
     147: 209,  # 'Њ'
     148: 210,  # 'ћ'
     149: 211,  # 'Ћ'
     150: 212,  # 'ќ'
     151: 213,  # 'Ќ'
     152: 214,  # 'ў'
     153: 215,  # 'Ў'
     154: 216,  # 'џ'
     155: 217,  # 'Џ'
     156: 27,  # 'ю'
     157: 59,  # 'Ю'
     158: 54,  # 'ъ'
     159: 70,  # 'Ъ'
     160: 3,  # 'а'
     161: 37,  # 'А'
     162: 21,  # 'б'
     163: 44,  # 'Б'
     164: 28,  # 'ц'
     165: 58,  # 'Ц'
     166: 13,  # 'д'
     167: 41,  # 'Д'
     168: 2,  # 'е'
     169: 48,  # 'Е'
     170: 39,  # 'ф'
     171: 53,  # 'Ф'
     172: 19,  # 'г'
     173: 46,  # 'Г'
     174: 218,  # '«'
     175: 219,  # '»'
     176: 220,  # '░'
     177: 221,  # '▒'
     178: 222,  # '▓'
     179: 223,  # '│'
     180: 224,  # '┤'
     181: 26,  # 'х'
     182: 55,  # 'Х'
     183: 4,  # 'и'
     184: 42,  # 'И'
     185: 225,  # '╣'
     186: 226,  # '║'
     187: 227,  # '╗'
     188: 228,  # '╝'
     189: 23,  # 'й'
     190: 60,  # 'Й'
     191: 229,  # '┐'
     192: 230,  # '└'
     193: 231,  # '┴'
     194: 232,  # '┬'
     195: 233,  # '├'
     196: 234,  # '─'
     197: 235,  # '┼'
     198: 11,  # 'к'
     199: 36,  # 'К'
     200: 236,  # '╚'
     201: 237,  # '╔'
     202: 238,  # '╩'
     203: 239,  # '╦'
     204: 240,  # '╠'
     205: 241,  # '═'
     206: 242,  # '╬'
     207: 243,  # '¤'
     208: 8,  # 'л'
     209: 49,  # 'Л'
     210: 12,  # 'м'
     211: 38,  # 'М'
     212: 5,  # 'н'
     213: 31,  # 'Н'
     214: 1,  # 'о'
     215: 34,  # 'О'
     216: 15,  # 'п'
     217: 244,  # '┘'
     218: 245,  # '┌'
     219: 246,  # '█'
     220: 247,  # '▄'
     221: 35,  # 'П'
     222: 16,  # 'я'
     223: 248,  # '▀'
     224: 43,  # 'Я'
     225: 9,  # 'р'
     226: 45,  # 'Р'
     227: 7,  # 'с'
     228: 32,  # 'С'
     229: 6,  # 'т'
     230: 40,  # 'Т'
     231: 14,  # 'у'
     232: 52,  # 'У'
     233: 24,  # 'ж'
     234: 56,  # 'Ж'
     235: 10,  # 'в'
     236: 33,  # 'В'
     237: 17,  # 'ь'
     238: 61,  # 'Ь'
     239: 249,  # '№'
     240: 250,  # '\xad'
     241: 18,  # 'ы'
     242: 62,  # 'Ы'
     243: 20,  # 'з'
     244: 51,  # 'З'
     245: 25,  # 'ш'
     246: 57,  # 'Ш'
     247: 30,  # 'э'
     248: 47,  # 'Э'
     249: 29,  # 'щ'
     250: 63,  # 'Щ'
     251: 22,  # 'ч'
     252: 50,  # 'Ч'
     253: 251,  # '§'
     254: 252,  # '■'
     255: 255,  # '\xa0'
}

IBM855_RUSSIAN_MODEL = SingleByteCharSetModel(charset_name='IBM855',
                                              language='Russian',
                                              char_to_order_map=IBM855_RUSSIAN_CHAR_TO_ORDER,
                                              language_model=RUSSIAN_LANG_MODEL,
                                              typical_positive_ratio=0.976601,
                                              keep_ascii_letters=False,
                                              alphabet='ЁАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяё')

KOI8_R_RUSSIAN_CHAR_TO_ORDER = {
     0: 255,  # '\x00'
     1: 255,  # '\x01'
     2: 255,  # '\x02'
     3: 255,  # '\x03'
     4: 255,  # '\x04'
     5: 255,  # '\x05'
     6: 255,  # '\x06'
     7: 255,  # '\x07'
     8: 255,  # '\x08'
     9: 255,  # '\t'
     10: 254,  # '\n'
     11: 255,  # '\x0b'
     12: 255,  # '\x0c'
     13: 254,  # '\r'
     14: 255,  # '\x0e'
     15: 255,  # '\x0f'
     16: 255,  # '\x10'
     17: 255,  # '\x11'
     18: 255,  # '\x12'
     19: 255,  # '\x13'
     20: 255,  # '\x14'
     21: 255,  # '\x15'
     22: 255,  # '\x16'
     23: 255,  # '\x17'
     24: 255,  # '\x18'
     25: 255,  # '\x19'
     26: 255,  # '\x1a'
     27: 255,  # '\x1b'
     28: 255,  # '\x1c'
     29: 255,  # '\x1d'
     30: 255,  # '\x1e'
     31: 255,  # '\x1f'
     32: 253,  # ' '
     33: 253,  # '!'
     34: 253,  # '"'
     35: 253,  # '#'
     36: 253,  # '$'
     37: 253,  # '%'
     38: 253,  # '&'
     39: 253,  # "'"
     40: 253,  # '('
     41: 253,  # ')'
     42: 253,  # '*'
     43: 253,  # '+'
     44: 253,  # ','
     45: 253,  # '-'
     46: 253,  # '.'
     47: 253,  # '/'
     48: 252,  # '0'
     49: 252,  # '1'
     50: 252,  # '2'
     51: 252,  # '3'
     52: 252,  # '4'
     53: 252,  # '5'
     54: 252,  # '6'
     55: 252,  # '7'
     56: 252,  # '8'
     57: 252,  # '9'
     58: 253,  # ':'
     59: 253,  # ';'
     60: 253,  # '<'
     61: 253,  # '='
     62: 253,  # '>'
     63: 253,  # '?'
     64: 253,  # '@'
     65: 142,  # 'A'
     66: 143,  # 'B'
     67: 144,  # 'C'
     68: 145,  # 'D'
     69: 146,  # 'E'
     70: 147,  # 'F'
     71: 148,  # 'G'
     72: 149,  # 'H'
     73: 150,  # 'I'
     74: 151,  # 'J'
     75: 152,  # 'K'
     76: 74,  # 'L'
     77: 153,  # 'M'
     78: 75,  # 'N'
     79: 154,  # 'O'
     80: 155,  # 'P'
     81: 156,  # 'Q'
     82: 157,  # 'R'
     83: 158,  # 'S'
     84: 159,  # 'T'
     85: 160,  # 'U'
     86: 161,  # 'V'
     87: 162,  # 'W'
     88: 163,  # 'X'
     89: 164,  # 'Y'
     90: 165,  # 'Z'
     91: 253,  # '['
     92: 253,  # '\\'
     93: 253,  # ']'
     94: 253,  # '^'
     95: 253,  # '_'
     96: 253,  # '`'
     97: 71,  # 'a'
     98: 172,  # 'b'
     99: 66,  # 'c'
     100: 173,  # 'd'
     101: 65,  # 'e'
     102: 174,  # 'f'
     103: 76,  # 'g'
     104: 175,  # 'h'
     105: 64,  # 'i'
     106: 176,  # 'j'
     107: 177,  # 'k'
     108: 77,  # 'l'
     109: 72,  # 'm'
     110: 178,  # 'n'
     111: 69,  # 'o'
     112: 67,  # 'p'
     113: 179,  # 'q'
     114: 78,  # 'r'
     115: 73,  # 's'
     116: 180,  # 't'
     117: 181,  # 'u'
     118: 79,  # 'v'
     119: 182,  # 'w'
     120: 183,  # 'x'
     121: 184,  # 'y'
     122: 185,  # 'z'
     123: 253,  # '{'
     124: 253,  # '|'
     125: 253,  # '}'
     126: 253,  # '~'
     127: 253,  # '\x7f'
     128: 191,  # '─'
     129: 192,  # '│'
     130: 193,  # '┌'
     131: 194,  # '┐'
     132: 195,  # '└'
     133: 196,  # '┘'
     134: 197,  # '├'
     135: 198,  # '┤'
     136: 199,  # '┬'
     137: 200,  # '┴'
     138: 201,  # '┼'
     139: 202,  # '▀'
     140: 203,  # '▄'
     141: 204,  # '█'
     142: 205,  # '▌'
     143: 206,  # '▐'
     144: 207,  # '░'
     145: 208,  # '▒'
     146: 209,  # '▓'
     147: 210,  # '⌠'
     148: 211,  # '■'
     149: 212,  # '∙'
     150: 213,  # '√'
     151: 214,  # '≈'
     152: 215,  # '≤'
     153: 216,  # '≥'
     154: 217,  # '\xa0'
     155: 218,  # '⌡'
     156: 219,  # '°'
     157: 220,  # '²'
     158: 221,  # '·'
     159: 222,  # '÷'
     160: 223,  # '═'
     161: 224,  # '║'
     162: 225,  # '╒'
     163: 68,  # 'ё'
     164: 226,  # '╓'
     165: 227,  # '╔'
     166: 228,  # '╕'
     167: 229,  # '╖'
     168: 230,  # '╗'
     169: 231,  # '╘'
     170: 232,  # '╙'
     171: 233,  # '╚'
     172: 234,  # '╛'
     173: 235,  # '╜'
     174: 236,  # '╝'
     175: 237,  # '╞'
     176: 238,  # '╟'
     177: 239,  # '╠'
     178: 240,  # '╡'
     179: 241,  # 'Ё'
     180: 242,  # '╢'
     181: 243,  # '╣'
     182: 244,  # '╤'
     183: 245,  # '╥'
     184: 246,  # '╦'
     185: 247,  # '╧'
     186: 248,  # '╨'
     187: 249,  # '╩'
     188: 250,  # '╪'
     189: 251,  # '╫'
     190: 252,  # '╬'
     191: 253,  # '©'
     192: 27,  # 'ю'
     193: 3,  # 'а'
     194: 21,  # 'б'
     195: 28,  # 'ц'
     196: 13,  # 'д'
     197: 2,  # 'е'
     198: 39,  # 'ф'
     199: 19,  # 'г'
     200: 26,  # 'х'
     201: 4,  # 'и'
     202: 23,  # 'й'
     203: 11,  # 'к'
     204: 8,  # 'л'
     205: 12,  # 'м'
     206: 5,  # 'н'
     207: 1,  # 'о'
     208: 15,  # 'п'
     209: 16,  # 'я'
     210: 9,  # 'р'
     211: 7,  # 'с'
     212: 6,  # 'т'
     213: 14,  # 'у'
     214: 24,  # 'ж'
     215: 10,  # 'в'
     216: 17,  # 'ь'
     217: 18,  # 'ы'
     218: 20,  # 'з'
     219: 25,  # 'ш'
     220: 30,  # 'э'
     221: 29,  # 'щ'
     222: 22,  # 'ч'
     223: 54,  # 'ъ'
     224: 59,  # 'Ю'
     225: 37,  # 'А'
     226: 44,  # 'Б'
     227: 58,  # 'Ц'
     228: 41,  # 'Д'
     229: 48,  # 'Е'
     230: 53,  # 'Ф'
     231: 46,  # 'Г'
     232: 55,  # 'Х'
     233: 42,  # 'И'
     234: 60,  # 'Й'
     235: 36,  # 'К'
     236: 49,  # 'Л'
     237: 38,  # 'М'
     238: 31,  # 'Н'
     239: 34,  # 'О'
     240: 35,  # 'П'
     241: 43,  # 'Я'
     242: 45,  # 'Р'
     243: 32,  # 'С'
     244: 40,  # 'Т'
     245: 52,  # 'У'
     246: 56,  # 'Ж'
     247: 33,  # 'В'
     248: 61,  # 'Ь'
     249: 62,  # 'Ы'
     250: 51,  # 'З'
     251: 57,  # 'Ш'
     252: 47,  # 'Э'
     253: 63,  # 'Щ'
     254: 50,  # 'Ч'
     255: 70,  # 'Ъ'
}

KOI8_R_RUSSIAN_MODEL = SingleByteCharSetModel(charset_name='KOI8-R',
                                              language='Russian',
                                              char_to_order_map=KOI8_R_RUSSIAN_CHAR_TO_ORDER,
                                              language_model=RUSSIAN_LANG_MODEL,
                                              typical_positive_ratio=0.976601,
                                              keep_ascii_letters=False,
                                              alphabet='ЁАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяё')

MACCYRILLIC_RUSSIAN_CHAR_TO_ORDER = {
     0: 255,  # '\x00'
     1: 255,  # '\x01'
     2: 255,  # '\x02'
     3: 255,  # '\x03'
     4: 255,  # '\x04'
     5: 255,  # '\x05'
     6: 255,  # '\x06'
     7: 255,  # '\x07'
     8: 255,  # '\x08'
     9: 255,  # '\t'
     10: 254,  # '\n'
     11: 255,  # '\x0b'
     12: 255,  # '\x0c'
     13: 254,  # '\r'
     14: 255,  # '\x0e'
     15: 255,  # '\x0f'
     16: 255,  # '\x10'
     17: 255,  # '\x11'
     18: 255,  # '\x12'
     19: 255,  # '\x13'
     20: 255,  # '\x14'
     21: 255,  # '\x15'
     22: 255,  # '\x16'
     23: 255,  # '\x17'
     24: 255,  # '\x18'
     25: 255,  # '\x19'
     26: 255,  # '\x1a'
     27: 255,  # '\x1b'
     28: 255,  # '\x1c'
     29: 255,  # '\x1d'
     30: 255,  # '\x1e'
     31: 255,  # '\x1f'
     32: 253,  # ' '
     33: 253,  # '!'
     34: 253,  # '"'
     35: 253,  # '#'
     36: 253,  # '$'
     37: 253,  # '%'
     38: 253,  # '&'
     39: 253,  # "'"
     40: 253,  # '('
     41: 253,  # ')'
     42: 253,  # '*'
     43: 253,  # '+'
     44: 253,  # ','
     45: 253,  # '-'
     46: 253,  # '.'
     47: 253,  # '/'
     48: 252,  # '0'
     49: 252,  # '1'
     50: 252,  # '2'
     51: 252,  # '3'
     52: 252,  # '4'
     53: 252,  # '5'
     54: 252,  # '6'
     55: 252,  # '7'
     56: 252,  # '8'
     57: 252,  # '9'
     58: 253,  # ':'
     59: 253,  # ';'
     60: 253,  # '<'
     61: 253,  # '='
     62: 253,  # '>'
     63: 253,  # '?'
     64: 253,  # '@'
     65: 142,  # 'A'
     66: 143,  # 'B'
     67: 144,  # 'C'
     68: 145,  # 'D'
     69: 146,  # 'E'
     70: 147,  # 'F'
     71: 148,  # 'G'
     72: 149,  # 'H'
     73: 150,  # 'I'
     74: 151,  # 'J'
     75: 152,  # 'K'
     76: 74,  # 'L'
     77: 153,  # 'M'
     78: 75,  # 'N'
     79: 154,  # 'O'
     80: 155,  # 'P'
     81: 156,  # 'Q'
     82: 157,  # 'R'
     83: 158,  # 'S'
     84: 159,  # 'T'
     85: 160,  # 'U'
     86: 161,  # 'V'
     87: 162,  # 'W'
     88: 163,  # 'X'
     89: 164,  # 'Y'
     90: 165,  # 'Z'
     91: 253,  # '['
     92: 253,  # '\\'
     93: 253,  # ']'
     94: 253,  # '^'
     95: 253,  # '_'
     96: 253,  # '`'
     97: 71,  # 'a'
     98: 172,  # 'b'
     99: 66,  # 'c'
     100: 173,  # 'd'
     101: 65,  # 'e'
     102: 174,  # 'f'
     103: 76,  # 'g'
     104: 175,  # 'h'
     105: 64,  # 'i'
     106: 176,  # 'j'
     107: 177,  # 'k'
     108: 77,  # 'l'
     109: 72,  # 'm'
     110: 178,  # 'n'
     111: 69,  # 'o'
     112: 67,  # 'p'
     113: 179,  # 'q'
     114: 78,  # 'r'
     115: 73,  # 's'
     116: 180,  # 't'
     117: 181,  # 'u'
     118: 79,  # 'v'
     119: 182,  # 'w'
     120: 183,  # 'x'
     121: 184,  # 'y'
     122: 185,  # 'z'
     123: 253,  # '{'
     124: 253,  # '|'
     125: 253,  # '}'
     126: 253,  # '~'
     127: 253,  # '\x7f'
     128: 37,  # 'А'
     129: 44,  # 'Б'
     130: 33,  # 'В'
     131: 46,  # 'Г'
     132: 41,  # 'Д'
     133: 48,  # 'Е'
     134: 56,  # 'Ж'
     135: 51,  # 'З'
     136: 42,  # 'И'
     137: 60,  # 'Й'
     138: 36,  # 'К'
     139: 49,  # 'Л'
     140: 38,  # 'М'
     141: 31,  # 'Н'
     142: 34,  # 'О'
     143: 35,  # 'П'
     144: 45,  # 'Р'
     145: 32,  # 'С'
     146: 40,  # 'Т'
     147: 52,  # 'У'
     148: 53,  # 'Ф'
     149: 55,  # 'Х'
     150: 58,  # 'Ц'
     151: 50,  # 'Ч'
     152: 57,  # 'Ш'
     153: 63,  # 'Щ'
     154: 70,  # 'Ъ'
     155: 62,  # 'Ы'
     156: 61,  # 'Ь'
     157: 47,  # 'Э'
     158: 59,  # 'Ю'
     159: 43,  # 'Я'
     160: 191,  # '†'
     161: 192,  # '°'
     162: 193,  # 'Ґ'
     163: 194,  # '£'
     164: 195,  # '§'
     165: 196,  # '•'
     166: 197,  # '¶'
     167: 198,  # 'І'
     168: 199,  # '®'
     169: 200,  # '©'
     170: 201,  # '™'
     171: 202,  # 'Ђ'
     172: 203,  # 'ђ'
     173: 204,  # '≠'
     174: 205,  # 'Ѓ'
     175: 206,  # 'ѓ'
     176: 207,  # '∞'
     177: 208,  # '±'
     178: 209,  # '≤'
     179: 210,  # '≥'
     180: 211,  # 'і'
     181: 212,  # 'µ'
     182: 213,  # 'ґ'
     183: 214,  # 'Ј'
     184: 215,  # 'Є'
     185: 216,  # 'є'
     186: 217,  # 'Ї'
     187: 218,  # 'ї'
     188: 219,  # 'Љ'
     189: 220,  # 'љ'
     190: 221,  # 'Њ'
     191: 222,  # 'њ'
     192: 223,  # 'ј'
     193: 224,  # 'Ѕ'
     194: 225,  # '¬'
     195: 226,  # '√'
     196: 227,  # 'ƒ'
     197: 228,  # '≈'
     198: 229,  # '∆'
     199: 230,  # '«'
     200: 231,  # '»'
     201: 232,  # '…'
     202: 233,  # '\xa0'
     203: 234,  # 'Ћ'
     204: 235,  # 'ћ'
     205: 236,  # 'Ќ'
     206: 237,  # 'ќ'
     207: 238,  # 'ѕ'
     208: 239,  # '–'
     209: 240,  # '—'
     210: 241,  # '“'
     211: 242,  # '”'
     212: 243,  # '‘'
     213: 244,  # '’'
     214: 245,  # '÷'
     215: 246,  # '„'
     216: 247,  # 'Ў'
     217: 248,  # 'ў'
     218: 249,  # 'Џ'
     219: 250,  # 'џ'
     220: 251,  # '№'
     221: 252,  # 'Ё'
     222: 68,  # 'ё'
     223: 16,  # 'я'
     224: 3,  # 'а'
     225: 21,  # 'б'
     226: 10,  # 'в'
     227: 19,  # 'г'
     228: 13,  # 'д'
     229: 2,  # 'е'
     230: 24,  # 'ж'
     231: 20,  # 'з'
     232: 4,  # 'и'
     233: 23,  # 'й'
     234: 11,  # 'к'
     235: 8,  # 'л'
     236: 12,  # 'м'
     237: 5,  # 'н'
     238: 1,  # 'о'
     239: 15,  # 'п'
     240: 9,  # 'р'
     241: 7,  # 'с'
     242: 6,  # 'т'
     243: 14,  # 'у'
     244: 39,  # 'ф'
     245: 26,  # 'х'
     246: 28,  # 'ц'
     247: 22,  # 'ч'
     248: 25,  # 'ш'
     249: 29,  # 'щ'
     250: 54,  # 'ъ'
     251: 18,  # 'ы'
     252: 17,  # 'ь'
     253: 30,  # 'э'
     254: 27,  # 'ю'
     255: 255,  # '€'
}

MACCYRILLIC_RUSSIAN_MODEL = SingleByteCharSetModel(charset_name='MacCyrillic',
                                                   language='Russian',
                                                   char_to_order_map=MACCYRILLIC_RUSSIAN_CHAR_TO_ORDER,
                                                   language_model=RUSSIAN_LANG_MODEL,
                                                   typical_positive_ratio=0.976601,
                                                   keep_ascii_letters=False,
                                                   alphabet='ЁАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяё')

ISO_8859_5_RUSSIAN_CHAR_TO_ORDER = {
     0: 255,  # '\x00'
     1: 255,  # '\x01'
     2: 255,  # '\x02'
     3: 255,  # '\x03'
     4: 255,  # '\x04'
     5: 255,  # '\x05'
     6: 255,  # '\x06'
     7: 255,  # '\x07'
     8: 255,  # '\x08'
     9: 255,  # '\t'
     10: 254,  # '\n'
     11: 255,  # '\x0b'
     12: 255,  # '\x0c'
     13: 254,  # '\r'
     14: 255,  # '\x0e'
     15: 255,  # '\x0f'
     16: 255,  # '\x10'
     17: 255,  # '\x11'
     18: 255,  # '\x12'
     19: 255,  # '\x13'
     20: 255,  # '\x14'
     21: 255,  # '\x15'
     22: 255,  # '\x16'
     23: 255,  # '\x17'
     24: 255,  # '\x18'
     25: 255,  # '\x19'
     26: 255,  # '\x1a'
     27: 255,  # '\x1b'
     28: 255,  # '\x1c'
     29: 255,  # '\x1d'
     30: 255,  # '\x1e'
     31: 255,  # '\x1f'
     32: 253,  # ' '
     33: 253,  # '!'
     34: 253,  # '"'
     35: 253,  # '#'
     36: 253,  # '$'
     37: 253,  # '%'
     38: 253,  # '&'
     39: 253,  # "'"
     40: 253,  # '('
     41: 253,  # ')'
     42: 253,  # '*'
     43: 253,  # '+'
     44: 253,  # ','
     45: 253,  # '-'
     46: 253,  # '.'
     47: 253,  # '/'
     48: 252,  # '0'
     49: 252,  # '1'
     50: 252,  # '2'
     51: 252,  # '3'
     52: 252,  # '4'
     53: 252,  # '5'
     54: 252,  # '6'
     55: 252,  # '7'
     56: 252,  # '8'
     57: 252,  # '9'
     58: 253,  # ':'
     59: 253,  # ';'
     60: 253,  # '<'
     61: 253,  # '='
     62: 253,  # '>'
     63: 253,  # '?'
     64: 253,  # '@'
     65: 142,  # 'A'
     66: 143,  # 'B'
     67: 144,  # 'C'
     68: 145,  # 'D'
     69: 146,  # 'E'
     70: 147,  # 'F'
     71: 148,  # 'G'
     72: 149,  # 'H'
     73: 150,  # 'I'
     74: 151,  # 'J'
     75: 152,  # 'K'
     76: 74,  # 'L'
     77: 153,  # 'M'
     78: 75,  # 'N'
     79: 154,  # 'O'
     80: 155,  # 'P'
     81: 156,  # 'Q'
     82: 157,  # 'R'
     83: 158,  # 'S'
     84: 159,  # 'T'
     85: 160,  # 'U'
     86: 161,  # 'V'
     87: 162,  # 'W'
     88: 163,  # 'X'
     89: 164,  # 'Y'
     90: 165,  # 'Z'
     91: 253,  # '['
     92: 253,  # '\\'
     93: 253,  # ']'
     94: 253,  # '^'
     95: 253,  # '_'
     96: 253,  # '`'
     97: 71,  # 'a'
     98: 172,  # 'b'
     99: 66,  # 'c'
     100: 173,  # 'd'
     101: 65,  # 'e'
     102: 174,  # 'f'
     103: 76,  # 'g'
     104: 175,  # 'h'
     105: 64,  # 'i'
     106: 176,  # 'j'
     107: 177,  # 'k'
     108: 77,  # 'l'
     109: 72,  # 'm'
     110: 178,  # 'n'
     111: 69,  # 'o'
     112: 67,  # 'p'
     113: 179,  # 'q'
     114: 78,  # 'r'
     115: 73,  # 's'
     116: 180,  # 't'
     117: 181,  # 'u'
     118: 79,  # 'v'
     119: 182,  # 'w'
     120: 183,  # 'x'
     121: 184,  # 'y'
     122: 185,  # 'z'
     123: 253,  # '{'
     124: 253,  # '|'
     125: 253,  # '}'
     126: 253,  # '~'
     127: 253,  # '\x7f'
     128: 191,  # '\x80'
     129: 192,  # '\x81'
     130: 193,  # '\x82'
     131: 194,  # '\x83'
     132: 195,  # '\x84'
     133: 196,  # '\x85'
     134: 197,  # '\x86'
     135: 198,  # '\x87'
     136: 199,  # '\x88'
     137: 200,  # '\x89'
     138: 201,  # '\x8a'
     139: 202,  # '\x8b'
     140: 203,  # '\x8c'
     141: 204,  # '\x8d'
     142: 205,  # '\x8e'
     143: 206,  # '\x8f'
     144: 207,  # '\x90'
     145: 208,  # '\x91'
     146: 209,  # '\x92'
     147: 210,  # '\x93'
     148: 211,  # '\x94'
     149: 212,  # '\x95'
     150: 213,  # '\x96'
     151: 214,  # '\x97'
     152: 215,  # '\x98'
     153: 216,  # '\x99'
     154: 217,  # '\x9a'
     155: 218,  # '\x9b'
     156: 219,  # '\x9c'
     157: 220,  # '\x9d'
     158: 221,  # '\x9e'
     159: 222,  # '\x9f'
     160: 223,  # '\xa0'
     161: 224,  # 'Ё'
     162: 225,  # 'Ђ'
     163: 226,  # 'Ѓ'
     164: 227,  # 'Є'
     165: 228,  # 'Ѕ'
     166: 229,  # 'І'
     167: 230,  # 'Ї'
     168: 231,  # 'Ј'
     169: 232,  # 'Љ'
     170: 233,  # 'Њ'
     171: 234,  # 'Ћ'
     172: 235,  # 'Ќ'
     173: 236,  # '\xad'
     174: 237,  # 'Ў'
     175: 238,  # 'Џ'
     176: 37,  # 'А'
     177: 44,  # 'Б'
     178: 33,  # 'В'
     179: 46,  # 'Г'
     180: 41,  # 'Д'
     181: 48,  # 'Е'
     182: 56,  # 'Ж'
     183: 51,  # 'З'
     184: 42,  # 'И'
     185: 60,  # 'Й'
     186: 36,  # 'К'
     187: 49,  # 'Л'
     188: 38,  # 'М'
     189: 31,  # 'Н'
     190: 34,  # 'О'
     191: 35,  # 'П'
     192: 45,  # 'Р'
     193: 32,  # 'С'
     194: 40,  # 'Т'
     195: 52,  # 'У'
     196: 53,  # 'Ф'
     197: 55,  # 'Х'
     198: 58,  # 'Ц'
     199: 50,  # 'Ч'
     200: 57,  # 'Ш'
     201: 63,  # 'Щ'
     202: 70,  # 'Ъ'
     203: 62,  # 'Ы'
     204: 61,  # 'Ь'
     205: 47,  # 'Э'
     206: 59,  # 'Ю'
     207: 43,  # 'Я'
     208: 3,  # 'а'
     209: 21,  # 'б'
     210: 10,  # 'в'
     211: 19,  # 'г'
     212: 13,  # 'д'
     213: 2,  # 'е'
     214: 24,  # 'ж'
     215: 20,  # 'з'
     216: 4,  # 'и'
     217: 23,  # 'й'
     218: 11,  # 'к'
     219: 8,  # 'л'
     220: 12,  # 'м'
     221: 5,  # 'н'
     222: 1,  # 'о'
     223: 15,  # 'п'
     224: 9,  # 'р'
     225: 7,  # 'с'
     226: 6,  # 'т'
     227: 14,  # 'у'
     228: 39,  # 'ф'
     229: 26,  # 'х'
     230: 28,  # 'ц'
     231: 22,  # 'ч'
     232: 25,  # 'ш'
     233: 29,  # 'щ'
     234: 54,  # 'ъ'
     235: 18,  # 'ы'
     236: 17,  # 'ь'
     237: 30,  # 'э'
     238: 27,  # 'ю'
     239: 16,  # 'я'
     240: 239,  # '№'
     241: 68,  # 'ё'
     242: 240,  # 'ђ'
     243: 241,  # 'ѓ'
     244: 242,  # 'є'
     245: 243,  # 'ѕ'
     246: 244,  # 'і'
     247: 245,  # 'ї'
     248: 246,  # 'ј'
     249: 247,  # 'љ'
     250: 248,  # 'њ'
     251: 249,  # 'ћ'
     252: 250,  # 'ќ'
     253: 251,  # '§'
     254: 252,  # 'ў'
     255: 255,  # 'џ'
}

ISO_8859_5_RUSSIAN_MODEL = SingleByteCharSetModel(charset_name='ISO-8859-5',
                                                  language='Russian',
                                                  char_to_order_map=ISO_8859_5_RUSSIAN_CHAR_TO_ORDER,
                                                  language_model=RUSSIAN_LANG_MODEL,
                                                  typical_positive_ratio=0.976601,
                                                  keep_ascii_letters=False,
                                                  alphabet='ЁАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяё')

