/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.TemplateService;

public final class RemoveProcessor
extends AbstractProcessor {
    public static final String TYPE = "remove";
    private final List<TemplateService.Template> fields;

    RemoveProcessor(String tag, List<TemplateService.Template> fields) {
        super(tag);
        this.fields = new ArrayList<TemplateService.Template>(fields);
    }

    public List<TemplateService.Template> getFields() {
        return this.fields;
    }

    public void execute(IngestDocument document) {
        this.fields.forEach(arg_0 -> ((IngestDocument)document).removeField(arg_0));
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final TemplateService templateService;

        public Factory(TemplateService templateService) {
            this.templateService = templateService;
        }

        public RemoveProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            ArrayList<String> fields = new ArrayList<String>();
            Object field = ConfigurationUtils.readObject((String)RemoveProcessor.TYPE, (String)processorTag, config, (String)"field");
            if (field instanceof List) {
                fields.addAll((List)field);
            } else {
                fields.add((String)field);
            }
            List<TemplateService.Template> compiledTemplates = fields.stream().map(f -> ConfigurationUtils.compileTemplate((String)RemoveProcessor.TYPE, (String)processorTag, (String)"field", (String)f, (TemplateService)this.templateService)).collect(Collectors.toList());
            return new RemoveProcessor(processorTag, compiledTemplates);
        }
    }
}

