/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.sig;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DHParameters
extends AlgorithmParametersSpi {
    private BigInteger p;
    private BigInteger g;
    private BigInteger q;
    private int l;

    protected void engineInit(AlgorithmParameterSpec spec) throws InvalidParameterSpecException {
        if (!(spec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("Wrong AlgorithmParameterSpec type: " + spec.getClass().getName());
        }
        DHParameterSpec dhSpec = (DHParameterSpec)spec;
        this.p = dhSpec.getP();
        this.g = dhSpec.getG();
        this.l = dhSpec.getL();
    }

    protected void engineInit(byte[] params) throws IOException {
        DERReader der = new DERReader(params);
        DERValue derParams = der.read();
        DerUtil.checkIsConstructed(derParams, "Wrong DH Parameters field");
        DERValue val = der.read();
        DerUtil.checkIsBigInteger(val, "Wrong P field");
        this.p = (BigInteger)val.getValue();
        val = der.read();
        DerUtil.checkIsBigInteger(val, "Wrong G field");
        this.g = (BigInteger)val.getValue();
        val = der.read();
        DerUtil.checkIsBigInteger(val, "Wrong Q field");
        this.q = (BigInteger)val.getValue();
        this.l = this.q.bitLength();
    }

    protected void engineInit(byte[] params, String format) throws IOException {
        if (format != null) {
            if ((format = format.trim()).length() == 0) {
                throw new IOException("Format MUST NOT be an empty string");
            }
            if (!format.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown or unsupported format: " + format);
            }
        }
        this.engineInit(params);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec.isAssignableFrom(DHParameterSpec.class)) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        if (paramSpec.isAssignableFrom(DHGenParameterSpec.class)) {
            return new DHGenParameterSpec(this.p.bitLength(), this.l);
        }
        throw new InvalidParameterSpecException("Wrong AlgorithmParameterSpec type: " + paramSpec.getName());
    }

    protected byte[] engineGetEncoded() throws IOException {
        DERValue derP = new DERValue(2, this.p);
        DERValue derG = new DERValue(2, this.g);
        DERValue derQ = new DERValue(2, this.q);
        ArrayList<DERValue> params = new ArrayList<DERValue>(3);
        params.add(derP);
        params.add(derG);
        params.add(derQ);
        DERValue derParams = new DERValue(48, params);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DERWriter.write(baos, derParams);
        byte[] result = baos.toByteArray();
        return result;
    }

    protected byte[] engineGetEncoded(String format) throws IOException {
        if (format != null) {
            if ((format = format.trim()).length() == 0) {
                throw new IOException("Format MUST NOT be an empty string");
            }
            if (!format.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown or unsupported format: " + format);
            }
        }
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        CPStringBuilder sb = new CPStringBuilder("p=");
        if (this.p == null) {
            sb.append("???");
        } else {
            sb.append("0x").append(this.p.toString(16));
        }
        sb.append(", g=");
        if (this.g == null) {
            sb.append("???");
        } else {
            sb.append("0x").append(this.g.toString(16));
        }
        sb.append(", q=");
        if (this.q == null) {
            sb.append("???");
        } else {
            sb.append("0x").append(this.q.toString(16));
        }
        sb.append(", l=").append(this.l);
        return sb.toString();
    }
}

