/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.geom.AffineTransform;

public class FontRenderContext {
    private AffineTransform affineTransform;
    private boolean isAntiAliased;
    private boolean usesFractionalMetrics;

    protected FontRenderContext() {
    }

    public FontRenderContext(AffineTransform tx, boolean isAntiAliased, boolean usesFractionalMetrics) {
        if (tx != null && !tx.isIdentity()) {
            this.affineTransform = new AffineTransform(tx);
        }
        this.isAntiAliased = isAntiAliased;
        this.usesFractionalMetrics = usesFractionalMetrics;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FontRenderContext)) {
            return false;
        }
        return this.equals((FontRenderContext)obj);
    }

    public boolean equals(FontRenderContext rhs) {
        if (rhs == null) {
            return false;
        }
        if (this.affineTransform == null && rhs.affineTransform != null || this.affineTransform != null && rhs.affineTransform == null) {
            return false;
        }
        return (this.affineTransform == rhs.affineTransform || this.affineTransform.equals(rhs.getTransform())) && this.isAntiAliased == rhs.isAntiAliased() && this.usesFractionalMetrics == rhs.usesFractionalMetrics();
    }

    public AffineTransform getTransform() {
        if (this.affineTransform == null) {
            return new AffineTransform();
        }
        return new AffineTransform(this.affineTransform);
    }

    public int hashCode() {
        int code = (this.isAntiAliased ? 1 : 0) + (this.usesFractionalMetrics ? 2 : 0);
        if (this.affineTransform != null && !this.affineTransform.isIdentity()) {
            code ^= this.affineTransform.hashCode();
        }
        return code;
    }

    public boolean isAntiAliased() {
        return this.isAntiAliased;
    }

    public boolean usesFractionalMetrics() {
        return this.usesFractionalMetrics;
    }
}

