/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import gnu.java.lang.reflect.MethodSignatureParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Constructor<T>
extends AccessibleObject
implements Member,
GenericDeclaration {
    private static final int CONSTRUCTOR_MODIFIERS = 7;
    private Class<T> declaringClass;
    private Class[] exception_types;
    private Class[] parameter_types;
    private int offset;

    private Constructor() {
    }

    public Class<T> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        return this.declaringClass.getName();
    }

    private native int getModifiersInternal();

    @Override
    public int getModifiers() {
        return this.getModifiersInternal() & 7;
    }

    @Override
    public boolean isSynthetic() {
        return (this.getModifiersInternal() & 0x1000) != 0;
    }

    public boolean isVarArgs() {
        return (this.getModifiersInternal() & 0x80) != 0;
    }

    public Class<?>[] getParameterTypes() {
        if (this.parameter_types == null) {
            this.getType();
        }
        return (Class[])this.parameter_types.clone();
    }

    public Class<?>[] getExceptionTypes() {
        if (this.exception_types == null) {
            this.getType();
        }
        return (Class[])this.exception_types.clone();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Constructor)) {
            return false;
        }
        Constructor c = (Constructor)obj;
        return this.declaringClass == c.declaringClass && this.offset == c.offset;
    }

    public int hashCode() {
        return this.declaringClass.getName().hashCode();
    }

    public String toString() {
        if (this.parameter_types == null) {
            this.getType();
        }
        StringBuffer b = new StringBuffer();
        int mods = this.getModifiers();
        if (mods != 0) {
            Modifier.toString(mods, b);
            b.append(" ");
        }
        Method.appendClassName(b, this.declaringClass);
        b.append("(");
        int i = 0;
        while (i < this.parameter_types.length) {
            Method.appendClassName(b, this.parameter_types[i]);
            if (i < this.parameter_types.length - 1) {
                b.append(",");
            }
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    static <X extends GenericDeclaration> void addTypeParameters(StringBuilder sb, TypeVariable<X>[] typeArgs) {
        if (typeArgs.length == 0) {
            return;
        }
        sb.append('<');
        int i = 0;
        while (i < typeArgs.length) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(typeArgs[i]);
            ++i;
        }
        sb.append("> ");
    }

    public String toGenericString() {
        int i;
        StringBuilder sb = new StringBuilder(128);
        Modifier.toString(this.getModifiers(), sb).append(' ');
        Constructor.addTypeParameters(sb, this.getTypeParameters());
        sb.append(this.getDeclaringClass().getName()).append('(');
        Type[] types = this.getGenericParameterTypes();
        if (types.length > 0) {
            sb.append(types[0]);
            i = 1;
            while (i < types.length) {
                sb.append(',').append(types[i]);
                ++i;
            }
        }
        sb.append(')');
        types = this.getGenericExceptionTypes();
        if (types.length > 0) {
            sb.append(" throws ").append(types[0]);
            i = 1;
            while (i < types.length) {
                sb.append(',').append(types[i]);
                ++i;
            }
        }
        return sb.toString();
    }

    public native T newInstance(Object ... var1) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public TypeVariable<Constructor<T>>[] getTypeParameters() {
        String sig = this.getSignature();
        if (sig == null) {
            return new TypeVariable[0];
        }
        MethodSignatureParser p = new MethodSignatureParser(this, sig);
        return p.getTypeParameters();
    }

    private native String getSignature();

    public Type[] getGenericExceptionTypes() {
        String sig = this.getSignature();
        if (sig == null) {
            return this.getExceptionTypes();
        }
        MethodSignatureParser p = new MethodSignatureParser(this, sig);
        return p.getGenericExceptionTypes();
    }

    public Type[] getGenericParameterTypes() {
        String sig = this.getSignature();
        if (sig == null) {
            return this.getParameterTypes();
        }
        MethodSignatureParser p = new MethodSignatureParser(this, sig);
        return p.getGenericParameterTypes();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annoClass) {
        Annotation[] annos = this.getDeclaredAnnotations();
        int i = 0;
        while (i < annos.length) {
            if (annos[i].annotationType() == annoClass) {
                return (T)annos[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Annotation[] result = this.getDeclaredAnnotationsInternal();
        if (result == null) {
            result = new Annotation[]{};
        }
        return result;
    }

    public Annotation[][] getParameterAnnotations() {
        Annotation[][] result = this.getParameterAnnotationsInternal();
        if (result == null) {
            result = new Annotation[0][0];
        }
        return result;
    }

    private native Annotation[] getDeclaredAnnotationsInternal();

    private native Annotation[][] getParameterAnnotationsInternal();

    private native void getType();
}

