/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AttributeNotFoundException;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.ReflectionException;
import javax.management.StringValueExp;
import javax.management.ValueExp;

public class AttributeValueExp
implements ValueExp {
    private static final long serialVersionUID = -7768025046539163385L;
    private String attr;

    @Deprecated
    public AttributeValueExp() {
    }

    public AttributeValueExp(String attr) {
        this.attr = attr;
    }

    public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        Object val = this.getAttribute(name);
        if (val == null || !(val instanceof String)) {
            throw new BadAttributeValueExpException(val);
        }
        return new StringValueExp((String)val);
    }

    protected Object getAttribute(ObjectName name) {
        try {
            return QueryEval.getMBeanServer().getAttribute(name, this.attr);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (MBeanException mBeanException) {
            return null;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return null;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return null;
        }
        catch (ReflectionException reflectionException) {
            return null;
        }
    }

    public String getAttributeName() {
        return this.attr;
    }

    public void setMBeanServer(MBeanServer server) {
    }

    public String toString() {
        return "'" + this.attr + "'";
    }
}

