/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

class PLPInputStream
extends InputStream {
    private final long PLP_NULL = -1L;
    private final long UNKNOWN_PLP_LEN = -2L;
    private final int PLP_TERMINATOR = 0;
    private final int PLP_HEADER_BYTES = 8;
    private final int PLP_CHUNK_BYTES = 4;
    final int XML_BOM_BYTES = 2;
    private final int PLP_EOS = -1;
    private final int MARK_UNDEFINED = -2;
    private byte[] tdsBuffer;
    private long headerPLP;
    private int startOffset;
    private int chunkOffset;
    private int chunkLength;
    private int chunkPos;
    int totalLength;
    private int tdsBufferUsed;
    private int maxChunkSize;
    private int markChunkOffset = -2;
    private int markChunkPos;
    private int markChunkLength;
    private SQLServerResultSet parentRS = null;
    private SQLServerCallableStatement parentCS = null;
    private int accessCounter;

    PLPInputStream(byte[] byArray, int n) throws IOException {
        this.tdsBuffer = byArray;
        this.startOffset = n;
        this.initialize();
    }

    void setParentResultSet(SQLServerResultSet sQLServerResultSet) {
        this.accessCounter = sQLServerResultSet.getAccessCounter();
        this.parentRS = sQLServerResultSet;
    }

    void setParentCallableStatement(SQLServerCallableStatement sQLServerCallableStatement) {
        this.accessCounter = sQLServerCallableStatement.getAccessCounter();
        this.parentCS = sQLServerCallableStatement;
    }

    private void initialize() throws IOException {
        this.headerPLP = Util.readLong(this.tdsBuffer, this.startOffset);
        this.tdsBufferUsed = 8;
        if (-1L == this.headerPLP) {
            this.chunkOffset = -1;
            this.totalLength = 0;
            return;
        }
        this.chunkOffset = this.startOffset + 8;
        this.tdsBufferUsed += 4;
        this.chunkLength = this.totalLength = Util.readInt(this.tdsBuffer, this.chunkOffset);
        if (this.chunkLength > 0) {
            this.maxChunkSize = this.chunkLength;
            while (this.moveToNextChunk()) {
                if (this.chunkLength > this.maxChunkSize) {
                    this.maxChunkSize = this.chunkLength;
                }
                this.tdsBufferUsed += 4;
                this.totalLength += this.chunkLength;
            }
            this.tdsBufferUsed += 4;
        }
        if (0 == this.totalLength) {
            this.chunkOffset = -1;
        } else {
            this.tdsBufferUsed += this.totalLength;
            this.chunkOffset = this.startOffset + 8;
            this.chunkPos = 0;
            this.chunkLength = Util.readInt(this.tdsBuffer, this.chunkOffset);
        }
    }

    private void moveToFirstChunk() {
        if (-1L != this.headerPLP && this.totalLength > 0) {
            this.chunkOffset = this.startOffset + 8;
            this.chunkPos = 0;
            this.chunkLength = Util.readInt(this.tdsBuffer, this.chunkOffset);
        }
    }

    private boolean moveToNextChunk() throws IOException {
        if (-1 == this.chunkOffset) {
            return false;
        }
        this.chunkOffset += this.chunkLength + 4;
        if (this.chunkOffset > this.tdsBuffer.length) {
            throw new IOException(SQLServerException.getErrString("R_invalidTDS"));
        }
        this.chunkLength = Util.readInt(this.tdsBuffer, this.chunkOffset);
        if (this.chunkOffset + this.chunkLength + 4 > this.tdsBuffer.length) {
            throw new IOException(SQLServerException.getErrString("R_invalidTDS"));
        }
        this.chunkPos = 0;
        if (0 == this.chunkLength) {
            this.chunkOffset = -1;
            return false;
        }
        return true;
    }

    void checkClosed() throws IOException {
        if (null == this.tdsBuffer) {
            throw new IOException(SQLServerException.getErrString("R_streamIsClosed"));
        }
        if (null != this.parentRS) {
            try {
                this.parentRS.checkClosed();
            }
            catch (SQLServerException sQLServerException) {
                throw new IOException(sQLServerException.getMessage());
            }
            if (this.parentRS.getAccessCounter() != this.accessCounter) {
                throw new IOException(SQLServerException.getErrString("R_streamClosedByRSAccess"));
            }
        }
        if (null != this.parentCS) {
            try {
                this.parentCS.checkClosed();
            }
            catch (SQLServerException sQLServerException) {
                throw new IOException(sQLServerException.getMessage());
            }
            if (this.parentCS.getAccessCounter() != this.accessCounter) {
                throw new IOException(SQLServerException.getErrString("R_streamClosedByCALLStmtAccess"));
            }
        }
    }

    int getDataLength() {
        return this.totalLength;
    }

    int getTDSBufferUsed() {
        return this.tdsBufferUsed;
    }

    boolean isNull() {
        return this.headerPLP == -1L;
    }

    String getString(String string, int n) throws UnsupportedEncodingException, IOException {
        this.checkClosed();
        if (this.isNull()) {
            return null;
        }
        if (0 == this.totalLength) {
            return "";
        }
        if (this.chunkLength == this.totalLength) {
            return new String(this.tdsBuffer, this.chunkOffset + 4, this.chunkLength, string);
        }
        char[] cArray = new char[this.maxChunkSize];
        InputStreamReader inputStreamReader = this.getCharacterStream(string);
        StringBuffer stringBuffer = new StringBuffer(n);
        while (inputStreamReader.ready()) {
            int n2 = inputStreamReader.read(cArray, 0, cArray.length);
            if (n2 <= 0) continue;
            stringBuffer.append(cArray, 0, n2);
        }
        return stringBuffer.toString();
    }

    InputStreamReader getCharacterStream(String string) throws UnsupportedEncodingException, IOException {
        this.checkClosed();
        this.reset();
        return new InputStreamReader((InputStream)this, string);
    }

    String getHexizedString() throws IOException, SQLServerException {
        StringBuffer stringBuffer = new StringBuffer(this.totalLength * 2);
        for (int i = 0; i < this.totalLength; ++i) {
            int n = this.read();
            if (-1 == n) {
                throw new SQLServerException(null, SQLServerException.getErrString("R_unexpectedEndOfStream"), null, 0, true);
            }
            stringBuffer.append(ParameterUtils.hex[(n &= 0xFF) >> 4]);
            stringBuffer.append(ParameterUtils.hex[n & 0xF]);
        }
        return stringBuffer.toString();
    }

    public long skip(long l) throws IOException {
        this.checkClosed();
        return this.readBytesInternal(null, 0, (int)l);
    }

    public int available() throws IOException {
        this.checkClosed();
        if (-1 != this.chunkOffset && -1L != this.headerPLP && this.totalLength > 0) {
            if (this.chunkPos == this.chunkLength) {
                this.moveToNextChunk();
            }
            if (-1 == this.chunkOffset) {
                return 0;
            }
            return this.chunkLength - this.chunkPos;
        }
        return 0;
    }

    public int read() throws IOException {
        this.checkClosed();
        if (-1 == this.chunkOffset) {
            return -1;
        }
        if (this.chunkPos < this.chunkLength) {
            int n = this.chunkOffset + this.chunkPos + 4;
            ++this.chunkPos;
            return this.tdsBuffer[n] & 0xFF;
        }
        if (this.moveToNextChunk()) {
            return this.read();
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException, NullPointerException {
        this.checkClosed();
        if (null == byArray) {
            throw new NullPointerException();
        }
        return this.readBytesInternal(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, NullPointerException {
        this.checkClosed();
        if (null == byArray) {
            throw new NullPointerException();
        }
        return this.readBytesInternal(byArray, n, n2);
    }

    int readBytesInternal(byte[] byArray, int n, int n2) throws IOException {
        if (-1 == this.chunkOffset) {
            return -1;
        }
        if (n2 <= 0 || n < 0) {
            return 0;
        }
        if (null != byArray) {
            if (n >= byArray.length) {
                return 0;
            }
            if (n + n2 > byArray.length) {
                n2 = byArray.length - n;
            }
        }
        int n3 = 0;
        if (this.chunkPos == this.chunkLength) {
            this.moveToNextChunk();
        }
        while (-1 != this.chunkOffset) {
            int n4;
            int n5 = this.chunkLength - this.chunkPos;
            if (n3 + n5 > n2) {
                n5 = n2 - n3;
            }
            if ((n4 = this.chunkOffset + this.chunkPos + 4) > this.tdsBuffer.length || n4 + n5 > this.tdsBuffer.length) {
                throw new IOException(SQLServerException.getErrString("R_invalidTDS"));
            }
            if (null != byArray) {
                System.arraycopy(this.tdsBuffer, n4, byArray, n + n3, n5);
            }
            this.chunkPos += n5;
            if (n2 == (n3 += n5)) {
                return n3;
            }
            if (this.chunkPos != this.chunkLength || this.moveToNextChunk()) continue;
            return n3;
        }
        return n3;
    }

    public void mark(int n) {
        this.markChunkOffset = this.chunkOffset;
        this.markChunkPos = this.chunkPos;
        this.markChunkLength = this.chunkLength;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        this.tdsBuffer = null;
        this.chunkOffset = -1;
        this.headerPLP = -1L;
        this.parentRS = null;
        this.parentCS = null;
    }

    public void reset() throws IOException {
        this.checkClosed();
        if (-2 == this.markChunkOffset) {
            this.moveToFirstChunk();
        } else {
            this.chunkOffset = this.markChunkOffset;
            this.chunkPos = this.markChunkPos;
            this.chunkLength = this.markChunkLength;
        }
    }
}

