/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSetIterator;

public abstract class XFilteredDocIdSetIterator
extends DocIdSetIterator {
    protected DocIdSetIterator _innerIter;
    private int doc;

    public XFilteredDocIdSetIterator(DocIdSetIterator innerIter) {
        if (innerIter == null) {
            throw new IllegalArgumentException("null iterator");
        }
        this._innerIter = innerIter;
        this.doc = -1;
    }

    public DocIdSetIterator getDelegate() {
        return this._innerIter;
    }

    protected abstract boolean match(int var1);

    public int docID() {
        return this.doc;
    }

    public int nextDoc() throws IOException {
        try {
            while ((this.doc = this._innerIter.nextDoc()) != Integer.MAX_VALUE) {
                if (!this.match(this.doc)) continue;
                return this.doc;
            }
        }
        catch (CollectionTerminatedException e) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        return this.doc;
    }

    public int advance(int target) throws IOException {
        this.doc = this._innerIter.advance(target);
        try {
            if (this.doc != Integer.MAX_VALUE) {
                if (this.match(this.doc)) {
                    return this.doc;
                }
                while ((this.doc = this._innerIter.nextDoc()) != Integer.MAX_VALUE) {
                    if (!this.match(this.doc)) continue;
                    return this.doc;
                }
                return this.doc;
            }
        }
        catch (CollectionTerminatedException e) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        return this.doc;
    }

    public long cost() {
        return this._innerIter.cost();
    }
}

