/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;

public final class RequestOptions {
    public static final RequestOptions DEFAULT = new Builder(Collections.emptyList(), HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory.DEFAULT).build();
    private final List<Header> headers;
    private final HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory;

    private RequestOptions(Builder builder) {
        this.headers = Collections.unmodifiableList(new ArrayList(builder.headers));
        this.httpAsyncResponseConsumerFactory = builder.httpAsyncResponseConsumerFactory;
    }

    public Builder toBuilder() {
        return new Builder(this.headers, this.httpAsyncResponseConsumerFactory);
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public HttpAsyncResponseConsumerFactory getHttpAsyncResponseConsumerFactory() {
        return this.httpAsyncResponseConsumerFactory;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RequestOptions{");
        if (this.headers.size() > 0) {
            b.append(", headers=");
            for (int h = 0; h < this.headers.size(); ++h) {
                if (h != 0) {
                    b.append(',');
                }
                b.append(this.headers.get(h).toString());
            }
        }
        if (this.httpAsyncResponseConsumerFactory != HttpAsyncResponseConsumerFactory.DEFAULT) {
            b.append(", consumerFactory=").append(this.httpAsyncResponseConsumerFactory);
        }
        return b.append('}').toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RequestOptions other = (RequestOptions)obj;
        return this.headers.equals(other.headers) && this.httpAsyncResponseConsumerFactory.equals(other.httpAsyncResponseConsumerFactory);
    }

    public int hashCode() {
        return Objects.hash(this.headers, this.httpAsyncResponseConsumerFactory);
    }

    static final class ReqHeader
    extends BasicHeader {
        ReqHeader(String name, String value) {
            super(name, value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ReqHeader) {
                Header otherHeader = (Header)other;
                return Objects.equals(this.getName(), otherHeader.getName()) && Objects.equals(this.getValue(), otherHeader.getValue());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getValue());
        }
    }

    public static class Builder {
        private final List<Header> headers;
        private HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory;

        private Builder(List<Header> headers, HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory) {
            this.headers = new ArrayList<Header>(headers);
            this.httpAsyncResponseConsumerFactory = httpAsyncResponseConsumerFactory;
        }

        public RequestOptions build() {
            return new RequestOptions(this);
        }

        public void addHeader(String name, String value) {
            Objects.requireNonNull(name, "header name cannot be null");
            Objects.requireNonNull(value, "header value cannot be null");
            this.headers.add((Header)new ReqHeader(name, value));
        }

        public void setHttpAsyncResponseConsumerFactory(HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory) {
            this.httpAsyncResponseConsumerFactory = Objects.requireNonNull(httpAsyncResponseConsumerFactory, "httpAsyncResponseConsumerFactory cannot be null");
        }
    }
}

