/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.doclets;

import com.sun.javadoc.PackageDoc;
import gnu.classpath.tools.doclets.InvalidPackageWildcardException;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageMatcher {
    private Set<Pattern> patterns = new HashSet<Pattern>();

    public void addWildcard(String wildcard) throws InvalidPackageWildcardException {
        int state = 0;
        char[] wildcardChars = wildcard.toCharArray();
        StringBuffer regexString = new StringBuffer();
        int i = 0;
        while (i < wildcardChars.length) {
            char c = wildcardChars[i];
            switch (state) {
                case 0: {
                    if ('*' == c) {
                        regexString.append(".*");
                    } else if (Character.isJavaIdentifierStart(c)) {
                        regexString.append(c);
                    } else {
                        throw new InvalidPackageWildcardException(wildcard);
                    }
                    state = 1;
                    break;
                }
                case 1: {
                    if ('.' == c) {
                        regexString.append("\\.");
                        state = 0;
                        break;
                    }
                    if ('*' == c) {
                        regexString.append(".*");
                        break;
                    }
                    if (Character.isJavaIdentifierPart(c)) {
                        regexString.append(c);
                        break;
                    }
                    throw new InvalidPackageWildcardException(wildcard);
                }
            }
            ++i;
        }
        if (state == 0) {
            throw new InvalidPackageWildcardException(wildcard);
        }
        this.patterns.add(Pattern.compile(regexString.toString()));
    }

    public SortedSet<PackageDoc> filter(PackageDoc[] packageDocs) {
        TreeSet<PackageDoc> result = new TreeSet<PackageDoc>();
        int i = 0;
        while (i < packageDocs.length) {
            if (this.match(packageDocs[i])) {
                result.add(packageDocs[i]);
            }
            ++i;
        }
        return result;
    }

    public boolean match(PackageDoc packageDoc) {
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(packageDoc.name());
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "PackageMatcher{patterns=" + this.patterns + "}";
    }
}

