/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.x500;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.security.auth.Destroyable;

public final class X500PrivateCredential
implements Destroyable {
    private PrivateKey key;
    private X509Certificate certificate;
    private String alias;

    public X500PrivateCredential(X509Certificate certificate, PrivateKey key) {
        if (certificate == null || key == null) {
            throw new IllegalArgumentException();
        }
        this.certificate = certificate;
        this.key = key;
    }

    public X500PrivateCredential(X509Certificate certificate, PrivateKey key, String alias) {
        this(certificate, key);
        if (alias == null) {
            throw new IllegalArgumentException();
        }
        this.alias = alias;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }

    public String getAlias() {
        return this.alias;
    }

    public void destroy() {
        this.certificate = null;
        this.key = null;
        this.alias = null;
    }

    public boolean isDestroyed() {
        return this.certificate == null && this.key == null;
    }
}

