/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.core.codegen.CodeWriter;
import jadx.core.utils.files.FileUtils;
import jadx.core.utils.files.ZipSecurity;
import jadx.core.xmlgen.ResContainer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesSaver
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesSaver.class);
    private final ResourceFile resourceFile;
    private File outDir;

    public ResourcesSaver(File outDir, ResourceFile resourceFile) {
        this.resourceFile = resourceFile;
        this.outDir = outDir;
    }

    @Override
    public void run() {
        if (!ResourceType.isSupportedForUnpack(this.resourceFile.getType())) {
            return;
        }
        ResContainer rc = this.resourceFile.loadContent();
        if (rc != null) {
            this.saveResources(rc);
        }
    }

    private void saveResources(ResContainer rc) {
        if (rc == null) {
            return;
        }
        List<ResContainer> subFiles = rc.getSubFiles();
        if (subFiles.isEmpty()) {
            this.save(rc, this.outDir);
        } else {
            this.saveToFile(rc, new File(this.outDir, "res/values/public.xml"));
            for (ResContainer subFile : subFiles) {
                this.saveResources(subFile);
            }
        }
    }

    private void save(ResContainer rc, File outDir) {
        File outFile = new File(outDir, rc.getFileName());
        BufferedImage image = rc.getImage();
        if (image != null) {
            String ext = FilenameUtils.getExtension((String)outFile.getName());
            try {
                outFile = FileUtils.prepareFile(outFile);
                if (!ZipSecurity.isInSubDirectory(outDir, outFile)) {
                    LOG.error("Path traversal attack detected, invalid resource name: {}", (Object)outFile.getPath());
                    return;
                }
                ImageIO.write((RenderedImage)image, ext, outFile);
            }
            catch (IOException e) {
                LOG.error("Failed to save image: {}", (Object)rc.getName(), (Object)e);
            }
            return;
        }
        if (!ZipSecurity.isInSubDirectory(outDir, outFile)) {
            LOG.error("Path traversal attack detected, invalid resource name: {}", (Object)rc.getFileName());
            return;
        }
        this.saveToFile(rc, outFile);
    }

    private void saveToFile(ResContainer rc, File outFile) {
        CodeWriter cw = rc.getContent();
        if (cw != null) {
            cw.save(outFile);
            return;
        }
        LOG.warn("Resource '{}' not saved, unknown type", (Object)rc.getName());
    }
}

