/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.EncryptedPrivateKeyInfo;
import com.sun.crypto.provider.KeyProtector;
import com.sun.crypto.provider.SealedObjectForKeyProtector;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.crypto.SealedObject;
import sun.misc.ObjectInputFilter;

public final class JceKeyStore
extends KeyStoreSpi {
    private static final int JCEKS_MAGIC = -825307442;
    private static final int JKS_MAGIC = -17957139;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private Hashtable<String, Object> entries = new Hashtable();

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Key key = null;
        Object object = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (!(object instanceof PrivateKeyEntry) && !(object instanceof SecretKeyEntry)) {
            return null;
        }
        KeyProtector keyProtector = new KeyProtector(cArray);
        if (object instanceof PrivateKeyEntry) {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
            byte[] byArray = ((PrivateKeyEntry)object).protectedKey;
            try {
                encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
            }
            catch (IOException iOException) {
                throw new UnrecoverableKeyException("Private key not stored as PKCS #8 EncryptedPrivateKeyInfo");
            }
            key = keyProtector.recover(encryptedPrivateKeyInfo);
        } else {
            key = keyProtector.unseal(((SecretKeyEntry)object).sealedKey);
        }
        return key;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        Certificate[] certificateArray = null;
        Object object = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (object instanceof PrivateKeyEntry && ((PrivateKeyEntry)object).chain != null) {
            certificateArray = (Certificate[])((PrivateKeyEntry)object).chain.clone();
        }
        return certificateArray;
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        Certificate certificate = null;
        Object object = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (object != null) {
            if (object instanceof TrustedCertEntry) {
                certificate = ((TrustedCertEntry)object).cert;
            } else if (object instanceof PrivateKeyEntry && ((PrivateKeyEntry)object).chain != null) {
                certificate = ((PrivateKeyEntry)object).chain[0];
            }
        }
        return certificate;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        Date date = null;
        Object object = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (object != null) {
            date = object instanceof TrustedCertEntry ? new Date(((TrustedCertEntry)object).date.getTime()) : (object instanceof PrivateKeyEntry ? new Date(((PrivateKeyEntry)object).date.getTime()) : new Date(((SecretKeyEntry)object).date.getTime()));
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            try {
                KeyProtector keyProtector = new KeyProtector(cArray);
                if (key instanceof PrivateKey) {
                    PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry();
                    privateKeyEntry.date = new Date();
                    privateKeyEntry.protectedKey = keyProtector.protect((PrivateKey)key);
                    privateKeyEntry.chain = certificateArray != null && certificateArray.length != 0 ? (Certificate[])certificateArray.clone() : null;
                    this.entries.put(string.toLowerCase(Locale.ENGLISH), privateKeyEntry);
                } else {
                    SecretKeyEntry secretKeyEntry = new SecretKeyEntry();
                    secretKeyEntry.date = new Date();
                    secretKeyEntry.sealedKey = keyProtector.seal(key);
                    this.entries.put(string.toLowerCase(Locale.ENGLISH), secretKeyEntry);
                }
            }
            catch (Exception exception) {
                throw new KeyStoreException(exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry();
            privateKeyEntry.date = new Date();
            privateKeyEntry.protectedKey = (byte[])byArray.clone();
            privateKeyEntry.chain = certificateArray != null && certificateArray.length != 0 ? (Certificate[])certificateArray.clone() : null;
            this.entries.put(string.toLowerCase(Locale.ENGLISH), privateKeyEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            Object object = this.entries.get(string.toLowerCase(Locale.ENGLISH));
            if (object != null) {
                if (object instanceof PrivateKeyEntry) {
                    throw new KeyStoreException("Cannot overwrite own certificate");
                }
                if (object instanceof SecretKeyEntry) {
                    throw new KeyStoreException("Cannot overwrite secret key");
                }
            }
            TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
            trustedCertEntry.cert = certificate;
            trustedCertEntry.date = new Date();
            this.entries.put(string.toLowerCase(Locale.ENGLISH), trustedCertEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            this.entries.remove(string.toLowerCase(Locale.ENGLISH));
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        boolean bl = false;
        Object object = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (object instanceof PrivateKeyEntry || object instanceof SecretKeyEntry) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        boolean bl = false;
        Object object = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (object instanceof TrustedCertEntry) {
            bl = true;
        }
        return bl;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration<String> enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = enumeration.nextElement();
            Object object = this.entries.get(string);
            if (object instanceof TrustedCertEntry) {
                certificate2 = ((TrustedCertEntry)object).cert;
            } else {
                if (!(object instanceof PrivateKeyEntry) || ((PrivateKeyEntry)object).chain == null) continue;
                certificate2 = ((PrivateKeyEntry)object).chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            if (cArray == null) {
                throw new IllegalArgumentException("password can't be null");
            }
            MessageDigest messageDigest = this.getPreKeyedHash(cArray);
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(outputStream, messageDigest));
            ObjectOutputStream objectOutputStream = null;
            try {
                Object object;
                dataOutputStream.writeInt(-825307442);
                dataOutputStream.writeInt(2);
                dataOutputStream.writeInt(this.entries.size());
                Enumeration<String> enumeration = this.entries.keys();
                while (enumeration.hasMoreElements()) {
                    byte[] byArray;
                    object = enumeration.nextElement();
                    Object object2 = this.entries.get(object);
                    if (object2 instanceof PrivateKeyEntry) {
                        PrivateKeyEntry privateKeyEntry = (PrivateKeyEntry)object2;
                        dataOutputStream.writeInt(1);
                        dataOutputStream.writeUTF((String)object);
                        dataOutputStream.writeLong(privateKeyEntry.date.getTime());
                        dataOutputStream.writeInt(privateKeyEntry.protectedKey.length);
                        dataOutputStream.write(privateKeyEntry.protectedKey);
                        int n = privateKeyEntry.chain == null ? 0 : privateKeyEntry.chain.length;
                        dataOutputStream.writeInt(n);
                        for (int i = 0; i < n; ++i) {
                            byArray = privateKeyEntry.chain[i].getEncoded();
                            dataOutputStream.writeUTF(privateKeyEntry.chain[i].getType());
                            dataOutputStream.writeInt(byArray.length);
                            dataOutputStream.write(byArray);
                        }
                        continue;
                    }
                    if (object2 instanceof TrustedCertEntry) {
                        dataOutputStream.writeInt(2);
                        dataOutputStream.writeUTF((String)object);
                        dataOutputStream.writeLong(((TrustedCertEntry)object2).date.getTime());
                        byArray = ((TrustedCertEntry)object2).cert.getEncoded();
                        dataOutputStream.writeUTF(((TrustedCertEntry)object2).cert.getType());
                        dataOutputStream.writeInt(byArray.length);
                        dataOutputStream.write(byArray);
                        continue;
                    }
                    dataOutputStream.writeInt(3);
                    dataOutputStream.writeUTF((String)object);
                    dataOutputStream.writeLong(((SecretKeyEntry)object2).date.getTime());
                    objectOutputStream = new ObjectOutputStream(dataOutputStream);
                    objectOutputStream.writeObject(((SecretKeyEntry)object2).sealedKey);
                }
                object = messageDigest.digest();
                dataOutputStream.write((byte[])object);
                dataOutputStream.flush();
            }
            finally {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                } else {
                    dataOutputStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            DataInputStream dataInputStream;
            MessageDigest messageDigest = null;
            CertificateFactory certificateFactory = null;
            Hashtable<String, CertificateFactory> hashtable2 = null;
            ByteArrayInputStream byteArrayInputStream = null;
            byte[] byArray = null;
            if (inputStream == null) {
                return;
            }
            if (cArray != null) {
                messageDigest = this.getPreKeyedHash(cArray);
                dataInputStream = new DataInputStream(new DigestInputStream(inputStream, messageDigest));
            } else {
                dataInputStream = new DataInputStream(inputStream);
            }
            ObjectInputStream objectInputStream = null;
            try {
                int n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                if (n != -825307442 && n != -17957139 || n2 != 1 && n2 != 2) {
                    throw new IOException("Invalid keystore format");
                }
                if (n2 == 1) {
                    certificateFactory = CertificateFactory.getInstance("X509");
                } else {
                    hashtable2 = new Hashtable<String, CertificateFactory>(3);
                }
                this.entries.clear();
                int n3 = dataInputStream.readInt();
                for (int i = 0; i < n3; ++i) {
                    String string;
                    Object object;
                    int n4 = dataInputStream.readInt();
                    if (n4 == 1) {
                        object = new PrivateKeyEntry();
                        string = dataInputStream.readUTF();
                        ((PrivateKeyEntry)object).date = new Date(dataInputStream.readLong());
                        try {
                            ((PrivateKeyEntry)object).protectedKey = new byte[dataInputStream.readInt()];
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            throw new IOException("Keysize too big");
                        }
                        dataInputStream.readFully(((PrivateKeyEntry)object).protectedKey);
                        int n5 = dataInputStream.readInt();
                        try {
                            if (n5 > 0) {
                                ((PrivateKeyEntry)object).chain = new Certificate[n5];
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            throw new IOException("Too many certificates in chain");
                        }
                        for (int j = 0; j < n5; ++j) {
                            if (n2 == 2) {
                                String string2 = dataInputStream.readUTF();
                                if (hashtable2.containsKey(string2)) {
                                    certificateFactory = (CertificateFactory)hashtable2.get(string2);
                                } else {
                                    certificateFactory = CertificateFactory.getInstance(string2);
                                    hashtable2.put(string2, certificateFactory);
                                }
                            }
                            try {
                                byArray = new byte[dataInputStream.readInt()];
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                                throw new IOException("Certificate too big");
                            }
                            dataInputStream.readFully(byArray);
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                            ((PrivateKeyEntry)object).chain[j] = certificateFactory.generateCertificate(byteArrayInputStream);
                        }
                        this.entries.put(string, object);
                        continue;
                    }
                    if (n4 == 2) {
                        object = new TrustedCertEntry();
                        string = dataInputStream.readUTF();
                        ((TrustedCertEntry)object).date = new Date(dataInputStream.readLong());
                        if (n2 == 2) {
                            String string3 = dataInputStream.readUTF();
                            if (hashtable2.containsKey(string3)) {
                                certificateFactory = (CertificateFactory)hashtable2.get(string3);
                            } else {
                                certificateFactory = CertificateFactory.getInstance(string3);
                                hashtable2.put(string3, certificateFactory);
                            }
                        }
                        try {
                            byArray = new byte[dataInputStream.readInt()];
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            throw new IOException("Certificate too big");
                        }
                        dataInputStream.readFully(byArray);
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        ((TrustedCertEntry)object).cert = certificateFactory.generateCertificate(byteArrayInputStream);
                        this.entries.put(string, object);
                        continue;
                    }
                    if (n4 == 3) {
                        object = new SecretKeyEntry();
                        string = dataInputStream.readUTF();
                        ((SecretKeyEntry)object).date = new Date(dataInputStream.readLong());
                        try {
                            ObjectInputStream objectInputStream2 = objectInputStream = new ObjectInputStream(dataInputStream);
                            AccessController.doPrivileged(() -> {
                                ObjectInputFilter.Config.setObjectInputFilter((ObjectInputStream)objectInputStream2, (ObjectInputFilter)new DeserializationChecker());
                                return null;
                            });
                            ((SecretKeyEntry)object).sealedKey = (SealedObject)objectInputStream.readObject();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new IOException(classNotFoundException.getMessage());
                        }
                        catch (InvalidClassException invalidClassException) {
                            throw new IOException("Invalid secret key format");
                        }
                        this.entries.put(string, object);
                        continue;
                    }
                    throw new IOException("Unrecognized keystore entry");
                }
                if (cArray != null) {
                    byte[] byArray2 = messageDigest.digest();
                    byte[] byArray3 = new byte[byArray2.length];
                    dataInputStream.readFully(byArray3);
                    for (int i = 0; i < byArray2.length; ++i) {
                        if (byArray2[i] == byArray3[i]) continue;
                        throw new IOException("Keystore was tampered with, or password was incorrect", new UnrecoverableKeyException("Password verification failed"));
                    }
                }
            }
            finally {
                if (objectInputStream != null) {
                    objectInputStream.close();
                } else {
                    dataInputStream.close();
                }
            }
        }
    }

    private MessageDigest getPreKeyedHash(char[] cArray) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        int n;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        byte[] byArray = new byte[cArray.length * 2];
        int n2 = 0;
        for (n = 0; n < cArray.length; ++n) {
            byArray[n2++] = (byte)(cArray[n] >> 8);
            byArray[n2++] = (byte)cArray[n];
        }
        messageDigest.update(byArray);
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = 0;
        }
        messageDigest.update("Mighty Aphrodite".getBytes("UTF8"));
        return messageDigest;
    }

    private static class DeserializationChecker
    implements ObjectInputFilter {
        private static final int MAX_NESTED_DEPTH = 2;

        private DeserializationChecker() {
        }

        public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
            long l = filterInfo.depth();
            if (l == 1L && filterInfo.serialClass() != SealedObjectForKeyProtector.class || l > 2L && filterInfo.serialClass() != null && filterInfo.serialClass() != Object.class) {
                return ObjectInputFilter.Status.REJECTED;
            }
            ObjectInputFilter objectInputFilter = ObjectInputFilter.Config.getSerialFilter();
            if (objectInputFilter != null) {
                return objectInputFilter.checkInput(filterInfo);
            }
            return ObjectInputFilter.Status.UNDECIDED;
        }
    }

    private static final class TrustedCertEntry {
        Date date;
        Certificate cert;

        private TrustedCertEntry() {
        }
    }

    private static final class SecretKeyEntry {
        Date date;
        SealedObject sealedKey;

        private SecretKeyEntry() {
        }
    }

    private static final class PrivateKeyEntry {
        Date date;
        byte[] protectedKey;
        Certificate[] chain;

        private PrivateKeyEntry() {
        }
    }
}

