'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiXYChartAxisUtils = exports.TITLE_POSITION = exports.ORIENTATION = undefined;

var _reactVis = require('react-vis');

/**
 * Axis orientation. Can be top, bottom, left, right.
 * See react-vis AxisUtils.ORIENTATION for docs.
 */
var ORIENTATION = exports.ORIENTATION = {
  TOP: _reactVis.AxisUtils.ORIENTATION.TOP,
  LEFT: _reactVis.AxisUtils.ORIENTATION.LEFT,
  RIGHT: _reactVis.AxisUtils.ORIENTATION.RIGHT,
  BOTTOM: _reactVis.AxisUtils.ORIENTATION.BOTTOM,
  HORIZONTAL: _reactVis.AxisUtils.ORIENTATION.HORIZONTAL,
  VERTICAL: _reactVis.AxisUtils.ORIENTATION.VERTICAL
};

/**
 * The title position along the axis.
 */
var TITLE_POSITION = exports.TITLE_POSITION = {
  MIDDLE: 'middle',
  START: 'start',
  END: 'end'
};

var EuiXYChartAxisUtils = exports.EuiXYChartAxisUtils = {
  TITLE_POSITION: TITLE_POSITION,
  ORIENTATION: ORIENTATION
};