"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** Constants and utilities for data type */
/** Data type based on level of measurement */
var Type;
(function (Type) {
    Type.QUANTITATIVE = 'quantitative';
    Type.ORDINAL = 'ordinal';
    Type.TEMPORAL = 'temporal';
    Type.NOMINAL = 'nominal';
    Type.LATITUDE = 'latitude';
    Type.LONGITUDE = 'longitude';
    Type.GEOJSON = 'geojson';
})(Type = exports.Type || (exports.Type = {}));
var TYPE_INDEX = {
    quantitative: 1,
    ordinal: 1,
    temporal: 1,
    nominal: 1,
    latitude: 1,
    longitude: 1,
    geojson: 1
};
function isType(t) {
    return !!TYPE_INDEX[t];
}
exports.isType = isType;
exports.QUANTITATIVE = Type.QUANTITATIVE;
exports.ORDINAL = Type.ORDINAL;
exports.TEMPORAL = Type.TEMPORAL;
exports.NOMINAL = Type.NOMINAL;
exports.GEOJSON = Type.GEOJSON;
/**
 * Get full, lowercase type name for a given type.
 * @param  type
 * @return Full type name.
 */
function getFullName(type) {
    if (type) {
        type = type.toLowerCase();
        switch (type) {
            case 'q':
            case exports.QUANTITATIVE:
                return 'quantitative';
            case 't':
            case exports.TEMPORAL:
                return 'temporal';
            case 'o':
            case exports.ORDINAL:
                return 'ordinal';
            case 'n':
            case exports.NOMINAL:
                return 'nominal';
            case Type.LATITUDE:
                return 'latitude';
            case Type.LONGITUDE:
                return 'longitude';
            case exports.GEOJSON:
                return 'geojson';
        }
    }
    // If we get invalid input, return undefined type.
    return undefined;
}
exports.getFullName = getFullName;
//# sourceMappingURL=data:application/json;base64,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