'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHorizontalRule = exports.MARGINS = exports.SIZES = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var sizeToClassNameMap = {
  full: 'euiHorizontalRule--full',
  half: 'euiHorizontalRule--half',
  quarter: 'euiHorizontalRule--quarter'
};

var SIZES = exports.SIZES = Object.keys(sizeToClassNameMap);

var marginToClassNameMap = {
  none: null,
  xs: 'euiHorizontalRule--marginXSmall',
  s: 'euiHorizontalRule--marginSmall',
  m: 'euiHorizontalRule--marginMedium',
  l: 'euiHorizontalRule--marginLarge',
  xl: 'euiHorizontalRule--marginXLarge',
  xxl: 'euiHorizontalRule--marginXXLarge'
};

var MARGINS = exports.MARGINS = Object.keys(marginToClassNameMap);

var EuiHorizontalRule = function EuiHorizontalRule(_ref) {
  var className = _ref.className,
      size = _ref.size,
      margin = _ref.margin,
      rest = _objectWithoutProperties(_ref, ['className', 'size', 'margin']);

  var classes = (0, _classnames2.default)('euiHorizontalRule', sizeToClassNameMap[size], marginToClassNameMap[margin], className);

  return _react2.default.createElement('hr', _extends({
    className: classes
  }, rest));
};

exports.EuiHorizontalRule = EuiHorizontalRule;
EuiHorizontalRule.propTypes = {
  children: _propTypes2.default.node,
  className: _propTypes2.default.string,
  size: _propTypes2.default.oneOf(SIZES),
  margin: _propTypes2.default.oneOf(MARGINS)
};

EuiHorizontalRule.defaultProps = {
  size: 'full',
  margin: 'l'
};
EuiHorizontalRule.__docgenInfo = [{
  'description': '',
  'methods': [],
  'props': {
    'children': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': ''
    },
    'className': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'size': {
      'type': {
        'name': 'enum',
        'value': [{
          'value': '"full"',
          'computed': false
        }, {
          'value': '"half"',
          'computed': false
        }, {
          'value': '"quarter"',
          'computed': false
        }]
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': '\'full\'',
        'computed': false
      }
    },
    'margin': {
      'type': {
        'name': 'enum',
        'value': [{
          'value': '"none"',
          'computed': false
        }, {
          'value': '"xs"',
          'computed': false
        }, {
          'value': '"s"',
          'computed': false
        }, {
          'value': '"m"',
          'computed': false
        }, {
          'value': '"l"',
          'computed': false
        }, {
          'value': '"xl"',
          'computed': false
        }, {
          'value': '"xxl"',
          'computed': false
        }]
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': '\'l\'',
        'computed': false
      }
    }
  }
}];