'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KuiColorPicker = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _reactColor = require('react-color');

var _outside_click_detector = require('../outside_click_detector');

var _color_picker_swatch = require('./color_picker_swatch');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * this work for additional information regarding copyright
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may obtain a copy of the License at
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * software distributed under the License is distributed on an
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * specific language governing permissions and limitations
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * under the License.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var KuiColorPicker = exports.KuiColorPicker = function (_React$Component) {
  _inherits(KuiColorPicker, _React$Component);

  function KuiColorPicker(props) {
    _classCallCheck(this, KuiColorPicker);

    var _this = _possibleConstructorReturn(this, (KuiColorPicker.__proto__ || Object.getPrototypeOf(KuiColorPicker)).call(this, props));

    _this.closeColorSelector = function () {
      _this.setState({ showColorSelector: false });
    };

    _this.toggleColorSelector = function () {
      _this.setState({ showColorSelector: !_this.state.showColorSelector });
    };

    _this.handleColorSelection = function (color) {
      _this.props.onChange(color.hex);
    };

    _this.state = {
      showColorSelector: false
    };
    return _this;
  }

  _createClass(KuiColorPicker, [{
    key: 'getColorLabel',
    value: function getColorLabel() {
      var color = this.props.color;

      var colorValue = color === null ? '(transparent)' : color;
      return _react2.default.createElement(
        'div',
        {
          className: 'kuiColorPicker__label',
          'aria-label': 'Color selection is ' + colorValue
        },
        colorValue
      );
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          color = _props.color,
          className = _props.className,
          showColorLabel = _props.showColorLabel;

      var classes = (0, _classnames2.default)('kuiColorPicker', className);
      return _react2.default.createElement(
        _outside_click_detector.KuiOutsideClickDetector,
        { onOutsideClick: this.closeColorSelector },
        _react2.default.createElement(
          'div',
          {
            className: classes,
            'data-test-subj': this.props['data-test-subj']
          },
          _react2.default.createElement(
            'div',
            {
              className: 'kuiColorPicker__preview',
              onClick: this.toggleColorSelector
            },
            _react2.default.createElement(_color_picker_swatch.KuiColorPickerSwatch, { color: color, 'aria-label': this.props['aria-label'] }),
            showColorLabel ? this.getColorLabel() : null
          ),
          this.state.showColorSelector ? _react2.default.createElement(
            'div',
            { className: 'kuiColorPickerPopUp', 'data-test-subj': 'colorPickerPopup' },
            _react2.default.createElement(_reactColor.ChromePicker, {
              color: color ? color : '#ffffff',
              disableAlpha: true,
              onChange: this.handleColorSelection
            })
          ) : null
        )
      );
    }
  }]);

  return KuiColorPicker;
}(_react2.default.Component);

KuiColorPicker.propTypes = {
  className: _propTypes2.default.string,
  color: _propTypes2.default.string,
  onChange: _propTypes2.default.func.isRequired,
  showColorLabel: _propTypes2.default.bool
};

KuiColorPicker.defaultProps = {
  'aria-label': 'Select a color',
  showColorLabel: true
};
