/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventprocessorhost.Checkpoint;
import com.microsoft.azure.eventprocessorhost.HostContext;
import com.microsoft.azure.eventprocessorhost.ICheckpointManager;
import com.microsoft.azure.eventprocessorhost.Lease;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryCheckpointManager
implements ICheckpointManager {
    private HostContext hostContext;
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(InMemoryCheckpointManager.class);

    public void initialize(HostContext hostContext) {
        this.hostContext = hostContext;
    }

    @Override
    public CompletableFuture<Boolean> checkpointStoreExists() {
        boolean exists = InMemoryCheckpointStore.singleton.existsMap();
        TRACE_LOGGER.debug(this.hostContext.withHost("checkpointStoreExists() " + exists));
        return CompletableFuture.completedFuture(exists);
    }

    @Override
    public CompletableFuture<Void> createCheckpointStoreIfNotExists() {
        TRACE_LOGGER.debug(this.hostContext.withHost("createCheckpointStoreIfNotExists()"));
        InMemoryCheckpointStore.singleton.initializeMap();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> deleteCheckpointStore() {
        TRACE_LOGGER.debug(this.hostContext.withHost("deleteCheckpointStore()"));
        InMemoryCheckpointStore.singleton.deleteMap();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Checkpoint> getCheckpoint(String partitionId) {
        Checkpoint returnCheckpoint = null;
        Checkpoint checkpointInStore = InMemoryCheckpointStore.singleton.getCheckpoint(partitionId);
        if (checkpointInStore == null) {
            TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(partitionId, "getCheckpoint() no existing Checkpoint"));
            returnCheckpoint = null;
        } else if (checkpointInStore.getSequenceNumber() == -1L) {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "getCheckpoint() uninitalized"));
            returnCheckpoint = null;
        } else {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "getCheckpoint() found " + checkpointInStore.getOffset() + "//" + checkpointInStore.getSequenceNumber()));
            returnCheckpoint = new Checkpoint(checkpointInStore);
        }
        return CompletableFuture.completedFuture(returnCheckpoint);
    }

    @Override
    public CompletableFuture<Checkpoint> createCheckpointIfNotExists(String partitionId) {
        Checkpoint checkpointInStore = InMemoryCheckpointStore.singleton.getCheckpoint(partitionId);
        Checkpoint returnCheckpoint = null;
        if (checkpointInStore != null) {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "createCheckpointIfNotExists() found existing checkpoint, OK"));
            returnCheckpoint = checkpointInStore.getSequenceNumber() != -1L ? new Checkpoint(checkpointInStore) : null;
        } else {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "createCheckpointIfNotExists() creating new checkpoint"));
            Checkpoint newStoreCheckpoint = new Checkpoint(partitionId);
            newStoreCheckpoint.setOffset(null);
            newStoreCheckpoint.setSequenceNumber(-1L);
            InMemoryCheckpointStore.singleton.setOrReplaceCheckpoint(newStoreCheckpoint);
            returnCheckpoint = null;
        }
        return CompletableFuture.completedFuture(returnCheckpoint);
    }

    @Override
    public CompletableFuture<Void> updateCheckpoint(Lease lease, Checkpoint checkpoint) {
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(checkpoint.getPartitionId(), "updateCheckpoint() " + checkpoint.getOffset() + "//" + checkpoint.getSequenceNumber()));
        Checkpoint checkpointInStore = InMemoryCheckpointStore.singleton.getCheckpoint(checkpoint.getPartitionId());
        if (checkpointInStore != null) {
            checkpointInStore.setOffset(checkpoint.getOffset());
            checkpointInStore.setSequenceNumber(checkpoint.getSequenceNumber());
        } else {
            TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(checkpoint.getPartitionId(), "updateCheckpoint() can't find checkpoint"));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> deleteCheckpoint(String partitionId) {
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "deleteCheckpoint()"));
        InMemoryCheckpointStore.singleton.removeCheckpoint(partitionId);
        return CompletableFuture.completedFuture(null);
    }

    private static class InMemoryCheckpointStore {
        static final InMemoryCheckpointStore singleton = new InMemoryCheckpointStore();
        private ConcurrentHashMap<String, Checkpoint> inMemoryCheckpointsPrivate = null;

        private InMemoryCheckpointStore() {
        }

        synchronized boolean existsMap() {
            return this.inMemoryCheckpointsPrivate != null;
        }

        synchronized void initializeMap() {
            if (this.inMemoryCheckpointsPrivate == null) {
                this.inMemoryCheckpointsPrivate = new ConcurrentHashMap();
            }
        }

        synchronized void deleteMap() {
            this.inMemoryCheckpointsPrivate = null;
        }

        synchronized Checkpoint getCheckpoint(String partitionId) {
            return this.inMemoryCheckpointsPrivate.get(partitionId);
        }

        synchronized void setOrReplaceCheckpoint(Checkpoint newCheckpoint) {
            this.inMemoryCheckpointsPrivate.put(newCheckpoint.getPartitionId(), newCheckpoint);
        }

        synchronized void removeCheckpoint(String partitionId) {
            this.inMemoryCheckpointsPrivate.remove(partitionId);
        }
    }
}

