/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.List;
import nokogiri.NokogiriService;
import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.internals.NokogiriHelpers;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JRubyClass(name={"Nokogiri::XML::NodeSet"})
public class XmlNodeSet
extends RubyObject
implements NodeList {
    RubyArray nodes;

    public XmlNodeSet(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static XmlNodeSet create(Ruby ruby) {
        return (XmlNodeSet)NokogiriService.XML_NODESET_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::NodeSet"));
    }

    public static XmlNodeSet newEmptyNodeSet(ThreadContext threadContext) {
        return XmlNodeSet.create(threadContext.getRuntime());
    }

    public static XmlNodeSet newXmlNodeSet(Ruby ruby, RubyArray rubyArray) {
        XmlNodeSet xmlNodeSet = XmlNodeSet.create(ruby);
        xmlNodeSet.setNodes(rubyArray);
        return xmlNodeSet;
    }

    static XmlNodeSet newXmlNodeSet(ThreadContext threadContext, RubyArray rubyArray) {
        return XmlNodeSet.newXmlNodeSet(threadContext.getRuntime(), rubyArray);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    void setNodes(RubyArray rubyArray) {
        this.nodes = rubyArray;
        IRubyObject iRubyObject = rubyArray.first();
        this.initialize(rubyArray.getRuntime(), iRubyObject);
    }

    private void setReference(XmlNodeSet xmlNodeSet) {
        this.nodes = null;
        IRubyObject iRubyObject = xmlNodeSet.nodes.first();
        this.initialize(xmlNodeSet.getRuntime(), iRubyObject);
    }

    public void setNodeList(NodeList nodeList) {
        this.setNodes(NokogiriHelpers.nodeListToRubyArray(this.getRuntime(), nodeList));
    }

    final void initialize(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlNode) {
            IRubyObject iRubyObject2 = ((XmlNode)iRubyObject).document(ruby);
            XmlNode.setDocumentAndDecorate(ruby.getCurrentContext(), this, iRubyObject2);
        }
    }

    public int length() {
        if (this.nodes == null) {
            return 0;
        }
        return this.nodes.size();
    }

    public void relink_namespace(ThreadContext threadContext) {
        List list = this.nodes.getList();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof XmlNode)) continue;
            ((XmlNode)((Object)list.get(i))).relink_namespace(threadContext);
        }
    }

    @JRubyMethod(name={"&"})
    public IRubyObject and(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.nodes == null) {
            this.setNodes(RubyArray.newEmptyArray((Ruby)threadContext.getRuntime()));
        }
        return XmlNodeSet.newXmlNodeSet(threadContext, (RubyArray)this.nodes.op_and((IRubyObject)XmlNodeSet.getNodes(threadContext, iRubyObject)));
    }

    @JRubyMethod
    public IRubyObject delete(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.nodes == null) {
            return threadContext.getRuntime().getNil();
        }
        if (iRubyObject instanceof XmlNamespace) {
            ((XmlNamespace)iRubyObject).deleteHref();
        }
        return this.nodes.delete(threadContext, XmlNodeSet.asXmlNodeOrNamespace(threadContext, iRubyObject), Block.NULL_BLOCK);
    }

    @JRubyMethod
    public IRubyObject dup(ThreadContext threadContext) {
        if (this.nodes == null) {
            return XmlNodeSet.newEmptyNodeSet(threadContext);
        }
        return XmlNodeSet.newXmlNodeSet(threadContext, this.nodes.aryDup());
    }

    @JRubyMethod(name={"include?"})
    public IRubyObject include_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        iRubyObject = XmlNodeSet.asXmlNodeOrNamespace(threadContext, iRubyObject);
        if (this.nodes == null) {
            return threadContext.getRuntime().getFalse();
        }
        return this.nodes.include_p(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length(ThreadContext threadContext) {
        return this.nodes != null ? this.nodes.length() : threadContext.getRuntime().newFixnum(0);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_diff(ThreadContext threadContext, IRubyObject iRubyObject) {
        XmlNodeSet xmlNodeSet = XmlNodeSet.newXmlNodeSet(threadContext, this);
        if (this.nodes == null) {
            this.setNodes(RubyArray.newEmptyArray((Ruby)threadContext.getRuntime()));
        }
        xmlNodeSet.setNodes((RubyArray)this.nodes.op_diff((IRubyObject)XmlNodeSet.getNodes(threadContext, iRubyObject)));
        return xmlNodeSet;
    }

    @JRubyMethod(name={"|", "+"})
    public IRubyObject op_or(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.nodes == null) {
            this.setNodes(RubyArray.newEmptyArray((Ruby)threadContext.getRuntime()));
        }
        return XmlNodeSet.newXmlNodeSet(threadContext, (RubyArray)this.nodes.op_or((IRubyObject)XmlNodeSet.getNodes(threadContext, iRubyObject)));
    }

    @JRubyMethod(name={"push", "<<"})
    public IRubyObject push(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.nodes == null) {
            this.setNodes(RubyArray.newArray((Ruby)threadContext.getRuntime()));
        }
        this.nodes.append(XmlNodeSet.asXmlNodeOrNamespace(threadContext, iRubyObject));
        return this;
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject slice(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.nodes == null) {
            return threadContext.getRuntime().getNil();
        }
        IRubyObject iRubyObject2 = this.nodes.aref19(iRubyObject);
        if (iRubyObject2 instanceof RubyArray) {
            return XmlNodeSet.newXmlNodeSet(threadContext, (RubyArray)iRubyObject2);
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject slice(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (this.nodes == null) {
            return threadContext.getRuntime().getNil();
        }
        IRubyObject iRubyObject3 = this.nodes.aref19(iRubyObject, iRubyObject2);
        if (iRubyObject3 instanceof RubyArray) {
            return XmlNodeSet.newXmlNodeSet(threadContext, (RubyArray)iRubyObject3);
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"to_a", "to_ary"})
    public IRubyObject to_a(ThreadContext threadContext) {
        return this.nodes;
    }

    @JRubyMethod(name={"unlink", "remove"})
    public IRubyObject unlink(ThreadContext threadContext) {
        if (this.nodes == null) {
            return this;
        }
        IRubyObject[] iRubyObjectArray = this.nodes.toJavaArrayUnsafe();
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            if (!(iRubyObjectArray[i] instanceof XmlNode)) continue;
            ((XmlNode)iRubyObjectArray[i]).unlink(threadContext);
        }
        return this;
    }

    private static XmlNodeSet newXmlNodeSet(ThreadContext threadContext, XmlNodeSet xmlNodeSet) {
        XmlNodeSet xmlNodeSet2 = XmlNodeSet.create(threadContext.getRuntime());
        xmlNodeSet2.setReference(xmlNodeSet);
        return xmlNodeSet2;
    }

    private static IRubyObject asXmlNodeOrNamespace(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlNode || iRubyObject instanceof XmlNamespace) {
            return iRubyObject;
        }
        throw threadContext.getRuntime().newArgumentError("node must be a Nokogiri::XML::Node or Nokogiri::XML::Namespace");
    }

    private static RubyArray getNodes(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlNodeSet) {
            RubyArray rubyArray = ((XmlNodeSet)iRubyObject).nodes;
            return rubyArray == null ? RubyArray.newEmptyArray((Ruby)threadContext.getRuntime()) : rubyArray;
        }
        throw threadContext.getRuntime().newArgumentError("node must be a Nokogiri::XML::NodeSet");
    }

    @Override
    public int getLength() {
        return this.nodes == null ? 0 : this.nodes.size();
    }

    @Override
    public Node item(int n) {
        if (this.nodes == null) {
            return null;
        }
        Object object = this.nodes.get(n);
        if (object instanceof XmlNode) {
            return ((XmlNode)((Object)object)).node;
        }
        if (object instanceof XmlNamespace) {
            return ((XmlNamespace)((Object)object)).getNode();
        }
        return null;
    }
}

