/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import nokogiri.XmlNode;
import nokogiri.XmlNodeSet;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriNamespaceContext;
import nokogiri.internals.NokogiriXPathFunctionResolver;
import nokogiri.internals.NokogiriXPathVariableResolver;
import nokogiri.internals.XalanDTMManagerPatch;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.jaxp.JAXPPrefixResolver;
import org.apache.xpath.jaxp.JAXPVariableStack;
import org.apache.xpath.objects.XObject;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SafePropertyAccessor;
import org.w3c.dom.Node;

@JRubyClass(name={"Nokogiri::XML::XPathContext"})
public class XmlXpathContext
extends RubyObject {
    public static final String XPATH_CONTEXT = "CACHED_XPATH_CONTEXT";
    private XmlNode context;
    private final NokogiriNamespaceContext nsContext = NokogiriNamespaceContext.create();
    private NokogiriXPathVariableResolver variableResolver;

    public XmlXpathContext(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public XmlXpathContext(Ruby ruby, RubyClass rubyClass, XmlNode xmlNode) {
        this(ruby, rubyClass);
        this.initNode(xmlNode);
    }

    private void initNode(XmlNode xmlNode) {
        this.context = xmlNode;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        try {
            return new XmlXpathContext(threadContext.runtime, (RubyClass)iRubyObject, (XmlNode)iRubyObject2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw threadContext.getRuntime().newRuntimeError(illegalArgumentException.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject evaluate(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject.convertToString().asJavaString();
        if (!iRubyObject2.isNil() && !this.isContainsPrefix(string)) {
            StringBuilder stringBuilder = new StringBuilder();
            Set set = iRubyObject2.getMetaClass().getMethods().keySet();
            for (String string2 : set) {
                stringBuilder.setLength(0);
                stringBuilder.ensureCapacity("nokogiri".length() + 1 + string2.length());
                stringBuilder.append("nokogiri").append(':').append(string2);
                string = string.replace(string2, stringBuilder);
            }
        }
        return this.node_set(threadContext, string, iRubyObject2);
    }

    @JRubyMethod
    public IRubyObject evaluate(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.evaluate(threadContext, iRubyObject, threadContext.getRuntime().getNil());
    }

    @JRubyMethod
    public IRubyObject register_ns(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.nsContext.registerNamespace(iRubyObject.asJavaString(), iRubyObject2.asJavaString());
        return this;
    }

    @JRubyMethod
    public IRubyObject register_variable(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        NokogiriXPathVariableResolver nokogiriXPathVariableResolver = this.variableResolver;
        if (nokogiriXPathVariableResolver == null) {
            this.variableResolver = nokogiriXPathVariableResolver = NokogiriXPathVariableResolver.create();
        }
        nokogiriXPathVariableResolver.registerVariable(iRubyObject.asJavaString(), iRubyObject2.asJavaString());
        return this;
    }

    private IRubyObject node_set(ThreadContext threadContext, String string, IRubyObject iRubyObject) {
        NokogiriXPathFunctionResolver nokogiriXPathFunctionResolver = iRubyObject.isNil() ? null : NokogiriXPathFunctionResolver.create(iRubyObject);
        try {
            return this.tryGetNodeSet(threadContext, string, nokogiriXPathFunctionResolver);
        }
        catch (TransformerException transformerException) {
            throw new RaiseException(XmlSyntaxError.createXMLXPathSyntaxError(threadContext.runtime, string, transformerException));
        }
    }

    private IRubyObject tryGetNodeSet(ThreadContext threadContext, String string, NokogiriXPathFunctionResolver nokogiriXPathFunctionResolver) throws TransformerException {
        Node node = this.context.node;
        JAXPPrefixResolver jAXPPrefixResolver = new JAXPPrefixResolver((NamespaceContext)this.nsContext);
        XPath xPath = new XPath(string, null, (PrefixResolver)jAXPPrefixResolver, 0);
        XObject xObject = node == null ? xPath.execute(this.getXPathContext(nokogiriXPathFunctionResolver), -1, (PrefixResolver)jAXPPrefixResolver) : xPath.execute(this.getXPathContext(nokogiriXPathFunctionResolver), node, (PrefixResolver)jAXPPrefixResolver);
        switch (xObject.getType()) {
            case 1: {
                return threadContext.getRuntime().newBoolean(xObject.bool());
            }
            case 2: {
                return threadContext.getRuntime().newFloat(xObject.num());
            }
            case 4: {
                XmlNodeSet xmlNodeSet = XmlNodeSet.create(threadContext.getRuntime());
                xmlNodeSet.setNodeList(xObject.nodelist());
                xmlNodeSet.initialize(threadContext.getRuntime(), (IRubyObject)this.context);
                return xmlNodeSet;
            }
        }
        return threadContext.getRuntime().newString(xObject.str());
    }

    private XPathContext getXPathContext(NokogiriXPathFunctionResolver nokogiriXPathFunctionResolver) {
        XPathContext xPathContext;
        Node node = this.context.getNode().getOwnerDocument();
        if (node == null) {
            node = this.context.getNode();
        }
        if ((xPathContext = (XPathContext)node.getUserData(XPATH_CONTEXT)) == null) {
            xPathContext = XmlXpathContext.newXPathContext(nokogiriXPathFunctionResolver);
            if (this.variableResolver == null) {
                node.setUserData(XPATH_CONTEXT, xPathContext, null);
            }
        } else {
            Object object = xPathContext.getOwnerObject();
            if ((object == null && nokogiriXPathFunctionResolver == null || object instanceof JAXPExtensionsProvider && ((JAXPExtensionsProvider)((Object)object)).hasSameResolver(nokogiriXPathFunctionResolver)) && this.variableResolver == null) {
                return xPathContext;
            }
            xPathContext = XmlXpathContext.newXPathContext(nokogiriXPathFunctionResolver);
        }
        if (this.variableResolver != null) {
            xPathContext.setVarStack((VariableStack)new JAXPVariableStack((XPathVariableResolver)this.variableResolver));
        }
        return xPathContext;
    }

    private static XPathContext newXPathContext(NokogiriXPathFunctionResolver nokogiriXPathFunctionResolver) {
        if (nokogiriXPathFunctionResolver == null) {
            return new XPathContext(false);
        }
        return new XPathContext((Object)new JAXPExtensionsProvider(nokogiriXPathFunctionResolver), false);
    }

    private boolean isContainsPrefix(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : this.nsContext.getAllPrefixes()) {
            stringBuilder.setLength(0);
            stringBuilder.ensureCapacity(string2.length() + 1);
            stringBuilder.append(string2).append(':');
            if (!string.contains(stringBuilder)) continue;
            return true;
        }
        return false;
    }

    static {
        if (SafePropertyAccessor.getProperty((String)"org.apache.xml.dtm.DTMManager") == null) {
            try {
                System.setProperty("org.apache.xml.dtm.DTMManager", XalanDTMManagerPatch.class.getName());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private static final class JAXPExtensionsProvider
    extends org.apache.xpath.jaxp.JAXPExtensionsProvider {
        final NokogiriXPathFunctionResolver resolver;

        JAXPExtensionsProvider(NokogiriXPathFunctionResolver nokogiriXPathFunctionResolver) {
            super((XPathFunctionResolver)nokogiriXPathFunctionResolver, false);
            this.resolver = nokogiriXPathFunctionResolver;
        }

        final boolean hasSameResolver(NokogiriXPathFunctionResolver nokogiriXPathFunctionResolver) {
            return nokogiriXPathFunctionResolver == this.resolver || nokogiriXPathFunctionResolver != null && (nokogiriXPathFunctionResolver.getHandler() == null ? this.resolver.getHandler() == null : nokogiriXPathFunctionResolver.getHandler() == this.resolver.getHandler());
        }
    }
}

