/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;
import java.io.IOException;

public final class SettableIntFieldProperty
extends OptimizedSettableBeanProperty<SettableIntFieldProperty> {
    private static final long serialVersionUID = 1L;

    public SettableIntFieldProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src, mutator, index);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableIntFieldProperty(del, this._propertyMutator, this._optimizedIndex);
    }

    @Override
    public SettableBeanProperty withMutator(BeanPropertyMutator mut) {
        return new SettableIntFieldProperty(this.delegate, mut, this._optimizedIndex);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        int v = p.hasToken(JsonToken.VALUE_NUMBER_INT) ? p.getIntValue() : this._deserializeInt(p, ctxt);
        try {
            this._propertyMutator.intField(bean, this._optimizedIndex, v);
        }
        catch (Throwable e) {
            this._reportProblem(bean, v, e);
        }
    }

    @Override
    public void set(Object bean, Object value) throws IOException {
        int v = ((Number)value).intValue();
        try {
            this._propertyMutator.intField(bean, this._optimizedIndex, v);
        }
        catch (Throwable e) {
            this._reportProblem(bean, v, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        int v = p.hasToken(JsonToken.VALUE_NUMBER_INT) ? p.getIntValue() : this._deserializeInt(p, ctxt);
        return this.setAndReturn(instance, v);
    }
}

