/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.ackedqueue.ext.JRubyWrappedAckedQueueExt;
import org.logstash.execution.AbstractWrappedQueueExt;
import org.logstash.ext.JrubyWrappedSynchronousQueueExt;

@JRubyClass(name={"QueueFactory"})
public final class QueueFactoryExt
extends RubyBasicObject {
    public QueueFactoryExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(meta=true)
    public static AbstractWrappedQueueExt create(ThreadContext context, IRubyObject recv, IRubyObject settings) throws IOException {
        String type = QueueFactoryExt.getSetting(context, settings, "queue.type").asJavaString();
        if ("persisted".equals(type)) {
            Path queuePath = Paths.get(QueueFactoryExt.getSetting(context, settings, "path.queue").asJavaString(), QueueFactoryExt.getSetting(context, settings, "pipeline.id").asJavaString());
            Files.createDirectories(queuePath, new FileAttribute[0]);
            return new JRubyWrappedAckedQueueExt(context.runtime, RubyUtil.WRAPPED_ACKED_QUEUE_CLASS).initialize(context, new IRubyObject[]{context.runtime.newString(queuePath.toString()), QueueFactoryExt.getSetting(context, settings, "queue.page_capacity"), QueueFactoryExt.getSetting(context, settings, "queue.max_events"), QueueFactoryExt.getSetting(context, settings, "queue.checkpoint.writes"), QueueFactoryExt.getSetting(context, settings, "queue.checkpoint.acks"), QueueFactoryExt.getSetting(context, settings, "queue.checkpoint.interval"), QueueFactoryExt.getSetting(context, settings, "queue.max_bytes")});
        }
        if ("memory".equals(type)) {
            return new JrubyWrappedSynchronousQueueExt(context.runtime, RubyUtil.WRAPPED_SYNCHRONOUS_QUEUE_CLASS).initialize(context, (IRubyObject)context.runtime.newFixnum(QueueFactoryExt.getSetting(context, settings, "pipeline.batch.size").convertToInteger().getIntValue() * QueueFactoryExt.getSetting(context, settings, "pipeline.workers").convertToInteger().getIntValue()));
        }
        throw context.runtime.newRaiseException(RubyUtil.CONFIGURATION_ERROR_CLASS, String.format("Invalid setting `%s` for `queue.type`, supported types are: 'memory' or 'persisted'", type));
    }

    private static IRubyObject getSetting(ThreadContext context, IRubyObject settings, String name) {
        return settings.callMethod(context, "get_value", (IRubyObject)context.runtime.newString(name));
    }
}

