/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.execution.WorkerLoop;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.instrument.metrics.counter.LongCounter;

@JRubyClass(name={"JavaFilterDelegator"})
public final class FilterDelegatorExt
extends RubyObject {
    private static final String FILTER_METHOD_NAME = "multi_filter";
    private static final long serialVersionUID = 1L;
    private RubyClass filterClass;
    private IRubyObject filter;
    private AbstractNamespacedMetricExt metricEvents;
    private RubyString id;
    private LongCounter eventMetricOut;
    private LongCounter eventMetricIn;
    private DynamicMethod filterMethod;
    private LongCounter eventMetricTime;
    private boolean flushes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject filter, IRubyObject id) {
        this.id = (RubyString)id;
        this.filter = filter;
        this.filterClass = filter.getSingletonClass().getRealClass();
        this.filterMethod = this.filterClass.searchMethod(FILTER_METHOD_NAME);
        AbstractNamespacedMetricExt namespacedMetric = (AbstractNamespacedMetricExt)filter.callMethod(context, "metric");
        AbstractMetricExt abstractMetricExt = namespacedMetric.getMetric();
        synchronized (abstractMetricExt) {
            this.metricEvents = namespacedMetric.namespace(context, (IRubyObject)MetricKeys.EVENTS_KEY);
            this.eventMetricOut = LongCounter.fromRubyBase(this.metricEvents, MetricKeys.OUT_KEY);
            this.eventMetricIn = LongCounter.fromRubyBase(this.metricEvents, MetricKeys.IN_KEY);
            this.eventMetricTime = LongCounter.fromRubyBase(this.metricEvents, MetricKeys.DURATION_IN_MILLIS_KEY);
            namespacedMetric.gauge(context, (IRubyObject)MetricKeys.NAME_KEY, this.configName(context));
        }
        this.flushes = filter.respondsTo("flush");
        return this;
    }

    @VisibleForTesting
    public FilterDelegatorExt initForTesting(IRubyObject filter) {
        this.eventMetricOut = LongCounter.DUMMY_COUNTER;
        this.eventMetricIn = LongCounter.DUMMY_COUNTER;
        this.eventMetricTime = LongCounter.DUMMY_COUNTER;
        this.filter = filter;
        this.filterMethod = filter.getMetaClass().searchMethod(FILTER_METHOD_NAME);
        this.flushes = filter.respondsTo("flush");
        return this;
    }

    public FilterDelegatorExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod
    public IRubyObject register(ThreadContext context) {
        return this.filter.callMethod(context, "register");
    }

    @JRubyMethod
    public IRubyObject close(ThreadContext context) {
        return this.filter.callMethod(context, "close");
    }

    @JRubyMethod(name={"do_close"})
    public IRubyObject doClose(ThreadContext context) {
        return this.filter.callMethod(context, "do_close");
    }

    @JRubyMethod(name={"do_stop"})
    public IRubyObject doStop(ThreadContext context) {
        return this.filter.callMethod(context, "do_stop");
    }

    @JRubyMethod(name={"reloadable?"})
    public IRubyObject isReloadable(ThreadContext context) {
        return this.filter.callMethod(context, "reloadable?");
    }

    @JRubyMethod(name={"threadsafe?"})
    public IRubyObject concurrency(ThreadContext context) {
        return this.filter.callMethod(context, "threadsafe?");
    }

    @JRubyMethod(name={"config_name"})
    public IRubyObject configName(ThreadContext context) {
        return this.filterClass.callMethod(context, "config_name");
    }

    @JRubyMethod(name={"id"})
    public IRubyObject getId() {
        return this.id;
    }

    public RubyArray multiFilter(RubyArray batch) {
        this.eventMetricIn.increment(batch.size());
        long start = System.nanoTime();
        RubyArray result = (RubyArray)this.filterMethod.call(WorkerLoop.THREAD_CONTEXT.get(), this.filter, (RubyModule)this.filterClass, FILTER_METHOD_NAME, (IRubyObject)batch);
        this.eventMetricTime.increment(TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        int count = 0;
        for (JrubyEventExtLibrary.RubyEvent event : result) {
            if (event.getEvent().isCancelled()) continue;
            ++count;
        }
        this.eventMetricOut.increment(count);
        return result;
    }

    public RubyArray flush(RubyHash options) {
        RubyArray result;
        ThreadContext context = WorkerLoop.THREAD_CONTEXT.get();
        IRubyObject newEvents = this.filter.callMethod(context, "flush", (IRubyObject)options);
        if (newEvents.isNil()) {
            result = RubyArray.newEmptyArray((Ruby)context.runtime);
        } else {
            result = (RubyArray)newEvents;
            this.eventMetricOut.increment(result.size());
        }
        return result;
    }

    public boolean hasFlush() {
        return this.flushes;
    }

    public boolean periodicFlush() {
        return this.filter.callMethod(RubyUtil.RUBY.getCurrentContext(), "periodic_flush").isTrue();
    }
}

