/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness.pipeline;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.gauge.NumberGauge;
import org.logstash.instrument.metrics.gauge.TextGauge;
import org.logstash.instrument.witness.MetricSerializer;
import org.logstash.instrument.witness.SerializableWitness;

@JsonSerialize(using=Serializer.class)
public final class QueueWitness
implements SerializableWitness {
    private final TextGauge type = new TextGauge("type");
    private final NumberGauge events = new NumberGauge("events");
    private final Snitch snitch = new Snitch(this);
    private final CapacityWitness capacity = new CapacityWitness();
    private final DataWitness data = new DataWitness();
    private static final String KEY = "queue";
    private static final Serializer SERIALIZER = new Serializer();

    public void events(long count) {
        this.events.set(count);
    }

    public CapacityWitness capacity() {
        return this.capacity;
    }

    public DataWitness data() {
        return this.data;
    }

    public Snitch snitch() {
        return this.snitch;
    }

    public void type(String type) {
        this.type.set(type);
    }

    @Override
    public void genJson(JsonGenerator gen, SerializerProvider provider) throws IOException {
        Serializer.innerSerialize(this, gen);
    }

    public static final class Snitch {
        private final QueueWitness witness;

        private Snitch(QueueWitness witness) {
            this.witness = witness;
        }

        public String type() {
            return (String)this.witness.type.getValue();
        }

        public Number events() {
            return (Number)this.witness.events.getValue();
        }
    }

    public static final class Serializer
    extends StdSerializer<QueueWitness> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            this(QueueWitness.class);
        }

        protected Serializer(Class<QueueWitness> t) {
            super(t);
        }

        public void serialize(QueueWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            Serializer.innerSerialize(witness, gen);
            gen.writeEndObject();
        }

        static void innerSerialize(QueueWitness witness, JsonGenerator gen) throws IOException {
            gen.writeObjectFieldStart(QueueWitness.KEY);
            MetricSerializer<Metric<Number>> numberSerializer = MetricSerializer.Get.numberSerializer(gen);
            MetricSerializer<Metric<String>> stringSerializer = MetricSerializer.Get.stringSerializer(gen);
            stringSerializer.serialize(witness.type);
            if ("persisted".equals(witness.type.getValue())) {
                numberSerializer.serialize(witness.events);
                gen.writeObjectFieldStart("capacity");
                numberSerializer.serialize(witness.capacity.queueSizeInBytes);
                numberSerializer.serialize(witness.capacity.pageCapacityInBytes);
                numberSerializer.serialize(witness.capacity.maxQueueSizeInBytes);
                numberSerializer.serialize(witness.capacity.maxUnreadEvents);
                gen.writeEndObject();
                gen.writeObjectFieldStart("data");
                stringSerializer.serialize(witness.data.path);
                numberSerializer.serialize(witness.data.freeSpaceInBytes);
                stringSerializer.serialize(witness.data.storageType);
                gen.writeEndObject();
            }
            gen.writeEndObject();
        }
    }

    public static class DataWitness {
        private final TextGauge path = new TextGauge("path");
        private final NumberGauge freeSpaceInBytes = new NumberGauge("free_space_in_bytes");
        private final TextGauge storageType = new TextGauge("storage_type");
        private final Snitch snitch = new Snitch(this);
        private static final String KEY = "data";

        private DataWitness() {
        }

        public void freeSpaceInBytes(long space) {
            this.freeSpaceInBytes.set(space);
        }

        public void path(String path) {
            this.path.set(path);
        }

        public void storageType(String storageType) {
            this.storageType.set(storageType);
        }

        public Snitch snitch() {
            return this.snitch;
        }

        public static class Snitch {
            private final DataWitness witness;

            private Snitch(DataWitness witness) {
                this.witness = witness;
            }

            public String path() {
                return (String)this.witness.path.getValue();
            }

            public Number freeSpaceInBytes() {
                return (Number)this.witness.freeSpaceInBytes.getValue();
            }

            public String storageType() {
                return (String)this.witness.storageType.getValue();
            }
        }
    }

    public static class CapacityWitness {
        private final NumberGauge queueSizeInBytes = new NumberGauge("queue_size_in_bytes");
        private final NumberGauge pageCapacityInBytes = new NumberGauge("page_capacity_in_bytes");
        private final NumberGauge maxQueueSizeInBytes = new NumberGauge("max_queue_size_in_bytes");
        private final NumberGauge maxUnreadEvents = new NumberGauge("max_unread_events");
        private final Snitch snitch = new Snitch(this);
        private static final String KEY = "capacity";

        private CapacityWitness() {
        }

        public void queueSizeInBytes(long size) {
            this.queueSizeInBytes.set(size);
        }

        public void pageCapacityInBytes(long capacity) {
            this.pageCapacityInBytes.set(capacity);
        }

        public void maxQueueSizeInBytes(long max) {
            this.maxQueueSizeInBytes.set(max);
        }

        public void maxUnreadEvents(long max) {
            this.maxUnreadEvents.set(max);
        }

        public Snitch snitch() {
            return this.snitch;
        }

        public static class Snitch {
            private final CapacityWitness witness;

            private Snitch(CapacityWitness witness) {
                this.witness = witness;
            }

            public Number queueSizeInBytes() {
                return (Number)this.witness.queueSizeInBytes.getValue();
            }

            public Number pageCapacityInBytes() {
                return (Number)this.witness.pageCapacityInBytes.getValue();
            }

            public Number maxQueueSizeInBytes() {
                return (Number)this.witness.maxQueueSizeInBytes.getValue();
            }

            public Number maxUnreadEvents() {
                return (Number)this.witness.maxUnreadEvents.getValue();
            }
        }
    }
}

