/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.ocsp.RevokedInfo;
import org.bouncycastle.asn1.ocsp.SingleResponse;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.OCSP;
import org.jruby.ext.openssl.OCSPCertificateId;
import org.jruby.ext.openssl.X509Extension;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class OCSPSingleResponse
extends RubyObject {
    private static final long serialVersionUID = 7947277768033100227L;
    private static ObjectAllocator SINGLERESPONSE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new OCSPSingleResponse(runtime, klass);
        }
    };
    private SingleResponse bcSingleResponse;

    public static void createSingleResponse(Ruby runtime, RubyModule _OCSP) {
        RubyClass _request = _OCSP.defineClassUnder("SingleResponse", runtime.getObject(), SINGLERESPONSE_ALLOCATOR);
        _request.defineAnnotatedMethods(OCSPSingleResponse.class);
    }

    public OCSPSingleResponse(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public OCSPSingleResponse(Ruby runtime) {
        this(runtime, (RubyClass)OCSP._OCSP(runtime).getConstantAt("SingleResponse"));
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject derStr) {
        Ruby runtime = context2.getRuntime();
        RubyString rubyDerStr = (RubyString)derStr;
        try {
            this.bcSingleResponse = SingleResponse.getInstance((Object)DERTaggedObject.fromByteArray((byte[])rubyDerStr.getBytes()));
        }
        catch (IOException e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        return this;
    }

    @JRubyMethod(name={"cert_status"})
    public IRubyObject cert_status() {
        return RubyFixnum.newFixnum((Ruby)this.getRuntime(), (long)this.bcSingleResponse.getCertStatus().getTagNo());
    }

    @JRubyMethod(name={"certid"})
    public IRubyObject certid(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        CertID bcCertId = this.bcSingleResponse.getCertID();
        OCSPCertificateId rubyCertId = new OCSPCertificateId(runtime);
        try {
            rubyCertId.initialize(context2, (IRubyObject)RubyString.newString((Ruby)runtime, (byte[])bcCertId.getEncoded()));
        }
        catch (IOException e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        return rubyCertId;
    }

    @JRubyMethod(name={"check_validity"}, rest=true)
    public IRubyObject check_validity(IRubyObject[] args) {
        Date nextUpdate;
        Date thisUpdate;
        RubyFixnum rNsec;
        int maxsec;
        int nsec;
        Ruby runtime = this.getRuntime();
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)2) == 0) {
            nsec = 0;
            maxsec = -1;
        } else if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)2) == 1) {
            rNsec = (RubyFixnum)args[0];
            nsec = (int)rNsec.getLongValue();
            maxsec = -1;
        } else {
            rNsec = (RubyFixnum)args[0];
            RubyFixnum rMaxsec = (RubyFixnum)args[1];
            nsec = (int)rNsec.getLongValue();
            maxsec = (int)rMaxsec.getLongValue();
        }
        try {
            ASN1GeneralizedTime bcThisUpdate = this.bcSingleResponse.getThisUpdate();
            thisUpdate = bcThisUpdate == null ? null : bcThisUpdate.getDate();
            ASN1GeneralizedTime bcNextUpdate = this.bcSingleResponse.getNextUpdate();
            nextUpdate = bcNextUpdate == null ? null : bcNextUpdate.getDate();
        }
        catch (ParseException e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        return RubyBoolean.newBoolean((Ruby)runtime, (boolean)this.checkValidityImpl(thisUpdate, nextUpdate, nsec, maxsec));
    }

    @JRubyMethod(name={"extensions"})
    public IRubyObject extensions() {
        Ruby runtime = this.getRuntime();
        Extensions exts = this.bcSingleResponse.getSingleExtensions();
        if (exts == null) {
            return RubyArray.newEmptyArray((Ruby)runtime);
        }
        ASN1ObjectIdentifier[] extOIDs = exts.getExtensionOIDs();
        RubyArray retExts = runtime.newArray(extOIDs.length);
        for (ASN1ObjectIdentifier extOID : extOIDs) {
            Extension ext2 = exts.getExtension(extOID);
            ASN1Encodable extAsn1 = ext2.getParsedValue();
            X509Extension retExt = X509Extension.newExtension(runtime, extOID, extAsn1, ext2.isCritical());
            retExts.append((IRubyObject)retExt);
        }
        return retExts;
    }

    @JRubyMethod(name={"next_update"})
    public IRubyObject next_update() {
        Date nextUpdate;
        Ruby runtime = this.getRuntime();
        if (this.bcSingleResponse.getNextUpdate() == null) {
            return runtime.getNil();
        }
        try {
            nextUpdate = this.bcSingleResponse.getNextUpdate().getDate();
        }
        catch (ParseException e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        if (nextUpdate == null) {
            return runtime.getNil();
        }
        return RubyTime.newTime((Ruby)runtime, (long)nextUpdate.getTime());
    }

    @JRubyMethod(name={"this_update"})
    public IRubyObject this_update() {
        Date thisUpdate;
        Ruby runtime = this.getRuntime();
        if (this.bcSingleResponse.getThisUpdate() == null) {
            return runtime.getNil();
        }
        try {
            thisUpdate = this.bcSingleResponse.getThisUpdate().getDate();
        }
        catch (ParseException e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        return RubyTime.newTime((Ruby)runtime, (long)thisUpdate.getTime());
    }

    @JRubyMethod(name={"revocation_reason"})
    public IRubyObject revocation_reason() {
        Ruby runtime = this.getRuntime();
        RubyFixnum revoked2 = (RubyFixnum)OCSP._OCSP(runtime).getConstant("V_CERTSTATUS_REVOKED");
        if (this.bcSingleResponse.getCertStatus().getTagNo() == (int)revoked2.getLongValue()) {
            try {
                RevokedInfo revokedInfo = RevokedInfo.getInstance((Object)DERTaggedObject.fromByteArray((byte[])this.bcSingleResponse.getCertStatus().getStatus().toASN1Primitive().getEncoded()));
                return RubyFixnum.newFixnum((Ruby)runtime, (long)revokedInfo.getRevocationReason().getValue().intValue());
            }
            catch (IOException e) {
                throw OCSP.newOCSPError(runtime, e);
            }
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"revocation_time"})
    public IRubyObject revocation_time() {
        Ruby runtime = this.getRuntime();
        RubyFixnum revoked2 = (RubyFixnum)OCSP._OCSP(runtime).getConstant("V_CERTSTATUS_REVOKED");
        if (this.bcSingleResponse.getCertStatus().getTagNo() == (int)revoked2.getLongValue()) {
            try {
                RevokedInfo revokedInfo = RevokedInfo.getInstance((Object)DERTaggedObject.fromByteArray((byte[])this.bcSingleResponse.getCertStatus().getStatus().toASN1Primitive().getEncoded()));
                return RubyTime.newTime((Ruby)runtime, (long)revokedInfo.getRevocationTime().getDate().getTime());
            }
            catch (Exception e) {
                throw OCSP.newOCSPError(runtime, e);
            }
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"to_der"})
    public IRubyObject to_der() {
        Ruby runtime = this.getRuntime();
        try {
            return RubyString.newString((Ruby)runtime, (byte[])this.bcSingleResponse.getEncoded());
        }
        catch (IOException e) {
            throw OCSP.newOCSPError(runtime, e);
        }
    }

    public SingleResponse getBCSingleResp() {
        return this.bcSingleResponse;
    }

    private boolean checkValidityImpl(Date thisUpdate, Date nextUpdate, int nsec, int maxsec) {
        boolean ret = true;
        Date currentTime = new Date();
        Date tempTime = new Date();
        tempTime.setTime(currentTime.getTime() + (long)(nsec * 1000));
        if (thisUpdate.compareTo(tempTime) > 0) {
            ret = false;
        }
        if (maxsec >= 0) {
            tempTime.setTime(currentTime.getTime() - (long)(maxsec * 1000));
            if (thisUpdate.compareTo(tempTime) < 0) {
                ret = false;
            }
        }
        if (nextUpdate == null) {
            return ret;
        }
        tempTime.setTime(currentTime.getTime() - (long)(nsec * 1000));
        if (nextUpdate.compareTo(tempTime) < 0) {
            ret = false;
        }
        if (nextUpdate.compareTo(thisUpdate) < 0) {
            ret = false;
        }
        return ret;
    }
}

