/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet.attribute.value;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import net.jradius.log.RadiusLog;
import net.jradius.packet.attribute.value.AttributeValue;

public class IPAddrValue
extends AttributeValue {
    private static final long serialVersionUID = 0L;
    protected InetAddress inetAddressValue;

    public IPAddrValue() {
    }

    public IPAddrValue(InetAddress i) {
        this.inetAddressValue = i;
    }

    public IPAddrValue(String s) {
        this.setValue(s);
    }

    public IPAddrValue(byte[] bytes) {
        this.setValue(bytes);
    }

    public void copy(AttributeValue value) {
        IPAddrValue ipValue = (IPAddrValue)value;
        this.inetAddressValue = ipValue.inetAddressValue;
    }

    public void setValue(String s) {
        try {
            this.inetAddressValue = InetAddress.getByName(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getLength() {
        return 4;
    }

    public void getBytes(OutputStream out) throws IOException {
        if (this.inetAddressValue != null) {
            byte[] a = this.inetAddressValue.getAddress();
            if (a.length != this.getLength()) {
                throw new RuntimeException("Wrong IP address size for attribute");
            }
            out.write(a);
        }
    }

    public void getBytes(ByteBuffer buffer) {
        if (this.inetAddressValue != null) {
            byte[] a = this.inetAddressValue.getAddress();
            if (a.length != this.getLength()) {
                throw new RuntimeException("Wrong IP address size for attribute");
            }
            buffer.put(a);
        }
    }

    public void setValue(byte[] b) {
        if (b == null) {
            return;
        }
        try {
            if (b.length != this.getLength()) {
                throw new RuntimeException("Wrong IP address size for attribute");
            }
            this.inetAddressValue = InetAddress.getByAddress(b);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setValue(byte[] b, int off, int len) {
        if (b == null) {
            return;
        }
        try {
            if (len != this.getLength()) {
                throw new RuntimeException("Wrong IP address size for attribute");
            }
            byte[] bf = new byte[len];
            System.arraycopy(b, off, bf, 0, len);
            this.inetAddressValue = InetAddress.getByAddress(bf);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String toString() {
        if (this.inetAddressValue != null) {
            return this.inetAddressValue.getHostAddress();
        }
        return "[Bad IP Address Value]";
    }

    public String toXMLString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<ip>");
        if (this.inetAddressValue != null) {
            sb.append(this.inetAddressValue.getHostAddress());
        }
        sb.append("</ip>");
        return sb.toString();
    }

    public void setInetAddress(InetAddress inet) {
        this.inetAddressValue = inet;
    }

    public Serializable getValueObject() {
        return this.inetAddressValue;
    }

    public void setValueObject(Serializable o) {
        if (o instanceof InetAddress) {
            this.setInetAddress((InetAddress)o);
        } else if (o instanceof byte[]) {
            this.setValue((byte[])o);
        } else {
            try {
                this.setInetAddress(InetAddress.getByName(o.toString()));
            }
            catch (Exception e) {
                RadiusLog.warn(e.getMessage());
            }
        }
    }
}

