/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.work.Task;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class RunDeviceScriptTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(RunDeviceScriptTask.class);
    private Device device;
    private String script;
    private String deviceDriver;

    protected RunDeviceScriptTask() {
    }

    public RunDeviceScriptTask(Device device, String script, DeviceDriver driver, String comments, String author) {
        super(comments, device.getLastConfig() == null ? device.getMgmtAddress().getIp() : device.getName(), author);
        this.device = device;
        this.script = script;
        this.deviceDriver = driver.getName();
    }

    @Override
    public void prepare() {
        Hibernate.initialize(this.getDevice());
    }

    @Override
    public void run() {
        logger.debug("Starting script task for device {}.", (Object)this.device.getId());
        this.logIt(String.format("Run script task for device %s (%s).", this.device.getName(), this.device.getMgmtAddress().getIp()), 5);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            session.refresh(this.device);
            if (this.deviceDriver == null || !this.deviceDriver.equals(this.device.getDriver())) {
                logger.trace("The script doesn't apply to the driver of the device.");
                this.logIt("The script doesn't apply to the driver of the device.", 2);
                this.status = Task.Status.CANCELLED;
                return;
            }
            if (this.device.getStatus() != Device.Status.INPRODUCTION) {
                logger.trace("Device not INPRODUCTION, stopping the run script task.");
                this.logIt("The device is not enabled (not in production).", 2);
                this.status = Task.Status.FAILURE;
                return;
            }
            this.device.runScript(this.script, false);
            this.logIt(String.format("Device logs (%d next lines):", this.device.getLog().size()), 3);
            this.log.append(this.device.getPlainLog());
            session.update(this.device);
            session.getTransaction().commit();
            this.status = Task.Status.SUCCESS;
        }
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Device script execution";
    }

    @ManyToOne(fetch=FetchType.LAZY)
    protected Device getDevice() {
        return this.device;
    }

    protected void setDevice(Device device) {
        this.device = device;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RunDeviceScriptTask task = (RunDeviceScriptTask)super.clone();
        task.setDevice(this.device);
        return task;
    }

    @Column(length=100000000)
    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getDeviceDriver() {
        return this.deviceDriver;
    }

    public void setDeviceDriver(String deviceDriver) {
        this.deviceDriver = deviceDriver;
    }
}

