/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.format;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import org.apache.poi.ss.format.CellFormatPart;
import org.apache.poi.ss.format.CellFormatResult;
import org.apache.poi.ss.format.CellFormatType;
import org.apache.poi.ss.format.CellFormatter;
import org.apache.poi.ss.format.CellGeneralFormatter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;

public class CellFormat {
    private final String format;
    private final CellFormatPart posNumFmt;
    private final CellFormatPart zeroNumFmt;
    private final CellFormatPart negNumFmt;
    private final CellFormatPart textFmt;
    private final int formatPartCount;
    private static final Pattern ONE_PART = Pattern.compile(CellFormatPart.FORMAT_PAT.pattern() + "(;|$)", 6);
    private static final CellFormatPart DEFAULT_TEXT_FORMAT = new CellFormatPart("@");
    private static final String INVALID_VALUE_FOR_FORMAT = "###############################################################################################################################################################################################################################################################";
    private static String QUOTE = "\"";
    public static final CellFormat GENERAL_FORMAT = new CellFormat("General"){

        @Override
        public CellFormatResult apply(Object value) {
            String text = new CellGeneralFormatter().format(value);
            return new CellFormatResult(true, text, null);
        }
    };
    private static final Map<String, CellFormat> formatCache = new WeakHashMap<String, CellFormat>();

    public static CellFormat getInstance(String format) {
        CellFormat fmt = formatCache.get(format);
        if (fmt == null) {
            fmt = format.equals("General") || format.equals("@") ? GENERAL_FORMAT : new CellFormat(format);
            formatCache.put(format, fmt);
        }
        return fmt;
    }

    private CellFormat(String format) {
        this.format = format;
        Matcher m = ONE_PART.matcher(format);
        ArrayList<CellFormatPart> parts = new ArrayList<CellFormatPart>();
        while (m.find()) {
            try {
                String valueDesc = m.group();
                if (valueDesc.endsWith(";")) {
                    valueDesc = valueDesc.substring(0, valueDesc.length() - 1);
                }
                parts.add(new CellFormatPart(valueDesc));
            }
            catch (RuntimeException e) {
                CellFormatter.logger.log(Level.WARNING, "Invalid format: " + CellFormatter.quote(m.group()), e);
                parts.add(null);
            }
        }
        this.formatPartCount = parts.size();
        switch (this.formatPartCount) {
            case 1: {
                this.posNumFmt = (CellFormatPart)parts.get(0);
                this.negNumFmt = null;
                this.zeroNumFmt = null;
                this.textFmt = DEFAULT_TEXT_FORMAT;
                break;
            }
            case 2: {
                this.posNumFmt = (CellFormatPart)parts.get(0);
                this.negNumFmt = (CellFormatPart)parts.get(1);
                this.zeroNumFmt = null;
                this.textFmt = DEFAULT_TEXT_FORMAT;
                break;
            }
            case 3: {
                this.posNumFmt = (CellFormatPart)parts.get(0);
                this.negNumFmt = (CellFormatPart)parts.get(1);
                this.zeroNumFmt = (CellFormatPart)parts.get(2);
                this.textFmt = DEFAULT_TEXT_FORMAT;
                break;
            }
            default: {
                this.posNumFmt = (CellFormatPart)parts.get(0);
                this.negNumFmt = (CellFormatPart)parts.get(1);
                this.zeroNumFmt = (CellFormatPart)parts.get(2);
                this.textFmt = (CellFormatPart)parts.get(3);
            }
        }
    }

    public CellFormatResult apply(Object value) {
        if (value instanceof Number) {
            Number num = (Number)value;
            double val = num.doubleValue();
            if (val < 0.0 && (this.formatPartCount == 2 && !this.posNumFmt.hasCondition() && !this.negNumFmt.hasCondition() || this.formatPartCount == 3 && !this.negNumFmt.hasCondition() || this.formatPartCount == 4 && !this.negNumFmt.hasCondition())) {
                return this.negNumFmt.apply(-val);
            }
            return this.getApplicableFormatPart(val).apply(val);
        }
        if (value instanceof Date) {
            Double numericValue = DateUtil.getExcelDate((Date)value);
            if (DateUtil.isValidExcelDate(numericValue)) {
                return this.getApplicableFormatPart(numericValue).apply(value);
            }
            throw new IllegalArgumentException("value " + numericValue + " of date " + value + " is not a valid Excel date");
        }
        return this.textFmt.apply(value);
    }

    private CellFormatResult apply(Date date, double numericValue) {
        return this.getApplicableFormatPart(numericValue).apply(date);
    }

    public CellFormatResult apply(Cell c) {
        switch (CellFormat.ultimateType(c)) {
            case 3: {
                return this.apply("");
            }
            case 4: {
                return this.apply(c.getBooleanCellValue());
            }
            case 0: {
                Double value = c.getNumericCellValue();
                if (this.getApplicableFormatPart(value).getCellFormatType() == CellFormatType.DATE) {
                    if (DateUtil.isValidExcelDate(value)) {
                        return this.apply(c.getDateCellValue(), value);
                    }
                    return this.apply(INVALID_VALUE_FOR_FORMAT);
                }
                return this.apply(value);
            }
            case 1: {
                return this.apply(c.getStringCellValue());
            }
        }
        return this.apply("?");
    }

    public CellFormatResult apply(JLabel label, Object value) {
        CellFormatResult result = this.apply(value);
        label.setText(result.text);
        if (result.textColor != null) {
            label.setForeground(result.textColor);
        }
        return result;
    }

    private CellFormatResult apply(JLabel label, Date date, double numericValue) {
        CellFormatResult result = this.apply(date, numericValue);
        label.setText(result.text);
        if (result.textColor != null) {
            label.setForeground(result.textColor);
        }
        return result;
    }

    public CellFormatResult apply(JLabel label, Cell c) {
        switch (CellFormat.ultimateType(c)) {
            case 3: {
                return this.apply(label, "");
            }
            case 4: {
                return this.apply(label, c.getBooleanCellValue());
            }
            case 0: {
                Double value = c.getNumericCellValue();
                if (this.getApplicableFormatPart(value).getCellFormatType() == CellFormatType.DATE) {
                    if (DateUtil.isValidExcelDate(value)) {
                        return this.apply(label, c.getDateCellValue(), value);
                    }
                    return this.apply(label, INVALID_VALUE_FOR_FORMAT);
                }
                return this.apply(label, value);
            }
            case 1: {
                return this.apply(label, c.getStringCellValue());
            }
        }
        return this.apply(label, "?");
    }

    private CellFormatPart getApplicableFormatPart(Object value) {
        if (value instanceof Number) {
            double val = ((Number)value).doubleValue();
            if (this.formatPartCount == 1) {
                if (!this.posNumFmt.hasCondition() || this.posNumFmt.hasCondition() && this.posNumFmt.applies(val)) {
                    return this.posNumFmt;
                }
                return new CellFormatPart("General");
            }
            if (this.formatPartCount == 2) {
                if (!this.posNumFmt.hasCondition() && val >= 0.0 || this.posNumFmt.hasCondition() && this.posNumFmt.applies(val)) {
                    return this.posNumFmt;
                }
                if (!this.negNumFmt.hasCondition() || this.negNumFmt.hasCondition() && this.negNumFmt.applies(val)) {
                    return this.negNumFmt;
                }
                return new CellFormatPart(QUOTE + INVALID_VALUE_FOR_FORMAT + QUOTE);
            }
            if (!this.posNumFmt.hasCondition() && val > 0.0 || this.posNumFmt.hasCondition() && this.posNumFmt.applies(val)) {
                return this.posNumFmt;
            }
            if (!this.negNumFmt.hasCondition() && val < 0.0 || this.negNumFmt.hasCondition() && this.negNumFmt.applies(val)) {
                return this.negNumFmt;
            }
            return this.zeroNumFmt;
        }
        throw new IllegalArgumentException("value must be a Number");
    }

    public static int ultimateType(Cell cell) {
        int type = cell.getCellType();
        if (type == 2) {
            return cell.getCachedFormulaResultType();
        }
        return type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CellFormat) {
            CellFormat that = (CellFormat)obj;
            return this.format.equals(that.format);
        }
        return false;
    }

    public int hashCode() {
        return this.format.hashCode();
    }
}

