/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.spdy.SpdyHeader;
import org.glassfish.grizzly.spdy.SpdyStream;

class SpdyResponse
extends HttpResponsePacket
implements SpdyHeader {
    private static final ThreadCache.CachedTypeIndex<SpdyResponseRecyclable> CACHE_IDX = ThreadCache.obtainIndex(SpdyResponseRecyclable.class, 2);
    private boolean contentTypeParsed;

    SpdyResponse() {
    }

    public static SpdyResponse create() {
        SpdyResponse spdyResponse = ThreadCache.takeFromCache(CACHE_IDX);
        if (spdyResponse == null) {
            spdyResponse = new SpdyResponse();
        }
        return spdyResponse;
    }

    @Override
    public ProcessingState getProcessingState() {
        return this.getRequest().getProcessingState();
    }

    @Override
    public SpdyStream getSpdyStream() {
        return SpdyStream.getSpdyStream(this);
    }

    @Override
    public String getCharacterEncoding() {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        return super.getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String charset) {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        super.setCharacterEncoding(charset);
    }

    @Override
    public String getContentType() {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        return super.getContentType();
    }

    private void parseContentTypeHeader() {
        DataChunk dc;
        this.contentTypeParsed = true;
        if (!this.contentType.isSet() && (dc = this.headers.getValue(Header.ContentType)) != null && !dc.isNull()) {
            this.setContentType(dc.toString());
        }
    }

    @Override
    public void setExpectContent(boolean isExpectContent) {
        super.setExpectContent(isExpectContent);
    }

    @Override
    protected void reset() {
        this.contentTypeParsed = false;
        super.reset();
    }

    private static class SpdyResponseRecyclable
    extends SpdyResponse {
        private SpdyResponseRecyclable() {
        }

        @Override
        public void recycle() {
            this.reset();
            ThreadCache.putToCache(CACHE_IDX, this);
        }
    }
}

