/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.dialog.ButtonPanel;
import com.projity.document.ObjectEvent;
import com.projity.field.Field;
import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.graphic.frames.DocumentSelectedEvent;
import com.projity.pm.graphic.views.SearchContext;
import com.projity.pm.graphic.views.Searchable;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public final class FindDialog
extends AbstractDialog
implements ObjectEvent.Listener,
DocumentSelectedEvent.Listener {
    private static final long serialVersionUID = 1L;
    JComboBox combo;
    JTextField search = new JTextField(30);
    DocumentFrame documentFrame;
    SearchContext context;
    JButton next;
    JButton previous;
    private static FindDialog instance = null;
    private Searchable searchable;

    public static FindDialog getInstance(DocumentFrame documentFrame, Searchable searchable, Field field) {
        return new FindDialog(documentFrame, searchable, field);
    }

    private FindDialog(DocumentFrame documentFrame, Searchable searchable, Field field) {
        super(documentFrame.getGraphicManager().getFrame(), Messages.getString("LookupDialog.Find"), false);
        DocumentSelectedEvent.addListener(this);
        this.init(searchable, field);
    }

    public void init(Searchable searchable, Field field) {
        this.searchable = searchable;
        this.context = searchable.createSearchContext();
        if (field != null) {
            this.context.setField(field);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(searchable.getAvailableFields());
        Collections.sort(arrayList);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        if (this.combo == null) {
            this.combo = new JComboBox<Object>(defaultComboBoxModel);
        } else {
            this.combo.setModel(defaultComboBoxModel);
        }
        this.bind(true);
        this.updateFindButtonState();
        this.search.requestFocus();
    }

    @Override
    public void onOk() {
        this.bind(false);
        if (!this.searchable.findNext(this.context)) {
            Alert.warn("No more matches");
        }
    }

    @Override
    protected boolean bind(boolean bl) {
        if (bl) {
            if (this.context.getField() != null) {
                this.combo.setSelectedItem(this.context.getField());
            }
            if (this.search != null) {
                this.search.setText("");
            }
        } else {
            this.context.setField((Field)this.combo.getSelectedItem());
            this.context.setSearchValue(this.search.getText());
        }
        return true;
    }

    @Override
    public JComponent createContentPanel() {
        FormLayout formLayout = new FormLayout("default, 3dlu, default, 3dlu, default", "p, 3dlu, p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.append(Messages.getString("LookupDialog.Find"), (Component)this.search);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("Text.Field"), (Component)this.combo);
        return defaultFormBuilder.getPanel();
    }

    public void setDocumentFrame(DocumentFrame documentFrame) {
        if (this.documentFrame != null) {
            this.documentFrame.getProject().removeObjectListener(this);
        }
        this.documentFrame = documentFrame;
        documentFrame.getProject().addObjectListener(this);
    }

    @Override
    public void documentSelected(DocumentSelectedEvent documentSelectedEvent) {
        this.setVisible(false);
    }

    @Override
    public void objectChanged(ObjectEvent objectEvent) {
    }

    @Override
    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.next = new JButton(Messages.getString("LookupDialog.Find"), IconManager.getIcon("image.down"));
        this.previous = new JButton(Messages.getString("LookupDialog.Find"), IconManager.getIcon("image.up"));
        buttonPanel.add(this.next);
        buttonPanel.add(this.previous);
        this.updateFindButtonState();
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindDialog.this.context.setForward(true);
                FindDialog.this.onOk();
            }
        });
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindDialog.this.context.setForward(false);
                FindDialog.this.onOk();
            }
        });
        this.search.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                FindDialog.this.updateFindButtonState();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        return buttonPanel;
    }

    private void updateFindButtonState() {
        if (this.next == null) {
            return;
        }
        boolean bl = this.search.getText().length() == 0;
        this.next.setEnabled(!bl);
        this.previous.setEnabled(!bl);
    }

    @Override
    protected boolean hasOkAndCancelButtons() {
        return false;
    }
}

