/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.graph;

import com.projity.configuration.Configuration;
import com.projity.field.Field;
import com.projity.graphic.configuration.BarStyles;
import com.projity.grouping.core.model.NodeModel;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.graphic.graph.event.GraphEvent;
import com.projity.pm.graphic.graph.event.GraphListener;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.event.CacheListener;
import com.projity.pm.graphic.model.event.CompositeCacheEvent;
import com.projity.pm.task.Project;
import com.projity.pm.task.Task;
import com.projity.util.Environment;
import java.io.Serializable;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;

public class GraphModel
implements Serializable,
CacheListener {
    private static final long serialVersionUID = -6589463266745797527L;
    protected NodeModelCache cache;
    protected BarStyles barStyles;
    protected Project project;
    protected static Field nameField = Configuration.getFieldFromId("Field.name");
    protected EventListenerList listenerList = new EventListenerList();

    public GraphModel(Project project, String string) {
        this.project = project;
    }

    public void close() {
        this.setCache(null);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public BarStyles getBarStyles() {
        return this.barStyles;
    }

    public void setBarStyles(BarStyles barStyles) {
        this.barStyles = barStyles;
    }

    public NodeModelCache getCache() {
        return this.cache;
    }

    public void setCache(NodeModelCache nodeModelCache) {
        if (this.cache != null) {
            this.cache.removeNodeModelListener(this);
        }
        this.cache = nodeModelCache;
        nodeModelCache.addNodeModelListener(this);
    }

    public ListIterator getNodeIterator() {
        return this.cache.getIterator();
    }

    public ListIterator getNodeIterator(int n) {
        return this.cache.getIterator(n);
    }

    public ListIterator getDependencyIterator() {
        return this.cache.getEdgesIterator();
    }

    public List searchJustModifiedNodes() {
        LinkedList<GraphicNode> linkedList = new LinkedList<GraphicNode>();
        ListIterator listIterator = this.getCache().getIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)listIterator.next();
            Object object = graphicNode.getNode().getImpl();
            if (object instanceof Task) {
                if (!((Task)object).isJustModified()) continue;
                linkedList.add(graphicNode);
                continue;
            }
            if (!(object instanceof Assignment) || !((Task)this.getCache().getModel().getParent(graphicNode.getNode()).getImpl()).isJustModified()) continue;
            linkedList.add(graphicNode);
        }
        return linkedList;
    }

    public List searchNode(Object object) {
        LinkedList<GraphicNode> linkedList = new LinkedList<GraphicNode>();
        ListIterator listIterator = this.getCache().getIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)listIterator.next();
            if (graphicNode.getNode().getImpl() != object) continue;
            linkedList.add(graphicNode);
            break;
        }
        return linkedList;
    }

    @Override
    public void graphicNodesCompositeEvent(CompositeCacheEvent compositeCacheEvent) {
        if (compositeCacheEvent.getRemovedNodes() != null) {
            this.remove(compositeCacheEvent.getRemovedNodes(), false);
        }
        if (compositeCacheEvent.getInsertedNodes() != null) {
            this.insert(compositeCacheEvent.getInsertedNodes(), false);
        }
        this.update(compositeCacheEvent.getUpdatedNodes(), false);
        if (compositeCacheEvent.getRemovedEdges() != null) {
            this.removeEdges(compositeCacheEvent.getRemovedEdges(), false);
        }
        if (compositeCacheEvent.getInsertedEdges() != null) {
            this.insertEdges(compositeCacheEvent.getInsertedEdges(), false);
        }
        if (compositeCacheEvent.getUpdatedEdges() != null) {
            this.updateEdges(compositeCacheEvent.getUpdatedEdges(), false);
        }
    }

    public void updateAll(boolean bl) {
        this.update(null, bl);
    }

    protected void update(List list, boolean bl) {
        this.fireUpdate(this, list);
    }

    public void insertAll(boolean bl) {
        if (this.cache.getSize() > 0) {
            this.insert(null, true, bl);
        }
    }

    protected void insert(List list, boolean bl) {
        this.insert(list, false, bl);
    }

    protected void insert(List list, boolean bl, boolean bl2) {
    }

    public void removeAll(boolean bl) {
        this.remove(null, bl);
    }

    protected void remove(List list, boolean bl) {
    }

    protected void insertEdges(List list, boolean bl) {
    }

    protected void removeEdges(List list, boolean bl) {
    }

    protected void updateEdges(List list, boolean bl) {
    }

    public void addGraphListener(GraphListener graphListener) {
        this.listenerList.add(GraphListener.class, graphListener);
    }

    public void removeGraphListener(GraphListener graphListener) {
        this.listenerList.remove(GraphListener.class, graphListener);
    }

    public GraphListener[] getGraphListeners() {
        return (GraphListener[])this.listenerList.getListeners(GraphListener.class);
    }

    protected void fireUpdate(Object object, List list) {
        Object[] objectArray = this.listenerList.getListenerList();
        GraphEvent graphEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GraphListener.class) continue;
            if (graphEvent == null) {
                graphEvent = new GraphEvent(object, list);
            }
            ((GraphListener)objectArray[i + 1]).updateGraph(graphEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public boolean isReadOnly() {
        NodeModel nodeModel = this.cache.getModel();
        return !nodeModel.isLocal() && !nodeModel.isMaster() && !Environment.getStandAlone();
    }
}

