/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.endresulttransformer;

import java.util.Map;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.search.grouping.endresulttransformer.EndResultTransformer;

public class SimpleEndResultTransformer
implements EndResultTransformer {
    @Override
    public void transform(Map<String, ?> result, ResponseBuilder rb, EndResultTransformer.SolrDocumentSource solrDocumentSource) {
        SimpleOrderedMap commands = new SimpleOrderedMap();
        for (Map.Entry<String, ?> entry : result.entrySet()) {
            Object value = entry.getValue();
            if (!TopGroups.class.isInstance(value)) continue;
            TopGroups topGroups = (TopGroups)value;
            SimpleOrderedMap command = new SimpleOrderedMap();
            command.add("matches", (Object)rb.totalHitCount);
            if (topGroups.totalGroupCount != null) {
                command.add("ngroups", (Object)topGroups.totalGroupCount);
            }
            SolrDocumentList docList = new SolrDocumentList();
            docList.setStart((long)rb.getGroupingSpec().getOffset());
            docList.setNumFound((long)topGroups.totalHitCount);
            Float maxScore = Float.valueOf(Float.NEGATIVE_INFINITY);
            for (GroupDocs group : topGroups.groups) {
                for (ScoreDoc scoreDoc : group.scoreDocs) {
                    if (maxScore.floatValue() < scoreDoc.score) {
                        maxScore = Float.valueOf(scoreDoc.score);
                    }
                    docList.add((Object)solrDocumentSource.retrieve(scoreDoc));
                }
            }
            if (maxScore.floatValue() != Float.NEGATIVE_INFINITY) {
                docList.setMaxScore(maxScore);
            }
            command.add("doclist", (Object)docList);
            commands.add(entry.getKey(), (Object)command);
        }
        rb.rsp.add("grouped", commands);
    }
}

