/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.FindDialogPanel;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.OutputPane;
import org.netbeans.core.output2.OutputWindow;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.netbeans.core.output2.ui.AbstractOutputTab;

final class OutputTab
extends AbstractOutputTab {
    private NbIO io;
    private long timestamp = 0L;
    private int firstNavigableListenerLine = -1;
    private boolean hasOutputListeners = false;
    private ActionListener findActionListener;

    OutputTab(NbIO nbIO) {
        this.io = nbIO;
        if (Controller.LOG) {
            Controller.log("Created an output component for " + nbIO);
        }
        OutputDocument outputDocument = new OutputDocument(((NbWriter)nbIO.getOut()).out());
        this.setDocument(outputDocument);
    }

    public void addNotify() {
        super.addNotify();
        if (this.io != null) {
            this.io.setClosed(false);
        }
    }

    public void removeNotify() {
        if (this.io != null) {
            this.io.setClosed(true);
        }
        super.removeNotify();
    }

    public void setDocument(Document document) {
        if (Controller.LOG) {
            Controller.log("Set document on " + this + " with " + this.io);
        }
        assert (SwingUtilities.isEventDispatchThread());
        OutputDocument outputDocument = this.getDocument();
        this.hasOutputListeners = false;
        this.firstNavigableListenerLine = -1;
        super.setDocument(document);
        if (outputDocument != null && outputDocument instanceof OutputDocument) {
            outputDocument.dispose();
        }
    }

    public void setIO(NbIO nbIO) {
        if (Controller.LOG) {
            Controller.log("Replacing io on " + this + " with " + nbIO + " out is " + (nbIO != null ? nbIO.getOut() : null));
        }
        if (nbIO != null) {
            this.setDocument(new OutputDocument(((NbWriter)nbIO.getOut()).out()));
            nbIO.setClosed(false);
        } else {
            if (this.io != null) {
                this.io.setClosed(true);
            }
            this.io = null;
            this.setDocument(null);
        }
    }

    public OutputDocument getDocument() {
        Document document = this.getOutputPane().getDocument();
        if (document instanceof OutputDocument) {
            return (OutputDocument)document;
        }
        return null;
    }

    protected AbstractOutputPane createOutputPane() {
        return new OutputPane();
    }

    protected void inputSent(String string) {
        if (Controller.LOG) {
            Controller.log("Input sent on OutputTab: " + string);
        }
        this.getOutputPane().lockScroll();
        this.findOutputWindow().inputSent(this, string);
    }

    protected void inputEof() {
        if (Controller.LOG) {
            Controller.log("Input EOF on OutputTab: ");
        }
        this.findOutputWindow().inputEof(this);
    }

    public void hasSelectionChanged(boolean bl) {
        OutputWindow outputWindow = this.findOutputWindow();
        if (outputWindow != null) {
            outputWindow.hasSelectionChanged(this, bl);
        }
    }

    public NbIO getIO() {
        return this.io;
    }

    void updateTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    long getTimestamp() {
        return this.timestamp;
    }

    private OutputWindow findOutputWindow() {
        if (this.getParent() != null) {
            return (OutputWindow)((Object)SwingUtilities.getAncestorOfClass(OutputWindow.class, this));
        }
        return (OutputWindow)this.getClientProperty("outputWindow");
    }

    void requestActive() {
        this.findOutputWindow().requestActive();
    }

    public void lineClicked(int n) {
        this.findOutputWindow().lineClicked(this, n);
    }

    boolean linePressed(int n, Point point) {
        OutWriter outWriter = this.getIO().out();
        if (outWriter != null) {
            return outWriter.getLines().getListenerForLine(n) != null;
        }
        return false;
    }

    public void postPopupMenu(Point point, Component component) {
        this.findOutputWindow().postPopupMenu(this, point, component);
    }

    public void caretEnteredLine(int n) {
        this.findOutputWindow().caretEnteredLine(this, n);
    }

    public int getFirstNavigableListenerLine() {
        if (this.firstNavigableListenerLine != -1) {
            return this.firstNavigableListenerLine;
        }
        int n = -1;
        OutWriter outWriter = this.io.out();
        if (outWriter != null) {
            if (Controller.LOG) {
                Controller.log("Looking for first appropriate listener line to send the caret to");
            }
            n = outWriter.getLines().firstImportantListenerLine();
        }
        return n;
    }

    public String toString() {
        return "OutputTab@" + System.identityHashCode(this) + " for " + this.io;
    }

    public void documentChanged() {
        OutputWindow outputWindow = this.findOutputWindow();
        if (outputWindow != null) {
            boolean bl = this.hasOutputListeners;
            if (this.getFirstNavigableListenerLine() == -1) {
                return;
            }
            boolean bl2 = this.hasOutputListeners = this.getIO().out() != null && this.getIO().out().getLines().firstListenerLine() >= 0;
            if (this.hasOutputListeners != bl) {
                outputWindow.hasOutputListenersChanged(this, this.hasOutputListeners);
            }
            outputWindow.documentChanged(this);
        }
    }

    public boolean shouldRelock(int n) {
        OutWriter outWriter;
        if (this.io != null && (outWriter = this.io.out()) != null && !outWriter.isClosed()) {
            int n2 = Math.abs(outWriter.getLines().getCharCount() - n);
            return n2 < 100;
        }
        return false;
    }

    ActionListener getFindActionListener(Action action, Action action2, Action action3) {
        if (this.findActionListener == null) {
            this.findActionListener = new FindActionListener(this, action, action2, action3);
        }
        return this.findActionListener;
    }

    static class FindActionListener
    implements ActionListener {
        OutputTab tab;
        Action findNextAction;
        Action findPreviousAction;
        Action copyAction;

        FindActionListener(OutputTab outputTab, Action action, Action action2, Action action3) {
            this.tab = outputTab;
            this.findNextAction = action;
            this.findPreviousAction = action2;
            this.copyAction = action3;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Matcher matcher;
            String string;
            FindDialogPanel findDialogPanel = (FindDialogPanel)SwingUtilities.getAncestorOfClass(FindDialogPanel.class, (JComponent)actionEvent.getSource());
            if (findDialogPanel == null) {
                findDialogPanel = (FindDialogPanel)((JComponent)actionEvent.getSource()).getClientProperty("panel");
            }
            if ((string = findDialogPanel.getPattern()) == null || string.length() == 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            OutWriter outWriter = this.tab.getIO().out();
            if (outWriter != null && !outWriter.isDisposed() && (matcher = outWriter.getLines().find(string)) != null && matcher.find()) {
                int n = matcher.start();
                int n2 = matcher.end();
                this.tab.getOutputPane().setSelection(n, n2);
                this.findNextAction.setEnabled(true);
                this.findPreviousAction.setEnabled(true);
                this.copyAction.setEnabled(true);
                findDialogPanel.getTopLevelAncestor().setVisible(false);
                this.tab.requestFocus();
            }
        }
    }
}

