/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.sql.DataSource;
import org.apache.naming.factory.ResourceLinkFactory;

public class DataSourceLinkFactory
extends ResourceLinkFactory {
    public static void setGlobalContext(Context newGlobalContext) {
        ResourceLinkFactory.setGlobalContext(newGlobalContext);
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        Object result = super.getObjectInstance(obj, name, nameCtx, environment);
        if (result != null) {
            Reference ref = (Reference)obj;
            RefAddr userAttr = ref.get("username");
            RefAddr passAttr = ref.get("password");
            if (userAttr.getContent() != null && passAttr.getContent() != null) {
                result = this.wrapDataSource(result, userAttr.getContent().toString(), passAttr.getContent().toString());
            }
        }
        return result;
    }

    protected Object wrapDataSource(Object datasource, String username, String password) throws NamingException {
        try {
            Class<?> proxyClass = Proxy.getProxyClass(datasource.getClass().getClassLoader(), datasource.getClass().getInterfaces());
            Constructor<?> proxyConstructor = proxyClass.getConstructor(InvocationHandler.class);
            DataSourceHandler handler = new DataSourceHandler((DataSource)datasource, username, password);
            return proxyConstructor.newInstance(handler);
        }
        catch (Exception x) {
            if (x instanceof NamingException) {
                throw (NamingException)x;
            }
            NamingException nx = new NamingException(x.getMessage());
            nx.initCause(x);
            throw nx;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataSourceHandler
    implements InvocationHandler {
        private final DataSource ds;
        private final String username;
        private final String password;
        private final Method getConnection;

        public DataSourceHandler(DataSource ds, String username, String password) throws Exception {
            this.ds = ds;
            this.username = username;
            this.password = password;
            this.getConnection = ds.getClass().getMethod("getConnection", String.class, String.class);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getConnection".equals(method.getName()) && (args == null || args.length == 0)) {
                args = new String[]{this.username, this.password};
                method = this.getConnection;
            } else if ("unwrap".equals(method.getName())) {
                return this.unwrap((Class)args[0]);
            }
            try {
                return method.invoke((Object)this.ds, args);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    InvocationTargetException it = (InvocationTargetException)t;
                    throw it.getCause() != null ? it.getCause() : it;
                }
                throw t;
            }
        }

        public Object unwrap(Class<?> iface) throws SQLException {
            if (iface == DataSource.class) {
                return this.ds;
            }
            throw new SQLException("Not a wrapper of " + iface.getName());
        }
    }
}

