/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.spec;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.List;
import jde.debugger.JDE;
import jde.debugger.spec.ReferenceTypeSpec;

public class SourceNameReferenceTypeSpec
implements ReferenceTypeSpec {
    final String m_sourceName;
    final int m_lineNumber;

    public SourceNameReferenceTypeSpec(String src, int line) {
        this.m_sourceName = src;
        this.m_lineNumber = line;
    }

    public String getSourceName() {
        return this.m_sourceName;
    }

    public boolean matches(ReferenceType refType) {
        try {
            String sourceMaybeWithPath = refType.sourceName();
            int directorySepIndex = sourceMaybeWithPath.lastIndexOf(47);
            if (directorySepIndex == -1) {
                directorySepIndex = sourceMaybeWithPath.lastIndexOf(92);
            }
            String refSourceName = sourceMaybeWithPath;
            if (directorySepIndex > -1) {
                refSourceName = sourceMaybeWithPath.substring(directorySepIndex + 1);
            }
            if (refSourceName.equals(this.m_sourceName)) {
                try {
                    List<Location> locs = refType.locationsOfLine(this.m_lineNumber);
                    return locs.size() > 0;
                }
                catch (Exception exc) {
                    JDE.debug(8, exc.toString());
                }
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return this.m_sourceName + " " + this.m_lineNumber;
    }
}

