/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;

public class PopupMenuExportResponse
extends JMenuItem {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(PopupMenuExportResponse.class);
    private ExtensionHistory extension = null;

    public PopupMenuExportResponse() {
        super(Constant.messages.getString("history.export.response.popup"));
        this.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                List<HistoryReference> hrefs = PopupMenuExportResponse.this.extension.getSelectedHistoryReferences();
                if (hrefs.size() == 0) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog(Constant.messages.getString("history.export.response.select.warning"));
                    return;
                }
                if (hrefs.size() > 1) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog(Constant.messages.getString("history.export.response.single.warning"));
                    return;
                }
                HttpMessage msg = null;
                try {
                    msg = hrefs.get(0).getHttpMessage();
                }
                catch (Exception e1) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog(Constant.messages.getString("history.export.response.read.warning"));
                    return;
                }
                if (msg.getResponseHeader().isEmpty() || msg.getResponseBody().length() == 0) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog(Constant.messages.getString("history.export.response.body.warning"));
                    return;
                }
                File file = PopupMenuExportResponse.this.getOutputFile(msg);
                if (file == null) {
                    return;
                }
                boolean isAppend = true;
                if (file.exists()) {
                    int rc = PopupMenuExportResponse.this.extension.getView().showYesNoCancelDialog(Constant.messages.getString("file.overwrite.warning"));
                    if (rc == 2) {
                        return;
                    }
                    if (rc == 0) {
                        isAppend = false;
                    }
                }
                FilterOutputStream bos = null;
                try {
                    bos = new BufferedOutputStream(new FileOutputStream(file, isAppend));
                    PopupMenuExportResponse.this.exportHistory(msg, (BufferedOutputStream)bos);
                }
                catch (Exception e1) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog(Constant.messages.getString("file.save.error") + file.getAbsolutePath() + ".");
                    log.warn((Object)e1.getMessage(), (Throwable)e1);
                }
                finally {
                    try {
                        bos.close();
                    }
                    catch (Exception e2) {
                        log.warn((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
        });
    }

    void setExtension(ExtensionHistory extension) {
        this.extension = extension;
    }

    private void exportHistory(HttpMessage msg, BufferedOutputStream bos) {
        try {
            if (!msg.getResponseHeader().isEmpty()) {
                bos.write(msg.getResponseBody().getBytes());
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private File getOutputFile(HttpMessage msg) {
        String filename = "";
        try {
            filename = msg.getRequestHeader().getURI().getPath();
            int pos = filename.lastIndexOf("/");
            filename = filename.substring(pos);
        }
        catch (Exception pos) {
            // empty catch block
        }
        JFileChooser chooser = new JFileChooser(this.extension.getModel().getOptionsParam().getUserDirectory());
        if (filename.length() > 0) {
            chooser.setSelectedFile(new File(filename));
        }
        File file = null;
        int rc = chooser.showSaveDialog(this.extension.getView().getMainFrame());
        if (rc == 0) {
            file = chooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            this.extension.getModel().getOptionsParam().setUserDirectory(chooser.getCurrentDirectory());
            return file;
        }
        return file;
    }
}

