/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.SSLConnector;
import org.zaproxy.zap.CommandLineBootstrap;
import org.zaproxy.zap.DaemonBootstrap;
import org.zaproxy.zap.GuiBootstrap;
import org.zaproxy.zap.ZapBootstrap;
import org.zaproxy.zap.eventBus.EventBus;
import org.zaproxy.zap.eventBus.SimpleEventBus;
import org.zaproxy.zap.utils.ClassLoaderUtil;

public class ZAP {
    private static ProcessType processType;
    private static final EventBus eventBus;
    private static final Logger logger;

    public static void main(String[] args) throws Exception {
        CommandLine cmdLine = null;
        try {
            cmdLine = new CommandLine(args != null ? Arrays.copyOf(args, args.length) : null);
        }
        catch (Exception e) {
            System.out.println("Failed due to invalid parameters: " + Arrays.toString(args));
            System.out.println(e.getMessage());
            System.out.println("Use '-h' for more details.");
            System.exit(1);
        }
        ZAP.initClassLoader();
        ZapBootstrap bootstrap = ZAP.createZapBootstrap(cmdLine);
        try {
            int rc = bootstrap.start();
            if (rc != 0) {
                System.exit(rc);
            }
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    private static void initClassLoader() {
        try {
            File langDir = new File(Constant.getZapInstall(), "lang");
            if (langDir.exists() && langDir.isDirectory()) {
                ClassLoaderUtil.addFile(langDir.getAbsolutePath());
            } else {
                System.out.println("Warning: failed to load language files from " + langDir.getAbsolutePath());
            }
            File libDir = new File(Constant.getZapInstall(), "lib");
            if (libDir.exists() && libDir.isDirectory()) {
                File[] files;
                for (File file : files = libDir.listFiles()) {
                    if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith("jar")) continue;
                    ClassLoaderUtil.addFile(file);
                }
            } else {
                System.out.println("Warning: failed to load jar files from " + libDir.getAbsolutePath());
            }
        }
        catch (IOException e) {
            System.out.println("Failed loading jars: " + e);
        }
    }

    private static ZapBootstrap createZapBootstrap(CommandLine cmdLineArgs) {
        ZapBootstrap bootstrap;
        if (cmdLineArgs.isGUI()) {
            processType = ProcessType.desktop;
            bootstrap = new GuiBootstrap(cmdLineArgs);
        } else if (cmdLineArgs.isDaemon()) {
            processType = ProcessType.daemon;
            bootstrap = new DaemonBootstrap(cmdLineArgs);
        } else {
            processType = ProcessType.cmdline;
            bootstrap = new CommandLineBootstrap(cmdLineArgs);
        }
        return bootstrap;
    }

    public static ProcessType getProcessType() {
        return processType;
    }

    public static EventBus getEventBus() {
        return eventBus;
    }

    static {
        eventBus = new SimpleEventBus();
        logger = Logger.getLogger(ZAP.class);
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionLogger());
        ProtocolSocketFactory sslFactory = null;
        try {
            Protocol protocol = Protocol.getProtocol((String)"https");
            sslFactory = protocol.getSocketFactory();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        if (sslFactory == null || !(sslFactory instanceof SSLConnector)) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new SSLConnector(), 443));
        }
    }

    private static final class UncaughtExceptionLogger
    implements Thread.UncaughtExceptionHandler {
        private static final Logger logger = Logger.getLogger(UncaughtExceptionLogger.class);
        private static boolean loggerConfigured = false;

        private UncaughtExceptionLogger() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (!(e instanceof ThreadDeath)) {
                if (loggerConfigured || UncaughtExceptionLogger.isLoggerConfigured()) {
                    logger.error((Object)("Exception in thread \"" + t.getName() + "\""), e);
                } else {
                    System.err.println("Exception in thread \"" + t.getName() + "\"");
                    e.printStackTrace();
                }
            }
        }

        private static boolean isLoggerConfigured() {
            if (loggerConfigured) {
                return true;
            }
            Enumeration appenders = LogManager.getRootLogger().getAllAppenders();
            if (appenders.hasMoreElements()) {
                loggerConfigured = true;
            } else {
                Enumeration loggers = LogManager.getCurrentLoggers();
                while (loggers.hasMoreElements()) {
                    Logger c = (Logger)loggers.nextElement();
                    if (!c.getAllAppenders().hasMoreElements()) continue;
                    loggerConfigured = true;
                    break;
                }
            }
            return loggerConfigured;
        }
    }

    public static enum ProcessType {
        cmdline,
        daemon,
        desktop,
        zaas;

    }
}

