/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.authentication.AbstractAuthenticationMethodOptionsPanel;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.authentication.UsernamePasswordAuthenticationCredentials;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.ZapPortNumberSpinner;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class HttpAuthenticationMethodType
extends AuthenticationMethodType {
    public static final String CONTEXT_CONFIG_AUTH_HTTP = "context.authentication.http";
    public static final String CONTEXT_CONFIG_AUTH_HTTP_HOSTNAME = "context.authentication.http.hostname";
    public static final String CONTEXT_CONFIG_AUTH_HTTP_REALM = "context.authentication.http.realm";
    public static final String CONTEXT_CONFIG_AUTH_HTTP_PORT = "context.authentication.http.port";
    private static final Logger log = Logger.getLogger(HttpAuthenticationMethodType.class);
    private static final int METHOD_IDENTIFIER = 3;
    private static final String METHOD_NAME = Constant.messages.getString("authentication.method.http.name");
    private static final String API_METHOD_NAME = "httpAuthentication";
    private static final String PARAM_HOSTNAME = "hostname";
    private static final String PARAM_REALM = "realm";
    private static final String PARAM_PORT = "port";

    @Override
    public HttpAuthenticationMethod createAuthenticationMethod(int contextId) {
        return new HttpAuthenticationMethod();
    }

    @Override
    public String getName() {
        return METHOD_NAME;
    }

    @Override
    public int getUniqueIdentifier() {
        return 3;
    }

    @Override
    public AbstractAuthenticationMethodOptionsPanel buildOptionsPanel(Context uiSharedContext) {
        return new HttpAuthenticationMethodOptionsPanel();
    }

    @Override
    public boolean hasOptionsPanel() {
        return true;
    }

    @Override
    public AbstractCredentialsOptionsPanel<? extends AuthenticationCredentials> buildCredentialsOptionsPanel(AuthenticationCredentials credentials, Context uiSharedContext) {
        return new UsernamePasswordAuthenticationCredentials.UsernamePasswordAuthenticationCredentialsOptionsPanel((UsernamePasswordAuthenticationCredentials)credentials);
    }

    @Override
    public boolean hasCredentialsOptionsPanel() {
        return true;
    }

    @Override
    public boolean isTypeForMethod(AuthenticationMethod method) {
        return method instanceof HttpAuthenticationMethod;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
    }

    @Override
    public AuthenticationMethod loadMethodFromSession(Session session, int contextId) throws DatabaseException {
        List<String> ports;
        List<String> realms;
        HttpAuthenticationMethod method = this.createAuthenticationMethod(contextId);
        List<String> hostnames = session.getContextDataStrings(contextId, 201);
        if (hostnames != null && hostnames.size() > 0) {
            method.hostname = hostnames.get(0);
        }
        if ((realms = session.getContextDataStrings(contextId, 202)) != null && realms.size() > 0) {
            method.realm = realms.get(0);
        }
        if ((ports = session.getContextDataStrings(contextId, 203)) != null && ports.size() > 0) {
            try {
                method.port = Integer.parseInt(ports.get(0));
            }
            catch (Exception ex) {
                log.error((Object)"Unable to load HttpAuthenticationMethod. ", (Throwable)ex);
            }
        }
        return method;
    }

    @Override
    public void persistMethodToSession(Session session, int contextId, AuthenticationMethod authMethod) throws AuthenticationMethodType.UnsupportedAuthenticationMethodException, DatabaseException {
        if (!(authMethod instanceof HttpAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Http Authentication type only supports: " + HttpAuthenticationMethod.class);
        }
        HttpAuthenticationMethod method = (HttpAuthenticationMethod)authMethod;
        session.setContextData(contextId, 201, method.hostname);
        session.setContextData(contextId, 202, method.realm);
        session.setContextData(contextId, 203, Integer.toString(method.port));
    }

    @Override
    public AuthenticationCredentials createAuthenticationCredentials() {
        return new UsernamePasswordAuthenticationCredentials();
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        return new ApiDynamicActionImplementor(API_METHOD_NAME, new String[]{PARAM_HOSTNAME, PARAM_REALM}, new String[]{PARAM_PORT}){

            @Override
            public void handleAction(JSONObject params) throws ApiException {
                Context context = ApiUtils.getContextByParamId(params, "contextId");
                HttpAuthenticationMethod method = HttpAuthenticationMethodType.this.createAuthenticationMethod(context.getIndex());
                method.hostname = ApiUtils.getNonEmptyStringParam(params, HttpAuthenticationMethodType.PARAM_HOSTNAME);
                try {
                    new URI(method.hostname);
                }
                catch (Exception ex) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, HttpAuthenticationMethodType.PARAM_HOSTNAME);
                }
                if (params.containsKey((Object)HttpAuthenticationMethodType.PARAM_REALM)) {
                    method.realm = params.getString(HttpAuthenticationMethodType.PARAM_REALM);
                }
                if (params.containsKey((Object)HttpAuthenticationMethodType.PARAM_PORT)) {
                    try {
                        String portString = params.getString(HttpAuthenticationMethodType.PARAM_PORT);
                        method.port = Integer.parseInt(portString);
                    }
                    catch (Exception ex) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, HttpAuthenticationMethodType.PARAM_PORT);
                    }
                }
                if (!context.getAuthenticationMethod().isSameType(method)) {
                    AuthenticationMethodType.apiChangedAuthenticationMethodForContext(context.getIndex());
                }
                context.setAuthenticationMethod(method);
            }
        };
    }

    @Override
    public ApiDynamicActionImplementor getSetCredentialsForUserApiAction() {
        return UsernamePasswordAuthenticationCredentials.getSetCredentialsForUserApiAction(this);
    }

    @Override
    public void exportData(Configuration config, AuthenticationMethod authMethod) {
        if (!(authMethod instanceof HttpAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("HTTP based authentication type only supports: " + HttpAuthenticationMethod.class.getName());
        }
        HttpAuthenticationMethod method = (HttpAuthenticationMethod)authMethod;
        config.setProperty(CONTEXT_CONFIG_AUTH_HTTP_HOSTNAME, (Object)method.hostname);
        config.setProperty(CONTEXT_CONFIG_AUTH_HTTP_REALM, (Object)method.realm);
        config.setProperty(CONTEXT_CONFIG_AUTH_HTTP_PORT, (Object)method.port);
    }

    @Override
    public void importData(Configuration config, AuthenticationMethod authMethod) throws ConfigurationException {
        if (!(authMethod instanceof HttpAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("HTTP based authentication type only supports: " + HttpAuthenticationMethod.class.getName());
        }
        HttpAuthenticationMethod method = (HttpAuthenticationMethod)authMethod;
        method.hostname = config.getString(CONTEXT_CONFIG_AUTH_HTTP_HOSTNAME);
        method.realm = config.getString(CONTEXT_CONFIG_AUTH_HTTP_REALM);
        method.port = config.getInt(CONTEXT_CONFIG_AUTH_HTTP_PORT);
    }

    private static class HttpAuthenticationMethodOptionsPanel
    extends AbstractAuthenticationMethodOptionsPanel {
        private static final long serialVersionUID = 4341092284683481288L;
        private static final String HOSTNAME_LABEL = Constant.messages.getString("authentication.method.http.field.label.hostname");
        private static final String PORT_LABEL = Constant.messages.getString("authentication.method.http.field.label.port");
        private static final String REALM_LABEL = Constant.messages.getString("authentication.method.http.field.label.realm");
        private ZapTextField hostnameField;
        private ZapTextField realmField;
        private ZapPortNumberSpinner portNumberSpinner;
        private HttpAuthenticationMethod method;

        public HttpAuthenticationMethodOptionsPanel() {
            this.initialize();
        }

        private void initialize() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(HOSTNAME_LABEL), LayoutHelper.getGBC(0, 0, 1, 0.0));
            this.hostnameField = new ZapTextField();
            this.add((Component)this.hostnameField, LayoutHelper.getGBC(1, 0, 1, 1.0, new Insets(0, 0, 0, 10)));
            this.add((Component)new JLabel(PORT_LABEL), LayoutHelper.getGBC(2, 0, 1, 0.0));
            this.portNumberSpinner = new ZapPortNumberSpinner(80);
            this.add((Component)this.portNumberSpinner, LayoutHelper.getGBC(3, 0, 1, 0.0));
            this.add((Component)new JLabel(REALM_LABEL), LayoutHelper.getGBC(0, 1, 1, 0.0));
            this.realmField = new ZapTextField();
            this.add((Component)this.realmField, LayoutHelper.getGBC(1, 1, 1, 1.0, new Insets(0, 0, 0, 10)));
        }

        @Override
        public void validateFields() throws IllegalStateException {
            try {
                new URI(this.hostnameField.getText());
            }
            catch (Exception ex) {
                this.hostnameField.requestFocusInWindow();
                throw new IllegalStateException(Constant.messages.getString("authentication.method.http.dialog.error.url.text"));
            }
        }

        @Override
        public void saveMethod() {
            this.getMethod().hostname = this.hostnameField.getText();
            this.getMethod().port = this.portNumberSpinner.getValue();
            this.getMethod().realm = this.realmField.getText();
        }

        @Override
        public void bindMethod(AuthenticationMethod method) throws AuthenticationMethodType.UnsupportedAuthenticationMethodException {
            this.method = (HttpAuthenticationMethod)method;
            this.hostnameField.setText(this.method.hostname);
            this.portNumberSpinner.setValue(this.method.port);
            this.realmField.setText(this.method.realm);
        }

        @Override
        public HttpAuthenticationMethod getMethod() {
            return this.method;
        }
    }

    protected static class HttpAuthenticationMethod
    extends AuthenticationMethod {
        protected String hostname;
        protected int port = 80;
        protected String realm;

        @Override
        public boolean isConfigured() {
            return this.hostname != null && !this.hostname.isEmpty() && this.realm != null && !this.realm.isEmpty();
        }

        @Override
        protected AuthenticationMethod duplicate() {
            HttpAuthenticationMethod method = new HttpAuthenticationMethod();
            method.hostname = this.hostname;
            method.port = this.port;
            method.realm = this.realm;
            return method;
        }

        @Override
        public AuthenticationCredentials createAuthenticationCredentials() {
            return new UsernamePasswordAuthenticationCredentials();
        }

        @Override
        public AuthenticationMethodType getType() {
            return new HttpAuthenticationMethodType();
        }

        @Override
        public WebSession authenticate(SessionManagementMethod sessionManagementMethod, AuthenticationCredentials credentials, User user) throws AuthenticationMethod.UnsupportedAuthenticationCredentialsException {
            WebSession session = user.getAuthenticatedSession();
            if (session == null) {
                session = sessionManagementMethod.createEmptyWebSession();
            }
            if (!(credentials instanceof UsernamePasswordAuthenticationCredentials)) {
                throw new AuthenticationMethod.UnsupportedAuthenticationCredentialsException("Form based authentication method only supports " + UsernamePasswordAuthenticationCredentials.class.getSimpleName());
            }
            UsernamePasswordAuthenticationCredentials userCredentials = (UsernamePasswordAuthenticationCredentials)credentials;
            AuthScope stateAuthScope = null;
            NTCredentials stateCredentials = null;
            try {
                stateAuthScope = new AuthScope(this.hostname, this.port, this.realm == null || this.realm.isEmpty() ? AuthScope.ANY_REALM : this.realm);
                stateCredentials = new NTCredentials(userCredentials.getUsername(), userCredentials.getPassword(), InetAddress.getLocalHost().getCanonicalHostName(), this.realm);
                session.getHttpState().setCredentials(stateAuthScope, (Credentials)stateCredentials);
            }
            catch (UnknownHostException e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            return session;
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("methodName", HttpAuthenticationMethodType.API_METHOD_NAME);
            values.put("host", this.hostname);
            values.put(HttpAuthenticationMethodType.PARAM_PORT, Integer.toString(this.port));
            values.put(HttpAuthenticationMethodType.PARAM_REALM, this.realm);
            return new ApiResponseSet("method", values);
        }
    }
}

