/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordStructure;
import org.parosproxy.paros.db.TableStructure;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlAbstractTable;
import org.zaproxy.zap.db.sql.SqlPreparedStatementWrapper;

public class SqlTableStructure
extends SqlAbstractTable
implements TableStructure {
    private static final String TABLE_NAME = "STRUCTURE";
    private static final String STRUCTUREID = "STRUCTUREID";
    private static final String SESSIONID = "SESSIONID";
    private static final String PARENTID = "PARENTID";
    private static final String HISTORYID = "HISTORYID";
    private static final String NAME = "NAME";
    private static final String URL = "URL";
    private static final String METHOD = "METHOD";

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, TABLE_NAME)) {
                DbUtils.executeAndClose(conn.prepareStatement(DbSQL.getSQL("structure.ps.createtable")));
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized RecordStructure read(long sessionId, long urlId) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public RecordStructure insert(long sessionId, long parentId, int historyId, String name, String url, String method) throws DatabaseException {
        SqlPreparedStatementWrapper psInsert = null;
        try {
            long id;
            psInsert = DbSQL.getSingleton().getPreparedStatement("structure.ps.insert");
            psInsert.getPs().setLong(1, sessionId);
            psInsert.getPs().setLong(2, parentId);
            psInsert.getPs().setInt(3, historyId);
            psInsert.getPs().setString(4, name);
            psInsert.getPs().setLong(5, name.hashCode());
            psInsert.getPs().setString(6, url);
            psInsert.getPs().setString(7, method);
            psInsert.getPs().executeUpdate();
            try (ResultSet rs = psInsert.getLastInsertedId();){
                rs.next();
                id = rs.getLong(1);
            }
            RecordStructure recordStructure = this.read(sessionId, id);
            return recordStructure;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psInsert);
        }
    }

    @Override
    public RecordStructure find(long sessionId, String name, String method) throws DatabaseException {
        SqlPreparedStatementWrapper psFind = null;
        try {
            psFind = DbSQL.getSingleton().getPreparedStatement("structure.ps.find");
            psFind.getPs().setLong(1, sessionId);
            psFind.getPs().setLong(2, name.hashCode());
            psFind.getPs().setString(3, method);
            try (ResultSet rs = psFind.getPs().executeQuery();){
                while (rs.next()) {
                    if (!name.equals(rs.getString(NAME))) continue;
                    RecordStructure recordStructure = this.build(rs);
                    return recordStructure;
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psFind);
        }
        return null;
    }

    @Override
    public List<RecordStructure> getChildren(long sessionId, long parentId) throws DatabaseException {
        SqlPreparedStatementWrapper psGetChildren = null;
        try {
            psGetChildren = DbSQL.getSingleton().getPreparedStatement("structure.ps.getchildren");
            psGetChildren.getPs().setLong(1, sessionId);
            psGetChildren.getPs().setLong(2, parentId);
            ArrayList<RecordStructure> result = new ArrayList<RecordStructure>();
            try (ResultSet rs = psGetChildren.getPs().executeQuery();){
                while (rs.next()) {
                    result.add(this.build(rs));
                }
            }
            ArrayList<RecordStructure> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetChildren);
        }
    }

    @Override
    public long getChildCount(long sessionId, long parentId) throws DatabaseException {
        SqlPreparedStatementWrapper psGetChildCount = null;
        try {
            psGetChildCount = DbSQL.getSingleton().getPreparedStatement("structure.ps.getchildcount");
            psGetChildCount.getPs().setLong(1, sessionId);
            psGetChildCount.getPs().setLong(2, parentId);
            try (ResultSet rs2 = psGetChildCount.getPs().executeQuery();){
                if (rs2.next()) {
                    long l = rs2.getLong(1);
                    return l;
                }
            }
            long rs2 = 0L;
            return rs2;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetChildCount);
        }
    }

    @Override
    public void deleteLeaf(long sessionId, long structureId) throws DatabaseException {
    }

    @Override
    public void deleteSubtree(long sessionId, long structureId) throws DatabaseException {
    }

    private RecordStructure build(ResultSet rs) throws DatabaseException {
        try {
            return new RecordStructure(rs.getLong(SESSIONID), rs.getLong(STRUCTUREID), rs.getLong(PARENTID), rs.getInt(HISTORYID), rs.getString(NAME), rs.getString(URL), rs.getString(METHOD));
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }
}

