/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.alert.AlertNode;
import org.zaproxy.zap.extension.alert.AlertTreeCellRenderer;
import org.zaproxy.zap.extension.alert.AlertTreeModel;
import org.zaproxy.zap.extension.alert.AlertViewPanel;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.DeselectableButtonGroup;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.ZapToggleButton;
import org.zaproxy.zap.view.messagecontainer.http.DefaultSelectableHistoryReferencesContainer;

public class AlertPanel
extends AbstractPanel {
    public static final String ALERT_TREE_PANEL_NAME = "treeAlert";
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(AlertPanel.class);
    private ViewDelegate view = null;
    private JTree treeAlert = null;
    private JScrollPane paneScroll = null;
    private JPanel panelCommand = null;
    private JToolBar panelToolbar = null;
    private JSplitPane splitPane = null;
    private AlertViewPanel alertViewPanel = null;
    private ZapToggleButton scopeButton = null;
    private AlertTreeModel linkWithSitesTreeModel;
    private LinkWithSitesTreeSelectionListener linkWithSitesTreeSelectionListener;
    private ZapToggleButton linkWithSitesTreeButton;
    private DeselectableButtonGroup alertsTreeFiltersButtonGroup;
    private JButton editButton = null;
    private ExtensionAlert extension = null;

    public AlertPanel(ExtensionAlert extension) {
        this.extension = extension;
        this.view = extension.getView();
        this.alertsTreeFiltersButtonGroup = new DeselectableButtonGroup();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setSize(274, 251);
        this.setName(Constant.messages.getString("alerts.panel.title"));
        this.setIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/16/071.png")));
        this.add((Component)this.getPanelCommand(), this.getPanelCommand().getName());
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40, false));
        this.setMnemonic(Constant.messages.getChar("alerts.panel.mnemonic"));
        this.setShowByDefault(true);
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName("AlertPanel");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.anchor = 18;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.anchor = 18;
            this.panelCommand.add((Component)this.getSplitPane(), gridBagConstraints2);
        }
        return this.panelCommand;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName("AlertToolbar");
            this.panelToolbar.add(this.getScopeButton());
            this.panelToolbar.add(this.getLinkWithSitesTreeButton());
            this.panelToolbar.addSeparator();
            this.panelToolbar.add(this.getEditButton());
        }
        return this.panelToolbar;
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setName("AlertPanels");
            this.splitPane.setDividerSize(3);
            this.splitPane.setDividerLocation(400);
            this.splitPane.setOrientation(1);
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            panel.add((Component)this.getPanelToolbar(), LayoutHelper.getGBC(0, 0, 1, 0.0));
            panel.add((Component)this.getPaneScroll(), LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0));
            this.splitPane.setLeftComponent(panel);
            this.splitPane.setRightComponent(this.getAlertViewPanel());
            this.splitPane.setPreferredSize(new Dimension(100, 200));
        }
        return this.splitPane;
    }

    public AlertViewPanel getAlertViewPanel() {
        if (this.alertViewPanel == null) {
            this.alertViewPanel = new AlertViewPanel();
        }
        return this.alertViewPanel;
    }

    private JToggleButton getScopeButton() {
        if (this.scopeButton == null) {
            this.scopeButton = new ZapToggleButton();
            this.scopeButton.setIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/fugue/target-grey.png")));
            this.scopeButton.setToolTipText(Constant.messages.getString("history.scope.button.unselected"));
            this.scopeButton.setSelectedIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/fugue/target.png")));
            this.scopeButton.setSelectedToolTipText(Constant.messages.getString("history.scope.button.selected"));
            DisplayUtils.scaleIcon(this.scopeButton);
            this.scopeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlertPanel.this.extension.setShowJustInScope(AlertPanel.this.scopeButton.isSelected());
                }
            });
            this.alertsTreeFiltersButtonGroup.add(this.scopeButton);
        }
        return this.scopeButton;
    }

    private JToggleButton getLinkWithSitesTreeButton() {
        if (this.linkWithSitesTreeButton == null) {
            this.linkWithSitesTreeButton = new ZapToggleButton();
            this.linkWithSitesTreeButton.setIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/16/earth-grey.png")));
            this.linkWithSitesTreeButton.setToolTipText(Constant.messages.getString("alerts.panel.linkWithSitesSelection.unselected.button.tooltip"));
            this.linkWithSitesTreeButton.setSelectedIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/16/094.png")));
            this.linkWithSitesTreeButton.setSelectedToolTipText(Constant.messages.getString("alerts.panel.linkWithSitesSelection.selected.button.tooltip"));
            DisplayUtils.scaleIcon(this.linkWithSitesTreeButton);
            this.linkWithSitesTreeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlertPanel.this.setLinkWithSitesTreeSelection(AlertPanel.this.linkWithSitesTreeButton.isSelected());
                }
            });
            this.alertsTreeFiltersButtonGroup.add(this.linkWithSitesTreeButton);
        }
        return this.linkWithSitesTreeButton;
    }

    public void setLinkWithSitesTreeSelection(boolean enabled) {
        this.linkWithSitesTreeButton.setSelected(enabled);
        if (enabled) {
            this.extension.setShowJustInScope(false);
            JTree sitesTree = this.view.getSiteTreePanel().getTreeSite();
            TreePath selectionPath = sitesTree.getSelectionPath();
            this.getTreeAlert().setModel(this.getLinkWithSitesTreeModel());
            if (selectionPath != null) {
                this.recreateLinkWithSitesTreeModel((SiteNode)selectionPath.getLastPathComponent());
            }
            sitesTree.addTreeSelectionListener(this.getLinkWithSitesTreeSelectionListener());
        } else {
            this.extension.setMainTreeModel();
            ((AlertNode)this.getLinkWithSitesTreeModel().getRoot()).removeAllChildren();
            this.view.getSiteTreePanel().getTreeSite().removeTreeSelectionListener(this.getLinkWithSitesTreeSelectionListener());
        }
    }

    private AlertTreeModel getLinkWithSitesTreeModel() {
        if (this.linkWithSitesTreeModel == null) {
            this.linkWithSitesTreeModel = new AlertTreeModel();
        }
        return this.linkWithSitesTreeModel;
    }

    private void recreateLinkWithSitesTreeModel(SiteNode siteNode) {
        if (siteNode == null) {
            throw new IllegalArgumentException("Parameter siteNode must not be null.");
        }
        ((AlertNode)this.getLinkWithSitesTreeModel().getRoot()).removeAllChildren();
        if (siteNode.isRoot()) {
            this.getLinkWithSitesTreeModel().reload();
            this.extension.recalcAlerts();
            return;
        }
        String uri = null;
        HistoryReference historyReference = siteNode.getHistoryReference();
        if (historyReference != null) {
            uri = historyReference.getURI().toString();
        }
        for (Alert alert : siteNode.getAlerts()) {
            if (uri != null && !alert.getUri().equals(uri)) continue;
            this.getLinkWithSitesTreeModel().addPath(alert);
        }
        this.getLinkWithSitesTreeModel().reload();
        this.expandRootChildNodes();
        this.extension.recalcAlerts();
    }

    private LinkWithSitesTreeSelectionListener getLinkWithSitesTreeSelectionListener() {
        if (this.linkWithSitesTreeSelectionListener == null) {
            this.linkWithSitesTreeSelectionListener = new LinkWithSitesTreeSelectionListener();
        }
        return this.linkWithSitesTreeSelectionListener;
    }

    JTree getTreeAlert() {
        if (this.treeAlert == null) {
            this.treeAlert = new JTree(){
                private static final long serialVersionUID = 1L;

                @Override
                public Point getPopupLocation(MouseEvent event) {
                    TreePath tp;
                    if (event != null && (tp = AlertPanel.this.treeAlert.getPathForLocation(event.getX(), event.getY())) != null && !AlertPanel.this.treeAlert.getSelectionModel().isPathSelected(tp)) {
                        AlertPanel.this.treeAlert.getSelectionModel().setSelectionPath(tp);
                    }
                    return super.getPopupLocation(event);
                }
            };
            this.treeAlert.setName(ALERT_TREE_PANEL_NAME);
            this.treeAlert.setShowsRootHandles(true);
            this.treeAlert.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.treeAlert.setComponentPopupMenu(new JPopupMenu(){
                private static final long serialVersionUID = 1L;

                @Override
                public void show(Component invoker, int x, int y) {
                    int countSelectedNodes = AlertPanel.this.treeAlert.getSelectionCount();
                    ArrayList<HistoryReference> uniqueHistoryReferences = new ArrayList<HistoryReference>(countSelectedNodes);
                    if (countSelectedNodes > 0) {
                        TreeSet<Integer> historyReferenceIdsAdded = new TreeSet<Integer>();
                        for (TreePath path : AlertPanel.this.treeAlert.getSelectionPaths()) {
                            HistoryReference historyReference;
                            AlertNode node = (AlertNode)path.getLastPathComponent();
                            Alert userObject = node.getUserObject();
                            if (!(userObject instanceof Alert) || (historyReference = userObject.getHistoryRef()) == null || historyReferenceIdsAdded.contains(historyReference.getHistoryId())) continue;
                            historyReferenceIdsAdded.add(historyReference.getHistoryId());
                            uniqueHistoryReferences.add(historyReference);
                        }
                        uniqueHistoryReferences.trimToSize();
                    }
                    DefaultSelectableHistoryReferencesContainer messageContainer = new DefaultSelectableHistoryReferencesContainer(AlertPanel.this.treeAlert.getName(), AlertPanel.this.treeAlert, Collections.emptyList(), uniqueHistoryReferences);
                    AlertPanel.this.view.getPopupMenu().show(messageContainer, x, y);
                }
            });
            this.treeAlert.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                        AlertPanel.this.editSelectedAlert();
                    }
                }
            });
            this.treeAlert.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)AlertPanel.this.treeAlert.getLastSelectedPathComponent();
                    if (node != null && node.getUserObject() != null) {
                        Object obj = node.getUserObject();
                        if (obj instanceof Alert) {
                            Alert alert = (Alert)obj;
                            AlertPanel.this.setMessage(alert.getMessage(), alert.getEvidence());
                            AlertPanel.this.treeAlert.requestFocusInWindow();
                            AlertPanel.this.getAlertViewPanel().displayAlert(alert);
                        } else {
                            AlertPanel.this.getAlertViewPanel().clearAlert();
                        }
                    } else {
                        AlertPanel.this.getAlertViewPanel().clearAlert();
                    }
                }
            });
            this.treeAlert.setCellRenderer(new AlertTreeCellRenderer());
            this.treeAlert.setExpandsSelectedPaths(true);
            String deleteAlertKey = "zap.delete.alert";
            this.treeAlert.getInputMap().put(this.view.getDefaultDeleteKeyStroke(), deleteAlertKey);
            this.treeAlert.getActionMap().put(deleteAlertKey, new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Set<Alert> alerts = AlertPanel.this.getSelectedAlerts();
                    if (alerts.size() > 1 && View.getSingleton().showConfirmDialog(Constant.messages.getString("scanner.delete.confirm")) != 0) {
                        return;
                    }
                    for (Alert alert : alerts) {
                        AlertPanel.this.extension.deleteAlert(alert);
                    }
                }
            });
        }
        return this.treeAlert;
    }

    Set<Alert> getSelectedAlerts() {
        return this.getSelectedAlertsImpl(true);
    }

    private Set<Alert> getSelectedAlertsImpl(boolean allAlerts) {
        TreePath[] paths = this.getTreeAlert().getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Alert> alerts = new HashSet<Alert>();
        if (!allAlerts) {
            DefaultMutableTreeNode alertNode = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            alerts.add((Alert)alertNode.getUserObject());
            return alerts;
        }
        for (int i = 0; i < paths.length; ++i) {
            DefaultMutableTreeNode alertNode = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            if (alertNode.getChildCount() == 0) {
                alerts.add((Alert)alertNode.getUserObject());
                continue;
            }
            for (int j = 0; j < alertNode.getChildCount(); ++j) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)alertNode.getChildAt(j);
                alerts.add((Alert)node.getUserObject());
            }
        }
        return alerts;
    }

    Set<Alert> getSelectedAlert() {
        return this.getSelectedAlertsImpl(false);
    }

    private JScrollPane getPaneScroll() {
        if (this.paneScroll == null) {
            this.paneScroll = new JScrollPane();
            this.paneScroll.setName("paneScroll");
            this.paneScroll.setViewportView(this.getTreeAlert());
        }
        return this.paneScroll;
    }

    private ViewDelegate getView() {
        return this.view;
    }

    public void expandRoot() {
        if (EventQueue.isDispatchThread()) {
            this.getTreeAlert().expandPath(new TreePath(this.getTreeAlert().getModel().getRoot()));
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlertPanel.this.expandRoot();
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void expandRootChildNodes() {
        TreeNode root = (TreeNode)this.getTreeAlert().getModel().getRoot();
        if (root == null) {
            return;
        }
        TreePath basePath = new TreePath(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.getTreeAlert().expandPath(basePath.pathByAddingChild(root.getChildAt(i)));
        }
    }

    private void setMessage(HttpMessage msg, String highlight) {
        this.getView().displayMessage(msg);
        if (msg == null) {
            return;
        }
        if (!msg.getResponseHeader().isEmpty()) {
            HttpPanelRequest requestPanel = this.getView().getRequestPanel();
            HttpPanelResponse responsePanel = this.getView().getResponsePanel();
            SearchMatch sm = null;
            if (highlight != null && highlight.length() != 0) {
                int start = msg.getResponseHeader().toString().indexOf(highlight);
                if (start >= 0) {
                    sm = new SearchMatch(msg, SearchMatch.Location.RESPONSE_HEAD, start, start + highlight.length());
                    responsePanel.highlightHeader(sm);
                    responsePanel.setTabFocus();
                } else {
                    start = msg.getResponseBody().toString().indexOf(highlight);
                    if (start >= 0) {
                        sm = new SearchMatch(msg, SearchMatch.Location.RESPONSE_BODY, start, start + highlight.length());
                        responsePanel.highlightBody(sm);
                        responsePanel.setTabFocus();
                    } else {
                        start = msg.getRequestHeader().toString().indexOf(highlight);
                        if (start >= 0) {
                            sm = new SearchMatch(msg, SearchMatch.Location.REQUEST_HEAD, start, start + highlight.length());
                            requestPanel.highlightHeader(sm);
                            requestPanel.setTabFocus();
                        } else {
                            start = msg.getRequestBody().toString().indexOf(highlight);
                            if (start >= 0) {
                                sm = new SearchMatch(msg, SearchMatch.Location.REQUEST_BODY, start, start + highlight.length());
                                requestPanel.highlightBody(sm);
                                requestPanel.setTabFocus();
                            }
                        }
                    }
                }
            }
        }
    }

    private void editSelectedAlert() {
        Object obj;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeAlert.getLastSelectedPathComponent();
        if (node != null && node.getUserObject() != null && (obj = node.getUserObject()) instanceof Alert) {
            Alert alert = (Alert)obj;
            this.extension.showAlertEditDialog(alert);
        }
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setToolTipText(Constant.messages.getString("alert.edit.button.tooltip"));
            this.editButton.setIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/16/018.png")));
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlertPanel.this.editSelectedAlert();
                }
            });
        }
        return this.editButton;
    }

    private class LinkWithSitesTreeSelectionListener
    implements TreeSelectionListener {
        private LinkWithSitesTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            AlertPanel.this.recreateLinkWithSitesTreeModel((SiteNode)e.getPath().getLastPathComponent());
        }
    }
}

