/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import javax.script.ScriptException;
import org.zaproxy.zap.extension.script.ScriptEngineWrapper;
import org.zaproxy.zap.extension.script.ScriptType;

public class ScriptWrapper {
    private String name;
    private String description;
    private ScriptEngineWrapper engine;
    private String engineName;
    private ScriptType type;
    private String typeName;
    private String contents = "";
    private String lastOutput = "";
    private boolean changed = false;
    private boolean enabled = false;
    private boolean previouslyEnabled;
    private boolean error = false;
    private boolean loadOnStart = false;
    private File file;
    private String lastErrorDetails = "";
    private Exception lastException = null;
    private Writer writer = null;

    public ScriptWrapper() {
    }

    public ScriptWrapper(String name, String description, ScriptEngineWrapper engine, ScriptType type) {
        this.name = name;
        this.description = description;
        this.engine = engine;
        if (engine != null) {
            this.engineName = engine.getEngineName();
        }
        this.type = type;
    }

    public ScriptWrapper(String name, String description, String engineName, ScriptType type, boolean enabled, File file) {
        this.name = name;
        this.description = description;
        this.engineName = engineName;
        this.type = type;
        this.enabled = enabled;
        this.file = file;
    }

    public ScriptWrapper(String name, String description, ScriptEngineWrapper engine, ScriptType type, boolean enabled, File file) {
        this.name = name;
        this.description = description;
        this.engine = engine;
        if (engine != null) {
            this.engineName = engine.getEngineName();
        }
        this.type = type;
        this.enabled = enabled;
        this.file = file;
    }

    protected ScriptWrapper(String name, String description, String engineName, String typeName, boolean enabled, File file) {
        this.name = name;
        this.description = description;
        this.engineName = engineName;
        this.typeName = typeName;
        this.enabled = enabled;
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ScriptEngineWrapper getEngine() {
        return this.engine;
    }

    public void setEngine(ScriptEngineWrapper engine) {
        if (engine != null) {
            this.engineName = engine.getEngineName();
        }
        this.engine = engine;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getEngineName() {
        if (this.engine != null) {
            return this.engine.getEngineName();
        }
        return this.engineName;
    }

    public ScriptType getType() {
        return this.type;
    }

    public void setType(ScriptType type) {
        this.type = type;
    }

    public String getTypeName() {
        if (this.type != null) {
            return this.type.getName();
        }
        return this.typeName;
    }

    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        if (!contents.equals(this.contents)) {
            this.contents = contents;
            this.changed = true;
        }
    }

    public String getLastOutput() {
        return this.lastOutput;
    }

    public void setLastOutput(String lastOutput) {
        this.lastOutput = lastOutput;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled && this.engine == null) {
            return;
        }
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.changed = true;
        }
    }

    public String getLastErrorDetails() {
        return this.lastErrorDetails;
    }

    public void setLastErrorDetails(String lastErrorDetails) {
        this.lastErrorDetails = lastErrorDetails;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void setLastException(Exception lastException) {
        this.lastException = lastException;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isLoadOnStart() {
        return this.loadOnStart;
    }

    public void setLoadOnStart(boolean loadOnStart) {
        this.loadOnStart = loadOnStart;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public <T> T getInterface(Class<T> class1) throws ScriptException, IOException {
        return null;
    }

    public boolean isRunableStandalone() {
        return this.getType() != null && "standalone".equals(this.getType().getName());
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    void setPreviouslyEnabled(boolean enabled) {
        this.previouslyEnabled = enabled;
    }

    boolean isPreviouslyEnabled() {
        return this.previouslyEnabled;
    }
}

