/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.text;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class FontManager {
    private static FontManager instance;
    private Properties map = new Properties();

    public static FontManager getInstance() {
        if (instance == null) {
            instance = new FontManager();
        }
        return instance;
    }

    private FontManager() {
        this.loadEmbeddedFontDefinitions();
    }

    void loadEmbeddedFontDefinitions() {
        URL uRL = FontManager.class.getResource("/META-INF/fonts.mf");
        if (uRL == null) {
            return;
        }
        try {
            InputStream inputStream = uRL.openStream();
            this.map.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String findPathByName(String string) {
        return this.map.getProperty(string);
    }

    public String[] getAllPaths() {
        if (this.map.size() == 0) {
            return new String[0];
        }
        String[] stringArray = new String[this.map.size()];
        Enumeration<Object> enumeration = this.map.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public String[] getAllNames() {
        if (this.map.size() == 0) {
            return new String[0];
        }
        String[] stringArray = new String[this.map.size()];
        Enumeration<Object> enumeration = this.map.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }
}

