/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.xlib;

import gnu.gcj.RawData;
import gnu.gcj.xlib.Display;
import gnu.gcj.xlib.Screen;

public final class Visual {
    public static final int VC_STATIC_GRAY = 0;
    public static final int VC_GRAY_SCALE = 1;
    public static final int VC_STATIC_COLOR = 2;
    public static final int VC_PSEUDO_COLOR = 3;
    public static final int VC_TRUE_COLOR = 4;
    public static final int VC_DIRECT_COLOR = 5;
    protected static final int MASK_ID = 1;
    protected static final int MASK_SCREEN = 2;
    protected static final int MASK_DEPTH = 4;
    protected static final int MASK_CLASS = 8;
    protected static final int MASK_RED = 16;
    protected static final int MASK_GREEN = 32;
    protected static final int MASK_BLUE = 64;
    protected static final int MASK_COLORMAP_SIZE = 128;
    protected static final int MASK_BITS_PER_RGB = 256;
    protected static final int MASK_ALL = 511;
    private static final int MASK_VISUAL_STRUCTURE = Integer.MIN_VALUE;
    Display display;
    RawData xVisualInfo;
    int infoMask;
    Screen screen;

    Visual(RawData structure, Screen screen, int depth) {
        this.display = screen.getDisplay();
        this.screen = screen;
        this.init(structure, depth);
    }

    Visual(Display display, RawData structure, int depth) {
        this.display = display;
        this.init(structure, depth);
    }

    protected native void init(RawData var1, int var2);

    protected native void finalize();

    native RawData getVisualStructure();

    public native int getRedMask();

    public native int getGreenMask();

    public native int getBlueMask();

    public native int getScreenNumber();

    public native int getDepth();

    public Screen getScreen() {
        if (this.screen == null) {
            this.screen = new Screen(this.display, this.getScreenNumber());
        }
        return this.screen;
    }

    public native int getVisualClass();

    public boolean hasRGBSubfields() {
        switch (this.getVisualClass()) {
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    protected native void ensureXVisualInfo(int var1);

    public String toString() {
        int missingInfo = ~this.infoMask;
        boolean hasDepth = (missingInfo & 4) == 0;
        return String.valueOf(this.getClass().getName()) + "[" + (hasDepth ? "depth=" + this.getDepth() : "") + (this.hasRGBSubfields() ? ", redMask=" + Integer.toHexString(this.getRedMask()) + ", greenMask=" + Integer.toHexString(this.getGreenMask()) + ", blueMask=" + Integer.toHexString(this.getBlueMask()) : ", no-subfields") + ", class=" + this.getVisualClass() + "]";
    }
}

