/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import gnu.java.awt.font.opentype.truetype.Fixed;
import gnu.java.awt.font.opentype.truetype.Point;
import gnu.java.awt.font.opentype.truetype.ZonePathIterator;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public final class Zone {
    private Point[] points;
    private int numPoints;
    public double scaleX;
    public double scaleY;
    public double shearX;
    public double shearY;

    public Zone(int maxNumPoints) {
        this.points = new Point[maxNumPoints];
    }

    public int getCapacity() {
        return this.points.length;
    }

    public int getSize() {
        return this.numPoints;
    }

    public int getX(int point) {
        return this.getX(point, 1);
    }

    public int getX(int point, int flags) {
        int x = (flags & 1) != 0 ? this.points[point].x : this.points[point].scaledX;
        return x;
    }

    public void setX(int point, int value, boolean touch) {
        this.points[point].scaledX = value;
        this.points[point].x = value;
        if (touch) {
            this.points[point].flags = (short)(this.points[point].flags | 1);
        }
    }

    public void setY(int point, int value, boolean touch) {
        this.points[point].scaledY = value;
        this.points[point].y = value;
        if (touch) {
            this.points[point].flags = (short)(this.points[point].flags | 2);
        }
    }

    public int getY(int point) {
        return this.getY(point, 1);
    }

    public int getY(int point, int flags) {
        int y = (flags & 1) != 0 ? this.points[point].y : this.points[point].scaledY;
        return y;
    }

    public int getOriginalX(int point) {
        return this.points[point].origX;
    }

    public int getOriginalY(int point) {
        return this.points[point].origY;
    }

    public void setOriginalX(int point, int x) {
        this.points[point].origX = x;
    }

    public void setOriginalY(int point, int y) {
        this.points[point].origY = y;
    }

    public void setNumPoints(int numPoints) {
        int i = 0;
        while (i < numPoints) {
            this.points[i] = new Point();
            ++i;
        }
        this.numPoints = numPoints;
    }

    public boolean isOnCurve(int point) {
        return (this.points[point].flags & 4) != 0;
    }

    public void setOnCurve(int point, boolean onCurve) {
        this.points[point].flags = onCurve ? (short)(this.points[point].flags | 4) : (short)(this.points[point].flags & 0xFFFFFFFB);
    }

    public boolean isContourEnd(int point) {
        return (this.points[point].flags & 8) != 0;
    }

    public void setContourEnd(int point, boolean segEnd) {
        this.points[point].flags = segEnd ? (short)(this.points[point].flags | 8) : (short)(this.points[point].flags & 0xFFFFFFF7);
    }

    void transform(double pointSize, AffineTransform deviceTransform, int unitsPerEm, int preTranslateX, int preTranslateY) {
        double factor = pointSize / (double)unitsPerEm;
        this.scaleX = deviceTransform.getScaleX() * factor;
        this.scaleY = deviceTransform.getScaleY() * factor;
        this.shearX = deviceTransform.getShearX() * factor;
        this.shearY = deviceTransform.getShearY() * factor;
        int i = 0;
        while (i < this.numPoints) {
            int x = this.points[i].origX + preTranslateX;
            int y = this.points[i].origY + preTranslateY;
            this.points[i].scaledX = this.points[i].x = Fixed.valueOf(this.scaleX * (double)x + this.shearX * (double)y);
            this.points[i].scaledY = this.points[i].y = Fixed.valueOf(this.shearY * (double)x + this.scaleY * (double)y);
            ++i;
        }
    }

    void combineWithSubGlyph(Zone zone, int numPhantomPoints) {
        int offset = this.numPoints - numPhantomPoints;
        int count = zone.numPoints;
        System.arraycopy(zone.points, 0, this.points, offset, count);
        this.numPoints += count - numPhantomPoints;
    }

    private void dump() {
        int i = 0;
        while (i < this.numPoints) {
            System.out.print(" " + i + ": ");
            System.out.print(Fixed.toString(this.points[i].scaledX, this.points[i].scaledY));
            System.out.print(' ');
            System.out.print(Fixed.toString(this.points[i].origX, this.points[i].origY));
            System.out.print(' ');
            if (this.isOnCurve(i)) {
                System.out.print('.');
            } else {
                System.out.print('c');
            }
            if (this.isContourEnd(i)) {
                System.out.print('E');
            }
            System.out.println();
            if (this.isContourEnd(i)) {
                System.out.println();
            }
            ++i;
        }
    }

    public PathIterator getPathIterator(int type) {
        return new ZonePathIterator(this, type);
    }

    public GeneralPath getPath(int type) {
        GeneralPath p = new GeneralPath(1, this.numPoints);
        p.append(this.getPathIterator(type), false);
        return p;
    }

    public int getNumContours() {
        int num = 0;
        int i = 0;
        while (i < this.numPoints) {
            if (this.isContourEnd(i)) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int getContourEnd(int n) {
        int idx = -1;
        int num = 0;
        int i = 0;
        while (i < this.numPoints) {
            if (this.isContourEnd(i)) {
                idx = i;
                if (num == n) break;
                ++num;
            }
            ++i;
        }
        return idx;
    }

    public Point[] getPoints() {
        return this.points;
    }
}

